/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.BlueprintStatus;
import software.amazon.awssdk.services.glue.model.LastActiveDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Blueprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Blueprint> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Blueprint.getter(Blueprint::name)).setter(Blueprint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Blueprint.getter(Blueprint::description)).setter(Blueprint.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedOn").getter(Blueprint.getter(Blueprint::createdOn)).setter(Blueprint.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(Blueprint.getter(Blueprint::lastModifiedOn)).setter(Blueprint.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<String> PARAMETER_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterSpec").getter(Blueprint.getter(Blueprint::parameterSpec)).setter(Blueprint.setter(Builder::parameterSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterSpec").build()}).build();
    private static final SdkField<String> BLUEPRINT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintLocation").getter(Blueprint.getter(Blueprint::blueprintLocation)).setter(Blueprint.setter(Builder::blueprintLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintLocation").build()}).build();
    private static final SdkField<String> BLUEPRINT_SERVICE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueprintServiceLocation").getter(Blueprint.getter(Blueprint::blueprintServiceLocation)).setter(Blueprint.setter(Builder::blueprintServiceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintServiceLocation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Blueprint.getter(Blueprint::statusAsString)).setter(Blueprint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(Blueprint.getter(Blueprint::errorMessage)).setter(Blueprint.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<LastActiveDefinition> LAST_ACTIVE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastActiveDefinition").getter(Blueprint.getter(Blueprint::lastActiveDefinition)).setter(Blueprint.setter(Builder::lastActiveDefinition)).constructor(LastActiveDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastActiveDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, PARAMETER_SPEC_FIELD, BLUEPRINT_LOCATION_FIELD, BLUEPRINT_SERVICE_LOCATION_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, LAST_ACTIVE_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final String parameterSpec;
    private final String blueprintLocation;
    private final String blueprintServiceLocation;
    private final String status;
    private final String errorMessage;
    private final LastActiveDefinition lastActiveDefinition;

    private Blueprint(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.parameterSpec = builder.parameterSpec;
        this.blueprintLocation = builder.blueprintLocation;
        this.blueprintServiceLocation = builder.blueprintServiceLocation;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.lastActiveDefinition = builder.lastActiveDefinition;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final String parameterSpec() {
        return this.parameterSpec;
    }

    public final String blueprintLocation() {
        return this.blueprintLocation;
    }

    public final String blueprintServiceLocation() {
        return this.blueprintServiceLocation;
    }

    public final BlueprintStatus status() {
        return BlueprintStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final LastActiveDefinition lastActiveDefinition() {
        return this.lastActiveDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintServiceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActiveDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.parameterSpec(), other.parameterSpec()) && Objects.equals(this.blueprintLocation(), other.blueprintLocation()) && Objects.equals(this.blueprintServiceLocation(), other.blueprintServiceLocation()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.lastActiveDefinition(), other.lastActiveDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"Blueprint").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("ParameterSpec", (Object)this.parameterSpec()).add("BlueprintLocation", (Object)this.blueprintLocation()).add("BlueprintServiceLocation", (Object)this.blueprintServiceLocation()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("LastActiveDefinition", (Object)this.lastActiveDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "ParameterSpec": {
                return Optional.ofNullable(clazz.cast(this.parameterSpec()));
            }
            case "BlueprintLocation": {
                return Optional.ofNullable(clazz.cast(this.blueprintLocation()));
            }
            case "BlueprintServiceLocation": {
                return Optional.ofNullable(clazz.cast(this.blueprintServiceLocation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LastActiveDefinition": {
                return Optional.ofNullable(clazz.cast(this.lastActiveDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Instant createdOn;
        private Instant lastModifiedOn;
        private String parameterSpec;
        private String blueprintLocation;
        private String blueprintServiceLocation;
        private String status;
        private String errorMessage;
        private LastActiveDefinition lastActiveDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            this.name(model.name);
            this.description(model.description);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.parameterSpec(model.parameterSpec);
            this.blueprintLocation(model.blueprintLocation);
            this.blueprintServiceLocation(model.blueprintServiceLocation);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.lastActiveDefinition(model.lastActiveDefinition);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        @Transient
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        @Transient
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getParameterSpec() {
            return this.parameterSpec;
        }

        public final void setParameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
        }

        @Override
        @Transient
        public final Builder parameterSpec(String parameterSpec) {
            this.parameterSpec = parameterSpec;
            return this;
        }

        public final String getBlueprintLocation() {
            return this.blueprintLocation;
        }

        public final void setBlueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
        }

        @Override
        @Transient
        public final Builder blueprintLocation(String blueprintLocation) {
            this.blueprintLocation = blueprintLocation;
            return this;
        }

        public final String getBlueprintServiceLocation() {
            return this.blueprintServiceLocation;
        }

        public final void setBlueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
        }

        @Override
        @Transient
        public final Builder blueprintServiceLocation(String blueprintServiceLocation) {
            this.blueprintServiceLocation = blueprintServiceLocation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(BlueprintStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final LastActiveDefinition.Builder getLastActiveDefinition() {
            return this.lastActiveDefinition != null ? this.lastActiveDefinition.toBuilder() : null;
        }

        public final void setLastActiveDefinition(LastActiveDefinition.BuilderImpl lastActiveDefinition) {
            this.lastActiveDefinition = lastActiveDefinition != null ? lastActiveDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder lastActiveDefinition(LastActiveDefinition lastActiveDefinition) {
            this.lastActiveDefinition = lastActiveDefinition;
            return this;
        }

        public Blueprint build() {
            return new Blueprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Blueprint> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder parameterSpec(String var1);

        public Builder blueprintLocation(String var1);

        public Builder blueprintServiceLocation(String var1);

        public Builder status(String var1);

        public Builder status(BlueprintStatus var1);

        public Builder errorMessage(String var1);

        public Builder lastActiveDefinition(LastActiveDefinition var1);

        default public Builder lastActiveDefinition(Consumer<LastActiveDefinition.Builder> lastActiveDefinition) {
            return this.lastActiveDefinition((LastActiveDefinition)((LastActiveDefinition.Builder)LastActiveDefinition.builder().applyMutation(lastActiveDefinition)).build());
        }
    }
}

