/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.FindMatchesParameters;
import software.amazon.awssdk.services.glue.model.TransformType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformParameters> {
    private static final SdkField<String> TRANSFORM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformType").getter(TransformParameters.getter(TransformParameters::transformTypeAsString)).setter(TransformParameters.setter(Builder::transformType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformType").build()}).build();
    private static final SdkField<FindMatchesParameters> FIND_MATCHES_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FindMatchesParameters").getter(TransformParameters.getter(TransformParameters::findMatchesParameters)).setter(TransformParameters.setter(Builder::findMatchesParameters)).constructor(FindMatchesParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindMatchesParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_TYPE_FIELD, FIND_MATCHES_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transformType;
    private final FindMatchesParameters findMatchesParameters;

    private TransformParameters(BuilderImpl builder) {
        this.transformType = builder.transformType;
        this.findMatchesParameters = builder.findMatchesParameters;
    }

    public final TransformType transformType() {
        return TransformType.fromValue(this.transformType);
    }

    public final String transformTypeAsString() {
        return this.transformType;
    }

    public final FindMatchesParameters findMatchesParameters() {
        return this.findMatchesParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.findMatchesParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformParameters)) {
            return false;
        }
        TransformParameters other = (TransformParameters)obj;
        return Objects.equals(this.transformTypeAsString(), other.transformTypeAsString()) && Objects.equals(this.findMatchesParameters(), other.findMatchesParameters());
    }

    public final String toString() {
        return ToString.builder((String)"TransformParameters").add("TransformType", (Object)this.transformTypeAsString()).add("FindMatchesParameters", (Object)this.findMatchesParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformType": {
                return Optional.ofNullable(clazz.cast(this.transformTypeAsString()));
            }
            case "FindMatchesParameters": {
                return Optional.ofNullable(clazz.cast(this.findMatchesParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformParameters, T> g) {
        return obj -> g.apply((TransformParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformType;
        private FindMatchesParameters findMatchesParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformParameters model) {
            this.transformType(model.transformType);
            this.findMatchesParameters(model.findMatchesParameters);
        }

        public final String getTransformType() {
            return this.transformType;
        }

        @Override
        public final Builder transformType(String transformType) {
            this.transformType = transformType;
            return this;
        }

        @Override
        public final Builder transformType(TransformType transformType) {
            this.transformType(transformType == null ? null : transformType.toString());
            return this;
        }

        public final void setTransformType(String transformType) {
            this.transformType = transformType;
        }

        public final FindMatchesParameters.Builder getFindMatchesParameters() {
            return this.findMatchesParameters != null ? this.findMatchesParameters.toBuilder() : null;
        }

        @Override
        public final Builder findMatchesParameters(FindMatchesParameters findMatchesParameters) {
            this.findMatchesParameters = findMatchesParameters;
            return this;
        }

        public final void setFindMatchesParameters(FindMatchesParameters.BuilderImpl findMatchesParameters) {
            this.findMatchesParameters = findMatchesParameters != null ? findMatchesParameters.build() : null;
        }

        public TransformParameters build() {
            return new TransformParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformParameters> {
        public Builder transformType(String var1);

        public Builder transformType(TransformType var1);

        public Builder findMatchesParameters(FindMatchesParameters var1);

        default public Builder findMatchesParameters(Consumer<FindMatchesParameters.Builder> findMatchesParameters) {
            return this.findMatchesParameters((FindMatchesParameters)((FindMatchesParameters.Builder)FindMatchesParameters.builder().applyMutation(findMatchesParameters)).build());
        }
    }
}

