/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure used to provide information used to update a trigger. This object updates the previous trigger definition
 * by overwriting it completely.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerUpdate implements SdkPojo, Serializable, ToCopyableBuilder<TriggerUpdate.Builder, TriggerUpdate> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TriggerUpdate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TriggerUpdate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(TriggerUpdate::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(TriggerUpdate::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
            .memberName("Predicate").getter(getter(TriggerUpdate::predicate)).setter(setter(Builder::predicate))
            .constructor(Predicate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SCHEDULE_FIELD, ACTIONS_FIELD, PREDICATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String schedule;

    private final List<Action> actions;

    private final Predicate predicate;

    private TriggerUpdate(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.actions = builder.actions;
        this.predicate = builder.predicate;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of this trigger.
     * </p>
     * 
     * @return A description of this trigger.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A <code>cron</code> expression used to specify the schedule (see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for
     * Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
     * <code>cron(15 12 * * ? *)</code>.
     * </p>
     * 
     * @return A <code>cron</code> expression used to specify the schedule (see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
     *         Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
     *         specify: <code>cron(15 12 * * ? *)</code>.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions initiated by this trigger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions initiated by this trigger.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * The predicate of this trigger, which defines when it will fire.
     * </p>
     * 
     * @return The predicate of this trigger, which defines when it will fire.
     */
    public final Predicate predicate() {
        return predicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(predicate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerUpdate)) {
            return false;
        }
        TriggerUpdate other = (TriggerUpdate) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(schedule(), other.schedule()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && Objects.equals(predicate(), other.predicate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerUpdate").add("Name", name()).add("Description", description())
                .add("Schedule", schedule()).add("Actions", hasActions() ? actions() : null).add("Predicate", predicate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Predicate":
            return Optional.ofNullable(clazz.cast(predicate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerUpdate, T> g) {
        return obj -> g.apply((TriggerUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerUpdate> {
        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param name
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of this trigger.
         * </p>
         * 
         * @param description
         *        A description of this trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A <code>cron</code> expression used to specify the schedule (see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules
         * for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
         * <code>cron(15 12 * * ? *)</code>.
         * </p>
         * 
         * @param schedule
         *        A <code>cron</code> expression used to specify the schedule (see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
         *        Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
         *        specify: <code>cron(15 12 * * ? *)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The actions initiated by this trigger.
         * </p>
         * 
         * @param actions
         *        The actions initiated by this trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions initiated by this trigger.
         * </p>
         * 
         * @param actions
         *        The actions initiated by this trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions initiated by this trigger.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * The predicate of this trigger, which defines when it will fire.
         * </p>
         * 
         * @param predicate
         *        The predicate of this trigger, which defines when it will fire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicate(Predicate predicate);

        /**
         * <p>
         * The predicate of this trigger, which defines when it will fire.
         * </p>
         * This is a convenience that creates an instance of the {@link Predicate.Builder} avoiding the need to create
         * one manually via {@link Predicate#builder()}.
         *
         * When the {@link Consumer} completes, {@link Predicate.Builder#build()} is called immediately and its result
         * is passed to {@link #predicate(Predicate)}.
         * 
         * @param predicate
         *        a consumer that will call methods on {@link Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicate(Predicate)
         */
        default Builder predicate(Consumer<Predicate.Builder> predicate) {
            return predicate(Predicate.builder().applyMutation(predicate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String schedule;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private Predicate predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerUpdate model) {
            name(model.name);
            description(model.description);
            schedule(model.schedule);
            actions(model.actions);
            predicate(model.predicate);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Collection<Action.Builder> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions != null ? actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final Predicate.Builder getPredicate() {
            return predicate != null ? predicate.toBuilder() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public TriggerUpdate build() {
            return new TriggerUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
