/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the physical requirements for a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalConnectionRequirements implements SdkPojo, Serializable,
        ToCopyableBuilder<PhysicalConnectionRequirements.Builder, PhysicalConnectionRequirements> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(PhysicalConnectionRequirements::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIdList")
            .getter(getter(PhysicalConnectionRequirements::securityGroupIdList))
            .setter(setter(Builder::securityGroupIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(PhysicalConnectionRequirements::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD,
            SECURITY_GROUP_ID_LIST_FIELD, AVAILABILITY_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final List<String> securityGroupIdList;

    private final String availabilityZone;

    private PhysicalConnectionRequirements(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.securityGroupIdList = builder.securityGroupIdList;
        this.availabilityZone = builder.availabilityZone;
    }

    /**
     * <p>
     * The subnet ID used by the connection.
     * </p>
     * 
     * @return The subnet ID used by the connection.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * Returns true if the SecurityGroupIdList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIdList() {
        return securityGroupIdList != null && !(securityGroupIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group ID list used by the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIdList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group ID list used by the connection.
     */
    public final List<String> securityGroupIdList() {
        return securityGroupIdList;
    }

    /**
     * <p>
     * The connection's Availability Zone. This field is redundant because the specified subnet implies the Availability
     * Zone to be used. Currently the field must be populated, but it will be deprecated in the future.
     * </p>
     * 
     * @return The connection's Availability Zone. This field is redundant because the specified subnet implies the
     *         Availability Zone to be used. Currently the field must be populated, but it will be deprecated in the
     *         future.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIdList() ? securityGroupIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalConnectionRequirements)) {
            return false;
        }
        PhysicalConnectionRequirements other = (PhysicalConnectionRequirements) obj;
        return Objects.equals(subnetId(), other.subnetId()) && hasSecurityGroupIdList() == other.hasSecurityGroupIdList()
                && Objects.equals(securityGroupIdList(), other.securityGroupIdList())
                && Objects.equals(availabilityZone(), other.availabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalConnectionRequirements").add("SubnetId", subnetId())
                .add("SecurityGroupIdList", hasSecurityGroupIdList() ? securityGroupIdList() : null)
                .add("AvailabilityZone", availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SecurityGroupIdList":
            return Optional.ofNullable(clazz.cast(securityGroupIdList()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhysicalConnectionRequirements, T> g) {
        return obj -> g.apply((PhysicalConnectionRequirements) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalConnectionRequirements> {
        /**
         * <p>
         * The subnet ID used by the connection.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID used by the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The security group ID list used by the connection.
         * </p>
         * 
         * @param securityGroupIdList
         *        The security group ID list used by the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdList(Collection<String> securityGroupIdList);

        /**
         * <p>
         * The security group ID list used by the connection.
         * </p>
         * 
         * @param securityGroupIdList
         *        The security group ID list used by the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdList(String... securityGroupIdList);

        /**
         * <p>
         * The connection's Availability Zone. This field is redundant because the specified subnet implies the
         * Availability Zone to be used. Currently the field must be populated, but it will be deprecated in the future.
         * </p>
         * 
         * @param availabilityZone
         *        The connection's Availability Zone. This field is redundant because the specified subnet implies the
         *        Availability Zone to be used. Currently the field must be populated, but it will be deprecated in the
         *        future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalConnectionRequirements model) {
            subnetId(model.subnetId);
            securityGroupIdList(model.securityGroupIdList);
            availabilityZone(model.availabilityZone);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<String> getSecurityGroupIdList() {
            if (securityGroupIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIdList;
        }

        @Override
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdList(String... securityGroupIdList) {
            securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public PhysicalConnectionRequirements build() {
            return new PhysicalConnectionRequirements(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
