/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Location implements SdkPojo, Serializable, ToCopyableBuilder<Location.Builder, Location> {
    private static final SdkField<List<CodeGenNodeArg>> JDBC_FIELD = SdkField
            .<List<CodeGenNodeArg>> builder(MarshallingType.LIST)
            .memberName("Jdbc")
            .getter(getter(Location::jdbc))
            .setter(setter(Builder::jdbc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jdbc").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeGenNodeArg> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenNodeArg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CodeGenNodeArg>> S3_FIELD = SdkField
            .<List<CodeGenNodeArg>> builder(MarshallingType.LIST)
            .memberName("S3")
            .getter(getter(Location::s3))
            .setter(setter(Builder::s3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeGenNodeArg> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenNodeArg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CodeGenNodeArg>> DYNAMO_DB_FIELD = SdkField
            .<List<CodeGenNodeArg>> builder(MarshallingType.LIST)
            .memberName("DynamoDB")
            .getter(getter(Location::dynamoDB))
            .setter(setter(Builder::dynamoDB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDB").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeGenNodeArg> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenNodeArg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JDBC_FIELD, S3_FIELD,
            DYNAMO_DB_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CodeGenNodeArg> jdbc;

    private final List<CodeGenNodeArg> s3;

    private final List<CodeGenNodeArg> dynamoDB;

    private Location(BuilderImpl builder) {
        this.jdbc = builder.jdbc;
        this.s3 = builder.s3;
        this.dynamoDB = builder.dynamoDB;
    }

    /**
     * Returns true if the Jdbc property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJdbc() {
        return jdbc != null && !(jdbc instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JDBC location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJdbc()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JDBC location.
     */
    public final List<CodeGenNodeArg> jdbc() {
        return jdbc;
    }

    /**
     * Returns true if the S3 property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasS3() {
        return s3 != null && !(s3 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An Amazon Simple Storage Service (Amazon S3) location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasS3()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An Amazon Simple Storage Service (Amazon S3) location.
     */
    public final List<CodeGenNodeArg> s3() {
        return s3;
    }

    /**
     * Returns true if the DynamoDB property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDynamoDB() {
        return dynamoDB != null && !(dynamoDB instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An Amazon DynamoDB table location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDynamoDB()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An Amazon DynamoDB table location.
     */
    public final List<CodeGenNodeArg> dynamoDB() {
        return dynamoDB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJdbc() ? jdbc() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasS3() ? s3() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDynamoDB() ? dynamoDB() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location) obj;
        return hasJdbc() == other.hasJdbc() && Objects.equals(jdbc(), other.jdbc()) && hasS3() == other.hasS3()
                && Objects.equals(s3(), other.s3()) && hasDynamoDB() == other.hasDynamoDB()
                && Objects.equals(dynamoDB(), other.dynamoDB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Location").add("Jdbc", hasJdbc() ? jdbc() : null).add("S3", hasS3() ? s3() : null)
                .add("DynamoDB", hasDynamoDB() ? dynamoDB() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Jdbc":
            return Optional.ofNullable(clazz.cast(jdbc()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "DynamoDB":
            return Optional.ofNullable(clazz.cast(dynamoDB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Location> {
        /**
         * <p>
         * A JDBC location.
         * </p>
         * 
         * @param jdbc
         *        A JDBC location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbc(Collection<CodeGenNodeArg> jdbc);

        /**
         * <p>
         * A JDBC location.
         * </p>
         * 
         * @param jdbc
         *        A JDBC location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbc(CodeGenNodeArg... jdbc);

        /**
         * <p>
         * A JDBC location.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeGenNodeArg>.Builder} avoiding the need
         * to create one manually via {@link List<CodeGenNodeArg>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeGenNodeArg>.Builder#build()} is called immediately and
         * its result is passed to {@link #jdbc(List<CodeGenNodeArg>)}.
         * 
         * @param jdbc
         *        a consumer that will call methods on {@link List<CodeGenNodeArg>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jdbc(List<CodeGenNodeArg>)
         */
        Builder jdbc(Consumer<CodeGenNodeArg.Builder>... jdbc);

        /**
         * <p>
         * An Amazon Simple Storage Service (Amazon S3) location.
         * </p>
         * 
         * @param s3
         *        An Amazon Simple Storage Service (Amazon S3) location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(Collection<CodeGenNodeArg> s3);

        /**
         * <p>
         * An Amazon Simple Storage Service (Amazon S3) location.
         * </p>
         * 
         * @param s3
         *        An Amazon Simple Storage Service (Amazon S3) location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(CodeGenNodeArg... s3);

        /**
         * <p>
         * An Amazon Simple Storage Service (Amazon S3) location.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeGenNodeArg>.Builder} avoiding the need
         * to create one manually via {@link List<CodeGenNodeArg>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeGenNodeArg>.Builder#build()} is called immediately and
         * its result is passed to {@link #s3(List<CodeGenNodeArg>)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link List<CodeGenNodeArg>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(List<CodeGenNodeArg>)
         */
        Builder s3(Consumer<CodeGenNodeArg.Builder>... s3);

        /**
         * <p>
         * An Amazon DynamoDB table location.
         * </p>
         * 
         * @param dynamoDB
         *        An Amazon DynamoDB table location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDB(Collection<CodeGenNodeArg> dynamoDB);

        /**
         * <p>
         * An Amazon DynamoDB table location.
         * </p>
         * 
         * @param dynamoDB
         *        An Amazon DynamoDB table location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDB(CodeGenNodeArg... dynamoDB);

        /**
         * <p>
         * An Amazon DynamoDB table location.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeGenNodeArg>.Builder} avoiding the need
         * to create one manually via {@link List<CodeGenNodeArg>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeGenNodeArg>.Builder#build()} is called immediately and
         * its result is passed to {@link #dynamoDB(List<CodeGenNodeArg>)}.
         * 
         * @param dynamoDB
         *        a consumer that will call methods on {@link List<CodeGenNodeArg>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDB(List<CodeGenNodeArg>)
         */
        Builder dynamoDB(Consumer<CodeGenNodeArg.Builder>... dynamoDB);
    }

    static final class BuilderImpl implements Builder {
        private List<CodeGenNodeArg> jdbc = DefaultSdkAutoConstructList.getInstance();

        private List<CodeGenNodeArg> s3 = DefaultSdkAutoConstructList.getInstance();

        private List<CodeGenNodeArg> dynamoDB = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            jdbc(model.jdbc);
            s3(model.s3);
            dynamoDB(model.dynamoDB);
        }

        public final Collection<CodeGenNodeArg.Builder> getJdbc() {
            if (jdbc instanceof SdkAutoConstructList) {
                return null;
            }
            return jdbc != null ? jdbc.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jdbc(Collection<CodeGenNodeArg> jdbc) {
            this.jdbc = CodeGenNodeArgsCopier.copy(jdbc);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbc(CodeGenNodeArg... jdbc) {
            jdbc(Arrays.asList(jdbc));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbc(Consumer<CodeGenNodeArg.Builder>... jdbc) {
            jdbc(Stream.of(jdbc).map(c -> CodeGenNodeArg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJdbc(Collection<CodeGenNodeArg.BuilderImpl> jdbc) {
            this.jdbc = CodeGenNodeArgsCopier.copyFromBuilder(jdbc);
        }

        public final Collection<CodeGenNodeArg.Builder> getS3() {
            if (s3 instanceof SdkAutoConstructList) {
                return null;
            }
            return s3 != null ? s3.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3(Collection<CodeGenNodeArg> s3) {
            this.s3 = CodeGenNodeArgsCopier.copy(s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(CodeGenNodeArg... s3) {
            s3(Arrays.asList(s3));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(Consumer<CodeGenNodeArg.Builder>... s3) {
            s3(Stream.of(s3).map(c -> CodeGenNodeArg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3(Collection<CodeGenNodeArg.BuilderImpl> s3) {
            this.s3 = CodeGenNodeArgsCopier.copyFromBuilder(s3);
        }

        public final Collection<CodeGenNodeArg.Builder> getDynamoDB() {
            if (dynamoDB instanceof SdkAutoConstructList) {
                return null;
            }
            return dynamoDB != null ? dynamoDB.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dynamoDB(Collection<CodeGenNodeArg> dynamoDB) {
            this.dynamoDB = CodeGenNodeArgsCopier.copy(dynamoDB);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDB(CodeGenNodeArg... dynamoDB) {
            dynamoDB(Arrays.asList(dynamoDB));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDB(Consumer<CodeGenNodeArg.Builder>... dynamoDB) {
            dynamoDB(Stream.of(dynamoDB).map(c -> CodeGenNodeArg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDynamoDB(Collection<CodeGenNodeArg.BuilderImpl> dynamoDB) {
            this.dynamoDB = CodeGenNodeArgsCopier.copyFromBuilder(dynamoDB);
        }

        @Override
        public Location build() {
            return new Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
