/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemasResponse extends GlueResponse implements
        ToCopyableBuilder<ListSchemasResponse.Builder, ListSchemasResponse> {
    private static final SdkField<List<SchemaListItem>> SCHEMAS_FIELD = SdkField
            .<List<SchemaListItem>> builder(MarshallingType.LIST)
            .memberName("Schemas")
            .getter(getter(ListSchemasResponse::schemas))
            .setter(setter(Builder::schemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchemasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMAS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SchemaListItem> schemas;

    private final String nextToken;

    private ListSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.schemas = builder.schemas;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Schemas property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSchemas() {
        return schemas != null && !(schemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>SchemaListItem</code> objects containing details of each schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>SchemaListItem</code> objects containing details of each schema.
     */
    public final List<SchemaListItem> schemas() {
        return schemas;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemas() ? schemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasResponse)) {
            return false;
        }
        ListSchemasResponse other = (ListSchemasResponse) obj;
        return hasSchemas() == other.hasSchemas() && Objects.equals(schemas(), other.schemas())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemasResponse").add("Schemas", hasSchemas() ? schemas() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Schemas":
            return Optional.ofNullable(clazz.cast(schemas()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasResponse, T> g) {
        return obj -> g.apply((ListSchemasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemasResponse> {
        /**
         * <p>
         * An array of <code>SchemaListItem</code> objects containing details of each schema.
         * </p>
         * 
         * @param schemas
         *        An array of <code>SchemaListItem</code> objects containing details of each schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(Collection<SchemaListItem> schemas);

        /**
         * <p>
         * An array of <code>SchemaListItem</code> objects containing details of each schema.
         * </p>
         * 
         * @param schemas
         *        An array of <code>SchemaListItem</code> objects containing details of each schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemas(SchemaListItem... schemas);

        /**
         * <p>
         * An array of <code>SchemaListItem</code> objects containing details of each schema.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaListItem>.Builder} avoiding the need
         * to create one manually via {@link List<SchemaListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaListItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #schemas(List<SchemaListItem>)}.
         * 
         * @param schemas
         *        a consumer that will call methods on {@link List<SchemaListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemas(List<SchemaListItem>)
         */
        Builder schemas(Consumer<SchemaListItem.Builder>... schemas);

        /**
         * <p>
         * A continuation token for paginating the returned list of tokens, returned if the current segment of the list
         * is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of tokens, returned if the current segment of
         *        the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<SchemaListItem> schemas = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasResponse model) {
            super(model);
            schemas(model.schemas);
            nextToken(model.nextToken);
        }

        public final Collection<SchemaListItem.Builder> getSchemas() {
            if (schemas instanceof SdkAutoConstructList) {
                return null;
            }
            return schemas != null ? schemas.stream().map(SchemaListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemas(Collection<SchemaListItem> schemas) {
            this.schemas = SchemaListDefinitionCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(SchemaListItem... schemas) {
            schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<SchemaListItem.Builder>... schemas) {
            schemas(Stream.of(schemas).map(c -> SchemaListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemas(Collection<SchemaListItem.BuilderImpl> schemas) {
            this.schemas = SchemaListDefinitionCopier.copyFromBuilder(schemas);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSchemasResponse build() {
            return new ListSchemasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
