/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegistryResponse extends GlueResponse implements
        ToCopyableBuilder<GetRegistryResponse.Builder, GetRegistryResponse> {
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(GetRegistryResponse::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryName").build()).build();

    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryArn").getter(getter(GetRegistryResponse::registryArn)).setter(setter(Builder::registryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetRegistryResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetRegistryResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(GetRegistryResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedTime").getter(getter(GetRegistryResponse::updatedTime)).setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_NAME_FIELD,
            REGISTRY_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD));

    private final String registryName;

    private final String registryArn;

    private final String description;

    private final String status;

    private final String createdTime;

    private final String updatedTime;

    private GetRegistryResponse(BuilderImpl builder) {
        super(builder);
        this.registryName = builder.registryName;
        this.registryArn = builder.registryArn;
        this.description = builder.description;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the registry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the registry.
     */
    public final String registryArn() {
        return registryArn;
    }

    /**
     * <p>
     * A description of the registry.
     * </p>
     * 
     * @return A description of the registry.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the registry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the registry.
     * @see RegistryStatus
     */
    public final RegistryStatus status() {
        return RegistryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the registry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the registry.
     * @see RegistryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the registry was created.
     * </p>
     * 
     * @return The date and time the registry was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time the registry was updated.
     * </p>
     * 
     * @return The date and time the registry was updated.
     */
    public final String updatedTime() {
        return updatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegistryResponse)) {
            return false;
        }
        GetRegistryResponse other = (GetRegistryResponse) obj;
        return Objects.equals(registryName(), other.registryName()) && Objects.equals(registryArn(), other.registryArn())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(updatedTime(), other.updatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegistryResponse").add("RegistryName", registryName()).add("RegistryArn", registryArn())
                .add("Description", description()).add("Status", statusAsString()).add("CreatedTime", createdTime())
                .add("UpdatedTime", updatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "RegistryArn":
            return Optional.ofNullable(clazz.cast(registryArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "UpdatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRegistryResponse, T> g) {
        return obj -> g.apply((GetRegistryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRegistryResponse> {
        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the registry.
         * </p>
         * 
         * @param registryArn
         *        The Amazon Resource Name (ARN) of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryArn(String registryArn);

        /**
         * <p>
         * A description of the registry.
         * </p>
         * 
         * @param description
         *        A description of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the registry.
         * </p>
         * 
         * @param status
         *        The status of the registry.
         * @see RegistryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the registry.
         * </p>
         * 
         * @param status
         *        The status of the registry.
         * @see RegistryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryStatus
         */
        Builder status(RegistryStatus status);

        /**
         * <p>
         * The date and time the registry was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the registry was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The date and time the registry was updated.
         * </p>
         * 
         * @param updatedTime
         *        The date and time the registry was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(String updatedTime);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String registryName;

        private String registryArn;

        private String description;

        private String status;

        private String createdTime;

        private String updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegistryResponse model) {
            super(model);
            registryName(model.registryName);
            registryArn(model.registryArn);
            description(model.description);
            status(model.status);
            createdTime(model.createdTime);
            updatedTime(model.updatedTime);
        }

        public final String getRegistryName() {
            return registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getRegistryArn() {
            return registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public final String getUpdatedTime() {
            return updatedTime;
        }

        @Override
        public final Builder updatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public GetRegistryResponse build() {
            return new GetRegistryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
