/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMlTransformRequest extends GlueRequest implements
        ToCopyableBuilder<CreateMlTransformRequest.Builder, CreateMlTransformRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateMlTransformRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMlTransformRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<GlueTable>> INPUT_RECORD_TABLES_FIELD = SdkField
            .<List<GlueTable>> builder(MarshallingType.LIST)
            .memberName("InputRecordTables")
            .getter(getter(CreateMlTransformRequest::inputRecordTables))
            .setter(setter(Builder::inputRecordTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRecordTables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TransformParameters> PARAMETERS_FIELD = SdkField
            .<TransformParameters> builder(MarshallingType.SDK_POJO).memberName("Parameters")
            .getter(getter(CreateMlTransformRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(TransformParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateMlTransformRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueVersion").getter(getter(CreateMlTransformRequest::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(CreateMlTransformRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerType").getter(getter(CreateMlTransformRequest::workerTypeAsString))
            .setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(CreateMlTransformRequest::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(CreateMlTransformRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(CreateMlTransformRequest::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateMlTransformRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TransformEncryption> TRANSFORM_ENCRYPTION_FIELD = SdkField
            .<TransformEncryption> builder(MarshallingType.SDK_POJO).memberName("TransformEncryption")
            .getter(getter(CreateMlTransformRequest::transformEncryption)).setter(setter(Builder::transformEncryption))
            .constructor(TransformEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INPUT_RECORD_TABLES_FIELD, PARAMETERS_FIELD, ROLE_FIELD, GLUE_VERSION_FIELD, MAX_CAPACITY_FIELD, WORKER_TYPE_FIELD,
            NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, MAX_RETRIES_FIELD, TAGS_FIELD, TRANSFORM_ENCRYPTION_FIELD));

    private final String name;

    private final String description;

    private final List<GlueTable> inputRecordTables;

    private final TransformParameters parameters;

    private final String role;

    private final String glueVersion;

    private final Double maxCapacity;

    private final String workerType;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final Integer maxRetries;

    private final Map<String, String> tags;

    private final TransformEncryption transformEncryption;

    private CreateMlTransformRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.inputRecordTables = builder.inputRecordTables;
        this.parameters = builder.parameters;
        this.role = builder.role;
        this.glueVersion = builder.glueVersion;
        this.maxCapacity = builder.maxCapacity;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
        this.tags = builder.tags;
        this.transformEncryption = builder.transformEncryption;
    }

    /**
     * <p>
     * The unique name that you give the transform when you create it.
     * </p>
     * 
     * @return The unique name that you give the transform when you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the machine learning transform that is being defined. The default is an empty string.
     * </p>
     * 
     * @return A description of the machine learning transform that is being defined. The default is an empty string.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the InputRecordTables property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputRecordTables() {
        return inputRecordTables != null && !(inputRecordTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS Glue table definitions used by the transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputRecordTables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS Glue table definitions used by the transform.
     */
    public final List<GlueTable> inputRecordTables() {
        return inputRecordTables;
    }

    /**
     * <p>
     * The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform
     * type.
     * </p>
     * 
     * @return The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the
     *         transform type.
     */
    public final TransformParameters parameters() {
        return parameters;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions
     * include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the
     * transform.
     * </p>
     * <ul>
     * <li>
     * <p>
     * This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That
     * Access AWS Glue</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     * directory, scripts, and any libraries used by the task run for this transform.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required
     *         permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3
     *         permissions required by the transform. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM
     *         Users That Access AWS Glue</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
     *         directory, scripts, and any libraries used by the task run for this transform.
     *         </p>
     *         </li>
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a>
     * in the developer guide.
     * </p>
     * 
     * @return This value determines which version of AWS Glue this machine learning transform is compatible with. Glue
     *         1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue
     *         0.9. For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
     *         Versions</a> in the developer guide.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
     * </p>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * 
     * @return The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     *         You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power
     *         that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *         href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
     *         <p>
     *         <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *         <code>WorkerType</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *         cannot be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *         can be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *         <code>MaxCapacity</code> field is set automatically and becomes read-only.
     *         </p>
     *         <p>
     *         When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *         <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X,
     *         or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *         <code>WorkerType</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *         cannot be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *         can be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public final WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     * <code>WorkerType</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be
     * set.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X,
     *         or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
     *         <code>WorkerType</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
     *         cannot be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code>
     *         can be set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public final String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
     * </p>
     * <p>
     * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
     *         <p>
     *         If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout of the task run for this transform in minutes. This is the maximum time that a task run for this
     * transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is
     * 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout of the task run for this transform in minutes. This is the maximum time that a task run for
     *         this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The
     *         default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The maximum number of times to retry a task for this transform after a task run fails.
     * </p>
     * 
     * @return The maximum number of times to retry a task for this transform after a task run fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to use with this machine learning transform. You may use tags to limit access to the machine learning
     * transform. For more information about tags in AWS Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer
     * guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to use with this machine learning transform. You may use tags to limit access to the machine
     *         learning transform. For more information about tags in AWS Glue, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the
     *         developer guide.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms
     * can access user data encrypted in Amazon S3 using KMS.
     * </p>
     * 
     * @return The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
     *         transforms can access user data encrypted in Amazon S3 using KMS.
     */
    public final TransformEncryption transformEncryption() {
        return transformEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputRecordTables() ? inputRecordTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transformEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlTransformRequest)) {
            return false;
        }
        CreateMlTransformRequest other = (CreateMlTransformRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasInputRecordTables() == other.hasInputRecordTables()
                && Objects.equals(inputRecordTables(), other.inputRecordTables())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(role(), other.role())
                && Objects.equals(glueVersion(), other.glueVersion()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(maxRetries(), other.maxRetries()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(transformEncryption(), other.transformEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMlTransformRequest").add("Name", name()).add("Description", description())
                .add("InputRecordTables", hasInputRecordTables() ? inputRecordTables() : null).add("Parameters", parameters())
                .add("Role", role()).add("GlueVersion", glueVersion()).add("MaxCapacity", maxCapacity())
                .add("WorkerType", workerTypeAsString()).add("NumberOfWorkers", numberOfWorkers()).add("Timeout", timeout())
                .add("MaxRetries", maxRetries()).add("Tags", hasTags() ? tags() : null)
                .add("TransformEncryption", transformEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InputRecordTables":
            return Optional.ofNullable(clazz.cast(inputRecordTables()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TransformEncryption":
            return Optional.ofNullable(clazz.cast(transformEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMlTransformRequest, T> g) {
        return obj -> g.apply((CreateMlTransformRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMlTransformRequest> {
        /**
         * <p>
         * The unique name that you give the transform when you create it.
         * </p>
         * 
         * @param name
         *        The unique name that you give the transform when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the machine learning transform that is being defined. The default is an empty string.
         * </p>
         * 
         * @param description
         *        A description of the machine learning transform that is being defined. The default is an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of AWS Glue table definitions used by the transform.
         * </p>
         * 
         * @param inputRecordTables
         *        A list of AWS Glue table definitions used by the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecordTables(Collection<GlueTable> inputRecordTables);

        /**
         * <p>
         * A list of AWS Glue table definitions used by the transform.
         * </p>
         * 
         * @param inputRecordTables
         *        A list of AWS Glue table definitions used by the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecordTables(GlueTable... inputRecordTables);

        /**
         * <p>
         * A list of AWS Glue table definitions used by the transform.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlueTable>.Builder} avoiding the need to
         * create one manually via {@link List<GlueTable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlueTable>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputRecordTables(List<GlueTable>)}.
         * 
         * @param inputRecordTables
         *        a consumer that will call methods on {@link List<GlueTable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputRecordTables(List<GlueTable>)
         */
        Builder inputRecordTables(Consumer<GlueTable.Builder>... inputRecordTables);

        /**
         * <p>
         * The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the
         * transform type.
         * </p>
         * 
         * @param parameters
         *        The algorithmic parameters that are specific to the transform type used. Conditionally dependent on
         *        the transform type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(TransformParameters parameters);

        /**
         * <p>
         * The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the
         * transform type.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformParameters.Builder} avoiding the need
         * to create one manually via {@link TransformParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(TransformParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link TransformParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(TransformParameters)
         */
        default Builder parameters(Consumer<TransformParameters.Builder> parameters) {
            return parameters(TransformParameters.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required
         * permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions
         * required by the transform.
         * </p>
         * <ul>
         * <li>
         * <p>
         * This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users
         * That Access AWS Glue</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary
         * directory, scripts, and any libraries used by the task run for this transform.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required
         *        permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3
         *        permissions required by the transform. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM
         *        Users That Access AWS Glue</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets,
         *        temporary directory, scripts, and any libraries used by the task run for this transform.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0
         * is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
         * Versions</a> in the developer guide.
         * </p>
         * 
         * @param glueVersion
         *        This value determines which version of AWS Glue this machine learning transform is compatible with.
         *        Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults
         *        to Glue 0.9. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
         *        Versions</a> in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You
         * can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that
         * consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
         * href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
         * </p>
         * <p>
         * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
         * <code>WorkerType</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
         * cannot be set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can
         * be set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         * <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * </p>
         * <p>
         * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         * <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * </p>
         * 
         * @param maxCapacity
         *        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this
         *        transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
         *        processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
         *        information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
         *        <p>
         *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
         *        <code>WorkerType</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then
         *        <code>MaxCapacity</code> cannot be set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or
         *        <code>WorkerType</code> can be set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         *        <code>MaxCapacity</code> field is set automatically and becomes read-only.
         *        </p>
         *        <p>
         *        When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         *        <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);

        /**
         * <p>
         * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or
         * G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
         * <code>WorkerType</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
         * cannot be set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can
         * be set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when this task runs. Accepts a value of Standard,
         *        G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
         *        <code>WorkerType</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then
         *        <code>MaxCapacity</code> cannot be set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or
         *        <code>WorkerType</code> can be set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or
         * G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
         * <code>WorkerType</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code>
         * cannot be set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can
         * be set.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when this task runs. Accepts a value of Standard,
         *        G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and
         *        <code>WorkerType</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then
         *        <code>MaxCapacity</code> cannot be set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or
         *        <code>WorkerType</code> can be set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
         * </p>
         * <p>
         * If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
         *        <p>
         *        If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout of the task run for this transform in minutes. This is the maximum time that a task run for this
         * transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
         * is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout of the task run for this transform in minutes. This is the maximum time that a task run
         *        for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code>
         *        status. The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The maximum number of times to retry a task for this transform after a task run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry a task for this transform after a task run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * The tags to use with this machine learning transform. You may use tags to limit access to the machine
         * learning transform. For more information about tags in AWS Glue, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer
         * guide.
         * </p>
         * 
         * @param tags
         *        The tags to use with this machine learning transform. You may use tags to limit access to the machine
         *        learning transform. For more information about tags in AWS Glue, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the
         *        developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
         * transforms can access user data encrypted in Amazon S3 using KMS.
         * </p>
         * 
         * @param transformEncryption
         *        The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
         *        transforms can access user data encrypted in Amazon S3 using KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformEncryption(TransformEncryption transformEncryption);

        /**
         * <p>
         * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
         * transforms can access user data encrypted in Amazon S3 using KMS.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformEncryption.Builder} avoiding the need
         * to create one manually via {@link TransformEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #transformEncryption(TransformEncryption)}.
         * 
         * @param transformEncryption
         *        a consumer that will call methods on {@link TransformEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformEncryption(TransformEncryption)
         */
        default Builder transformEncryption(Consumer<TransformEncryption.Builder> transformEncryption) {
            return transformEncryption(TransformEncryption.builder().applyMutation(transformEncryption).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<GlueTable> inputRecordTables = DefaultSdkAutoConstructList.getInstance();

        private TransformParameters parameters;

        private String role;

        private String glueVersion;

        private Double maxCapacity;

        private String workerType;

        private Integer numberOfWorkers;

        private Integer timeout;

        private Integer maxRetries;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private TransformEncryption transformEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlTransformRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            inputRecordTables(model.inputRecordTables);
            parameters(model.parameters);
            role(model.role);
            glueVersion(model.glueVersion);
            maxCapacity(model.maxCapacity);
            workerType(model.workerType);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            maxRetries(model.maxRetries);
            tags(model.tags);
            transformEncryption(model.transformEncryption);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GlueTable.Builder> getInputRecordTables() {
            if (inputRecordTables instanceof SdkAutoConstructList) {
                return null;
            }
            return inputRecordTables != null ? inputRecordTables.stream().map(GlueTable::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder inputRecordTables(Collection<GlueTable> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copy(inputRecordTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(GlueTable... inputRecordTables) {
            inputRecordTables(Arrays.asList(inputRecordTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(Consumer<GlueTable.Builder>... inputRecordTables) {
            inputRecordTables(Stream.of(inputRecordTables).map(c -> GlueTable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputRecordTables(Collection<GlueTable.BuilderImpl> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copyFromBuilder(inputRecordTables);
        }

        public final TransformParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(TransformParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(TransformParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getWorkerType() {
            return workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final TransformEncryption.Builder getTransformEncryption() {
            return transformEncryption != null ? transformEncryption.toBuilder() : null;
        }

        @Override
        public final Builder transformEncryption(TransformEncryption transformEncryption) {
            this.transformEncryption = transformEncryption;
            return this;
        }

        public final void setTransformEncryption(TransformEncryption.BuilderImpl transformEncryption) {
            this.transformEncryption = transformEncryption != null ? transformEncryption.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlTransformRequest build() {
            return new CreateMlTransformRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
