/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies data stores to crawl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrawlerTargets implements SdkPojo, Serializable, ToCopyableBuilder<CrawlerTargets.Builder, CrawlerTargets> {
    private static final SdkField<List<S3Target>> S3_TARGETS_FIELD = SdkField
            .<List<S3Target>> builder(MarshallingType.LIST)
            .memberName("S3Targets")
            .getter(getter(CrawlerTargets::s3Targets))
            .setter(setter(Builder::s3Targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<JdbcTarget>> JDBC_TARGETS_FIELD = SdkField
            .<List<JdbcTarget>> builder(MarshallingType.LIST)
            .memberName("JdbcTargets")
            .getter(getter(CrawlerTargets::jdbcTargets))
            .setter(setter(Builder::jdbcTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JdbcTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JdbcTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(JdbcTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MongoDBTarget>> MONGO_DB_TARGETS_FIELD = SdkField
            .<List<MongoDBTarget>> builder(MarshallingType.LIST)
            .memberName("MongoDBTargets")
            .getter(getter(CrawlerTargets::mongoDBTargets))
            .setter(setter(Builder::mongoDBTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDBTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MongoDBTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(MongoDBTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DynamoDBTarget>> DYNAMO_DB_TARGETS_FIELD = SdkField
            .<List<DynamoDBTarget>> builder(MarshallingType.LIST)
            .memberName("DynamoDBTargets")
            .getter(getter(CrawlerTargets::dynamoDBTargets))
            .setter(setter(Builder::dynamoDBTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DynamoDBTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(DynamoDBTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CatalogTarget>> CATALOG_TARGETS_FIELD = SdkField
            .<List<CatalogTarget>> builder(MarshallingType.LIST)
            .memberName("CatalogTargets")
            .getter(getter(CrawlerTargets::catalogTargets))
            .setter(setter(Builder::catalogTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CatalogTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(CatalogTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_TARGETS_FIELD,
            JDBC_TARGETS_FIELD, MONGO_DB_TARGETS_FIELD, DYNAMO_DB_TARGETS_FIELD, CATALOG_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<S3Target> s3Targets;

    private final List<JdbcTarget> jdbcTargets;

    private final List<MongoDBTarget> mongoDBTargets;

    private final List<DynamoDBTarget> dynamoDBTargets;

    private final List<CatalogTarget> catalogTargets;

    private CrawlerTargets(BuilderImpl builder) {
        this.s3Targets = builder.s3Targets;
        this.jdbcTargets = builder.jdbcTargets;
        this.mongoDBTargets = builder.mongoDBTargets;
        this.dynamoDBTargets = builder.dynamoDBTargets;
        this.catalogTargets = builder.catalogTargets;
    }

    /**
     * Returns true if the S3Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasS3Targets() {
        return s3Targets != null && !(s3Targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies Amazon Simple Storage Service (Amazon S3) targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasS3Targets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies Amazon Simple Storage Service (Amazon S3) targets.
     */
    public final List<S3Target> s3Targets() {
        return s3Targets;
    }

    /**
     * Returns true if the JdbcTargets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJdbcTargets() {
        return jdbcTargets != null && !(jdbcTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies JDBC targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJdbcTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies JDBC targets.
     */
    public final List<JdbcTarget> jdbcTargets() {
        return jdbcTargets;
    }

    /**
     * Returns true if the MongoDBTargets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMongoDBTargets() {
        return mongoDBTargets != null && !(mongoDBTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies Amazon DocumentDB or MongoDB targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMongoDBTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies Amazon DocumentDB or MongoDB targets.
     */
    public final List<MongoDBTarget> mongoDBTargets() {
        return mongoDBTargets;
    }

    /**
     * Returns true if the DynamoDBTargets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDynamoDBTargets() {
        return dynamoDBTargets != null && !(dynamoDBTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies Amazon DynamoDB targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDynamoDBTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies Amazon DynamoDB targets.
     */
    public final List<DynamoDBTarget> dynamoDBTargets() {
        return dynamoDBTargets;
    }

    /**
     * Returns true if the CatalogTargets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCatalogTargets() {
        return catalogTargets != null && !(catalogTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies AWS Glue Data Catalog targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCatalogTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies AWS Glue Data Catalog targets.
     */
    public final List<CatalogTarget> catalogTargets() {
        return catalogTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Targets() ? s3Targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJdbcTargets() ? jdbcTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMongoDBTargets() ? mongoDBTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDynamoDBTargets() ? dynamoDBTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCatalogTargets() ? catalogTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerTargets)) {
            return false;
        }
        CrawlerTargets other = (CrawlerTargets) obj;
        return hasS3Targets() == other.hasS3Targets() && Objects.equals(s3Targets(), other.s3Targets())
                && hasJdbcTargets() == other.hasJdbcTargets() && Objects.equals(jdbcTargets(), other.jdbcTargets())
                && hasMongoDBTargets() == other.hasMongoDBTargets() && Objects.equals(mongoDBTargets(), other.mongoDBTargets())
                && hasDynamoDBTargets() == other.hasDynamoDBTargets()
                && Objects.equals(dynamoDBTargets(), other.dynamoDBTargets()) && hasCatalogTargets() == other.hasCatalogTargets()
                && Objects.equals(catalogTargets(), other.catalogTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrawlerTargets").add("S3Targets", hasS3Targets() ? s3Targets() : null)
                .add("JdbcTargets", hasJdbcTargets() ? jdbcTargets() : null)
                .add("MongoDBTargets", hasMongoDBTargets() ? mongoDBTargets() : null)
                .add("DynamoDBTargets", hasDynamoDBTargets() ? dynamoDBTargets() : null)
                .add("CatalogTargets", hasCatalogTargets() ? catalogTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Targets":
            return Optional.ofNullable(clazz.cast(s3Targets()));
        case "JdbcTargets":
            return Optional.ofNullable(clazz.cast(jdbcTargets()));
        case "MongoDBTargets":
            return Optional.ofNullable(clazz.cast(mongoDBTargets()));
        case "DynamoDBTargets":
            return Optional.ofNullable(clazz.cast(dynamoDBTargets()));
        case "CatalogTargets":
            return Optional.ofNullable(clazz.cast(catalogTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlerTargets, T> g) {
        return obj -> g.apply((CrawlerTargets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrawlerTargets> {
        /**
         * <p>
         * Specifies Amazon Simple Storage Service (Amazon S3) targets.
         * </p>
         * 
         * @param s3Targets
         *        Specifies Amazon Simple Storage Service (Amazon S3) targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Targets(Collection<S3Target> s3Targets);

        /**
         * <p>
         * Specifies Amazon Simple Storage Service (Amazon S3) targets.
         * </p>
         * 
         * @param s3Targets
         *        Specifies Amazon Simple Storage Service (Amazon S3) targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Targets(S3Target... s3Targets);

        /**
         * <p>
         * Specifies Amazon Simple Storage Service (Amazon S3) targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3Target>.Builder} avoiding the need to
         * create one manually via {@link List<S3Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Targets(List<S3Target>)}.
         * 
         * @param s3Targets
         *        a consumer that will call methods on {@link List<S3Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Targets(List<S3Target>)
         */
        Builder s3Targets(Consumer<S3Target.Builder>... s3Targets);

        /**
         * <p>
         * Specifies JDBC targets.
         * </p>
         * 
         * @param jdbcTargets
         *        Specifies JDBC targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbcTargets(Collection<JdbcTarget> jdbcTargets);

        /**
         * <p>
         * Specifies JDBC targets.
         * </p>
         * 
         * @param jdbcTargets
         *        Specifies JDBC targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jdbcTargets(JdbcTarget... jdbcTargets);

        /**
         * <p>
         * Specifies JDBC targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JdbcTarget>.Builder} avoiding the need to
         * create one manually via {@link List<JdbcTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JdbcTarget>.Builder#build()} is called immediately and its
         * result is passed to {@link #jdbcTargets(List<JdbcTarget>)}.
         * 
         * @param jdbcTargets
         *        a consumer that will call methods on {@link List<JdbcTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jdbcTargets(List<JdbcTarget>)
         */
        Builder jdbcTargets(Consumer<JdbcTarget.Builder>... jdbcTargets);

        /**
         * <p>
         * Specifies Amazon DocumentDB or MongoDB targets.
         * </p>
         * 
         * @param mongoDBTargets
         *        Specifies Amazon DocumentDB or MongoDB targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mongoDBTargets(Collection<MongoDBTarget> mongoDBTargets);

        /**
         * <p>
         * Specifies Amazon DocumentDB or MongoDB targets.
         * </p>
         * 
         * @param mongoDBTargets
         *        Specifies Amazon DocumentDB or MongoDB targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mongoDBTargets(MongoDBTarget... mongoDBTargets);

        /**
         * <p>
         * Specifies Amazon DocumentDB or MongoDB targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MongoDBTarget>.Builder} avoiding the need
         * to create one manually via {@link List<MongoDBTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MongoDBTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #mongoDBTargets(List<MongoDBTarget>)}.
         * 
         * @param mongoDBTargets
         *        a consumer that will call methods on {@link List<MongoDBTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mongoDBTargets(List<MongoDBTarget>)
         */
        Builder mongoDBTargets(Consumer<MongoDBTarget.Builder>... mongoDBTargets);

        /**
         * <p>
         * Specifies Amazon DynamoDB targets.
         * </p>
         * 
         * @param dynamoDBTargets
         *        Specifies Amazon DynamoDB targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBTargets(Collection<DynamoDBTarget> dynamoDBTargets);

        /**
         * <p>
         * Specifies Amazon DynamoDB targets.
         * </p>
         * 
         * @param dynamoDBTargets
         *        Specifies Amazon DynamoDB targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBTargets(DynamoDBTarget... dynamoDBTargets);

        /**
         * <p>
         * Specifies Amazon DynamoDB targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DynamoDBTarget>.Builder} avoiding the need
         * to create one manually via {@link List<DynamoDBTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DynamoDBTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #dynamoDBTargets(List<DynamoDBTarget>)}.
         * 
         * @param dynamoDBTargets
         *        a consumer that will call methods on {@link List<DynamoDBTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBTargets(List<DynamoDBTarget>)
         */
        Builder dynamoDBTargets(Consumer<DynamoDBTarget.Builder>... dynamoDBTargets);

        /**
         * <p>
         * Specifies AWS Glue Data Catalog targets.
         * </p>
         * 
         * @param catalogTargets
         *        Specifies AWS Glue Data Catalog targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogTargets(Collection<CatalogTarget> catalogTargets);

        /**
         * <p>
         * Specifies AWS Glue Data Catalog targets.
         * </p>
         * 
         * @param catalogTargets
         *        Specifies AWS Glue Data Catalog targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogTargets(CatalogTarget... catalogTargets);

        /**
         * <p>
         * Specifies AWS Glue Data Catalog targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CatalogTarget>.Builder} avoiding the need
         * to create one manually via {@link List<CatalogTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CatalogTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #catalogTargets(List<CatalogTarget>)}.
         * 
         * @param catalogTargets
         *        a consumer that will call methods on {@link List<CatalogTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogTargets(List<CatalogTarget>)
         */
        Builder catalogTargets(Consumer<CatalogTarget.Builder>... catalogTargets);
    }

    static final class BuilderImpl implements Builder {
        private List<S3Target> s3Targets = DefaultSdkAutoConstructList.getInstance();

        private List<JdbcTarget> jdbcTargets = DefaultSdkAutoConstructList.getInstance();

        private List<MongoDBTarget> mongoDBTargets = DefaultSdkAutoConstructList.getInstance();

        private List<DynamoDBTarget> dynamoDBTargets = DefaultSdkAutoConstructList.getInstance();

        private List<CatalogTarget> catalogTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerTargets model) {
            s3Targets(model.s3Targets);
            jdbcTargets(model.jdbcTargets);
            mongoDBTargets(model.mongoDBTargets);
            dynamoDBTargets(model.dynamoDBTargets);
            catalogTargets(model.catalogTargets);
        }

        public final Collection<S3Target.Builder> getS3Targets() {
            if (s3Targets instanceof SdkAutoConstructList) {
                return null;
            }
            return s3Targets != null ? s3Targets.stream().map(S3Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Targets(Collection<S3Target> s3Targets) {
            this.s3Targets = S3TargetListCopier.copy(s3Targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Targets(S3Target... s3Targets) {
            s3Targets(Arrays.asList(s3Targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Targets(Consumer<S3Target.Builder>... s3Targets) {
            s3Targets(Stream.of(s3Targets).map(c -> S3Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Targets(Collection<S3Target.BuilderImpl> s3Targets) {
            this.s3Targets = S3TargetListCopier.copyFromBuilder(s3Targets);
        }

        public final Collection<JdbcTarget.Builder> getJdbcTargets() {
            if (jdbcTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return jdbcTargets != null ? jdbcTargets.stream().map(JdbcTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jdbcTargets(Collection<JdbcTarget> jdbcTargets) {
            this.jdbcTargets = JdbcTargetListCopier.copy(jdbcTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbcTargets(JdbcTarget... jdbcTargets) {
            jdbcTargets(Arrays.asList(jdbcTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbcTargets(Consumer<JdbcTarget.Builder>... jdbcTargets) {
            jdbcTargets(Stream.of(jdbcTargets).map(c -> JdbcTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setJdbcTargets(Collection<JdbcTarget.BuilderImpl> jdbcTargets) {
            this.jdbcTargets = JdbcTargetListCopier.copyFromBuilder(jdbcTargets);
        }

        public final Collection<MongoDBTarget.Builder> getMongoDBTargets() {
            if (mongoDBTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return mongoDBTargets != null ? mongoDBTargets.stream().map(MongoDBTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder mongoDBTargets(Collection<MongoDBTarget> mongoDBTargets) {
            this.mongoDBTargets = MongoDBTargetListCopier.copy(mongoDBTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mongoDBTargets(MongoDBTarget... mongoDBTargets) {
            mongoDBTargets(Arrays.asList(mongoDBTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mongoDBTargets(Consumer<MongoDBTarget.Builder>... mongoDBTargets) {
            mongoDBTargets(Stream.of(mongoDBTargets).map(c -> MongoDBTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMongoDBTargets(Collection<MongoDBTarget.BuilderImpl> mongoDBTargets) {
            this.mongoDBTargets = MongoDBTargetListCopier.copyFromBuilder(mongoDBTargets);
        }

        public final Collection<DynamoDBTarget.Builder> getDynamoDBTargets() {
            if (dynamoDBTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return dynamoDBTargets != null ? dynamoDBTargets.stream().map(DynamoDBTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dynamoDBTargets(Collection<DynamoDBTarget> dynamoDBTargets) {
            this.dynamoDBTargets = DynamoDBTargetListCopier.copy(dynamoDBTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDBTargets(DynamoDBTarget... dynamoDBTargets) {
            dynamoDBTargets(Arrays.asList(dynamoDBTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDBTargets(Consumer<DynamoDBTarget.Builder>... dynamoDBTargets) {
            dynamoDBTargets(Stream.of(dynamoDBTargets).map(c -> DynamoDBTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDynamoDBTargets(Collection<DynamoDBTarget.BuilderImpl> dynamoDBTargets) {
            this.dynamoDBTargets = DynamoDBTargetListCopier.copyFromBuilder(dynamoDBTargets);
        }

        public final Collection<CatalogTarget.Builder> getCatalogTargets() {
            if (catalogTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return catalogTargets != null ? catalogTargets.stream().map(CatalogTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder catalogTargets(Collection<CatalogTarget> catalogTargets) {
            this.catalogTargets = CatalogTargetListCopier.copy(catalogTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogTargets(CatalogTarget... catalogTargets) {
            catalogTargets(Arrays.asList(catalogTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder catalogTargets(Consumer<CatalogTarget.Builder>... catalogTargets) {
            catalogTargets(Stream.of(catalogTargets).map(c -> CatalogTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCatalogTargets(Collection<CatalogTarget.BuilderImpl> catalogTargets) {
            this.catalogTargets = CatalogTargetListCopier.copyFromBuilder(catalogTargets);
        }

        @Override
        public CrawlerTargets build() {
            return new CrawlerTargets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
