/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the column name and column importance score for a column.
 * </p>
 * <p>
 * Column importance helps you understand how columns contribute to your model, by identifying which columns in your
 * records are more important than others.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnImportance implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnImportance.Builder, ColumnImportance> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(ColumnImportance::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<Double> IMPORTANCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Importance").getter(getter(ColumnImportance::importance)).setter(setter(Builder::importance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Importance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            IMPORTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final Double importance;

    private ColumnImportance(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.importance = builder.importance;
    }

    /**
     * <p>
     * The name of a column.
     * </p>
     * 
     * @return The name of a column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The column importance score for the column, as a decimal.
     * </p>
     * 
     * @return The column importance score for the column, as a decimal.
     */
    public final Double importance() {
        return importance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(importance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnImportance)) {
            return false;
        }
        ColumnImportance other = (ColumnImportance) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(importance(), other.importance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnImportance").add("ColumnName", columnName()).add("Importance", importance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "Importance":
            return Optional.ofNullable(clazz.cast(importance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnImportance, T> g) {
        return obj -> g.apply((ColumnImportance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnImportance> {
        /**
         * <p>
         * The name of a column.
         * </p>
         * 
         * @param columnName
         *        The name of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The column importance score for the column, as a decimal.
         * </p>
         * 
         * @param importance
         *        The column importance score for the column, as a decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importance(Double importance);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private Double importance;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnImportance model) {
            columnName(model.columnName);
            importance(model.importance);
        }

        public final String getColumnName() {
            return columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final Double getImportance() {
            return importance;
        }

        @Override
        public final Builder importance(Double importance) {
            this.importance = importance;
            return this;
        }

        public final void setImportance(Double importance) {
            this.importance = importance;
        }

        @Override
        public ColumnImportance build() {
            return new ColumnImportance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
