/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStopJobRunResponse extends GlueResponse implements
        ToCopyableBuilder<BatchStopJobRunResponse.Builder, BatchStopJobRunResponse> {
    private static final SdkField<List<BatchStopJobRunSuccessfulSubmission>> SUCCESSFUL_SUBMISSIONS_FIELD = SdkField
            .<List<BatchStopJobRunSuccessfulSubmission>> builder(MarshallingType.LIST)
            .memberName("SuccessfulSubmissions")
            .getter(getter(BatchStopJobRunResponse::successfulSubmissions))
            .setter(setter(Builder::successfulSubmissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulSubmissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchStopJobRunSuccessfulSubmission> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchStopJobRunSuccessfulSubmission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchStopJobRunError>> ERRORS_FIELD = SdkField
            .<List<BatchStopJobRunError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchStopJobRunResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchStopJobRunError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchStopJobRunError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SUBMISSIONS_FIELD,
            ERRORS_FIELD));

    private final List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions;

    private final List<BatchStopJobRunError> errors;

    private BatchStopJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSubmissions = builder.successfulSubmissions;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the SuccessfulSubmissions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSuccessfulSubmissions() {
        return successfulSubmissions != null && !(successfulSubmissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the JobRuns that were successfully submitted for stopping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuccessfulSubmissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the JobRuns that were successfully submitted for stopping.
     */
    public final List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions() {
        return successfulSubmissions;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
     * <code>JobRunId</code> for which each error was encountered and details about the error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
     *         <code>JobRunId</code> for which each error was encountered and details about the error.
     */
    public final List<BatchStopJobRunError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulSubmissions() ? successfulSubmissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunResponse)) {
            return false;
        }
        BatchStopJobRunResponse other = (BatchStopJobRunResponse) obj;
        return hasSuccessfulSubmissions() == other.hasSuccessfulSubmissions()
                && Objects.equals(successfulSubmissions(), other.successfulSubmissions()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStopJobRunResponse")
                .add("SuccessfulSubmissions", hasSuccessfulSubmissions() ? successfulSubmissions() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulSubmissions":
            return Optional.ofNullable(clazz.cast(successfulSubmissions()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopJobRunResponse, T> g) {
        return obj -> g.apply((BatchStopJobRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchStopJobRunResponse> {
        /**
         * <p>
         * A list of the JobRuns that were successfully submitted for stopping.
         * </p>
         * 
         * @param successfulSubmissions
         *        A list of the JobRuns that were successfully submitted for stopping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission> successfulSubmissions);

        /**
         * <p>
         * A list of the JobRuns that were successfully submitted for stopping.
         * </p>
         * 
         * @param successfulSubmissions
         *        A list of the JobRuns that were successfully submitted for stopping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulSubmissions(BatchStopJobRunSuccessfulSubmission... successfulSubmissions);

        /**
         * <p>
         * A list of the JobRuns that were successfully submitted for stopping.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchStopJobRunSuccessfulSubmission>.Builder} avoiding the need to create one manually via {@link List
         * <BatchStopJobRunSuccessfulSubmission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchStopJobRunSuccessfulSubmission>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successfulSubmissions(List<BatchStopJobRunSuccessfulSubmission>)}.
         * 
         * @param successfulSubmissions
         *        a consumer that will call methods on {@link List<BatchStopJobRunSuccessfulSubmission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulSubmissions(List<BatchStopJobRunSuccessfulSubmission>)
         */
        Builder successfulSubmissions(Consumer<BatchStopJobRunSuccessfulSubmission.Builder>... successfulSubmissions);

        /**
         * <p>
         * A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
         * <code>JobRunId</code> for which each error was encountered and details about the error.
         * </p>
         * 
         * @param errors
         *        A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
         *        <code>JobRunId</code> for which each error was encountered and details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchStopJobRunError> errors);

        /**
         * <p>
         * A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
         * <code>JobRunId</code> for which each error was encountered and details about the error.
         * </p>
         * 
         * @param errors
         *        A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
         *        <code>JobRunId</code> for which each error was encountered and details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchStopJobRunError... errors);

        /**
         * <p>
         * A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the
         * <code>JobRunId</code> for which each error was encountered and details about the error.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchStopJobRunError>.Builder} avoiding the
         * need to create one manually via {@link List<BatchStopJobRunError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchStopJobRunError>.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<BatchStopJobRunError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchStopJobRunError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchStopJobRunError>)
         */
        Builder errors(Consumer<BatchStopJobRunError.Builder>... errors);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions = DefaultSdkAutoConstructList.getInstance();

        private List<BatchStopJobRunError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunResponse model) {
            super(model);
            successfulSubmissions(model.successfulSubmissions);
            errors(model.errors);
        }

        public final Collection<BatchStopJobRunSuccessfulSubmission.Builder> getSuccessfulSubmissions() {
            if (successfulSubmissions instanceof SdkAutoConstructList) {
                return null;
            }
            return successfulSubmissions != null ? successfulSubmissions.stream()
                    .map(BatchStopJobRunSuccessfulSubmission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission> successfulSubmissions) {
            this.successfulSubmissions = BatchStopJobRunSuccessfulSubmissionListCopier.copy(successfulSubmissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSubmissions(BatchStopJobRunSuccessfulSubmission... successfulSubmissions) {
            successfulSubmissions(Arrays.asList(successfulSubmissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSubmissions(Consumer<BatchStopJobRunSuccessfulSubmission.Builder>... successfulSubmissions) {
            successfulSubmissions(Stream.of(successfulSubmissions)
                    .map(c -> BatchStopJobRunSuccessfulSubmission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulSubmissions(
                Collection<BatchStopJobRunSuccessfulSubmission.BuilderImpl> successfulSubmissions) {
            this.successfulSubmissions = BatchStopJobRunSuccessfulSubmissionListCopier.copyFromBuilder(successfulSubmissions);
        }

        public final Collection<BatchStopJobRunError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(BatchStopJobRunError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchStopJobRunError> errors) {
            this.errors = BatchStopJobRunErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchStopJobRunError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchStopJobRunError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchStopJobRunError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchStopJobRunError.BuilderImpl> errors) {
            this.errors = BatchStopJobRunErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchStopJobRunResponse build() {
            return new BatchStopJobRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
