/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetWorkflowsResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetWorkflowsResponse.Builder, BatchGetWorkflowsResponse> {
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField
            .<List<Workflow>> builder(MarshallingType.LIST)
            .memberName("Workflows")
            .getter(getter(BatchGetWorkflowsResponse::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workflow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MISSING_WORKFLOWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MissingWorkflows")
            .getter(getter(BatchGetWorkflowsResponse::missingWorkflows))
            .setter(setter(Builder::missingWorkflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingWorkflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOWS_FIELD,
            MISSING_WORKFLOWS_FIELD));

    private final List<Workflow> workflows;

    private final List<String> missingWorkflows;

    private BatchGetWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.workflows = builder.workflows;
        this.missingWorkflows = builder.missingWorkflows;
    }

    /**
     * Returns true if the Workflows property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of workflow resource metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorkflows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of workflow resource metadata.
     */
    public final List<Workflow> workflows() {
        return workflows;
    }

    /**
     * Returns true if the MissingWorkflows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMissingWorkflows() {
        return missingWorkflows != null && !(missingWorkflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of workflows not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMissingWorkflows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of workflows not found.
     */
    public final List<String> missingWorkflows() {
        return missingWorkflows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMissingWorkflows() ? missingWorkflows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetWorkflowsResponse)) {
            return false;
        }
        BatchGetWorkflowsResponse other = (BatchGetWorkflowsResponse) obj;
        return hasWorkflows() == other.hasWorkflows() && Objects.equals(workflows(), other.workflows())
                && hasMissingWorkflows() == other.hasMissingWorkflows()
                && Objects.equals(missingWorkflows(), other.missingWorkflows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetWorkflowsResponse").add("Workflows", hasWorkflows() ? workflows() : null)
                .add("MissingWorkflows", hasMissingWorkflows() ? missingWorkflows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "MissingWorkflows":
            return Optional.ofNullable(clazz.cast(missingWorkflows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetWorkflowsResponse, T> g) {
        return obj -> g.apply((BatchGetWorkflowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetWorkflowsResponse> {
        /**
         * <p>
         * A list of workflow resource metadata.
         * </p>
         * 
         * @param workflows
         *        A list of workflow resource metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<Workflow> workflows);

        /**
         * <p>
         * A list of workflow resource metadata.
         * </p>
         * 
         * @param workflows
         *        A list of workflow resource metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Workflow... workflows);

        /**
         * <p>
         * A list of workflow resource metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Workflow>.Builder} avoiding the need to
         * create one manually via {@link List<Workflow>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Workflow>.Builder#build()} is called immediately and its
         * result is passed to {@link #workflows(List<Workflow>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on {@link List<Workflow>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(List<Workflow>)
         */
        Builder workflows(Consumer<Workflow.Builder>... workflows);

        /**
         * <p>
         * A list of names of workflows not found.
         * </p>
         * 
         * @param missingWorkflows
         *        A list of names of workflows not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingWorkflows(Collection<String> missingWorkflows);

        /**
         * <p>
         * A list of names of workflows not found.
         * </p>
         * 
         * @param missingWorkflows
         *        A list of names of workflows not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingWorkflows(String... missingWorkflows);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();

        private List<String> missingWorkflows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetWorkflowsResponse model) {
            super(model);
            workflows(model.workflows);
            missingWorkflows(model.missingWorkflows);
        }

        public final Collection<Workflow.Builder> getWorkflows() {
            if (workflows instanceof SdkAutoConstructList) {
                return null;
            }
            return workflows != null ? workflows.stream().map(Workflow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowsCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> Workflow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowsCopier.copyFromBuilder(workflows);
        }

        public final Collection<String> getMissingWorkflows() {
            if (missingWorkflows instanceof SdkAutoConstructList) {
                return null;
            }
            return missingWorkflows;
        }

        @Override
        public final Builder missingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingWorkflows(String... missingWorkflows) {
            missingWorkflows(Arrays.asList(missingWorkflows));
            return this;
        }

        public final void setMissingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
        }

        @Override
        public BatchGetWorkflowsResponse build() {
            return new BatchGetWorkflowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
