/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetPartitionResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetPartitionResponse.Builder, BatchGetPartitionResponse> {
    private static final SdkField<List<Partition>> PARTITIONS_FIELD = SdkField
            .<List<Partition>> builder(MarshallingType.LIST)
            .memberName("Partitions")
            .getter(getter(BatchGetPartitionResponse::partitions))
            .setter(setter(Builder::partitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Partition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Partition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PartitionValueList>> UNPROCESSED_KEYS_FIELD = SdkField
            .<List<PartitionValueList>> builder(MarshallingType.LIST)
            .memberName("UnprocessedKeys")
            .getter(getter(BatchGetPartitionResponse::unprocessedKeys))
            .setter(setter(Builder::unprocessedKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionValueList> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionValueList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITIONS_FIELD,
            UNPROCESSED_KEYS_FIELD));

    private final List<Partition> partitions;

    private final List<PartitionValueList> unprocessedKeys;

    private BatchGetPartitionResponse(BuilderImpl builder) {
        super(builder);
        this.partitions = builder.partitions;
        this.unprocessedKeys = builder.unprocessedKeys;
    }

    /**
     * Returns true if the Partitions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPartitions() {
        return partitions != null && !(partitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the requested partitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the requested partitions.
     */
    public final List<Partition> partitions() {
        return partitions;
    }

    /**
     * Returns true if the UnprocessedKeys property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedKeys() {
        return unprocessedKeys != null && !(unprocessedKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the partition values in the request for which partitions were not returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the partition values in the request for which partitions were not returned.
     */
    public final List<PartitionValueList> unprocessedKeys() {
        return unprocessedKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitions() ? partitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedKeys() ? unprocessedKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPartitionResponse)) {
            return false;
        }
        BatchGetPartitionResponse other = (BatchGetPartitionResponse) obj;
        return hasPartitions() == other.hasPartitions() && Objects.equals(partitions(), other.partitions())
                && hasUnprocessedKeys() == other.hasUnprocessedKeys()
                && Objects.equals(unprocessedKeys(), other.unprocessedKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetPartitionResponse").add("Partitions", hasPartitions() ? partitions() : null)
                .add("UnprocessedKeys", hasUnprocessedKeys() ? unprocessedKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Partitions":
            return Optional.ofNullable(clazz.cast(partitions()));
        case "UnprocessedKeys":
            return Optional.ofNullable(clazz.cast(unprocessedKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPartitionResponse, T> g) {
        return obj -> g.apply((BatchGetPartitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetPartitionResponse> {
        /**
         * <p>
         * A list of the requested partitions.
         * </p>
         * 
         * @param partitions
         *        A list of the requested partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(Collection<Partition> partitions);

        /**
         * <p>
         * A list of the requested partitions.
         * </p>
         * 
         * @param partitions
         *        A list of the requested partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(Partition... partitions);

        /**
         * <p>
         * A list of the requested partitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Partition>.Builder} avoiding the need to
         * create one manually via {@link List<Partition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Partition>.Builder#build()} is called immediately and its
         * result is passed to {@link #partitions(List<Partition>)}.
         * 
         * @param partitions
         *        a consumer that will call methods on {@link List<Partition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitions(List<Partition>)
         */
        Builder partitions(Consumer<Partition.Builder>... partitions);

        /**
         * <p>
         * A list of the partition values in the request for which partitions were not returned.
         * </p>
         * 
         * @param unprocessedKeys
         *        A list of the partition values in the request for which partitions were not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedKeys(Collection<PartitionValueList> unprocessedKeys);

        /**
         * <p>
         * A list of the partition values in the request for which partitions were not returned.
         * </p>
         * 
         * @param unprocessedKeys
         *        A list of the partition values in the request for which partitions were not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedKeys(PartitionValueList... unprocessedKeys);

        /**
         * <p>
         * A list of the partition values in the request for which partitions were not returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartitionValueList>.Builder} avoiding the
         * need to create one manually via {@link List<PartitionValueList>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartitionValueList>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedKeys(List<PartitionValueList>)}.
         * 
         * @param unprocessedKeys
         *        a consumer that will call methods on {@link List<PartitionValueList>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedKeys(List<PartitionValueList>)
         */
        Builder unprocessedKeys(Consumer<PartitionValueList.Builder>... unprocessedKeys);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Partition> partitions = DefaultSdkAutoConstructList.getInstance();

        private List<PartitionValueList> unprocessedKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPartitionResponse model) {
            super(model);
            partitions(model.partitions);
            unprocessedKeys(model.unprocessedKeys);
        }

        public final Collection<Partition.Builder> getPartitions() {
            if (partitions instanceof SdkAutoConstructList) {
                return null;
            }
            return partitions != null ? partitions.stream().map(Partition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitions(Collection<Partition> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Partition... partitions) {
            partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<Partition.Builder>... partitions) {
            partitions(Stream.of(partitions).map(c -> Partition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitions(Collection<Partition.BuilderImpl> partitions) {
            this.partitions = PartitionListCopier.copyFromBuilder(partitions);
        }

        public final Collection<PartitionValueList.Builder> getUnprocessedKeys() {
            if (unprocessedKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedKeys != null ? unprocessedKeys.stream().map(PartitionValueList::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedKeys(Collection<PartitionValueList> unprocessedKeys) {
            this.unprocessedKeys = BatchGetPartitionValueListCopier.copy(unprocessedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedKeys(PartitionValueList... unprocessedKeys) {
            unprocessedKeys(Arrays.asList(unprocessedKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedKeys(Consumer<PartitionValueList.Builder>... unprocessedKeys) {
            unprocessedKeys(Stream.of(unprocessedKeys).map(c -> PartitionValueList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedKeys(Collection<PartitionValueList.BuilderImpl> unprocessedKeys) {
            this.unprocessedKeys = BatchGetPartitionValueListCopier.copyFromBuilder(unprocessedKeys);
        }

        @Override
        public BatchGetPartitionResponse build() {
            return new BatchGetPartitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
