/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteConnectionResponse extends GlueResponse implements
        ToCopyableBuilder<BatchDeleteConnectionResponse.Builder, BatchDeleteConnectionResponse> {
    private static final SdkField<List<String>> SUCCEEDED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Succeeded")
            .getter(getter(BatchDeleteConnectionResponse::succeeded))
            .setter(setter(Builder::succeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, ErrorDetail>> ERRORS_FIELD = SdkField
            .<Map<String, ErrorDetail>> builder(MarshallingType.MAP)
            .memberName("Errors")
            .getter(getter(BatchDeleteConnectionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SUCCEEDED_FIELD, ERRORS_FIELD));

    private final List<String> succeeded;

    private final Map<String, ErrorDetail> errors;

    private BatchDeleteConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.succeeded = builder.succeeded;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Succeeded property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSucceeded() {
        return succeeded != null && !(succeeded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of the connection definitions that were successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSucceeded()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of the connection definitions that were successfully deleted.
     */
    public final List<String> succeeded() {
        return succeeded;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the names of connections that were not successfully deleted to error details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of the names of connections that were not successfully deleted to error details.
     */
    public final Map<String, ErrorDetail> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSucceeded() ? succeeded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteConnectionResponse)) {
            return false;
        }
        BatchDeleteConnectionResponse other = (BatchDeleteConnectionResponse) obj;
        return hasSucceeded() == other.hasSucceeded() && Objects.equals(succeeded(), other.succeeded())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteConnectionResponse").add("Succeeded", hasSucceeded() ? succeeded() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Succeeded":
            return Optional.ofNullable(clazz.cast(succeeded()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteConnectionResponse, T> g) {
        return obj -> g.apply((BatchDeleteConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteConnectionResponse> {
        /**
         * <p>
         * A list of names of the connection definitions that were successfully deleted.
         * </p>
         * 
         * @param succeeded
         *        A list of names of the connection definitions that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Collection<String> succeeded);

        /**
         * <p>
         * A list of names of the connection definitions that were successfully deleted.
         * </p>
         * 
         * @param succeeded
         *        A list of names of the connection definitions that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(String... succeeded);

        /**
         * <p>
         * A map of the names of connections that were not successfully deleted to error details.
         * </p>
         * 
         * @param errors
         *        A map of the names of connections that were not successfully deleted to error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Map<String, ErrorDetail> errors);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<String> succeeded = DefaultSdkAutoConstructList.getInstance();

        private Map<String, ErrorDetail> errors = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteConnectionResponse model) {
            super(model);
            succeeded(model.succeeded);
            errors(model.errors);
        }

        public final Collection<String> getSucceeded() {
            if (succeeded instanceof SdkAutoConstructList) {
                return null;
            }
            return succeeded;
        }

        @Override
        public final Builder succeeded(Collection<String> succeeded) {
            this.succeeded = NameStringListCopier.copy(succeeded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeeded(String... succeeded) {
            succeeded(Arrays.asList(succeeded));
            return this;
        }

        public final void setSucceeded(Collection<String> succeeded) {
            this.succeeded = NameStringListCopier.copy(succeeded);
        }

        public final Map<String, ErrorDetail.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructMap) {
                return null;
            }
            return errors != null ? CollectionUtils.mapValues(errors, ErrorDetail::toBuilder) : null;
        }

        @Override
        public final Builder errors(Map<String, ErrorDetail> errors) {
            this.errors = ErrorByNameCopier.copy(errors);
            return this;
        }

        public final void setErrors(Map<String, ErrorDetail.BuilderImpl> errors) {
            this.errors = ErrorByNameCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeleteConnectionResponse build() {
            return new BatchDeleteConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
