/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetJobsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetJobsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunResponse;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityRequest;
import software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityResponse;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.glue.model.ConcurrentRunsExceededException;
import software.amazon.awssdk.services.glue.model.ConditionCheckFailureException;
import software.amazon.awssdk.services.glue.model.ConflictException;
import software.amazon.awssdk.services.glue.model.CrawlerNotRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerStoppingException;
import software.amazon.awssdk.services.glue.model.CreateClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateClassifierResponse;
import software.amazon.awssdk.services.glue.model.CreateConnectionRequest;
import software.amazon.awssdk.services.glue.model.CreateConnectionResponse;
import software.amazon.awssdk.services.glue.model.CreateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.CreateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.CreateJobRequest;
import software.amazon.awssdk.services.glue.model.CreateJobResponse;
import software.amazon.awssdk.services.glue.model.CreateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.CreateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CreateRegistryRequest;
import software.amazon.awssdk.services.glue.model.CreateRegistryResponse;
import software.amazon.awssdk.services.glue.model.CreateSchemaRequest;
import software.amazon.awssdk.services.glue.model.CreateSchemaResponse;
import software.amazon.awssdk.services.glue.model.CreateScriptRequest;
import software.amazon.awssdk.services.glue.model.CreateScriptResponse;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.CreateTriggerRequest;
import software.amazon.awssdk.services.glue.model.CreateTriggerResponse;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DeleteClassifierRequest;
import software.amazon.awssdk.services.glue.model.DeleteClassifierResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerRequest;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerResponse;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.DeleteJobRequest;
import software.amazon.awssdk.services.glue.model.DeleteJobResponse;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformRequest;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteRegistryRequest;
import software.amazon.awssdk.services.glue.model.DeleteRegistryResponse;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.glue.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTriggerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTriggerResponse;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusResponse;
import software.amazon.awssdk.services.glue.model.GetClassifierRequest;
import software.amazon.awssdk.services.glue.model.GetClassifierResponse;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphRequest;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.GetJobRequest;
import software.amazon.awssdk.services.glue.model.GetJobResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;
import software.amazon.awssdk.services.glue.model.GetMappingRequest;
import software.amazon.awssdk.services.glue.model.GetMappingResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetPlanRequest;
import software.amazon.awssdk.services.glue.model.GetPlanResponse;
import software.amazon.awssdk.services.glue.model.GetRegistryRequest;
import software.amazon.awssdk.services.glue.model.GetRegistryResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GetTagsRequest;
import software.amazon.awssdk.services.glue.model.GetTagsResponse;
import software.amazon.awssdk.services.glue.model.GetTriggerRequest;
import software.amazon.awssdk.services.glue.model.GetTriggerResponse;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;
import software.amazon.awssdk.services.glue.model.GlueEncryptionException;
import software.amazon.awssdk.services.glue.model.GlueException;
import software.amazon.awssdk.services.glue.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.glue.model.IllegalWorkflowStateException;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueRequest;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueResponse;
import software.amazon.awssdk.services.glue.model.InternalServiceException;
import software.amazon.awssdk.services.glue.model.InvalidInputException;
import software.amazon.awssdk.services.glue.model.ListCrawlersRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlersResponse;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.ListJobsRequest;
import software.amazon.awssdk.services.glue.model.ListJobsResponse;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.ListRegistriesRequest;
import software.amazon.awssdk.services.glue.model.ListRegistriesResponse;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.ListSchemasRequest;
import software.amazon.awssdk.services.glue.model.ListSchemasResponse;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.MlTransformNotReadyException;
import software.amazon.awssdk.services.glue.model.NoScheduleException;
import software.amazon.awssdk.services.glue.model.OperationTimeoutException;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.RemoveSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.RemoveSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.SchedulerNotRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerTransitioningException;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartJobRunRequest;
import software.amazon.awssdk.services.glue.model.StartJobRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartTriggerRequest;
import software.amazon.awssdk.services.glue.model.StartTriggerResponse;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopTriggerRequest;
import software.amazon.awssdk.services.glue.model.StopTriggerResponse;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.TagResourceRequest;
import software.amazon.awssdk.services.glue.model.TagResourceResponse;
import software.amazon.awssdk.services.glue.model.UntagResourceRequest;
import software.amazon.awssdk.services.glue.model.UntagResourceResponse;
import software.amazon.awssdk.services.glue.model.UpdateClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateClassifierResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.glue.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateRegistryRequest;
import software.amazon.awssdk.services.glue.model.UpdateRegistryResponse;
import software.amazon.awssdk.services.glue.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.glue.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateTriggerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTriggerResponse;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.ValidationException;
import software.amazon.awssdk.services.glue.model.VersionMismatchException;
import software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable;
import software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable;
import software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable;
import software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable;
import software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable;
import software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable;
import software.amazon.awssdk.services.glue.paginators.GetJobsIterable;
import software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable;
import software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable;
import software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable;
import software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable;
import software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable;
import software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetTablesIterable;
import software.amazon.awssdk.services.glue.paginators.GetTriggersIterable;
import software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable;
import software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable;
import software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable;
import software.amazon.awssdk.services.glue.paginators.ListJobsIterable;
import software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable;
import software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable;
import software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable;
import software.amazon.awssdk.services.glue.paginators.ListSchemasIterable;
import software.amazon.awssdk.services.glue.paginators.ListTriggersIterable;
import software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable;
import software.amazon.awssdk.services.glue.paginators.SearchTablesIterable;

/**
 * Service client for accessing AWS Glue. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Glue</fullname>
 * <p>
 * Defines the public endpoint for the AWS Glue service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface GlueClient extends SdkClient {
    String SERVICE_NAME = "glue";

    /**
     * Create a {@link GlueClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GlueClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GlueClient}.
     */
    static GlueClientBuilder builder() {
        return new DefaultGlueClientBuilder();
    }

    /**
     * <p>
     * Creates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchCreatePartitionRequest
     * @return Result of the BatchCreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchCreatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchCreatePartitionResponse batchCreatePartition(BatchCreatePartitionRequest batchCreatePartitionRequest)
            throws InvalidInputException, AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException,
            EntityNotFoundException, OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more partitions in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreatePartitionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreatePartitionRequest#builder()}
     * </p>
     *
     * @param batchCreatePartitionRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreatePartitionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchCreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchCreatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchCreatePartitionResponse batchCreatePartition(
            Consumer<BatchCreatePartitionRequest.Builder> batchCreatePartitionRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, EntityNotFoundException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return batchCreatePartition(BatchCreatePartitionRequest.builder().applyMutation(batchCreatePartitionRequest).build());
    }

    /**
     * <p>
     * Deletes a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param batchDeleteConnectionRequest
     * @return Result of the BatchDeleteConnection operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteConnectionResponse batchDeleteConnection(BatchDeleteConnectionRequest batchDeleteConnectionRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteConnectionRequest#builder()}
     * </p>
     *
     * @param batchDeleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteConnection operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteConnectionResponse batchDeleteConnection(
            Consumer<BatchDeleteConnectionRequest.Builder> batchDeleteConnectionRequest) throws InternalServiceException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return batchDeleteConnection(BatchDeleteConnectionRequest.builder().applyMutation(batchDeleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes one or more partitions in a batch operation.
     * </p>
     *
     * @param batchDeletePartitionRequest
     * @return Result of the BatchDeletePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeletePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeletePartitionResponse batchDeletePartition(BatchDeletePartitionRequest batchDeletePartitionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more partitions in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeletePartitionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeletePartitionRequest#builder()}
     * </p>
     *
     * @param batchDeletePartitionRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeletePartitionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeletePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeletePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeletePartitionResponse batchDeletePartition(
            Consumer<BatchDeletePartitionRequest.Builder> batchDeletePartitionRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return batchDeletePartition(BatchDeletePartitionRequest.builder().applyMutation(batchDeletePartitionRequest).build());
    }

    /**
     * <p>
     * Deletes multiple tables at once.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the
     * discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param batchDeleteTableRequest
     * @return Result of the BatchDeleteTable operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteTableResponse batchDeleteTable(BatchDeleteTableRequest batchDeleteTableRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes multiple tables at once.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the
     * discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTableRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteTableRequest#builder()}
     * </p>
     *
     * @param batchDeleteTableRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteTableRequest.Builder} to create a request.
     * @return Result of the BatchDeleteTable operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteTableResponse batchDeleteTable(Consumer<BatchDeleteTableRequest.Builder> batchDeleteTableRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return batchDeleteTable(BatchDeleteTableRequest.builder().applyMutation(batchDeleteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a specified batch of versions of a table.
     * </p>
     *
     * @param batchDeleteTableVersionRequest
     * @return Result of the BatchDeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteTableVersionResponse batchDeleteTableVersion(BatchDeleteTableVersionRequest batchDeleteTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified batch of versions of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTableVersionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteTableVersionRequest#builder()}
     * </p>
     *
     * @param batchDeleteTableVersionRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteTableVersionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteTableVersionResponse batchDeleteTableVersion(
            Consumer<BatchDeleteTableVersionRequest.Builder> batchDeleteTableVersionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return batchDeleteTableVersion(BatchDeleteTableVersionRequest.builder().applyMutation(batchDeleteTableVersionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of crawler names. After calling the
     * <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetCrawlersRequest
     * @return Result of the BatchGetCrawlers operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetCrawlersResponse batchGetCrawlers(BatchGetCrawlersRequest batchGetCrawlersRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of crawler names. After calling the
     * <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCrawlersRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetCrawlersRequest#builder()}
     * </p>
     *
     * @param batchGetCrawlersRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetCrawlersRequest.Builder} to create a request.
     * @return Result of the BatchGetCrawlers operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetCrawlersResponse batchGetCrawlers(Consumer<BatchGetCrawlersRequest.Builder> batchGetCrawlersRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return batchGetCrawlers(BatchGetCrawlersRequest.builder().applyMutation(batchGetCrawlersRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of development endpoint names. After calling the
     * <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetDevEndpointsRequest
     * @return Result of the BatchGetDevEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetDevEndpointsResponse batchGetDevEndpoints(BatchGetDevEndpointsRequest batchGetDevEndpointsRequest)
            throws AccessDeniedException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of development endpoint names. After calling the
     * <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDevEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDevEndpointsRequest#builder()}
     * </p>
     *
     * @param batchGetDevEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetDevEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetDevEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetDevEndpointsResponse batchGetDevEndpoints(
            Consumer<BatchGetDevEndpointsRequest.Builder> batchGetDevEndpointsRequest) throws AccessDeniedException,
            InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException,
            GlueException {
        return batchGetDevEndpoints(BatchGetDevEndpointsRequest.builder().applyMutation(batchGetDevEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code>
     * operation, you can call this operation to access the data to which you have been granted permissions. This
     * operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetJobsRequest
     * @return Result of the BatchGetJobs operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetJobsResponse batchGetJobs(BatchGetJobsRequest batchGetJobsRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code>
     * operation, you can call this operation to access the data to which you have been granted permissions. This
     * operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetJobsRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetJobsRequest#builder()}
     * </p>
     *
     * @param batchGetJobsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetJobsRequest.Builder} to create a request.
     * @return Result of the BatchGetJobs operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetJobsResponse batchGetJobs(Consumer<BatchGetJobsRequest.Builder> batchGetJobsRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        return batchGetJobs(BatchGetJobsRequest.builder().applyMutation(batchGetJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves partitions in a batch request.
     * </p>
     *
     * @param batchGetPartitionRequest
     * @return Result of the BatchGetPartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetPartitionResponse batchGetPartition(BatchGetPartitionRequest batchGetPartitionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves partitions in a batch request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetPartitionRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetPartitionRequest#builder()}
     * </p>
     *
     * @param batchGetPartitionRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetPartitionRequest.Builder} to create a request.
     * @return Result of the BatchGetPartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetPartitionResponse batchGetPartition(Consumer<BatchGetPartitionRequest.Builder> batchGetPartitionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return batchGetPartition(BatchGetPartitionRequest.builder().applyMutation(batchGetPartitionRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of trigger names. After calling the
     * <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetTriggersRequest
     * @return Result of the BatchGetTriggers operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetTriggersResponse batchGetTriggers(BatchGetTriggersRequest batchGetTriggersRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of trigger names. After calling the
     * <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTriggersRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetTriggersRequest#builder()}
     * </p>
     *
     * @param batchGetTriggersRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetTriggersRequest.Builder} to create a request.
     * @return Result of the BatchGetTriggers operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetTriggersResponse batchGetTriggers(Consumer<BatchGetTriggersRequest.Builder> batchGetTriggersRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        return batchGetTriggers(BatchGetTriggersRequest.builder().applyMutation(batchGetTriggersRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of workflow names. After calling the
     * <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetWorkflowsRequest
     * @return Result of the BatchGetWorkflows operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetWorkflowsResponse batchGetWorkflows(BatchGetWorkflowsRequest batchGetWorkflowsRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of workflow names. After calling the
     * <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetWorkflowsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetWorkflowsRequest#builder()}
     * </p>
     *
     * @param batchGetWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetWorkflowsRequest.Builder} to create a request.
     * @return Result of the BatchGetWorkflows operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetWorkflowsResponse batchGetWorkflows(Consumer<BatchGetWorkflowsRequest.Builder> batchGetWorkflowsRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        return batchGetWorkflows(BatchGetWorkflowsRequest.builder().applyMutation(batchGetWorkflowsRequest).build());
    }

    /**
     * <p>
     * Stops one or more job runs for a specified job definition.
     * </p>
     *
     * @param batchStopJobRunRequest
     * @return Result of the BatchStopJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchStopJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchStopJobRunResponse batchStopJobRun(BatchStopJobRunRequest batchStopJobRunRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops one or more job runs for a specified job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStopJobRunRequest.Builder} avoiding the need
     * to create one manually via {@link BatchStopJobRunRequest#builder()}
     * </p>
     *
     * @param batchStopJobRunRequest
     *        A {@link Consumer} that will call methods on {@link BatchStopJobRunRequest.Builder} to create a request.
     * @return Result of the BatchStopJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchStopJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchStopJobRunResponse batchStopJobRun(Consumer<BatchStopJobRunRequest.Builder> batchStopJobRunRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return batchStopJobRun(BatchStopJobRunRequest.builder().applyMutation(batchStopJobRunRequest).build());
    }

    /**
     * <p>
     * Updates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchUpdatePartitionRequest
     * @return Result of the BatchUpdatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchUpdatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchUpdatePartitionResponse batchUpdatePartition(BatchUpdatePartitionRequest batchUpdatePartitionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates one or more partitions in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdatePartitionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdatePartitionRequest#builder()}
     * </p>
     *
     * @param batchUpdatePartitionRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdatePartitionRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchUpdatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchUpdatePartitionResponse batchUpdatePartition(
            Consumer<BatchUpdatePartitionRequest.Builder> batchUpdatePartitionRequest) throws InvalidInputException,
            EntityNotFoundException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return batchUpdatePartition(BatchUpdatePartitionRequest.builder().applyMutation(batchUpdatePartitionRequest).build());
    }

    /**
     * <p>
     * Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that AWS Glue runs on your behalf
     * as part of various machine learning workflows. You can cancel a machine learning task run at any time by calling
     * <code>CancelMLTaskRun</code> with a task run's parent transform's <code>TransformID</code> and the task run's
     * <code>TaskRunId</code>.
     * </p>
     *
     * @param cancelMlTaskRunRequest
     * @return Result of the CancelMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelMLTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelMlTaskRunResponse cancelMLTaskRun(CancelMlTaskRunRequest cancelMlTaskRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that AWS Glue runs on your behalf
     * as part of various machine learning workflows. You can cancel a machine learning task run at any time by calling
     * <code>CancelMLTaskRun</code> with a task run's parent transform's <code>TransformID</code> and the task run's
     * <code>TaskRunId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlTaskRunRequest.Builder} avoiding the need
     * to create one manually via {@link CancelMlTaskRunRequest#builder()}
     * </p>
     *
     * @param cancelMlTaskRunRequest
     *        A {@link Consumer} that will call methods on {@link CancelMLTaskRunRequest.Builder} to create a request.
     * @return Result of the CancelMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelMLTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelMlTaskRunResponse cancelMLTaskRun(Consumer<CancelMlTaskRunRequest.Builder> cancelMlTaskRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return cancelMLTaskRun(CancelMlTaskRunRequest.builder().applyMutation(cancelMlTaskRunRequest).build());
    }

    /**
     * <p>
     * Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using
     * <code>DataFormat</code> as the format. Since it does not take a schema set name, no compatibility checks are
     * performed.
     * </p>
     *
     * @param checkSchemaVersionValidityRequest
     * @return Result of the CheckSchemaVersionValidity operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CheckSchemaVersionValidity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckSchemaVersionValidityResponse checkSchemaVersionValidity(
            CheckSchemaVersionValidityRequest checkSchemaVersionValidityRequest) throws InvalidInputException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using
     * <code>DataFormat</code> as the format. Since it does not take a schema set name, no compatibility checks are
     * performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckSchemaVersionValidityRequest.Builder} avoiding
     * the need to create one manually via {@link CheckSchemaVersionValidityRequest#builder()}
     * </p>
     *
     * @param checkSchemaVersionValidityRequest
     *        A {@link Consumer} that will call methods on {@link CheckSchemaVersionValidityInput.Builder} to create a
     *        request.
     * @return Result of the CheckSchemaVersionValidity operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CheckSchemaVersionValidity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity"
     *      target="_top">AWS API Documentation</a>
     */
    default CheckSchemaVersionValidityResponse checkSchemaVersionValidity(
            Consumer<CheckSchemaVersionValidityRequest.Builder> checkSchemaVersionValidityRequest) throws InvalidInputException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        return checkSchemaVersionValidity(CheckSchemaVersionValidityRequest.builder()
                .applyMutation(checkSchemaVersionValidityRequest).build());
    }

    /**
     * <p>
     * Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
     * <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which
     * field of the request is present.
     * </p>
     *
     * @param createClassifierRequest
     * @return Result of the CreateClassifier operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClassifierResponse createClassifier(CreateClassifierRequest createClassifierRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
     * <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which
     * field of the request is present.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClassifierRequest.Builder} avoiding the need
     * to create one manually via {@link CreateClassifierRequest#builder()}
     * </p>
     *
     * @param createClassifierRequest
     *        A {@link Consumer} that will call methods on {@link CreateClassifierRequest.Builder} to create a request.
     * @return Result of the CreateClassifier operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClassifierResponse createClassifier(Consumer<CreateClassifierRequest.Builder> createClassifierRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return createClassifier(CreateClassifierRequest.builder().applyMutation(createClassifierRequest).build());
    }

    /**
     * <p>
     * Creates a connection definition in the Data Catalog.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectionRequest.Builder} to create a request.
     * @return Result of the CreateConnection operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConnectionResponse createConnection(Consumer<CreateConnectionRequest.Builder> createConnectionRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl
     * target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the
     * <code>DynamoDBTargets</code> field.
     * </p>
     *
     * @param createCrawlerRequest
     * @return Result of the CreateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCrawlerResponse createCrawler(CreateCrawlerRequest createCrawlerRequest) throws InvalidInputException,
            AlreadyExistsException, OperationTimeoutException, ResourceNumberLimitExceededException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl
     * target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the
     * <code>DynamoDBTargets</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCrawlerRequest#builder()}
     * </p>
     *
     * @param createCrawlerRequest
     *        A {@link Consumer} that will call methods on {@link CreateCrawlerRequest.Builder} to create a request.
     * @return Result of the CreateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCrawlerResponse createCrawler(Consumer<CreateCrawlerRequest.Builder> createCrawlerRequest)
            throws InvalidInputException, AlreadyExistsException, OperationTimeoutException,
            ResourceNumberLimitExceededException, AwsServiceException, SdkClientException, GlueException {
        return createCrawler(CreateCrawlerRequest.builder().applyMutation(createCrawlerRequest).build());
    }

    /**
     * <p>
     * Creates a new database in a Data Catalog.
     * </p>
     *
     * @param createDatabaseRequest
     * @return Result of the CreateDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new database in a Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatabaseRequest#builder()}
     * </p>
     *
     * @param createDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatabaseRequest.Builder} to create a request.
     * @return Result of the CreateDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatabaseResponse createDatabase(Consumer<CreateDatabaseRequest.Builder> createDatabaseRequest)
            throws InvalidInputException, AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return createDatabase(CreateDatabaseRequest.builder().applyMutation(createDatabaseRequest).build());
    }

    /**
     * <p>
     * Creates a new development endpoint.
     * </p>
     *
     * @param createDevEndpointRequest
     * @return Result of the CreateDevEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDevEndpointResponse createDevEndpoint(CreateDevEndpointRequest createDevEndpointRequest)
            throws AccessDeniedException, AlreadyExistsException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, InvalidInputException, ValidationException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new development endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDevEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDevEndpointRequest#builder()}
     * </p>
     *
     * @param createDevEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateDevEndpointRequest.Builder} to create a request.
     * @return Result of the CreateDevEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDevEndpointResponse createDevEndpoint(Consumer<CreateDevEndpointRequest.Builder> createDevEndpointRequest)
            throws AccessDeniedException, AlreadyExistsException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, InvalidInputException, ValidationException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        return createDevEndpoint(CreateDevEndpointRequest.builder().applyMutation(createDevEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new job definition.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidInputException,
            IdempotentParameterMismatchException, AlreadyExistsException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateJobRequest.Builder} to create a request.
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws InvalidInputException,
            IdempotentParameterMismatchException, AlreadyExistsException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Glue machine learning transform. This operation creates the transform and all the necessary
     * parameters to train it.
     * </p>
     * <p>
     * Call this operation as the first step in the process of using a machine learning transform (such as the
     * <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>,
     * in addition to the parameters that you want to use for your algorithm.
     * </p>
     * <p>
     * You must also specify certain parameters for the tasks that AWS Glue runs on your behalf as part of learning from
     * your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and
     * optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.
     * </p>
     *
     * @param createMlTransformRequest
     * @return Result of the CreateMLTransform operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMlTransformResponse createMLTransform(CreateMlTransformRequest createMlTransformRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, ResourceNumberLimitExceededException, IdempotentParameterMismatchException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Glue machine learning transform. This operation creates the transform and all the necessary
     * parameters to train it.
     * </p>
     * <p>
     * Call this operation as the first step in the process of using a machine learning transform (such as the
     * <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>,
     * in addition to the parameters that you want to use for your algorithm.
     * </p>
     * <p>
     * You must also specify certain parameters for the tasks that AWS Glue runs on your behalf as part of learning from
     * your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and
     * optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlTransformRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMlTransformRequest#builder()}
     * </p>
     *
     * @param createMlTransformRequest
     *        A {@link Consumer} that will call methods on {@link CreateMLTransformRequest.Builder} to create a request.
     * @return Result of the CreateMLTransform operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMlTransformResponse createMLTransform(Consumer<CreateMlTransformRequest.Builder> createMlTransformRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, ResourceNumberLimitExceededException, IdempotentParameterMismatchException,
            AwsServiceException, SdkClientException, GlueException {
        return createMLTransform(CreateMlTransformRequest.builder().applyMutation(createMlTransformRequest).build());
    }

    /**
     * <p>
     * Creates a new partition.
     * </p>
     *
     * @param createPartitionRequest
     * @return Result of the CreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePartitionResponse createPartition(CreatePartitionRequest createPartitionRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, EntityNotFoundException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartitionRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePartitionRequest#builder()}
     * </p>
     *
     * @param createPartitionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePartitionRequest.Builder} to create a request.
     * @return Result of the CreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePartitionResponse createPartition(Consumer<CreatePartitionRequest.Builder> createPartitionRequest)
            throws InvalidInputException, AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException,
            EntityNotFoundException, OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        return createPartition(CreatePartitionRequest.builder().applyMutation(createPartitionRequest).build());
    }

    /**
     * <p>
     * Creates a specified partition index in an existing table.
     * </p>
     *
     * @param createPartitionIndexRequest
     * @return Result of the CreatePartitionIndex operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartitionIndex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePartitionIndexResponse createPartitionIndex(CreatePartitionIndexRequest createPartitionIndexRequest)
            throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a specified partition index in an existing table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartitionIndexRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePartitionIndexRequest#builder()}
     * </p>
     *
     * @param createPartitionIndexRequest
     *        A {@link Consumer} that will call methods on {@link CreatePartitionIndexRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePartitionIndex operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartitionIndex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePartitionIndexResponse createPartitionIndex(
            Consumer<CreatePartitionIndexRequest.Builder> createPartitionIndexRequest) throws AlreadyExistsException,
            InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return createPartitionIndex(CreatePartitionIndexRequest.builder().applyMutation(createPartitionIndexRequest).build());
    }

    /**
     * <p>
     * Creates a new registry which may be used to hold a collection of schemas.
     * </p>
     *
     * @param createRegistryRequest
     * @return Result of the CreateRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRegistryResponse createRegistry(CreateRegistryRequest createRegistryRequest) throws InvalidInputException,
            AccessDeniedException, AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new registry which may be used to hold a collection of schemas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRegistryRequest#builder()}
     * </p>
     *
     * @param createRegistryRequest
     *        A {@link Consumer} that will call methods on {@link CreateRegistryInput.Builder} to create a request.
     * @return Result of the CreateRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRegistryResponse createRegistry(Consumer<CreateRegistryRequest.Builder> createRegistryRequest)
            throws InvalidInputException, AccessDeniedException, AlreadyExistsException, ResourceNumberLimitExceededException,
            InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        return createRegistry(CreateRegistryRequest.builder().applyMutation(createRegistryRequest).build());
    }

    /**
     * <p>
     * Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists
     * without actually registering the version.
     * </p>
     * <p>
     * When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode
     * "DISABLED" restricts any additional schema versions from being added after the first schema version. For all
     * other compatibility modes, validation of compatibility settings will be applied only from the second version
     * onwards when the <code>RegisterSchemaVersion</code> API is used.
     * </p>
     * <p>
     * When this API is called without a <code>RegistryId</code>, this will create an entry for a "default-registry" in
     * the registry database tables, if it is not already present.
     * </p>
     *
     * @param createSchemaRequest
     * @return Result of the CreateSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, AlreadyExistsException, ResourceNumberLimitExceededException,
            InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists
     * without actually registering the version.
     * </p>
     * <p>
     * When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode
     * "DISABLED" restricts any additional schema versions from being added after the first schema version. For all
     * other compatibility modes, validation of compatibility settings will be applied only from the second version
     * onwards when the <code>RegisterSchemaVersion</code> API is used.
     * </p>
     * <p>
     * When this API is called without a <code>RegistryId</code>, this will create an entry for a "default-registry" in
     * the registry database tables, if it is not already present.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSchemaRequest#builder()}
     * </p>
     *
     * @param createSchemaRequest
     *        A {@link Consumer} that will call methods on {@link CreateSchemaInput.Builder} to create a request.
     * @return Result of the CreateSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSchemaResponse createSchema(Consumer<CreateSchemaRequest.Builder> createSchemaRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, AlreadyExistsException,
            ResourceNumberLimitExceededException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        return createSchema(CreateSchemaRequest.builder().applyMutation(createSchemaRequest).build());
    }

    /**
     * <p>
     * Transforms a directed acyclic graph (DAG) into code.
     * </p>
     *
     * @param createScriptRequest
     * @return Result of the CreateScript operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateScript
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateScriptResponse createScript(CreateScriptRequest createScriptRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transforms a directed acyclic graph (DAG) into code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScriptRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScriptRequest#builder()}
     * </p>
     *
     * @param createScriptRequest
     *        A {@link Consumer} that will call methods on {@link CreateScriptRequest.Builder} to create a request.
     * @return Result of the CreateScript operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateScript
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateScriptResponse createScript(Consumer<CreateScriptRequest.Builder> createScriptRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return createScript(CreateScriptRequest.builder().applyMutation(createScriptRequest).build());
    }

    /**
     * <p>
     * Creates a new security configuration. A security configuration is a set of security properties that can be used
     * by AWS Glue. You can use a security configuration to encrypt data at rest. For information about using security
     * configurations in AWS Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written
     * by Crawlers, Jobs, and Development Endpoints</a>.
     * </p>
     *
     * @param createSecurityConfigurationRequest
     * @return Result of the CreateSecurityConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityConfigurationResponse createSecurityConfiguration(
            CreateSecurityConfigurationRequest createSecurityConfigurationRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new security configuration. A security configuration is a set of security properties that can be used
     * by AWS Glue. You can use a security configuration to encrypt data at rest. For information about using security
     * configurations in AWS Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written
     * by Crawlers, Jobs, and Development Endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param createSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSecurityConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the CreateSecurityConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityConfigurationResponse createSecurityConfiguration(
            Consumer<CreateSecurityConfigurationRequest.Builder> createSecurityConfigurationRequest)
            throws AlreadyExistsException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, AwsServiceException, SdkClientException, GlueException {
        return createSecurityConfiguration(CreateSecurityConfigurationRequest.builder()
                .applyMutation(createSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new table definition in the Data Catalog.
     * </p>
     *
     * @param createTableRequest
     * @return Result of the CreateTable operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTableResponse createTable(CreateTableRequest createTableRequest) throws AlreadyExistsException,
            InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTableRequest#builder()}
     * </p>
     *
     * @param createTableRequest
     *        A {@link Consumer} that will call methods on {@link CreateTableRequest.Builder} to create a request.
     * @return Result of the CreateTable operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTableResponse createTable(Consumer<CreateTableRequest.Builder> createTableRequest)
            throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        return createTable(CreateTableRequest.builder().applyMutation(createTableRequest).build());
    }

    /**
     * <p>
     * Creates a new trigger.
     * </p>
     *
     * @param createTriggerRequest
     * @return Result of the CreateTrigger operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTriggerResponse createTrigger(CreateTriggerRequest createTriggerRequest) throws AlreadyExistsException,
            EntityNotFoundException, InvalidInputException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, ResourceNumberLimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new trigger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTriggerRequest#builder()}
     * </p>
     *
     * @param createTriggerRequest
     *        A {@link Consumer} that will call methods on {@link CreateTriggerRequest.Builder} to create a request.
     * @return Result of the CreateTrigger operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTriggerResponse createTrigger(Consumer<CreateTriggerRequest.Builder> createTriggerRequest)
            throws AlreadyExistsException, EntityNotFoundException, InvalidInputException, IdempotentParameterMismatchException,
            InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        return createTrigger(CreateTriggerRequest.builder().applyMutation(createTriggerRequest).build());
    }

    /**
     * <p>
     * Creates a new function definition in the Data Catalog.
     * </p>
     *
     * @param createUserDefinedFunctionRequest
     * @return Result of the CreateUserDefinedFunction operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserDefinedFunctionResponse createUserDefinedFunction(
            CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new function definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserDefinedFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param createUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserDefinedFunction operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserDefinedFunctionResponse createUserDefinedFunction(
            Consumer<CreateUserDefinedFunctionRequest.Builder> createUserDefinedFunctionRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return createUserDefinedFunction(CreateUserDefinedFunctionRequest.builder()
                .applyMutation(createUserDefinedFunctionRequest).build());
    }

    /**
     * <p>
     * Creates a new workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkflowRequest.Builder} to create a request.
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkflowResponse createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest)
            throws AlreadyExistsException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Removes a classifier from the Data Catalog.
     * </p>
     *
     * @param deleteClassifierRequest
     * @return Result of the DeleteClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClassifierResponse deleteClassifier(DeleteClassifierRequest deleteClassifierRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a classifier from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClassifierRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteClassifierRequest#builder()}
     * </p>
     *
     * @param deleteClassifierRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClassifierRequest.Builder} to create a request.
     * @return Result of the DeleteClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClassifierResponse deleteClassifier(Consumer<DeleteClassifierRequest.Builder> deleteClassifierRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return deleteClassifier(DeleteClassifierRequest.builder().applyMutation(deleteClassifierRequest).build());
    }

    /**
     * <p>
     * Delete the partition column statistics of a column.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeletePartition</code>.
     * </p>
     *
     * @param deleteColumnStatisticsForPartitionRequest
     * @return Result of the DeleteColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsForPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteColumnStatisticsForPartitionResponse deleteColumnStatisticsForPartition(
            DeleteColumnStatisticsForPartitionRequest deleteColumnStatisticsForPartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the partition column statistics of a column.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeletePartition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteColumnStatisticsForPartitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteColumnStatisticsForPartitionRequest#builder()}
     * </p>
     *
     * @param deleteColumnStatisticsForPartitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteColumnStatisticsForPartitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsForPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteColumnStatisticsForPartitionResponse deleteColumnStatisticsForPartition(
            Consumer<DeleteColumnStatisticsForPartitionRequest.Builder> deleteColumnStatisticsForPartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return deleteColumnStatisticsForPartition(DeleteColumnStatisticsForPartitionRequest.builder()
                .applyMutation(deleteColumnStatisticsForPartitionRequest).build());
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeleteTable</code>.
     * </p>
     *
     * @param deleteColumnStatisticsForTableRequest
     * @return Result of the DeleteColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsForTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteColumnStatisticsForTableResponse deleteColumnStatisticsForTable(
            DeleteColumnStatisticsForTableRequest deleteColumnStatisticsForTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeleteTable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteColumnStatisticsForTableRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteColumnStatisticsForTableRequest#builder()}
     * </p>
     *
     * @param deleteColumnStatisticsForTableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteColumnStatisticsForTableRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteColumnStatisticsForTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteColumnStatisticsForTableResponse deleteColumnStatisticsForTable(
            Consumer<DeleteColumnStatisticsForTableRequest.Builder> deleteColumnStatisticsForTableRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return deleteColumnStatisticsForTable(DeleteColumnStatisticsForTableRequest.builder()
                .applyMutation(deleteColumnStatisticsForTableRequest).build());
    }

    /**
     * <p>
     * Deletes a connection from the Data Catalog.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connection from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectionRequest.Builder} to create a request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Removes a specified crawler from the AWS Glue Data Catalog, unless the crawler state is <code>RUNNING</code>.
     * </p>
     *
     * @param deleteCrawlerRequest
     * @return Result of the DeleteCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCrawlerResponse deleteCrawler(DeleteCrawlerRequest deleteCrawlerRequest) throws EntityNotFoundException,
            CrawlerRunningException, SchedulerTransitioningException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specified crawler from the AWS Glue Data Catalog, unless the crawler state is <code>RUNNING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCrawlerRequest#builder()}
     * </p>
     *
     * @param deleteCrawlerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCrawlerRequest.Builder} to create a request.
     * @return Result of the DeleteCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCrawlerResponse deleteCrawler(Consumer<DeleteCrawlerRequest.Builder> deleteCrawlerRequest)
            throws EntityNotFoundException, CrawlerRunningException, SchedulerTransitioningException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteCrawler(DeleteCrawlerRequest.builder().applyMutation(deleteCrawlerRequest).build());
    }

    /**
     * <p>
     * Removes a specified database from a Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the tables (and all table versions and partitions
     * that might belong to the tables) and the user-defined functions in the deleted database. AWS Glue deletes these
     * "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteDatabase</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and <code>DeleteTable</code> or
     * <code>BatchDeleteTable</code>, to delete any resources that belong to the database.
     * </p>
     * </note>
     *
     * @param deleteDatabaseRequest
     * @return Result of the DeleteDatabase operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatabaseResponse deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specified database from a Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the tables (and all table versions and partitions
     * that might belong to the tables) and the user-defined functions in the deleted database. AWS Glue deletes these
     * "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteDatabase</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and <code>DeleteTable</code> or
     * <code>BatchDeleteTable</code>, to delete any resources that belong to the database.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatabaseRequest#builder()}
     * </p>
     *
     * @param deleteDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatabaseRequest.Builder} to create a request.
     * @return Result of the DeleteDatabase operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatabaseResponse deleteDatabase(Consumer<DeleteDatabaseRequest.Builder> deleteDatabaseRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteDatabase(DeleteDatabaseRequest.builder().applyMutation(deleteDatabaseRequest).build());
    }

    /**
     * <p>
     * Deletes a specified development endpoint.
     * </p>
     *
     * @param deleteDevEndpointRequest
     * @return Result of the DeleteDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDevEndpointResponse deleteDevEndpoint(DeleteDevEndpointRequest deleteDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified development endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDevEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDevEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDevEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDevEndpointRequest.Builder} to create a request.
     * @return Result of the DeleteDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDevEndpointResponse deleteDevEndpoint(Consumer<DeleteDevEndpointRequest.Builder> deleteDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteDevEndpoint(DeleteDevEndpointRequest.builder().applyMutation(deleteDevEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a specified job definition. If the job definition is not found, no exception is thrown.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified job definition. If the job definition is not found, no exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Glue machine learning transform. Machine learning transforms are a special type of transform that
     * use machine learning to learn the details of the transformation to be performed by learning from examples
     * provided by humans. These transformations are then saved by AWS Glue. If you no longer need a transform, you can
     * delete it by calling <code>DeleteMLTransforms</code>. However, any AWS Glue jobs that still reference the deleted
     * transform will no longer succeed.
     * </p>
     *
     * @param deleteMlTransformRequest
     * @return Result of the DeleteMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMlTransformResponse deleteMLTransform(DeleteMlTransformRequest deleteMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Glue machine learning transform. Machine learning transforms are a special type of transform that
     * use machine learning to learn the details of the transformation to be performed by learning from examples
     * provided by humans. These transformations are then saved by AWS Glue. If you no longer need a transform, you can
     * delete it by calling <code>DeleteMLTransforms</code>. However, any AWS Glue jobs that still reference the deleted
     * transform will no longer succeed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlTransformRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMlTransformRequest#builder()}
     * </p>
     *
     * @param deleteMlTransformRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMLTransformRequest.Builder} to create a request.
     * @return Result of the DeleteMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMlTransformResponse deleteMLTransform(Consumer<DeleteMlTransformRequest.Builder> deleteMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteMLTransform(DeleteMlTransformRequest.builder().applyMutation(deleteMlTransformRequest).build());
    }

    /**
     * <p>
     * Deletes a specified partition.
     * </p>
     *
     * @param deletePartitionRequest
     * @return Result of the DeletePartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeletePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePartitionResponse deletePartition(DeletePartitionRequest deletePartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartitionRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePartitionRequest#builder()}
     * </p>
     *
     * @param deletePartitionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePartitionRequest.Builder} to create a request.
     * @return Result of the DeletePartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeletePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePartitionResponse deletePartition(Consumer<DeletePartitionRequest.Builder> deletePartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return deletePartition(DeletePartitionRequest.builder().applyMutation(deletePartitionRequest).build());
    }

    /**
     * <p>
     * Deletes a specified partition index from an existing table.
     * </p>
     *
     * @param deletePartitionIndexRequest
     * @return Result of the DeletePartitionIndex operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeletePartitionIndex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePartitionIndexResponse deletePartitionIndex(DeletePartitionIndexRequest deletePartitionIndexRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, EntityNotFoundException,
            ConflictException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified partition index from an existing table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartitionIndexRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePartitionIndexRequest#builder()}
     * </p>
     *
     * @param deletePartitionIndexRequest
     *        A {@link Consumer} that will call methods on {@link DeletePartitionIndexRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePartitionIndex operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeletePartitionIndex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePartitionIndexResponse deletePartitionIndex(
            Consumer<DeletePartitionIndexRequest.Builder> deletePartitionIndexRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, EntityNotFoundException, ConflictException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return deletePartitionIndex(DeletePartitionIndexRequest.builder().applyMutation(deletePartitionIndexRequest).build());
    }

    /**
     * <p>
     * Delete the entire registry including schema and all of its versions. To get the status of the delete operation,
     * you can call the <code>GetRegistry</code> API after the asynchronous call. Deleting a registry will disable all
     * online operations for the registry such as the <code>UpdateRegistry</code>, <code>CreateSchema</code>,
     * <code>UpdateSchema</code>, and <code>RegisterSchemaVersion</code> APIs.
     * </p>
     *
     * @param deleteRegistryRequest
     * @return Result of the DeleteRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRegistryResponse deleteRegistry(DeleteRegistryRequest deleteRegistryRequest) throws InvalidInputException,
            EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the entire registry including schema and all of its versions. To get the status of the delete operation,
     * you can call the <code>GetRegistry</code> API after the asynchronous call. Deleting a registry will disable all
     * online operations for the registry such as the <code>UpdateRegistry</code>, <code>CreateSchema</code>,
     * <code>UpdateSchema</code>, and <code>RegisterSchemaVersion</code> APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRegistryRequest#builder()}
     * </p>
     *
     * @param deleteRegistryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRegistryInput.Builder} to create a request.
     * @return Result of the DeleteRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRegistryResponse deleteRegistry(Consumer<DeleteRegistryRequest.Builder> deleteRegistryRequest)
            throws InvalidInputException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteRegistry(DeleteRegistryRequest.builder().applyMutation(deleteRegistryRequest).build());
    }

    /**
     * <p>
     * Deletes a specified policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ConditionCheckFailureException
     *         A specified condition was not satisfied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ConditionCheckFailureException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ConditionCheckFailureException
     *         A specified condition was not satisfied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, InvalidInputException, ConditionCheckFailureException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete
     * operation, you can call <code>GetSchema</code> API after the asynchronous call. Deleting a registry will disable
     * all online operations for the schema, such as the <code>GetSchemaByDefinition</code>, and
     * <code>RegisterSchemaVersion</code> APIs.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return Result of the DeleteSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaResponse deleteSchema(DeleteSchemaRequest deleteSchemaRequest) throws InvalidInputException,
            EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete
     * operation, you can call <code>GetSchema</code> API after the asynchronous call. Deleting a registry will disable
     * all online operations for the schema, such as the <code>GetSchemaByDefinition</code>, and
     * <code>RegisterSchemaVersion</code> APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSchemaRequest#builder()}
     * </p>
     *
     * @param deleteSchemaRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaInput.Builder} to create a request.
     * @return Result of the DeleteSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaResponse deleteSchema(Consumer<DeleteSchemaRequest.Builder> deleteSchemaRequest)
            throws InvalidInputException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteSchema(DeleteSchemaRequest.builder().applyMutation(deleteSchemaRequest).build());
    }

    /**
     * <p>
     * Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode
     * forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned. Calling the
     * <code>GetSchemaVersions</code> API after this call will list the status of the deleted versions.
     * </p>
     * <p>
     * When the range of version numbers contain check pointed version, the API will return a 409 conflict and will not
     * proceed with the deletion. You have to remove the checkpoint first using the <code>DeleteSchemaCheckpoint</code>
     * API before using this API.
     * </p>
     * <p>
     * You cannot use the <code>DeleteSchemaVersions</code> API to delete the first schema version in the schema set.
     * The first schema version can only be deleted by the <code>DeleteSchema</code> API. This operation will also
     * delete the attached <code>SchemaVersionMetadata</code> under the schema versions. Hard deletes will be enforced
     * on the database.
     * </p>
     * <p>
     * If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is
     * returned.
     * </p>
     *
     * @param deleteSchemaVersionsRequest
     * @return Result of the DeleteSchemaVersions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaVersionsResponse deleteSchemaVersions(DeleteSchemaVersionsRequest deleteSchemaVersionsRequest)
            throws InvalidInputException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode
     * forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned. Calling the
     * <code>GetSchemaVersions</code> API after this call will list the status of the deleted versions.
     * </p>
     * <p>
     * When the range of version numbers contain check pointed version, the API will return a 409 conflict and will not
     * proceed with the deletion. You have to remove the checkpoint first using the <code>DeleteSchemaCheckpoint</code>
     * API before using this API.
     * </p>
     * <p>
     * You cannot use the <code>DeleteSchemaVersions</code> API to delete the first schema version in the schema set.
     * The first schema version can only be deleted by the <code>DeleteSchema</code> API. This operation will also
     * delete the attached <code>SchemaVersionMetadata</code> under the schema versions. Hard deletes will be enforced
     * on the database.
     * </p>
     * <p>
     * If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param deleteSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSchemaVersionsInput.Builder} to create a
     *        request.
     * @return Result of the DeleteSchemaVersions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSchemaVersionsResponse deleteSchemaVersions(
            Consumer<DeleteSchemaVersionsRequest.Builder> deleteSchemaVersionsRequest) throws InvalidInputException,
            EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        return deleteSchemaVersions(DeleteSchemaVersionsRequest.builder().applyMutation(deleteSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * Deletes a specified security configuration.
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     * @return Result of the DeleteSecurityConfiguration operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityConfigurationResponse deleteSecurityConfiguration(
            DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified security configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSecurityConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteSecurityConfiguration operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityConfigurationResponse deleteSecurityConfiguration(
            Consumer<DeleteSecurityConfigurationRequest.Builder> deleteSecurityConfigurationRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteSecurityConfiguration(DeleteSecurityConfigurationRequest.builder()
                .applyMutation(deleteSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes a table definition from the Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the
     * discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param deleteTableRequest
     * @return Result of the DeleteTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a table definition from the Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the
     * discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTableRequest#builder()}
     * </p>
     *
     * @param deleteTableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTableRequest.Builder} to create a request.
     * @return Result of the DeleteTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTableResponse deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteTable(DeleteTableRequest.builder().applyMutation(deleteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a specified version of a table.
     * </p>
     *
     * @param deleteTableVersionRequest
     * @return Result of the DeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTableVersionResponse deleteTableVersion(DeleteTableVersionRequest deleteTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified version of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTableVersionRequest#builder()}
     * </p>
     *
     * @param deleteTableVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTableVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTableVersionResponse deleteTableVersion(Consumer<DeleteTableVersionRequest.Builder> deleteTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteTableVersion(DeleteTableVersionRequest.builder().applyMutation(deleteTableVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a specified trigger. If the trigger is not found, no exception is thrown.
     * </p>
     *
     * @param deleteTriggerRequest
     * @return Result of the DeleteTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTriggerResponse deleteTrigger(DeleteTriggerRequest deleteTriggerRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified trigger. If the trigger is not found, no exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTriggerRequest#builder()}
     * </p>
     *
     * @param deleteTriggerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTriggerRequest.Builder} to create a request.
     * @return Result of the DeleteTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTriggerResponse deleteTrigger(Consumer<DeleteTriggerRequest.Builder> deleteTriggerRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteTrigger(DeleteTriggerRequest.builder().applyMutation(deleteTriggerRequest).build());
    }

    /**
     * <p>
     * Deletes an existing function definition from the Data Catalog.
     * </p>
     *
     * @param deleteUserDefinedFunctionRequest
     * @return Result of the DeleteUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserDefinedFunctionResponse deleteUserDefinedFunction(
            DeleteUserDefinedFunctionRequest deleteUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing function definition from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserDefinedFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param deleteUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserDefinedFunctionResponse deleteUserDefinedFunction(
            Consumer<DeleteUserDefinedFunctionRequest.Builder> deleteUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return deleteUserDefinedFunction(DeleteUserDefinedFunctionRequest.builder()
                .applyMutation(deleteUserDefinedFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkflowRequest.Builder} to create a request.
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of a migration operation.
     * </p>
     *
     * @param getCatalogImportStatusRequest
     * @return Result of the GetCatalogImportStatus operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCatalogImportStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCatalogImportStatusResponse getCatalogImportStatus(GetCatalogImportStatusRequest getCatalogImportStatusRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of a migration operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCatalogImportStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetCatalogImportStatusRequest#builder()}
     * </p>
     *
     * @param getCatalogImportStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetCatalogImportStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetCatalogImportStatus operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCatalogImportStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCatalogImportStatusResponse getCatalogImportStatus(
            Consumer<GetCatalogImportStatusRequest.Builder> getCatalogImportStatusRequest) throws InternalServiceException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getCatalogImportStatus(GetCatalogImportStatusRequest.builder().applyMutation(getCatalogImportStatusRequest)
                .build());
    }

    /**
     * <p>
     * Retrieve a classifier by name.
     * </p>
     *
     * @param getClassifierRequest
     * @return Result of the GetClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifierResponse getClassifier(GetClassifierRequest getClassifierRequest) throws EntityNotFoundException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a classifier by name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClassifierRequest.Builder} avoiding the need to
     * create one manually via {@link GetClassifierRequest#builder()}
     * </p>
     *
     * @param getClassifierRequest
     *        A {@link Consumer} that will call methods on {@link GetClassifierRequest.Builder} to create a request.
     * @return Result of the GetClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifierResponse getClassifier(Consumer<GetClassifierRequest.Builder> getClassifierRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getClassifier(GetClassifierRequest.builder().applyMutation(getClassifierRequest).build());
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     *
     * @param getClassifiersRequest
     * @return Result of the GetClassifiers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifiersResponse getClassifiers(GetClassifiersRequest getClassifiersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClassifiersRequest.Builder} avoiding the need to
     * create one manually via {@link GetClassifiersRequest#builder()}
     * </p>
     *
     * @param getClassifiersRequest
     *        A {@link Consumer} that will call methods on {@link GetClassifiersRequest.Builder} to create a request.
     * @return Result of the GetClassifiers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifiersResponse getClassifiers(Consumer<GetClassifiersRequest.Builder> getClassifiersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getClassifiers(GetClassifiersRequest.builder().applyMutation(getClassifiersRequest).build());
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)} operation.</b>
     * </p>
     *
     * @param getClassifiersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifiersIterable getClassifiersPaginator(GetClassifiersRequest getClassifiersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClassifiersRequest.Builder} avoiding the need to
     * create one manually via {@link GetClassifiersRequest#builder()}
     * </p>
     *
     * @param getClassifiersRequest
     *        A {@link Consumer} that will call methods on {@link GetClassifiersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifiersIterable getClassifiersPaginator(Consumer<GetClassifiersRequest.Builder> getClassifiersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getClassifiersPaginator(GetClassifiersRequest.builder().applyMutation(getClassifiersRequest).build());
    }

    /**
     * <p>
     * Retrieves partition statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetPartition</code>.
     * </p>
     *
     * @param getColumnStatisticsForPartitionRequest
     * @return Result of the GetColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetColumnStatisticsForPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetColumnStatisticsForPartitionResponse getColumnStatisticsForPartition(
            GetColumnStatisticsForPartitionRequest getColumnStatisticsForPartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves partition statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetPartition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsForPartitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsForPartitionRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsForPartitionRequest
     *        A {@link Consumer} that will call methods on {@link GetColumnStatisticsForPartitionRequest.Builder} to
     *        create a request.
     * @return Result of the GetColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetColumnStatisticsForPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetColumnStatisticsForPartitionResponse getColumnStatisticsForPartition(
            Consumer<GetColumnStatisticsForPartitionRequest.Builder> getColumnStatisticsForPartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getColumnStatisticsForPartition(GetColumnStatisticsForPartitionRequest.builder()
                .applyMutation(getColumnStatisticsForPartitionRequest).build());
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetTable</code>.
     * </p>
     *
     * @param getColumnStatisticsForTableRequest
     * @return Result of the GetColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetColumnStatisticsForTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default GetColumnStatisticsForTableResponse getColumnStatisticsForTable(
            GetColumnStatisticsForTableRequest getColumnStatisticsForTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetTable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsForTableRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsForTableRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsForTableRequest
     *        A {@link Consumer} that will call methods on {@link GetColumnStatisticsForTableRequest.Builder} to create
     *        a request.
     * @return Result of the GetColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetColumnStatisticsForTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default GetColumnStatisticsForTableResponse getColumnStatisticsForTable(
            Consumer<GetColumnStatisticsForTableRequest.Builder> getColumnStatisticsForTableRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getColumnStatisticsForTable(GetColumnStatisticsForTableRequest.builder()
                .applyMutation(getColumnStatisticsForTableRequest).build());
    }

    /**
     * <p>
     * Retrieves a connection definition from the Data Catalog.
     * </p>
     *
     * @param getConnectionRequest
     * @return Result of the GetConnection operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionResponse getConnection(GetConnectionRequest getConnectionRequest) throws EntityNotFoundException,
            OperationTimeoutException, InvalidInputException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a connection definition from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionRequest.Builder} to create a request.
     * @return Result of the GetConnection operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionResponse getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest)
            throws EntityNotFoundException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param getConnectionsRequest
     * @return Result of the GetConnections operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionsResponse getConnections(GetConnectionsRequest getConnectionsRequest) throws EntityNotFoundException,
            OperationTimeoutException, InvalidInputException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionsRequest.Builder} to create a request.
     * @return Result of the GetConnections operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionsResponse getConnections(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest)
            throws EntityNotFoundException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getConnections(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param getConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionsIterable getConnectionsPaginator(GetConnectionsRequest getConnectionsRequest)
            throws EntityNotFoundException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionsIterable getConnectionsPaginator(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest)
            throws EntityNotFoundException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getConnectionsPaginator(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for a specified crawler.
     * </p>
     *
     * @param getCrawlerRequest
     * @return Result of the GetCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerResponse getCrawler(GetCrawlerRequest getCrawlerRequest) throws EntityNotFoundException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for a specified crawler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link GetCrawlerRequest#builder()}
     * </p>
     *
     * @param getCrawlerRequest
     *        A {@link Consumer} that will call methods on {@link GetCrawlerRequest.Builder} to create a request.
     * @return Result of the GetCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerResponse getCrawler(Consumer<GetCrawlerRequest.Builder> getCrawlerRequest) throws EntityNotFoundException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getCrawler(GetCrawlerRequest.builder().applyMutation(getCrawlerRequest).build());
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     *
     * @param getCrawlerMetricsRequest
     * @return Result of the GetCrawlerMetrics operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlerMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerMetricsResponse getCrawlerMetrics(GetCrawlerMetricsRequest getCrawlerMetricsRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlerMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link GetCrawlerMetricsRequest#builder()}
     * </p>
     *
     * @param getCrawlerMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetCrawlerMetricsRequest.Builder} to create a request.
     * @return Result of the GetCrawlerMetrics operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlerMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerMetricsResponse getCrawlerMetrics(Consumer<GetCrawlerMetricsRequest.Builder> getCrawlerMetricsRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getCrawlerMetrics(GetCrawlerMetricsRequest.builder().applyMutation(getCrawlerMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client.getCrawlerMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client
     *             .getCrawlerMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client.getCrawlerMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation.</b>
     * </p>
     *
     * @param getCrawlerMetricsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlerMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerMetricsIterable getCrawlerMetricsPaginator(GetCrawlerMetricsRequest getCrawlerMetricsRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client.getCrawlerMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client
     *             .getCrawlerMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client.getCrawlerMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlerMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link GetCrawlerMetricsRequest#builder()}
     * </p>
     *
     * @param getCrawlerMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetCrawlerMetricsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlerMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerMetricsIterable getCrawlerMetricsPaginator(
            Consumer<GetCrawlerMetricsRequest.Builder> getCrawlerMetricsRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getCrawlerMetricsPaginator(GetCrawlerMetricsRequest.builder().applyMutation(getCrawlerMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     *
     * @param getCrawlersRequest
     * @return Result of the GetCrawlers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlersResponse getCrawlers(GetCrawlersRequest getCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlersRequest.Builder} avoiding the need to
     * create one manually via {@link GetCrawlersRequest#builder()}
     * </p>
     *
     * @param getCrawlersRequest
     *        A {@link Consumer} that will call methods on {@link GetCrawlersRequest.Builder} to create a request.
     * @return Result of the GetCrawlers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlersResponse getCrawlers(Consumer<GetCrawlersRequest.Builder> getCrawlersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getCrawlers(GetCrawlersRequest.builder().applyMutation(getCrawlersRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetCrawlersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)} operation.</b>
     * </p>
     *
     * @param getCrawlersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlersIterable getCrawlersPaginator(GetCrawlersRequest getCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetCrawlersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlersRequest.Builder} avoiding the need to
     * create one manually via {@link GetCrawlersRequest#builder()}
     * </p>
     *
     * @param getCrawlersRequest
     *        A {@link Consumer} that will call methods on {@link GetCrawlersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlersIterable getCrawlersPaginator(Consumer<GetCrawlersRequest.Builder> getCrawlersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getCrawlersPaginator(GetCrawlersRequest.builder().applyMutation(getCrawlersRequest).build());
    }

    /**
     * <p>
     * Retrieves the security configuration for a specified catalog.
     * </p>
     *
     * @param getDataCatalogEncryptionSettingsRequest
     * @return Result of the GetDataCatalogEncryptionSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDataCatalogEncryptionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataCatalogEncryptionSettingsResponse getDataCatalogEncryptionSettings(
            GetDataCatalogEncryptionSettingsRequest getDataCatalogEncryptionSettingsRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the security configuration for a specified catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataCatalogEncryptionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDataCatalogEncryptionSettingsRequest#builder()}
     * </p>
     *
     * @param getDataCatalogEncryptionSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetDataCatalogEncryptionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the GetDataCatalogEncryptionSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDataCatalogEncryptionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataCatalogEncryptionSettingsResponse getDataCatalogEncryptionSettings(
            Consumer<GetDataCatalogEncryptionSettingsRequest.Builder> getDataCatalogEncryptionSettingsRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getDataCatalogEncryptionSettings(GetDataCatalogEncryptionSettingsRequest.builder()
                .applyMutation(getDataCatalogEncryptionSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves the definition of a specified database.
     * </p>
     *
     * @param getDatabaseRequest
     * @return Result of the GetDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definition of a specified database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabaseRequest#builder()}
     * </p>
     *
     * @param getDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link GetDatabaseRequest.Builder} to create a request.
     * @return Result of the GetDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabaseResponse getDatabase(Consumer<GetDatabaseRequest.Builder> getDatabaseRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getDatabase(GetDatabaseRequest.builder().applyMutation(getDatabaseRequest).build());
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     *
     * @param getDatabasesRequest
     * @return Result of the GetDatabases operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabasesResponse getDatabases(GetDatabasesRequest getDatabasesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabasesRequest#builder()}
     * </p>
     *
     * @param getDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link GetDatabasesRequest.Builder} to create a request.
     * @return Result of the GetDatabases operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabasesResponse getDatabases(Consumer<GetDatabasesRequest.Builder> getDatabasesRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getDatabases(GetDatabasesRequest.builder().applyMutation(getDatabasesRequest).build());
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param getDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabasesIterable getDatabasesPaginator(GetDatabasesRequest getDatabasesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabasesRequest#builder()}
     * </p>
     *
     * @param getDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link GetDatabasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabasesIterable getDatabasesPaginator(Consumer<GetDatabasesRequest.Builder> getDatabasesRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getDatabasesPaginator(GetDatabasesRequest.builder().applyMutation(getDatabasesRequest).build());
    }

    /**
     * <p>
     * Transforms a Python script into a directed acyclic graph (DAG).
     * </p>
     *
     * @param getDataflowGraphRequest
     * @return Result of the GetDataflowGraph operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDataflowGraph
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataflowGraphResponse getDataflowGraph(GetDataflowGraphRequest getDataflowGraphRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transforms a Python script into a directed acyclic graph (DAG).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataflowGraphRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataflowGraphRequest#builder()}
     * </p>
     *
     * @param getDataflowGraphRequest
     *        A {@link Consumer} that will call methods on {@link GetDataflowGraphRequest.Builder} to create a request.
     * @return Result of the GetDataflowGraph operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDataflowGraph
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataflowGraphResponse getDataflowGraph(Consumer<GetDataflowGraphRequest.Builder> getDataflowGraphRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getDataflowGraph(GetDataflowGraphRequest.builder().applyMutation(getDataflowGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified development endpoint.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address, and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note>
     *
     * @param getDevEndpointRequest
     * @return Result of the GetDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointResponse getDevEndpoint(GetDevEndpointRequest getDevEndpointRequest) throws EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified development endpoint.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address, and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevEndpointRequest#builder()}
     * </p>
     *
     * @param getDevEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetDevEndpointRequest.Builder} to create a request.
     * @return Result of the GetDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointResponse getDevEndpoint(Consumer<GetDevEndpointRequest.Builder> getDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        return getDevEndpoint(GetDevEndpointRequest.builder().applyMutation(getDevEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this AWS account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note>
     *
     * @param getDevEndpointsRequest
     * @return Result of the GetDevEndpoints operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointsResponse getDevEndpoints(GetDevEndpointsRequest getDevEndpointsRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this AWS account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDevEndpointsRequest#builder()}
     * </p>
     *
     * @param getDevEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link GetDevEndpointsRequest.Builder} to create a request.
     * @return Result of the GetDevEndpoints operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointsResponse getDevEndpoints(Consumer<GetDevEndpointsRequest.Builder> getDevEndpointsRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        return getDevEndpoints(GetDevEndpointsRequest.builder().applyMutation(getDevEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this AWS account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param getDevEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointsIterable getDevEndpointsPaginator(GetDevEndpointsRequest getDevEndpointsRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this AWS account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDevEndpointsRequest#builder()}
     * </p>
     *
     * @param getDevEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link GetDevEndpointsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointsIterable getDevEndpointsPaginator(Consumer<GetDevEndpointsRequest.Builder> getDevEndpointsRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        return getDevEndpointsPaginator(GetDevEndpointsRequest.builder().applyMutation(getDevEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves an existing job definition.
     * </p>
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an existing job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRequest.Builder} to create a request.
     * @return Result of the GetJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Returns information on a job bookmark entry.
     * </p>
     *
     * @param getJobBookmarkRequest
     * @return Result of the GetJobBookmark operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobBookmark
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobBookmarkResponse getJobBookmark(GetJobBookmarkRequest getJobBookmarkRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ValidationException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information on a job bookmark entry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobBookmarkRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobBookmarkRequest#builder()}
     * </p>
     *
     * @param getJobBookmarkRequest
     *        A {@link Consumer} that will call methods on {@link GetJobBookmarkRequest.Builder} to create a request.
     * @return Result of the GetJobBookmark operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobBookmark
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobBookmarkResponse getJobBookmark(Consumer<GetJobBookmarkRequest.Builder> getJobBookmarkRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ValidationException, AwsServiceException, SdkClientException, GlueException {
        return getJobBookmark(GetJobBookmarkRequest.builder().applyMutation(getJobBookmarkRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for a given job run.
     * </p>
     *
     * @param getJobRunRequest
     * @return Result of the GetJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunResponse getJobRun(GetJobRunRequest getJobRunRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for a given job run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunRequest#builder()}
     * </p>
     *
     * @param getJobRunRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRunRequest.Builder} to create a request.
     * @return Result of the GetJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunResponse getJobRun(Consumer<GetJobRunRequest.Builder> getJobRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getJobRun(GetJobRunRequest.builder().applyMutation(getJobRunRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     *
     * @param getJobRunsRequest
     * @return Result of the GetJobRuns operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunsResponse getJobRuns(GetJobRunsRequest getJobRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunsRequest#builder()}
     * </p>
     *
     * @param getJobRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRunsRequest.Builder} to create a request.
     * @return Result of the GetJobRuns operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunsResponse getJobRuns(Consumer<GetJobRunsRequest.Builder> getJobRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getJobRuns(GetJobRunsRequest.builder().applyMutation(getJobRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.</b>
     * </p>
     *
     * @param getJobRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunsIterable getJobRunsPaginator(GetJobRunsRequest getJobRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunsRequest#builder()}
     * </p>
     *
     * @param getJobRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunsIterable getJobRunsPaginator(Consumer<GetJobRunsRequest.Builder> getJobRunsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getJobRunsPaginator(GetJobRunsRequest.builder().applyMutation(getJobRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     *
     * @param getJobsRequest
     * @return Result of the GetJobs operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobsResponse getJobs(GetJobsRequest getJobsRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobsRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobsRequest#builder()}
     * </p>
     *
     * @param getJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetJobsRequest.Builder} to create a request.
     * @return Result of the GetJobs operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobsResponse getJobs(Consumer<GetJobsRequest.Builder> getJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getJobs(GetJobsRequest.builder().applyMutation(getJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation.</b>
     * </p>
     *
     * @param getJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobsIterable getJobsPaginator(GetJobsRequest getJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobsRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobsRequest#builder()}
     * </p>
     *
     * @param getJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobsIterable getJobsPaginator(Consumer<GetJobsRequest.Builder> getJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getJobsPaginator(GetJobsRequest.builder().applyMutation(getJobsRequest).build());
    }

    /**
     * <p>
     * Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous
     * tasks that AWS Glue runs on your behalf as part of various machine learning workflows. You can check the stats of
     * any task run by calling <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform's
     * <code>TransformID</code>.
     * </p>
     *
     * @param getMlTaskRunRequest
     * @return Result of the GetMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTaskRunResponse getMLTaskRun(GetMlTaskRunRequest getMlTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous
     * tasks that AWS Glue runs on your behalf as part of various machine learning workflows. You can check the stats of
     * any task run by calling <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform's
     * <code>TransformID</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTaskRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTaskRunRequest#builder()}
     * </p>
     *
     * @param getMlTaskRunRequest
     *        A {@link Consumer} that will call methods on {@link GetMLTaskRunRequest.Builder} to create a request.
     * @return Result of the GetMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTaskRunResponse getMLTaskRun(Consumer<GetMlTaskRunRequest.Builder> getMlTaskRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getMLTaskRun(GetMlTaskRunRequest.builder().applyMutation(getMlTaskRunRequest).build());
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS
     * Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list
     * of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     *
     * @param getMlTaskRunsRequest
     * @return Result of the GetMLTaskRuns operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTaskRunsResponse getMLTaskRuns(GetMlTaskRunsRequest getMlTaskRunsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS
     * Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list
     * of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTaskRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTaskRunsRequest#builder()}
     * </p>
     *
     * @param getMlTaskRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetMLTaskRunsRequest.Builder} to create a request.
     * @return Result of the GetMLTaskRuns operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTaskRunsResponse getMLTaskRuns(Consumer<GetMlTaskRunsRequest.Builder> getMlTaskRunsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getMLTaskRuns(GetMlTaskRunsRequest.builder().applyMutation(getMlTaskRunsRequest).build());
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS
     * Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list
     * of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)} operation.</b>
     * </p>
     *
     * @param getMlTaskRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTaskRunsIterable getMLTaskRunsPaginator(GetMlTaskRunsRequest getMlTaskRunsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS
     * Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list
     * of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTaskRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTaskRunsRequest#builder()}
     * </p>
     *
     * @param getMlTaskRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetMLTaskRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTaskRunsIterable getMLTaskRunsPaginator(Consumer<GetMlTaskRunsRequest.Builder> getMlTaskRunsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getMLTaskRunsPaginator(GetMlTaskRunsRequest.builder().applyMutation(getMlTaskRunsRequest).build());
    }

    /**
     * <p>
     * Gets an AWS Glue machine learning transform artifact and all its corresponding metadata. Machine learning
     * transforms are a special type of transform that use machine learning to learn the details of the transformation
     * to be performed by learning from examples provided by humans. These transformations are then saved by AWS Glue.
     * You can retrieve their metadata by calling <code>GetMLTransform</code>.
     * </p>
     *
     * @param getMlTransformRequest
     * @return Result of the GetMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTransformResponse getMLTransform(GetMlTransformRequest getMlTransformRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an AWS Glue machine learning transform artifact and all its corresponding metadata. Machine learning
     * transforms are a special type of transform that use machine learning to learn the details of the transformation
     * to be performed by learning from examples provided by humans. These transformations are then saved by AWS Glue.
     * You can retrieve their metadata by calling <code>GetMLTransform</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTransformRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTransformRequest#builder()}
     * </p>
     *
     * @param getMlTransformRequest
     *        A {@link Consumer} that will call methods on {@link GetMLTransformRequest.Builder} to create a request.
     * @return Result of the GetMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTransformResponse getMLTransform(Consumer<GetMlTransformRequest.Builder> getMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getMLTransform(GetMlTransformRequest.builder().applyMutation(getMlTransformRequest).build());
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you
     * can retrieve their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     *
     * @param getMlTransformsRequest
     * @return Result of the GetMLTransforms operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTransformsResponse getMLTransforms(GetMlTransformsRequest getMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you
     * can retrieve their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTransformsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMlTransformsRequest#builder()}
     * </p>
     *
     * @param getMlTransformsRequest
     *        A {@link Consumer} that will call methods on {@link GetMLTransformsRequest.Builder} to create a request.
     * @return Result of the GetMLTransforms operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlTransformsResponse getMLTransforms(Consumer<GetMlTransformsRequest.Builder> getMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getMLTransforms(GetMlTransformsRequest.builder().applyMutation(getMlTransformsRequest).build());
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you
     * can retrieve their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetMlTransformsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)} operation.</b>
     * </p>
     *
     * @param getMlTransformsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTransformsIterable getMLTransformsPaginator(GetMlTransformsRequest getMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you
     * can retrieve their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetMlTransformsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTransformsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMlTransformsRequest#builder()}
     * </p>
     *
     * @param getMlTransformsRequest
     *        A {@link Consumer} that will call methods on {@link GetMLTransformsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTransformsIterable getMLTransformsPaginator(Consumer<GetMlTransformsRequest.Builder> getMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getMLTransformsPaginator(GetMlTransformsRequest.builder().applyMutation(getMlTransformsRequest).build());
    }

    /**
     * <p>
     * Creates mappings.
     * </p>
     *
     * @param getMappingRequest
     * @return Result of the GetMapping operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMappingResponse getMapping(GetMappingRequest getMappingRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates mappings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMappingRequest.Builder} avoiding the need to
     * create one manually via {@link GetMappingRequest#builder()}
     * </p>
     *
     * @param getMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetMappingRequest.Builder} to create a request.
     * @return Result of the GetMapping operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMappingResponse getMapping(Consumer<GetMappingRequest.Builder> getMappingRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        return getMapping(GetMappingRequest.builder().applyMutation(getMappingRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified partition.
     * </p>
     *
     * @param getPartitionRequest
     * @return Result of the GetPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionResponse getPartition(GetPartitionRequest getPartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartitionRequest#builder()}
     * </p>
     *
     * @param getPartitionRequest
     *        A {@link Consumer} that will call methods on {@link GetPartitionRequest.Builder} to create a request.
     * @return Result of the GetPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionResponse getPartition(Consumer<GetPartitionRequest.Builder> getPartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getPartition(GetPartitionRequest.builder().applyMutation(getPartitionRequest).build());
    }

    /**
     * <p>
     * Retrieves the partition indexes associated with a table.
     * </p>
     *
     * @param getPartitionIndexesRequest
     * @return Result of the GetPartitionIndexes operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitionIndexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionIndexesResponse getPartitionIndexes(GetPartitionIndexesRequest getPartitionIndexesRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, EntityNotFoundException,
            ConflictException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the partition indexes associated with a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link GetPartitionIndexesRequest#builder()}
     * </p>
     *
     * @param getPartitionIndexesRequest
     *        A {@link Consumer} that will call methods on {@link GetPartitionIndexesRequest.Builder} to create a
     *        request.
     * @return Result of the GetPartitionIndexes operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitionIndexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionIndexesResponse getPartitionIndexes(
            Consumer<GetPartitionIndexesRequest.Builder> getPartitionIndexesRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, EntityNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, GlueException {
        return getPartitionIndexes(GetPartitionIndexesRequest.builder().applyMutation(getPartitionIndexesRequest).build());
    }

    /**
     * <p>
     * Retrieves the partition indexes associated with a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable responses = client.getPartitionIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable responses = client
     *             .getPartitionIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable responses = client.getPartitionIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPartitionIndexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitionIndexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionIndexesIterable getPartitionIndexesPaginator(GetPartitionIndexesRequest getPartitionIndexesRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, EntityNotFoundException,
            ConflictException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the partition indexes associated with a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable responses = client.getPartitionIndexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable responses = client
     *             .getPartitionIndexesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesIterable responses = client.getPartitionIndexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link GetPartitionIndexesRequest#builder()}
     * </p>
     *
     * @param getPartitionIndexesRequest
     *        A {@link Consumer} that will call methods on {@link GetPartitionIndexesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConflictException
     *         The <code>CreatePartitions</code> API was called on a table that has indexes enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitionIndexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionIndexesIterable getPartitionIndexesPaginator(
            Consumer<GetPartitionIndexesRequest.Builder> getPartitionIndexesRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, EntityNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, GlueException {
        return getPartitionIndexesPaginator(GetPartitionIndexesRequest.builder().applyMutation(getPartitionIndexesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     *
     * @param getPartitionsRequest
     * @return Result of the GetPartitions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionsResponse getPartitions(GetPartitionsRequest getPartitionsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartitionsRequest#builder()}
     * </p>
     *
     * @param getPartitionsRequest
     *        A {@link Consumer} that will call methods on {@link GetPartitionsRequest.Builder} to create a request.
     * @return Result of the GetPartitions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionsResponse getPartitions(Consumer<GetPartitionsRequest.Builder> getPartitionsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getPartitions(GetPartitionsRequest.builder().applyMutation(getPartitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetPartitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)} operation.</b>
     * </p>
     *
     * @param getPartitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionsIterable getPartitionsPaginator(GetPartitionsRequest getPartitionsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetPartitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartitionsRequest#builder()}
     * </p>
     *
     * @param getPartitionsRequest
     *        A {@link Consumer} that will call methods on {@link GetPartitionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionsIterable getPartitionsPaginator(Consumer<GetPartitionsRequest.Builder> getPartitionsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getPartitionsPaginator(GetPartitionsRequest.builder().applyMutation(getPartitionsRequest).build());
    }

    /**
     * <p>
     * Gets code to perform a specified mapping.
     * </p>
     *
     * @param getPlanRequest
     * @return Result of the GetPlan operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPlanResponse getPlan(GetPlanRequest getPlanRequest) throws InvalidInputException, InternalServiceException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets code to perform a specified mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanRequest.Builder} avoiding the need to create
     * one manually via {@link GetPlanRequest#builder()}
     * </p>
     *
     * @param getPlanRequest
     *        A {@link Consumer} that will call methods on {@link GetPlanRequest.Builder} to create a request.
     * @return Result of the GetPlan operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPlanResponse getPlan(Consumer<GetPlanRequest.Builder> getPlanRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return getPlan(GetPlanRequest.builder().applyMutation(getPlanRequest).build());
    }

    /**
     * <p>
     * Describes the specified registry in detail.
     * </p>
     *
     * @param getRegistryRequest
     * @return Result of the GetRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegistryResponse getRegistry(GetRegistryRequest getRegistryRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified registry in detail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link GetRegistryRequest#builder()}
     * </p>
     *
     * @param getRegistryRequest
     *        A {@link Consumer} that will call methods on {@link GetRegistryInput.Builder} to create a request.
     * @return Result of the GetRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRegistryResponse getRegistry(Consumer<GetRegistryRequest.Builder> getRegistryRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getRegistry(GetRegistryRequest.builder().applyMutation(getRegistryRequest).build());
    }

    /**
     * <p>
     * Retrieves the security configurations for the resource policies set on individual resources, and also the
     * account-level policy.
     * </p>
     * <p>
     * This operation also returns the Data Catalog resource policy. However, if you enabled metadata encryption in Data
     * Catalog settings, and you do not have permission on the AWS KMS key, the operation can't return the Data Catalog
     * resource policy.
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return Result of the GetResourcePolicies operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesResponse getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the security configurations for the resource policies set on individual resources, and also the
     * account-level policy.
     * </p>
     * <p>
     * This operation also returns the Data Catalog resource policy. However, if you enabled metadata encryption in Data
     * Catalog settings, and you do not have permission on the AWS KMS key, the operation can't return the Data Catalog
     * resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePolicies operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesResponse getResourcePolicies(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        return getResourcePolicies(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the security configurations for the resource policies set on individual resources, and also the
     * account-level policy.
     * </p>
     * <p>
     * This operation also returns the Data Catalog resource policy. However, if you enabled metadata encryption in Data
     * Catalog settings, and you do not have permission on the AWS KMS key, the operation can't return the Data Catalog
     * resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable responses = client
     *             .getResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesIterable getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the security configurations for the resource policies set on individual resources, and also the
     * account-level policy.
     * </p>
     * <p>
     * This operation also returns the Data Catalog resource policy. However, if you enabled metadata encryption in Data
     * Catalog settings, and you do not have permission on the AWS KMS key, the operation can't return the Data Catalog
     * resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable responses = client
     *             .getResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesIterable getResourcePoliciesPaginator(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        return getResourcePoliciesPaginator(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a specified resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyRequest.Builder} to create a request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Describes the specified schema in detail.
     * </p>
     *
     * @param getSchemaRequest
     * @return Result of the GetSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaResponse getSchema(GetSchemaRequest getSchemaRequest) throws InvalidInputException, AccessDeniedException,
            EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified schema in detail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link GetSchemaRequest#builder()}
     * </p>
     *
     * @param getSchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaInput.Builder} to create a request.
     * @return Result of the GetSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaResponse getSchema(Consumer<GetSchemaRequest.Builder> getSchemaRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        return getSchema(GetSchemaRequest.builder().applyMutation(getSchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves a schema by the <code>SchemaDefinition</code>. The schema definition is sent to the Schema Registry,
     * canonicalized, and hashed. If the hash is matched within the scope of the <code>SchemaName</code> or ARN (or the
     * default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is
     * returned. Schema versions in <code>Deleted</code> statuses will not be included in the results.
     * </p>
     *
     * @param getSchemaByDefinitionRequest
     * @return Result of the GetSchemaByDefinition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchemaByDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaByDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaByDefinitionResponse getSchemaByDefinition(GetSchemaByDefinitionRequest getSchemaByDefinitionRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a schema by the <code>SchemaDefinition</code>. The schema definition is sent to the Schema Registry,
     * canonicalized, and hashed. If the hash is matched within the scope of the <code>SchemaName</code> or ARN (or the
     * default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is
     * returned. Schema versions in <code>Deleted</code> statuses will not be included in the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaByDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetSchemaByDefinitionRequest#builder()}
     * </p>
     *
     * @param getSchemaByDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaByDefinitionInput.Builder} to create a
     *        request.
     * @return Result of the GetSchemaByDefinition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchemaByDefinition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaByDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaByDefinitionResponse getSchemaByDefinition(
            Consumer<GetSchemaByDefinitionRequest.Builder> getSchemaByDefinitionRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        return getSchemaByDefinition(GetSchemaByDefinitionRequest.builder().applyMutation(getSchemaByDefinitionRequest).build());
    }

    /**
     * <p>
     * Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema
     * versions in Deleted status will not be included in the results.
     * </p>
     *
     * @param getSchemaVersionRequest
     * @return Result of the GetSchemaVersion operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchemaVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaVersionResponse getSchemaVersion(GetSchemaVersionRequest getSchemaVersionRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema
     * versions in Deleted status will not be included in the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaVersionRequest#builder()}
     * </p>
     *
     * @param getSchemaVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaVersionInput.Builder} to create a request.
     * @return Result of the GetSchemaVersion operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchemaVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaVersionResponse getSchemaVersion(Consumer<GetSchemaVersionRequest.Builder> getSchemaVersionRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return getSchemaVersion(GetSchemaVersionRequest.builder().applyMutation(getSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Fetches the schema version difference in the specified difference type between two stored schema versions in the
     * Schema Registry.
     * </p>
     * <p>
     * This API allows you to compare two schema versions between two schema definitions under the same schema.
     * </p>
     *
     * @param getSchemaVersionsDiffRequest
     * @return Result of the GetSchemaVersionsDiff operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchemaVersionsDiff
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersionsDiff" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaVersionsDiffResponse getSchemaVersionsDiff(GetSchemaVersionsDiffRequest getSchemaVersionsDiffRequest)
            throws InvalidInputException, EntityNotFoundException, AccessDeniedException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the schema version difference in the specified difference type between two stored schema versions in the
     * Schema Registry.
     * </p>
     * <p>
     * This API allows you to compare two schema versions between two schema definitions under the same schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaVersionsDiffRequest.Builder} avoiding the
     * need to create one manually via {@link GetSchemaVersionsDiffRequest#builder()}
     * </p>
     *
     * @param getSchemaVersionsDiffRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaVersionsDiffInput.Builder} to create a
     *        request.
     * @return Result of the GetSchemaVersionsDiff operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSchemaVersionsDiff
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersionsDiff" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaVersionsDiffResponse getSchemaVersionsDiff(
            Consumer<GetSchemaVersionsDiffRequest.Builder> getSchemaVersionsDiffRequest) throws InvalidInputException,
            EntityNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        return getSchemaVersionsDiff(GetSchemaVersionsDiffRequest.builder().applyMutation(getSchemaVersionsDiffRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified security configuration.
     * </p>
     *
     * @param getSecurityConfigurationRequest
     * @return Result of the GetSecurityConfiguration operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecurityConfigurationResponse getSecurityConfiguration(
            GetSecurityConfigurationRequest getSecurityConfigurationRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified security configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetSecurityConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetSecurityConfiguration operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecurityConfigurationResponse getSecurityConfiguration(
            Consumer<GetSecurityConfigurationRequest.Builder> getSecurityConfigurationRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return getSecurityConfiguration(GetSecurityConfigurationRequest.builder().applyMutation(getSecurityConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     * @return Result of the GetSecurityConfigurations operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecurityConfigurationsResponse getSecurityConfigurations(
            GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link GetSecurityConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSecurityConfigurations operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecurityConfigurationsResponse getSecurityConfigurations(
            Consumer<GetSecurityConfigurationsRequest.Builder> getSecurityConfigurationsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return getSecurityConfigurations(GetSecurityConfigurationsRequest.builder()
                .applyMutation(getSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client.getSecurityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client
     *             .getSecurityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client.getSecurityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecurityConfigurationsIterable getSecurityConfigurationsPaginator(
            GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client.getSecurityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client
     *             .getSecurityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client.getSecurityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link GetSecurityConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSecurityConfigurationsIterable getSecurityConfigurationsPaginator(
            Consumer<GetSecurityConfigurationsRequest.Builder> getSecurityConfigurationsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return getSecurityConfigurationsPaginator(GetSecurityConfigurationsRequest.builder()
                .applyMutation(getSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.
     * </p>
     *
     * @param getTableRequest
     * @return Result of the GetTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableResponse getTable(GetTableRequest getTableRequest) throws EntityNotFoundException, InvalidInputException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRequest.Builder} avoiding the need to
     * create one manually via {@link GetTableRequest#builder()}
     * </p>
     *
     * @param getTableRequest
     *        A {@link Consumer} that will call methods on {@link GetTableRequest.Builder} to create a request.
     * @return Result of the GetTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableResponse getTable(Consumer<GetTableRequest.Builder> getTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getTable(GetTableRequest.builder().applyMutation(getTableRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified version of a table.
     * </p>
     *
     * @param getTableVersionRequest
     * @return Result of the GetTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionResponse getTableVersion(GetTableVersionRequest getTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified version of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableVersionRequest#builder()}
     * </p>
     *
     * @param getTableVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetTableVersionRequest.Builder} to create a request.
     * @return Result of the GetTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionResponse getTableVersion(Consumer<GetTableVersionRequest.Builder> getTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getTableVersion(GetTableVersionRequest.builder().applyMutation(getTableVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     *
     * @param getTableVersionsRequest
     * @return Result of the GetTableVersions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionsResponse getTableVersions(GetTableVersionsRequest getTableVersionsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableVersionsRequest#builder()}
     * </p>
     *
     * @param getTableVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetTableVersionsRequest.Builder} to create a request.
     * @return Result of the GetTableVersions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionsResponse getTableVersions(Consumer<GetTableVersionsRequest.Builder> getTableVersionsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getTableVersions(GetTableVersionsRequest.builder().applyMutation(getTableVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client.getTableVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client
     *             .getTableVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTableVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client.getTableVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation.</b>
     * </p>
     *
     * @param getTableVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionsIterable getTableVersionsPaginator(GetTableVersionsRequest getTableVersionsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client.getTableVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client
     *             .getTableVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTableVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client.getTableVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableVersionsRequest#builder()}
     * </p>
     *
     * @param getTableVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetTableVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionsIterable getTableVersionsPaginator(Consumer<GetTableVersionsRequest.Builder> getTableVersionsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getTableVersionsPaginator(GetTableVersionsRequest.builder().applyMutation(getTableVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     *
     * @param getTablesRequest
     * @return Result of the GetTables operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablesResponse getTables(GetTablesRequest getTablesRequest) throws EntityNotFoundException, InvalidInputException,
            OperationTimeoutException, InternalServiceException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetTablesRequest#builder()}
     * </p>
     *
     * @param getTablesRequest
     *        A {@link Consumer} that will call methods on {@link GetTablesRequest.Builder} to create a request.
     * @return Result of the GetTables operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablesResponse getTables(Consumer<GetTablesRequest.Builder> getTablesRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getTables(GetTablesRequest.builder().applyMutation(getTablesRequest).build());
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.</b>
     * </p>
     *
     * @param getTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablesIterable getTablesPaginator(GetTablesRequest getTablesRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetTablesRequest#builder()}
     * </p>
     *
     * @param getTablesRequest
     *        A {@link Consumer} that will call methods on {@link GetTablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablesIterable getTablesPaginator(Consumer<GetTablesRequest.Builder> getTablesRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return getTablesPaginator(GetTablesRequest.builder().applyMutation(getTablesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags associated with a resource.
     * </p>
     *
     * @param getTagsRequest
     * @return Result of the GetTags operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws InvalidInputException, InternalServiceException,
            OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on {@link GetTagsRequest.Builder} to create a request.
     * @return Result of the GetTags operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTagsResponse getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves the definition of a trigger.
     * </p>
     *
     * @param getTriggerRequest
     * @return Result of the GetTrigger operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggerResponse getTrigger(GetTriggerRequest getTriggerRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definition of a trigger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link GetTriggerRequest#builder()}
     * </p>
     *
     * @param getTriggerRequest
     *        A {@link Consumer} that will call methods on {@link GetTriggerRequest.Builder} to create a request.
     * @return Result of the GetTrigger operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggerResponse getTrigger(Consumer<GetTriggerRequest.Builder> getTriggerRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return getTrigger(GetTriggerRequest.builder().applyMutation(getTriggerRequest).build());
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     *
     * @param getTriggersRequest
     * @return Result of the GetTriggers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggersResponse getTriggers(GetTriggersRequest getTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTriggersRequest.Builder} avoiding the need to
     * create one manually via {@link GetTriggersRequest#builder()}
     * </p>
     *
     * @param getTriggersRequest
     *        A {@link Consumer} that will call methods on {@link GetTriggersRequest.Builder} to create a request.
     * @return Result of the GetTriggers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggersResponse getTriggers(Consumer<GetTriggersRequest.Builder> getTriggersRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getTriggers(GetTriggersRequest.builder().applyMutation(getTriggersRequest).build());
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)} operation.</b>
     * </p>
     *
     * @param getTriggersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggersIterable getTriggersPaginator(GetTriggersRequest getTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTriggersRequest.Builder} avoiding the need to
     * create one manually via {@link GetTriggersRequest#builder()}
     * </p>
     *
     * @param getTriggersRequest
     *        A {@link Consumer} that will call methods on {@link GetTriggersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggersIterable getTriggersPaginator(Consumer<GetTriggersRequest.Builder> getTriggersRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getTriggersPaginator(GetTriggersRequest.builder().applyMutation(getTriggersRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified function definition from the Data Catalog.
     * </p>
     *
     * @param getUserDefinedFunctionRequest
     * @return Result of the GetUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionResponse getUserDefinedFunction(GetUserDefinedFunctionRequest getUserDefinedFunctionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified function definition from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserDefinedFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link GetUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param getUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on {@link GetUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the GetUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionResponse getUserDefinedFunction(
            Consumer<GetUserDefinedFunctionRequest.Builder> getUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getUserDefinedFunction(GetUserDefinedFunctionRequest.builder().applyMutation(getUserDefinedFunctionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     * @return Result of the GetUserDefinedFunctions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionsResponse getUserDefinedFunctions(GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserDefinedFunctionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetUserDefinedFunctionsRequest#builder()}
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link GetUserDefinedFunctionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetUserDefinedFunctions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionsResponse getUserDefinedFunctions(
            Consumer<GetUserDefinedFunctionsRequest.Builder> getUserDefinedFunctionsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getUserDefinedFunctions(GetUserDefinedFunctionsRequest.builder().applyMutation(getUserDefinedFunctionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client.getUserDefinedFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client
     *             .getUserDefinedFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client.getUserDefinedFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionsIterable getUserDefinedFunctionsPaginator(
            GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) throws EntityNotFoundException, InvalidInputException,
            OperationTimeoutException, InternalServiceException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client.getUserDefinedFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client
     *             .getUserDefinedFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client.getUserDefinedFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserDefinedFunctionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetUserDefinedFunctionsRequest#builder()}
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link GetUserDefinedFunctionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionsIterable getUserDefinedFunctionsPaginator(
            Consumer<GetUserDefinedFunctionsRequest.Builder> getUserDefinedFunctionsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return getUserDefinedFunctionsPaginator(GetUserDefinedFunctionsRequest.builder()
                .applyMutation(getUserDefinedFunctionsRequest).build());
    }

    /**
     * <p>
     * Retrieves resource metadata for a workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves resource metadata for a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRequest.Builder} to create a request.
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for a given workflow run.
     * </p>
     *
     * @param getWorkflowRunRequest
     * @return Result of the GetWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunResponse getWorkflowRun(GetWorkflowRunRequest getWorkflowRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for a given workflow run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRunRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRunRequest.Builder} to create a request.
     * @return Result of the GetWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunResponse getWorkflowRun(Consumer<GetWorkflowRunRequest.Builder> getWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getWorkflowRun(GetWorkflowRunRequest.builder().applyMutation(getWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Retrieves the workflow run properties which were set during the run.
     * </p>
     *
     * @param getWorkflowRunPropertiesRequest
     * @return Result of the GetWorkflowRunProperties operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRunProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkflowRunPropertiesResponse getWorkflowRunProperties(
            GetWorkflowRunPropertiesRequest getWorkflowRunPropertiesRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the workflow run properties which were set during the run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link GetWorkflowRunPropertiesRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRunPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorkflowRunProperties operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRunProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkflowRunPropertiesResponse getWorkflowRunProperties(
            Consumer<GetWorkflowRunPropertiesRequest.Builder> getWorkflowRunPropertiesRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return getWorkflowRunProperties(GetWorkflowRunPropertiesRequest.builder().applyMutation(getWorkflowRunPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     *
     * @param getWorkflowRunsRequest
     * @return Result of the GetWorkflowRuns operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunsResponse getWorkflowRuns(GetWorkflowRunsRequest getWorkflowRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunsRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowRunsRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRunsRequest.Builder} to create a request.
     * @return Result of the GetWorkflowRuns operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunsResponse getWorkflowRuns(Consumer<GetWorkflowRunsRequest.Builder> getWorkflowRunsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getWorkflowRuns(GetWorkflowRunsRequest.builder().applyMutation(getWorkflowRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)} operation.</b>
     * </p>
     *
     * @param getWorkflowRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunsIterable getWorkflowRunsPaginator(GetWorkflowRunsRequest getWorkflowRunsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunsRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowRunsRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRunsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunsIterable getWorkflowRunsPaginator(Consumer<GetWorkflowRunsRequest.Builder> getWorkflowRunsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return getWorkflowRunsPaginator(GetWorkflowRunsRequest.builder().applyMutation(getWorkflowRunsRequest).build());
    }

    /**
     * <p>
     * Imports an existing Amazon Athena Data Catalog to AWS Glue
     * </p>
     *
     * @param importCatalogToGlueRequest
     * @return Result of the ImportCatalogToGlue operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ImportCatalogToGlue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCatalogToGlueResponse importCatalogToGlue(ImportCatalogToGlueRequest importCatalogToGlueRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports an existing Amazon Athena Data Catalog to AWS Glue
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCatalogToGlueRequest.Builder} avoiding the
     * need to create one manually via {@link ImportCatalogToGlueRequest#builder()}
     * </p>
     *
     * @param importCatalogToGlueRequest
     *        A {@link Consumer} that will call methods on {@link ImportCatalogToGlueRequest.Builder} to create a
     *        request.
     * @return Result of the ImportCatalogToGlue operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ImportCatalogToGlue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCatalogToGlueResponse importCatalogToGlue(
            Consumer<ImportCatalogToGlueRequest.Builder> importCatalogToGlueRequest) throws InternalServiceException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return importCatalogToGlue(ImportCatalogToGlueRequest.builder().applyMutation(importCatalogToGlueRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listCrawlersRequest
     * @return Result of the ListCrawlers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrawlersResponse listCrawlers(ListCrawlersRequest listCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCrawlersRequest.Builder} avoiding the need to
     * create one manually via {@link ListCrawlersRequest#builder()}
     * </p>
     *
     * @param listCrawlersRequest
     *        A {@link Consumer} that will call methods on {@link ListCrawlersRequest.Builder} to create a request.
     * @return Result of the ListCrawlers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrawlersResponse listCrawlers(Consumer<ListCrawlersRequest.Builder> listCrawlersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return listCrawlers(ListCrawlersRequest.builder().applyMutation(listCrawlersRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCrawlers(software.amazon.awssdk.services.glue.model.ListCrawlersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListCrawlersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrawlers(software.amazon.awssdk.services.glue.model.ListCrawlersRequest)} operation.</b>
     * </p>
     *
     * @param listCrawlersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrawlersIterable listCrawlersPaginator(ListCrawlersRequest listCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCrawlers(software.amazon.awssdk.services.glue.model.ListCrawlersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListCrawlersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrawlers(software.amazon.awssdk.services.glue.model.ListCrawlersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCrawlersRequest.Builder} avoiding the need to
     * create one manually via {@link ListCrawlersRequest#builder()}
     * </p>
     *
     * @param listCrawlersRequest
     *        A {@link Consumer} that will call methods on {@link ListCrawlersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCrawlersIterable listCrawlersPaginator(Consumer<ListCrawlersRequest.Builder> listCrawlersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return listCrawlersPaginator(ListCrawlersRequest.builder().applyMutation(listCrawlersRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the
     * specified tag. This operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listDevEndpointsRequest
     * @return Result of the ListDevEndpoints operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevEndpointsResponse listDevEndpoints(ListDevEndpointsRequest listDevEndpointsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the
     * specified tag. This operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevEndpointsRequest#builder()}
     * </p>
     *
     * @param listDevEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevEndpointsRequest.Builder} to create a request.
     * @return Result of the ListDevEndpoints operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevEndpointsResponse listDevEndpoints(Consumer<ListDevEndpointsRequest.Builder> listDevEndpointsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return listDevEndpoints(ListDevEndpointsRequest.builder().applyMutation(listDevEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the
     * specified tag. This operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevEndpoints(software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client.listDevEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client
     *             .listDevEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client.listDevEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevEndpoints(software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param listDevEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevEndpointsIterable listDevEndpointsPaginator(ListDevEndpointsRequest listDevEndpointsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the
     * specified tag. This operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevEndpoints(software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client.listDevEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client
     *             .listDevEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client.listDevEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevEndpoints(software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDevEndpointsRequest#builder()}
     * </p>
     *
     * @param listDevEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListDevEndpointsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevEndpointsIterable listDevEndpointsPaginator(Consumer<ListDevEndpointsRequest.Builder> listDevEndpointsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return listDevEndpointsPaginator(ListDevEndpointsRequest.builder().applyMutation(listDevEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.glue.model.ListJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.glue.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.glue.model.ListJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.glue.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or
     * the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can
     * use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
     * filtering, only resources with the tags are retrieved.
     * </p>
     *
     * @param listMlTransformsRequest
     * @return Result of the ListMLTransforms operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMlTransformsResponse listMLTransforms(ListMlTransformsRequest listMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or
     * the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can
     * use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
     * filtering, only resources with the tags are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlTransformsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMlTransformsRequest#builder()}
     * </p>
     *
     * @param listMlTransformsRequest
     *        A {@link Consumer} that will call methods on {@link ListMLTransformsRequest.Builder} to create a request.
     * @return Result of the ListMLTransforms operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMlTransformsResponse listMLTransforms(Consumer<ListMlTransformsRequest.Builder> listMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return listMLTransforms(ListMlTransformsRequest.builder().applyMutation(listMlTransformsRequest).build());
    }

    /**
     * <p>
     * Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or
     * the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can
     * use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
     * filtering, only resources with the tags are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMLTransforms(software.amazon.awssdk.services.glue.model.ListMlTransformsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client.listMLTransformsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client
     *             .listMLTransformsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListMlTransformsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client.listMLTransformsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLTransforms(software.amazon.awssdk.services.glue.model.ListMlTransformsRequest)} operation.</b>
     * </p>
     *
     * @param listMlTransformsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMLTransformsIterable listMLTransformsPaginator(ListMlTransformsRequest listMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or
     * the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can
     * use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
     * filtering, only resources with the tags are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMLTransforms(software.amazon.awssdk.services.glue.model.ListMlTransformsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client.listMLTransformsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client
     *             .listMLTransformsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListMlTransformsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client.listMLTransformsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLTransforms(software.amazon.awssdk.services.glue.model.ListMlTransformsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlTransformsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMlTransformsRequest#builder()}
     * </p>
     *
     * @param listMlTransformsRequest
     *        A {@link Consumer} that will call methods on {@link ListMLTransformsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMLTransformsIterable listMLTransformsPaginator(Consumer<ListMlTransformsRequest.Builder> listMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return listMLTransformsPaginator(ListMlTransformsRequest.builder().applyMutation(listMlTransformsRequest).build());
    }

    /**
     * <p>
     * Returns a list of registries that you have created, with minimal registry information. Registries in the
     * <code>Deleting</code> status will not be included in the results. Empty results will be returned if there are no
     * registries available.
     * </p>
     *
     * @param listRegistriesRequest
     * @return Result of the ListRegistries operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesResponse listRegistries(ListRegistriesRequest listRegistriesRequest) throws InvalidInputException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registries that you have created, with minimal registry information. Registries in the
     * <code>Deleting</code> status will not be included in the results. Empty results will be returned if there are no
     * registries available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegistriesRequest#builder()}
     * </p>
     *
     * @param listRegistriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRegistriesInput.Builder} to create a request.
     * @return Result of the ListRegistries operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesResponse listRegistries(Consumer<ListRegistriesRequest.Builder> listRegistriesRequest)
            throws InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException,
            SdkClientException, GlueException {
        return listRegistries(ListRegistriesRequest.builder().applyMutation(listRegistriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of registries that you have created, with minimal registry information. Registries in the
     * <code>Deleting</code> status will not be included in the results. Empty results will be returned if there are no
     * registries available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRegistries(software.amazon.awssdk.services.glue.model.ListRegistriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListRegistriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistries(software.amazon.awssdk.services.glue.model.ListRegistriesRequest)} operation.</b>
     * </p>
     *
     * @param listRegistriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesIterable listRegistriesPaginator(ListRegistriesRequest listRegistriesRequest)
            throws InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registries that you have created, with minimal registry information. Registries in the
     * <code>Deleting</code> status will not be included in the results. Empty results will be returned if there are no
     * registries available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRegistries(software.amazon.awssdk.services.glue.model.ListRegistriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListRegistriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListRegistriesIterable responses = client.listRegistriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistries(software.amazon.awssdk.services.glue.model.ListRegistriesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegistriesRequest#builder()}
     * </p>
     *
     * @param listRegistriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRegistriesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListRegistries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesIterable listRegistriesPaginator(Consumer<ListRegistriesRequest.Builder> listRegistriesRequest)
            throws InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException,
            SdkClientException, GlueException {
        return listRegistriesPaginator(ListRegistriesRequest.builder().applyMutation(listRegistriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted
     * status will not be included in the results. Empty results will be returned if there are no schema versions
     * available.
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsResponse listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted
     * status will not be included in the results. Empty results will be returned if there are no schema versions
     * available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemaVersionsInput.Builder} to create a request.
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsResponse listSchemaVersions(Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return listSchemaVersions(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted
     * status will not be included in the results. Empty results will be returned if there are no schema versions
     * available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable responses = client
     *             .listSchemaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListSchemaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsIterable listSchemaVersionsPaginator(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted
     * status will not be included in the results. Empty results will be returned if there are no schema versions
     * available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable responses = client
     *             .listSchemaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListSchemaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemaVersionsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemaVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemaVersionsIterable listSchemaVersionsPaginator(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        return listSchemaVersionsPaginator(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results.
     * Empty results will be returned if there are no schemas available.
     * </p>
     * <p>
     * When the <code>RegistryId</code> is not provided, all the schemas across registries will be part of the API
     * response.
     * </p>
     *
     * @param listSchemasRequest
     * @return Result of the ListSchemas operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results.
     * Empty results will be returned if there are no schemas available.
     * </p>
     * <p>
     * When the <code>RegistryId</code> is not provided, all the schemas across registries will be part of the API
     * response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasInput.Builder} to create a request.
     * @return Result of the ListSchemas operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results.
     * Empty results will be returned if there are no schemas available.
     * </p>
     * <p>
     * When the <code>RegistryId</code> is not provided, all the schemas across registries will be part of the API
     * response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.glue.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.glue.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results.
     * Empty results will be returned if there are no schemas available.
     * </p>
     * <p>
     * When the <code>RegistryId</code> is not provided, all the schemas across registries will be part of the API
     * response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.glue.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.glue.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListSchemas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listTriggersRequest
     * @return Result of the ListTriggers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTriggersResponse listTriggers(ListTriggersRequest listTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTriggersRequest.Builder} avoiding the need to
     * create one manually via {@link ListTriggersRequest#builder()}
     * </p>
     *
     * @param listTriggersRequest
     *        A {@link Consumer} that will call methods on {@link ListTriggersRequest.Builder} to create a request.
     * @return Result of the ListTriggers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTriggersResponse listTriggers(Consumer<ListTriggersRequest.Builder> listTriggersRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return listTriggers(ListTriggersRequest.builder().applyMutation(listTriggersRequest).build());
    }

    /**
     * <p>
     * Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTriggers(software.amazon.awssdk.services.glue.model.ListTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTriggers(software.amazon.awssdk.services.glue.model.ListTriggersRequest)} operation.</b>
     * </p>
     *
     * @param listTriggersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTriggersIterable listTriggersPaginator(ListTriggersRequest listTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTriggers(software.amazon.awssdk.services.glue.model.ListTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTriggers(software.amazon.awssdk.services.glue.model.ListTriggersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTriggersRequest.Builder} avoiding the need to
     * create one manually via {@link ListTriggersRequest#builder()}
     * </p>
     *
     * @param listTriggersRequest
     *        A {@link Consumer} that will call methods on {@link ListTriggersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTriggersIterable listTriggersPaginator(Consumer<ListTriggersRequest.Builder> listTriggersRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return listTriggersPaginator(ListTriggersRequest.builder().applyMutation(listTriggersRequest).build());
    }

    /**
     * <p>
     * Lists names of workflows created in the account.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists names of workflows created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Lists names of workflows created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.glue.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.glue.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsIterable listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists names of workflows created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.glue.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.glue.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsIterable listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Sets the security configuration for a specified catalog. After the configuration has been set, the specified
     * encryption is applied to every catalog write thereafter.
     * </p>
     *
     * @param putDataCatalogEncryptionSettingsRequest
     * @return Result of the PutDataCatalogEncryptionSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutDataCatalogEncryptionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDataCatalogEncryptionSettingsResponse putDataCatalogEncryptionSettings(
            PutDataCatalogEncryptionSettingsRequest putDataCatalogEncryptionSettingsRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the security configuration for a specified catalog. After the configuration has been set, the specified
     * encryption is applied to every catalog write thereafter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDataCatalogEncryptionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link PutDataCatalogEncryptionSettingsRequest#builder()}
     * </p>
     *
     * @param putDataCatalogEncryptionSettingsRequest
     *        A {@link Consumer} that will call methods on {@link PutDataCatalogEncryptionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the PutDataCatalogEncryptionSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutDataCatalogEncryptionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDataCatalogEncryptionSettingsResponse putDataCatalogEncryptionSettings(
            Consumer<PutDataCatalogEncryptionSettingsRequest.Builder> putDataCatalogEncryptionSettingsRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return putDataCatalogEncryptionSettings(PutDataCatalogEncryptionSettingsRequest.builder()
                .applyMutation(putDataCatalogEncryptionSettingsRequest).build());
    }

    /**
     * <p>
     * Sets the Data Catalog resource policy for access control.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ConditionCheckFailureException
     *         A specified condition was not satisfied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ConditionCheckFailureException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the Data Catalog resource policy for access control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ConditionCheckFailureException
     *         A specified condition was not satisfied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ConditionCheckFailureException, AwsServiceException, SdkClientException, GlueException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Puts the metadata key value pair for a specified schema version ID. A maximum of 10 key value pairs will be
     * allowed per schema version. They can be added over one or more calls.
     * </p>
     *
     * @param putSchemaVersionMetadataRequest
     * @return Result of the PutSchemaVersionMetadata operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutSchemaVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutSchemaVersionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default PutSchemaVersionMetadataResponse putSchemaVersionMetadata(
            PutSchemaVersionMetadataRequest putSchemaVersionMetadataRequest) throws InvalidInputException, AccessDeniedException,
            AlreadyExistsException, EntityNotFoundException, ResourceNumberLimitExceededException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts the metadata key value pair for a specified schema version ID. A maximum of 10 key value pairs will be
     * allowed per schema version. They can be added over one or more calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSchemaVersionMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link PutSchemaVersionMetadataRequest#builder()}
     * </p>
     *
     * @param putSchemaVersionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link PutSchemaVersionMetadataInput.Builder} to create a
     *        request.
     * @return Result of the PutSchemaVersionMetadata operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutSchemaVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutSchemaVersionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default PutSchemaVersionMetadataResponse putSchemaVersionMetadata(
            Consumer<PutSchemaVersionMetadataRequest.Builder> putSchemaVersionMetadataRequest) throws InvalidInputException,
            AccessDeniedException, AlreadyExistsException, EntityNotFoundException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        return putSchemaVersionMetadata(PutSchemaVersionMetadataRequest.builder().applyMutation(putSchemaVersionMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Puts the specified workflow run properties for the given workflow run. If a property already exists for the
     * specified run, then it overrides the value otherwise adds the property to existing properties.
     * </p>
     *
     * @param putWorkflowRunPropertiesRequest
     * @return Result of the PutWorkflowRunProperties operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutWorkflowRunProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default PutWorkflowRunPropertiesResponse putWorkflowRunProperties(
            PutWorkflowRunPropertiesRequest putWorkflowRunPropertiesRequest) throws AlreadyExistsException,
            EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts the specified workflow run properties for the given workflow run. If a property already exists for the
     * specified run, then it overrides the value otherwise adds the property to existing properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutWorkflowRunPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link PutWorkflowRunPropertiesRequest#builder()}
     * </p>
     *
     * @param putWorkflowRunPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link PutWorkflowRunPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the PutWorkflowRunProperties operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutWorkflowRunProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default PutWorkflowRunPropertiesResponse putWorkflowRunProperties(
            Consumer<PutWorkflowRunPropertiesRequest.Builder> putWorkflowRunPropertiesRequest) throws AlreadyExistsException,
            EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        return putWorkflowRunProperties(PutWorkflowRunPropertiesRequest.builder().applyMutation(putWorkflowRunPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Queries for the schema version metadata information.
     * </p>
     *
     * @param querySchemaVersionMetadataRequest
     * @return Result of the QuerySchemaVersionMetadata operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.QuerySchemaVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/QuerySchemaVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default QuerySchemaVersionMetadataResponse querySchemaVersionMetadata(
            QuerySchemaVersionMetadataRequest querySchemaVersionMetadataRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries for the schema version metadata information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QuerySchemaVersionMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link QuerySchemaVersionMetadataRequest#builder()}
     * </p>
     *
     * @param querySchemaVersionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link QuerySchemaVersionMetadataInput.Builder} to create a
     *        request.
     * @return Result of the QuerySchemaVersionMetadata operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.QuerySchemaVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/QuerySchemaVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default QuerySchemaVersionMetadataResponse querySchemaVersionMetadata(
            Consumer<QuerySchemaVersionMetadataRequest.Builder> querySchemaVersionMetadataRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, AwsServiceException, SdkClientException, GlueException {
        return querySchemaVersionMetadata(QuerySchemaVersionMetadataRequest.builder()
                .applyMutation(querySchemaVersionMetadataRequest).build());
    }

    /**
     * <p>
     * Adds a new version to the existing schema. Returns an error if new version of schema does not meet the
     * compatibility requirements of the schema set. This API will not create a new schema set and will return a 404
     * error if the schema set is not already present in the Schema Registry.
     * </p>
     * <p>
     * If this is the first schema definition to be registered in the Schema Registry, this API will store the schema
     * version and return immediately. Otherwise, this call has the potential to run longer than other operations due to
     * compatibility modes. You can call the <code>GetSchemaVersion</code> API with the <code>SchemaVersionId</code> to
     * check compatibility modes.
     * </p>
     * <p>
     * If the same schema definition is already stored in Schema Registry as a version, the schema ID of the existing
     * schema is returned to the caller.
     * </p>
     *
     * @param registerSchemaVersionRequest
     * @return Result of the RegisterSchemaVersion operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.RegisterSchemaVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RegisterSchemaVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterSchemaVersionResponse registerSchemaVersion(RegisterSchemaVersionRequest registerSchemaVersionRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new version to the existing schema. Returns an error if new version of schema does not meet the
     * compatibility requirements of the schema set. This API will not create a new schema set and will return a 404
     * error if the schema set is not already present in the Schema Registry.
     * </p>
     * <p>
     * If this is the first schema definition to be registered in the Schema Registry, this API will store the schema
     * version and return immediately. Otherwise, this call has the potential to run longer than other operations due to
     * compatibility modes. You can call the <code>GetSchemaVersion</code> API with the <code>SchemaVersionId</code> to
     * check compatibility modes.
     * </p>
     * <p>
     * If the same schema definition is already stored in Schema Registry as a version, the schema ID of the existing
     * schema is returned to the caller.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterSchemaVersionRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterSchemaVersionRequest#builder()}
     * </p>
     *
     * @param registerSchemaVersionRequest
     *        A {@link Consumer} that will call methods on {@link RegisterSchemaVersionInput.Builder} to create a
     *        request.
     * @return Result of the RegisterSchemaVersion operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.RegisterSchemaVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RegisterSchemaVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterSchemaVersionResponse registerSchemaVersion(
            Consumer<RegisterSchemaVersionRequest.Builder> registerSchemaVersionRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        return registerSchemaVersion(RegisterSchemaVersionRequest.builder().applyMutation(registerSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Removes a key value pair from the schema version metadata for the specified schema version ID.
     * </p>
     *
     * @param removeSchemaVersionMetadataRequest
     * @return Result of the RemoveSchemaVersionMetadata operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.RemoveSchemaVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RemoveSchemaVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveSchemaVersionMetadataResponse removeSchemaVersionMetadata(
            RemoveSchemaVersionMetadataRequest removeSchemaVersionMetadataRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a key value pair from the schema version metadata for the specified schema version ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveSchemaVersionMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveSchemaVersionMetadataRequest#builder()}
     * </p>
     *
     * @param removeSchemaVersionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link RemoveSchemaVersionMetadataInput.Builder} to create a
     *        request.
     * @return Result of the RemoveSchemaVersionMetadata operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.RemoveSchemaVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/RemoveSchemaVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveSchemaVersionMetadataResponse removeSchemaVersionMetadata(
            Consumer<RemoveSchemaVersionMetadataRequest.Builder> removeSchemaVersionMetadataRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        return removeSchemaVersionMetadata(RemoveSchemaVersionMetadataRequest.builder()
                .applyMutation(removeSchemaVersionMetadataRequest).build());
    }

    /**
     * <p>
     * Resets a bookmark entry.
     * </p>
     *
     * @param resetJobBookmarkRequest
     * @return Result of the ResetJobBookmark operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ResetJobBookmark
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetJobBookmarkResponse resetJobBookmark(ResetJobBookmarkRequest resetJobBookmarkRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets a bookmark entry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetJobBookmarkRequest.Builder} avoiding the need
     * to create one manually via {@link ResetJobBookmarkRequest#builder()}
     * </p>
     *
     * @param resetJobBookmarkRequest
     *        A {@link Consumer} that will call methods on {@link ResetJobBookmarkRequest.Builder} to create a request.
     * @return Result of the ResetJobBookmark operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ResetJobBookmark
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetJobBookmarkResponse resetJobBookmark(Consumer<ResetJobBookmarkRequest.Builder> resetJobBookmarkRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return resetJobBookmark(ResetJobBookmarkRequest.builder().applyMutation(resetJobBookmarkRequest).build());
    }

    /**
     * <p>
     * Restarts selected nodes of a previous partially completed workflow run and resumes the workflow run. The selected
     * nodes and all nodes that are downstream from the selected nodes are run.
     * </p>
     *
     * @param resumeWorkflowRunRequest
     * @return Result of the ResumeWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws IllegalWorkflowStateException
     *         The workflow is in an invalid state to perform a requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ResumeWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResumeWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default ResumeWorkflowRunResponse resumeWorkflowRun(ResumeWorkflowRunRequest resumeWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ConcurrentRunsExceededException, IllegalWorkflowStateException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts selected nodes of a previous partially completed workflow run and resumes the workflow run. The selected
     * nodes and all nodes that are downstream from the selected nodes are run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeWorkflowRunRequest.Builder} avoiding the need
     * to create one manually via {@link ResumeWorkflowRunRequest#builder()}
     * </p>
     *
     * @param resumeWorkflowRunRequest
     *        A {@link Consumer} that will call methods on {@link ResumeWorkflowRunRequest.Builder} to create a request.
     * @return Result of the ResumeWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws IllegalWorkflowStateException
     *         The workflow is in an invalid state to perform a requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ResumeWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResumeWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default ResumeWorkflowRunResponse resumeWorkflowRun(Consumer<ResumeWorkflowRunRequest.Builder> resumeWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ConcurrentRunsExceededException, IllegalWorkflowStateException, AwsServiceException, SdkClientException,
            GlueException {
        return resumeWorkflowRun(ResumeWorkflowRunRequest.builder().applyMutation(resumeWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Searches a set of tables based on properties in the table metadata as well as on the parent database. You can
     * search against text or filter conditions.
     * </p>
     * <p>
     * You can only get tables that you have access to based on the security policies defined in Lake Formation. You
     * need at least a read-only access to the table for it to be returned. If you do not have access to all the columns
     * in the table, these columns will not be searched against when returning the list of tables back to you. If you
     * have access to the columns but not the data in the columns, those columns and the associated metadata for those
     * columns will be included in the search.
     * </p>
     *
     * @param searchTablesRequest
     * @return Result of the SearchTables operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.SearchTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTablesResponse searchTables(SearchTablesRequest searchTablesRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches a set of tables based on properties in the table metadata as well as on the parent database. You can
     * search against text or filter conditions.
     * </p>
     * <p>
     * You can only get tables that you have access to based on the security policies defined in Lake Formation. You
     * need at least a read-only access to the table for it to be returned. If you do not have access to all the columns
     * in the table, these columns will not be searched against when returning the list of tables back to you. If you
     * have access to the columns but not the data in the columns, those columns and the associated metadata for those
     * columns will be included in the search.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTablesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTablesRequest#builder()}
     * </p>
     *
     * @param searchTablesRequest
     *        A {@link Consumer} that will call methods on {@link SearchTablesRequest.Builder} to create a request.
     * @return Result of the SearchTables operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.SearchTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTablesResponse searchTables(Consumer<SearchTablesRequest.Builder> searchTablesRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return searchTables(SearchTablesRequest.builder().applyMutation(searchTablesRequest).build());
    }

    /**
     * <p>
     * Searches a set of tables based on properties in the table metadata as well as on the parent database. You can
     * search against text or filter conditions.
     * </p>
     * <p>
     * You can only get tables that you have access to based on the security policies defined in Lake Formation. You
     * need at least a read-only access to the table for it to be returned. If you do not have access to all the columns
     * in the table, these columns will not be searched against when returning the list of tables back to you. If you
     * have access to the columns but not the data in the columns, those columns and the associated metadata for those
     * columns will be included in the search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchTables(software.amazon.awssdk.services.glue.model.SearchTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.SearchTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTables(software.amazon.awssdk.services.glue.model.SearchTablesRequest)} operation.</b>
     * </p>
     *
     * @param searchTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.SearchTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTablesIterable searchTablesPaginator(SearchTablesRequest searchTablesRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches a set of tables based on properties in the table metadata as well as on the parent database. You can
     * search against text or filter conditions.
     * </p>
     * <p>
     * You can only get tables that you have access to based on the security policies defined in Lake Formation. You
     * need at least a read-only access to the table for it to be returned. If you do not have access to all the columns
     * in the table, these columns will not be searched against when returning the list of tables back to you. If you
     * have access to the columns but not the data in the columns, those columns and the associated metadata for those
     * columns will be included in the search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchTables(software.amazon.awssdk.services.glue.model.SearchTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.SearchTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTables(software.amazon.awssdk.services.glue.model.SearchTablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTablesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchTablesRequest#builder()}
     * </p>
     *
     * @param searchTablesRequest
     *        A {@link Consumer} that will call methods on {@link SearchTablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.SearchTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchTablesIterable searchTablesPaginator(Consumer<SearchTablesRequest.Builder> searchTablesRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return searchTablesPaginator(SearchTablesRequest.builder().applyMutation(searchTablesRequest).build());
    }

    /**
     * <p>
     * Starts a crawl using the specified crawler, regardless of what is scheduled. If the crawler is already running,
     * returns a <a href=
     * "https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException"
     * >CrawlerRunningException</a>.
     * </p>
     *
     * @param startCrawlerRequest
     * @return Result of the StartCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCrawlerResponse startCrawler(StartCrawlerRequest startCrawlerRequest) throws EntityNotFoundException,
            CrawlerRunningException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a crawl using the specified crawler, regardless of what is scheduled. If the crawler is already running,
     * returns a <a href=
     * "https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException"
     * >CrawlerRunningException</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link StartCrawlerRequest#builder()}
     * </p>
     *
     * @param startCrawlerRequest
     *        A {@link Consumer} that will call methods on {@link StartCrawlerRequest.Builder} to create a request.
     * @return Result of the StartCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCrawlerResponse startCrawler(Consumer<StartCrawlerRequest.Builder> startCrawlerRequest)
            throws EntityNotFoundException, CrawlerRunningException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return startCrawler(StartCrawlerRequest.builder().applyMutation(startCrawlerRequest).build());
    }

    /**
     * <p>
     * Changes the schedule state of the specified crawler to <code>SCHEDULED</code>, unless the crawler is already
     * running or the schedule state is already <code>SCHEDULED</code>.
     * </p>
     *
     * @param startCrawlerScheduleRequest
     * @return Result of the StartCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SchedulerRunningException
     *         The specified scheduler is already running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws NoScheduleException
     *         There is no applicable schedule.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCrawlerScheduleResponse startCrawlerSchedule(StartCrawlerScheduleRequest startCrawlerScheduleRequest)
            throws EntityNotFoundException, SchedulerRunningException, SchedulerTransitioningException, NoScheduleException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the schedule state of the specified crawler to <code>SCHEDULED</code>, unless the crawler is already
     * running or the schedule state is already <code>SCHEDULED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCrawlerScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link StartCrawlerScheduleRequest#builder()}
     * </p>
     *
     * @param startCrawlerScheduleRequest
     *        A {@link Consumer} that will call methods on {@link StartCrawlerScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the StartCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SchedulerRunningException
     *         The specified scheduler is already running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws NoScheduleException
     *         There is no applicable schedule.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCrawlerScheduleResponse startCrawlerSchedule(
            Consumer<StartCrawlerScheduleRequest.Builder> startCrawlerScheduleRequest) throws EntityNotFoundException,
            SchedulerRunningException, SchedulerTransitioningException, NoScheduleException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return startCrawlerSchedule(StartCrawlerScheduleRequest.builder().applyMutation(startCrawlerScheduleRequest).build());
    }

    /**
     * <p>
     * Begins an asynchronous task to export all labeled data for a particular transform. This task is the only
     * label-related API call that is not part of the typical active learning workflow. You typically use
     * <code>StartExportLabelsTaskRun</code> when you want to work with all of your existing labels at the same time,
     * such as when you want to remove or change labels that were previously submitted as truth. This API operation
     * accepts the <code>TransformId</code> whose labels you want to export and an Amazon Simple Storage Service (Amazon
     * S3) path to export the labels to. The operation returns a <code>TaskRunId</code>. You can check on the status of
     * your task run by calling the <code>GetMLTaskRun</code> API.
     * </p>
     *
     * @param startExportLabelsTaskRunRequest
     * @return Result of the StartExportLabelsTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartExportLabelsTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartExportLabelsTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartExportLabelsTaskRunResponse startExportLabelsTaskRun(
            StartExportLabelsTaskRunRequest startExportLabelsTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins an asynchronous task to export all labeled data for a particular transform. This task is the only
     * label-related API call that is not part of the typical active learning workflow. You typically use
     * <code>StartExportLabelsTaskRun</code> when you want to work with all of your existing labels at the same time,
     * such as when you want to remove or change labels that were previously submitted as truth. This API operation
     * accepts the <code>TransformId</code> whose labels you want to export and an Amazon Simple Storage Service (Amazon
     * S3) path to export the labels to. The operation returns a <code>TaskRunId</code>. You can check on the status of
     * your task run by calling the <code>GetMLTaskRun</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExportLabelsTaskRunRequest.Builder} avoiding
     * the need to create one manually via {@link StartExportLabelsTaskRunRequest#builder()}
     * </p>
     *
     * @param startExportLabelsTaskRunRequest
     *        A {@link Consumer} that will call methods on {@link StartExportLabelsTaskRunRequest.Builder} to create a
     *        request.
     * @return Result of the StartExportLabelsTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartExportLabelsTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartExportLabelsTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartExportLabelsTaskRunResponse startExportLabelsTaskRun(
            Consumer<StartExportLabelsTaskRunRequest.Builder> startExportLabelsTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        return startExportLabelsTaskRun(StartExportLabelsTaskRunRequest.builder().applyMutation(startExportLabelsTaskRunRequest)
                .build());
    }

    /**
     * <p>
     * Enables you to provide additional labels (examples of truth) to be used to teach the machine learning transform
     * and improve its quality. This API operation is generally used as part of the active learning workflow that starts
     * with the <code>StartMLLabelingSetGenerationTaskRun</code> call and that ultimately results in improving the
     * quality of your machine learning transform.
     * </p>
     * <p>
     * After the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue machine learning will have
     * generated a series of questions for humans to answer. (Answering these questions is often called 'labeling' in
     * the machine learning workflows). In the case of the <code>FindMatches</code> transform, these questions are of
     * the form, “What is the correct way to group these rows together into groups composed entirely of matching
     * records?” After the labeling process is finished, users upload their answers/labels with a call to
     * <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of
     * the machine learning transform use the new and improved labels and perform a higher-quality transformation.
     * </p>
     * <p>
     * By default, <code>StartMLLabelingSetGenerationTaskRun</code> continually learns from and combines all labels that
     * you upload unless you set <code>Replace</code> to true. If you set <code>Replace</code> to true,
     * <code>StartImportLabelsTaskRun</code> deletes and forgets all previously uploaded labels and learns only from the
     * exact set that you upload. Replacing labels can be helpful if you realize that you previously uploaded incorrect
     * labels, and you believe that they are having a negative effect on your transform quality.
     * </p>
     * <p>
     * You can check on the status of your task run by calling the <code>GetMLTaskRun</code> operation.
     * </p>
     *
     * @param startImportLabelsTaskRunRequest
     * @return Result of the StartImportLabelsTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartImportLabelsTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartImportLabelsTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImportLabelsTaskRunResponse startImportLabelsTaskRun(
            StartImportLabelsTaskRunRequest startImportLabelsTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, ResourceNumberLimitExceededException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to provide additional labels (examples of truth) to be used to teach the machine learning transform
     * and improve its quality. This API operation is generally used as part of the active learning workflow that starts
     * with the <code>StartMLLabelingSetGenerationTaskRun</code> call and that ultimately results in improving the
     * quality of your machine learning transform.
     * </p>
     * <p>
     * After the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue machine learning will have
     * generated a series of questions for humans to answer. (Answering these questions is often called 'labeling' in
     * the machine learning workflows). In the case of the <code>FindMatches</code> transform, these questions are of
     * the form, “What is the correct way to group these rows together into groups composed entirely of matching
     * records?” After the labeling process is finished, users upload their answers/labels with a call to
     * <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of
     * the machine learning transform use the new and improved labels and perform a higher-quality transformation.
     * </p>
     * <p>
     * By default, <code>StartMLLabelingSetGenerationTaskRun</code> continually learns from and combines all labels that
     * you upload unless you set <code>Replace</code> to true. If you set <code>Replace</code> to true,
     * <code>StartImportLabelsTaskRun</code> deletes and forgets all previously uploaded labels and learns only from the
     * exact set that you upload. Replacing labels can be helpful if you realize that you previously uploaded incorrect
     * labels, and you believe that they are having a negative effect on your transform quality.
     * </p>
     * <p>
     * You can check on the status of your task run by calling the <code>GetMLTaskRun</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportLabelsTaskRunRequest.Builder} avoiding
     * the need to create one manually via {@link StartImportLabelsTaskRunRequest#builder()}
     * </p>
     *
     * @param startImportLabelsTaskRunRequest
     *        A {@link Consumer} that will call methods on {@link StartImportLabelsTaskRunRequest.Builder} to create a
     *        request.
     * @return Result of the StartImportLabelsTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartImportLabelsTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartImportLabelsTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImportLabelsTaskRunResponse startImportLabelsTaskRun(
            Consumer<StartImportLabelsTaskRunRequest.Builder> startImportLabelsTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, ResourceNumberLimitExceededException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return startImportLabelsTaskRun(StartImportLabelsTaskRunRequest.builder().applyMutation(startImportLabelsTaskRunRequest)
                .build());
    }

    /**
     * <p>
     * Starts a job run using a job definition.
     * </p>
     *
     * @param startJobRunRequest
     * @return Result of the StartJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobRunResponse startJobRun(StartJobRunRequest startJobRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job run using a job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartJobRunRequest#builder()}
     * </p>
     *
     * @param startJobRunRequest
     *        A {@link Consumer} that will call methods on {@link StartJobRunRequest.Builder} to create a request.
     * @return Result of the StartJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StartJobRunResponse startJobRun(Consumer<StartJobRunRequest.Builder> startJobRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentRunsExceededException, AwsServiceException, SdkClientException,
            GlueException {
        return startJobRun(StartJobRunRequest.builder().applyMutation(startJobRunRequest).build());
    }

    /**
     * <p>
     * Starts a task to estimate the quality of the transform.
     * </p>
     * <p>
     * When you provide label sets as examples of truth, AWS Glue machine learning uses some of those examples to learn
     * from them. The rest of the labels are used as a test to estimate quality.
     * </p>
     * <p>
     * Returns a unique identifier for the run. You can call <code>GetMLTaskRun</code> to get more information about the
     * stats of the <code>EvaluationTaskRun</code>.
     * </p>
     *
     * @param startMlEvaluationTaskRunRequest
     * @return Result of the StartMLEvaluationTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws MlTransformNotReadyException
     *         The machine learning transform is not ready to run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartMLEvaluationTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLEvaluationTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMlEvaluationTaskRunResponse startMLEvaluationTaskRun(
            StartMlEvaluationTaskRunRequest startMlEvaluationTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, ConcurrentRunsExceededException,
            MlTransformNotReadyException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a task to estimate the quality of the transform.
     * </p>
     * <p>
     * When you provide label sets as examples of truth, AWS Glue machine learning uses some of those examples to learn
     * from them. The rest of the labels are used as a test to estimate quality.
     * </p>
     * <p>
     * Returns a unique identifier for the run. You can call <code>GetMLTaskRun</code> to get more information about the
     * stats of the <code>EvaluationTaskRun</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlEvaluationTaskRunRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlEvaluationTaskRunRequest#builder()}
     * </p>
     *
     * @param startMlEvaluationTaskRunRequest
     *        A {@link Consumer} that will call methods on {@link StartMLEvaluationTaskRunRequest.Builder} to create a
     *        request.
     * @return Result of the StartMLEvaluationTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws MlTransformNotReadyException
     *         The machine learning transform is not ready to run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartMLEvaluationTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLEvaluationTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMlEvaluationTaskRunResponse startMLEvaluationTaskRun(
            Consumer<StartMlEvaluationTaskRunRequest.Builder> startMlEvaluationTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, ConcurrentRunsExceededException,
            MlTransformNotReadyException, AwsServiceException, SdkClientException, GlueException {
        return startMLEvaluationTaskRun(StartMlEvaluationTaskRunRequest.builder().applyMutation(startMlEvaluationTaskRunRequest)
                .build());
    }

    /**
     * <p>
     * Starts the active learning workflow for your machine learning transform to improve the transform's quality by
     * generating label sets and adding labels.
     * </p>
     * <p>
     * When the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue will have generated a "labeling set"
     * or a set of questions for humans to answer.
     * </p>
     * <p>
     * In the case of the <code>FindMatches</code> transform, these questions are of the form, “What is the correct way
     * to group these rows together into groups composed entirely of matching records?”
     * </p>
     * <p>
     * After the labeling process is finished, you can upload your labels with a call to
     * <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of
     * the machine learning transform will use the new and improved labels and perform a higher-quality transformation.
     * </p>
     *
     * @param startMlLabelingSetGenerationTaskRunRequest
     * @return Result of the StartMLLabelingSetGenerationTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartMLLabelingSetGenerationTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLLabelingSetGenerationTaskRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlLabelingSetGenerationTaskRunResponse startMLLabelingSetGenerationTaskRun(
            StartMlLabelingSetGenerationTaskRunRequest startMlLabelingSetGenerationTaskRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the active learning workflow for your machine learning transform to improve the transform's quality by
     * generating label sets and adding labels.
     * </p>
     * <p>
     * When the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue will have generated a "labeling set"
     * or a set of questions for humans to answer.
     * </p>
     * <p>
     * In the case of the <code>FindMatches</code> transform, these questions are of the form, “What is the correct way
     * to group these rows together into groups composed entirely of matching records?”
     * </p>
     * <p>
     * After the labeling process is finished, you can upload your labels with a call to
     * <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of
     * the machine learning transform will use the new and improved labels and perform a higher-quality transformation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlLabelingSetGenerationTaskRunRequest.Builder}
     * avoiding the need to create one manually via {@link StartMlLabelingSetGenerationTaskRunRequest#builder()}
     * </p>
     *
     * @param startMlLabelingSetGenerationTaskRunRequest
     *        A {@link Consumer} that will call methods on {@link StartMLLabelingSetGenerationTaskRunRequest.Builder} to
     *        create a request.
     * @return Result of the StartMLLabelingSetGenerationTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartMLLabelingSetGenerationTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLLabelingSetGenerationTaskRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlLabelingSetGenerationTaskRunResponse startMLLabelingSetGenerationTaskRun(
            Consumer<StartMlLabelingSetGenerationTaskRunRequest.Builder> startMlLabelingSetGenerationTaskRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        return startMLLabelingSetGenerationTaskRun(StartMlLabelingSetGenerationTaskRunRequest.builder()
                .applyMutation(startMlLabelingSetGenerationTaskRunRequest).build());
    }

    /**
     * <p>
     * Starts an existing trigger. See <a href="https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html">Triggering
     * Jobs</a> for information about how different types of trigger are started.
     * </p>
     *
     * @param startTriggerRequest
     * @return Result of the StartTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTriggerResponse startTrigger(StartTriggerRequest startTriggerRequest) throws InvalidInputException,
            InternalServiceException, EntityNotFoundException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an existing trigger. See <a href="https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html">Triggering
     * Jobs</a> for information about how different types of trigger are started.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link StartTriggerRequest#builder()}
     * </p>
     *
     * @param startTriggerRequest
     *        A {@link Consumer} that will call methods on {@link StartTriggerRequest.Builder} to create a request.
     * @return Result of the StartTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTriggerResponse startTrigger(Consumer<StartTriggerRequest.Builder> startTriggerRequest)
            throws InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentRunsExceededException, AwsServiceException, SdkClientException,
            GlueException {
        return startTrigger(StartTriggerRequest.builder().applyMutation(startTriggerRequest).build());
    }

    /**
     * <p>
     * Starts a new run of the specified workflow.
     * </p>
     *
     * @param startWorkflowRunRequest
     * @return Result of the StartWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StartWorkflowRunResponse startWorkflowRun(StartWorkflowRunRequest startWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentRunsExceededException, AwsServiceException, SdkClientException,
            GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new run of the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartWorkflowRunRequest.Builder} avoiding the need
     * to create one manually via {@link StartWorkflowRunRequest#builder()}
     * </p>
     *
     * @param startWorkflowRunRequest
     *        A {@link Consumer} that will call methods on {@link StartWorkflowRunRequest.Builder} to create a request.
     * @return Result of the StartWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StartWorkflowRunResponse startWorkflowRun(Consumer<StartWorkflowRunRequest.Builder> startWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentRunsExceededException, AwsServiceException, SdkClientException,
            GlueException {
        return startWorkflowRun(StartWorkflowRunRequest.builder().applyMutation(startWorkflowRunRequest).build());
    }

    /**
     * <p>
     * If the specified crawler is running, stops the crawl.
     * </p>
     *
     * @param stopCrawlerRequest
     * @return Result of the StopCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerNotRunningException
     *         The specified crawler is not running.
     * @throws CrawlerStoppingException
     *         The specified crawler is stopping.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default StopCrawlerResponse stopCrawler(StopCrawlerRequest stopCrawlerRequest) throws EntityNotFoundException,
            CrawlerNotRunningException, CrawlerStoppingException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If the specified crawler is running, stops the crawl.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link StopCrawlerRequest#builder()}
     * </p>
     *
     * @param stopCrawlerRequest
     *        A {@link Consumer} that will call methods on {@link StopCrawlerRequest.Builder} to create a request.
     * @return Result of the StopCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerNotRunningException
     *         The specified crawler is not running.
     * @throws CrawlerStoppingException
     *         The specified crawler is stopping.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default StopCrawlerResponse stopCrawler(Consumer<StopCrawlerRequest.Builder> stopCrawlerRequest)
            throws EntityNotFoundException, CrawlerNotRunningException, CrawlerStoppingException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return stopCrawler(StopCrawlerRequest.builder().applyMutation(stopCrawlerRequest).build());
    }

    /**
     * <p>
     * Sets the schedule state of the specified crawler to <code>NOT_SCHEDULED</code>, but does not stop the crawler if
     * it is already running.
     * </p>
     *
     * @param stopCrawlerScheduleRequest
     * @return Result of the StopCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SchedulerNotRunningException
     *         The specified scheduler is not running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default StopCrawlerScheduleResponse stopCrawlerSchedule(StopCrawlerScheduleRequest stopCrawlerScheduleRequest)
            throws EntityNotFoundException, SchedulerNotRunningException, SchedulerTransitioningException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the schedule state of the specified crawler to <code>NOT_SCHEDULED</code>, but does not stop the crawler if
     * it is already running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCrawlerScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link StopCrawlerScheduleRequest#builder()}
     * </p>
     *
     * @param stopCrawlerScheduleRequest
     *        A {@link Consumer} that will call methods on {@link StopCrawlerScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the StopCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SchedulerNotRunningException
     *         The specified scheduler is not running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default StopCrawlerScheduleResponse stopCrawlerSchedule(
            Consumer<StopCrawlerScheduleRequest.Builder> stopCrawlerScheduleRequest) throws EntityNotFoundException,
            SchedulerNotRunningException, SchedulerTransitioningException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return stopCrawlerSchedule(StopCrawlerScheduleRequest.builder().applyMutation(stopCrawlerScheduleRequest).build());
    }

    /**
     * <p>
     * Stops a specified trigger.
     * </p>
     *
     * @param stopTriggerRequest
     * @return Result of the StopTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default StopTriggerResponse stopTrigger(StopTriggerRequest stopTriggerRequest) throws InvalidInputException,
            InternalServiceException, EntityNotFoundException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specified trigger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link StopTriggerRequest#builder()}
     * </p>
     *
     * @param stopTriggerRequest
     *        A {@link Consumer} that will call methods on {@link StopTriggerRequest.Builder} to create a request.
     * @return Result of the StopTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default StopTriggerResponse stopTrigger(Consumer<StopTriggerRequest.Builder> stopTriggerRequest)
            throws InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        return stopTrigger(StopTriggerRequest.builder().applyMutation(stopTriggerRequest).build());
    }

    /**
     * <p>
     * Stops the execution of the specified workflow run.
     * </p>
     *
     * @param stopWorkflowRunRequest
     * @return Result of the StopWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws IllegalWorkflowStateException
     *         The workflow is in an invalid state to perform a requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StopWorkflowRunResponse stopWorkflowRun(StopWorkflowRunRequest stopWorkflowRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, IllegalWorkflowStateException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the execution of the specified workflow run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopWorkflowRunRequest.Builder} avoiding the need
     * to create one manually via {@link StopWorkflowRunRequest#builder()}
     * </p>
     *
     * @param stopWorkflowRunRequest
     *        A {@link Consumer} that will call methods on {@link StopWorkflowRunRequest.Builder} to create a request.
     * @return Result of the StopWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws IllegalWorkflowStateException
     *         The workflow is in an invalid state to perform a requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default StopWorkflowRunResponse stopWorkflowRun(Consumer<StopWorkflowRunRequest.Builder> stopWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            IllegalWorkflowStateException, AwsServiceException, SdkClientException, GlueException {
        return stopWorkflowRun(StopWorkflowRunRequest.builder().applyMutation(stopWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource. A tag is a label you can assign to an AWS resource. In AWS Glue, you can tag only
     * certain resources. For information about what resources you can tag, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource. A tag is a label you can assign to an AWS resource. In AWS Glue, you can tag only
     * certain resources. For information about what resources you can tag, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, GlueException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, GlueException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Modifies an existing classifier (a <code>GrokClassifier</code>, an <code>XMLClassifier</code>, a
     * <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which field is present).
     * </p>
     *
     * @param updateClassifierRequest
     * @return Result of the UpdateClassifier operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClassifierResponse updateClassifier(UpdateClassifierRequest updateClassifierRequest)
            throws InvalidInputException, VersionMismatchException, EntityNotFoundException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing classifier (a <code>GrokClassifier</code>, an <code>XMLClassifier</code>, a
     * <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which field is present).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClassifierRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateClassifierRequest#builder()}
     * </p>
     *
     * @param updateClassifierRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClassifierRequest.Builder} to create a request.
     * @return Result of the UpdateClassifier operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClassifierResponse updateClassifier(Consumer<UpdateClassifierRequest.Builder> updateClassifierRequest)
            throws InvalidInputException, VersionMismatchException, EntityNotFoundException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return updateClassifier(UpdateClassifierRequest.builder().applyMutation(updateClassifierRequest).build());
    }

    /**
     * <p>
     * Creates or updates partition statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>UpdatePartition</code>.
     * </p>
     *
     * @param updateColumnStatisticsForPartitionRequest
     * @return Result of the UpdateColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateColumnStatisticsForPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateColumnStatisticsForPartitionResponse updateColumnStatisticsForPartition(
            UpdateColumnStatisticsForPartitionRequest updateColumnStatisticsForPartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates partition statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>UpdatePartition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateColumnStatisticsForPartitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateColumnStatisticsForPartitionRequest#builder()}
     * </p>
     *
     * @param updateColumnStatisticsForPartitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateColumnStatisticsForPartitionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateColumnStatisticsForPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateColumnStatisticsForPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateColumnStatisticsForPartitionResponse updateColumnStatisticsForPartition(
            Consumer<UpdateColumnStatisticsForPartitionRequest.Builder> updateColumnStatisticsForPartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return updateColumnStatisticsForPartition(UpdateColumnStatisticsForPartitionRequest.builder()
                .applyMutation(updateColumnStatisticsForPartitionRequest).build());
    }

    /**
     * <p>
     * Creates or updates table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>UpdateTable</code>.
     * </p>
     *
     * @param updateColumnStatisticsForTableRequest
     * @return Result of the UpdateColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateColumnStatisticsForTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateColumnStatisticsForTableResponse updateColumnStatisticsForTable(
            UpdateColumnStatisticsForTableRequest updateColumnStatisticsForTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>UpdateTable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateColumnStatisticsForTableRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateColumnStatisticsForTableRequest#builder()}
     * </p>
     *
     * @param updateColumnStatisticsForTableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateColumnStatisticsForTableRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateColumnStatisticsForTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateColumnStatisticsForTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateColumnStatisticsForTableResponse updateColumnStatisticsForTable(
            Consumer<UpdateColumnStatisticsForTableRequest.Builder> updateColumnStatisticsForTableRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return updateColumnStatisticsForTable(UpdateColumnStatisticsForTableRequest.builder()
                .applyMutation(updateColumnStatisticsForTableRequest).build());
    }

    /**
     * <p>
     * Updates a connection definition in the Data Catalog.
     * </p>
     *
     * @param updateConnectionRequest
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a connection definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectionRequest#builder()}
     * </p>
     *
     * @param updateConnectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectionRequest.Builder} to create a request.
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConnectionResponse updateConnection(Consumer<UpdateConnectionRequest.Builder> updateConnectionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return updateConnection(UpdateConnectionRequest.builder().applyMutation(updateConnectionRequest).build());
    }

    /**
     * <p>
     * Updates a crawler. If a crawler is running, you must stop it using <code>StopCrawler</code> before updating it.
     * </p>
     *
     * @param updateCrawlerRequest
     * @return Result of the UpdateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCrawlerResponse updateCrawler(UpdateCrawlerRequest updateCrawlerRequest) throws InvalidInputException,
            VersionMismatchException, EntityNotFoundException, CrawlerRunningException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a crawler. If a crawler is running, you must stop it using <code>StopCrawler</code> before updating it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCrawlerRequest#builder()}
     * </p>
     *
     * @param updateCrawlerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCrawlerRequest.Builder} to create a request.
     * @return Result of the UpdateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCrawlerResponse updateCrawler(Consumer<UpdateCrawlerRequest.Builder> updateCrawlerRequest)
            throws InvalidInputException, VersionMismatchException, EntityNotFoundException, CrawlerRunningException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return updateCrawler(UpdateCrawlerRequest.builder().applyMutation(updateCrawlerRequest).build());
    }

    /**
     * <p>
     * Updates the schedule of a crawler using a <code>cron</code> expression.
     * </p>
     *
     * @param updateCrawlerScheduleRequest
     * @return Result of the UpdateCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCrawlerScheduleResponse updateCrawlerSchedule(UpdateCrawlerScheduleRequest updateCrawlerScheduleRequest)
            throws EntityNotFoundException, InvalidInputException, VersionMismatchException, SchedulerTransitioningException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schedule of a crawler using a <code>cron</code> expression.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCrawlerScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCrawlerScheduleRequest#builder()}
     * </p>
     *
     * @param updateCrawlerScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCrawlerScheduleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCrawlerScheduleResponse updateCrawlerSchedule(
            Consumer<UpdateCrawlerScheduleRequest.Builder> updateCrawlerScheduleRequest) throws EntityNotFoundException,
            InvalidInputException, VersionMismatchException, SchedulerTransitioningException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return updateCrawlerSchedule(UpdateCrawlerScheduleRequest.builder().applyMutation(updateCrawlerScheduleRequest).build());
    }

    /**
     * <p>
     * Updates an existing database definition in a Data Catalog.
     * </p>
     *
     * @param updateDatabaseRequest
     * @return Result of the UpdateDatabase operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing database definition in a Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDatabaseRequest#builder()}
     * </p>
     *
     * @param updateDatabaseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatabaseRequest.Builder} to create a request.
     * @return Result of the UpdateDatabase operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDatabaseResponse updateDatabase(Consumer<UpdateDatabaseRequest.Builder> updateDatabaseRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return updateDatabase(UpdateDatabaseRequest.builder().applyMutation(updateDatabaseRequest).build());
    }

    /**
     * <p>
     * Updates a specified development endpoint.
     * </p>
     *
     * @param updateDevEndpointRequest
     * @return Result of the UpdateDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDevEndpointResponse updateDevEndpoint(UpdateDevEndpointRequest updateDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ValidationException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified development endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDevEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDevEndpointRequest#builder()}
     * </p>
     *
     * @param updateDevEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDevEndpointRequest.Builder} to create a request.
     * @return Result of the UpdateDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDevEndpointResponse updateDevEndpoint(Consumer<UpdateDevEndpointRequest.Builder> updateDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ValidationException, AwsServiceException, SdkClientException, GlueException {
        return updateDevEndpoint(UpdateDevEndpointRequest.builder().applyMutation(updateDevEndpointRequest).build());
    }

    /**
     * <p>
     * Updates an existing job definition.
     * </p>
     *
     * @param updateJobRequest
     * @return Result of the UpdateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJobRequest#builder()}
     * </p>
     *
     * @param updateJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateJobRequest.Builder} to create a request.
     * @return Result of the UpdateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateJobResponse updateJob(Consumer<UpdateJobRequest.Builder> updateJobRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        return updateJob(UpdateJobRequest.builder().applyMutation(updateJobRequest).build());
    }

    /**
     * <p>
     * Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve
     * better results.
     * </p>
     * <p>
     * After calling this operation, you can call the <code>StartMLEvaluationTaskRun</code> operation to assess how well
     * your new parameters achieved your goals (such as improving the quality of your machine learning transform, or
     * making it more cost-effective).
     * </p>
     *
     * @param updateMlTransformRequest
     * @return Result of the UpdateMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMlTransformResponse updateMLTransform(UpdateMlTransformRequest updateMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve
     * better results.
     * </p>
     * <p>
     * After calling this operation, you can call the <code>StartMLEvaluationTaskRun</code> operation to assess how well
     * your new parameters achieved your goals (such as improving the quality of your machine learning transform, or
     * making it more cost-effective).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMlTransformRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMlTransformRequest#builder()}
     * </p>
     *
     * @param updateMlTransformRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMLTransformRequest.Builder} to create a request.
     * @return Result of the UpdateMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMlTransformResponse updateMLTransform(Consumer<UpdateMlTransformRequest.Builder> updateMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, GlueException {
        return updateMLTransform(UpdateMlTransformRequest.builder().applyMutation(updateMlTransformRequest).build());
    }

    /**
     * <p>
     * Updates a partition.
     * </p>
     *
     * @param updatePartitionRequest
     * @return Result of the UpdatePartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePartitionResponse updatePartition(UpdatePartitionRequest updatePartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartitionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePartitionRequest#builder()}
     * </p>
     *
     * @param updatePartitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePartitionRequest.Builder} to create a request.
     * @return Result of the UpdatePartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePartitionResponse updatePartition(Consumer<UpdatePartitionRequest.Builder> updatePartitionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return updatePartition(UpdatePartitionRequest.builder().applyMutation(updatePartitionRequest).build());
    }

    /**
     * <p>
     * Updates an existing registry which is used to hold a collection of schemas. The updated properties relate to the
     * registry, and do not modify any of the schemas within the registry.
     * </p>
     *
     * @param updateRegistryRequest
     * @return Result of the UpdateRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRegistryResponse updateRegistry(UpdateRegistryRequest updateRegistryRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, ConcurrentModificationException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing registry which is used to hold a collection of schemas. The updated properties relate to the
     * registry, and do not modify any of the schemas within the registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRegistryRequest#builder()}
     * </p>
     *
     * @param updateRegistryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRegistryInput.Builder} to create a request.
     * @return Result of the UpdateRegistry operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateRegistry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRegistryResponse updateRegistry(Consumer<UpdateRegistryRequest.Builder> updateRegistryRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, ConcurrentModificationException,
            InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        return updateRegistry(UpdateRegistryRequest.builder().applyMutation(updateRegistryRequest).build());
    }

    /**
     * <p>
     * Updates the description, compatibility setting, or version checkpoint for a schema set.
     * </p>
     * <p>
     * For updating the compatibility setting, the call will not validate compatibility for the entire set of schema
     * versions with the new compatibility setting. If the value for <code>Compatibility</code> is provided, the
     * <code>VersionNumber</code> (a checkpoint) is also required. The API will validate the checkpoint version number
     * for consistency.
     * </p>
     * <p>
     * If the value for the <code>VersionNumber</code> (checkpoint) is provided, <code>Compatibility</code> is optional
     * and this can be used to set/reset a checkpoint for the schema.
     * </p>
     * <p>
     * This update will happen only if the schema is in the AVAILABLE state.
     * </p>
     *
     * @param updateSchemaRequest
     * @return Result of the UpdateSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSchemaResponse updateSchema(UpdateSchemaRequest updateSchemaRequest) throws InvalidInputException,
            AccessDeniedException, EntityNotFoundException, ConcurrentModificationException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description, compatibility setting, or version checkpoint for a schema set.
     * </p>
     * <p>
     * For updating the compatibility setting, the call will not validate compatibility for the entire set of schema
     * versions with the new compatibility setting. If the value for <code>Compatibility</code> is provided, the
     * <code>VersionNumber</code> (a checkpoint) is also required. The API will validate the checkpoint version number
     * for consistency.
     * </p>
     * <p>
     * If the value for the <code>VersionNumber</code> (checkpoint) is provided, <code>Compatibility</code> is optional
     * and this can be used to set/reset a checkpoint for the schema.
     * </p>
     * <p>
     * This update will happen only if the schema is in the AVAILABLE state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSchemaRequest#builder()}
     * </p>
     *
     * @param updateSchemaRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSchemaInput.Builder} to create a request.
     * @return Result of the UpdateSchema operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSchemaResponse updateSchema(Consumer<UpdateSchemaRequest.Builder> updateSchemaRequest)
            throws InvalidInputException, AccessDeniedException, EntityNotFoundException, ConcurrentModificationException,
            InternalServiceException, AwsServiceException, SdkClientException, GlueException {
        return updateSchema(UpdateSchemaRequest.builder().applyMutation(updateSchemaRequest).build());
    }

    /**
     * <p>
     * Updates a metadata table in the Data Catalog.
     * </p>
     *
     * @param updateTableRequest
     * @return Result of the UpdateTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a metadata table in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTableRequest#builder()}
     * </p>
     *
     * @param updateTableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTableRequest.Builder} to create a request.
     * @return Result of the UpdateTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTableResponse updateTable(Consumer<UpdateTableRequest.Builder> updateTableRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ConcurrentModificationException, ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        return updateTable(UpdateTableRequest.builder().applyMutation(updateTableRequest).build());
    }

    /**
     * <p>
     * Updates a trigger definition.
     * </p>
     *
     * @param updateTriggerRequest
     * @return Result of the UpdateTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTriggerResponse updateTrigger(UpdateTriggerRequest updateTriggerRequest) throws InvalidInputException,
            InternalServiceException, EntityNotFoundException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a trigger definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTriggerRequest#builder()}
     * </p>
     *
     * @param updateTriggerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTriggerRequest.Builder} to create a request.
     * @return Result of the UpdateTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTriggerResponse updateTrigger(Consumer<UpdateTriggerRequest.Builder> updateTriggerRequest)
            throws InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        return updateTrigger(UpdateTriggerRequest.builder().applyMutation(updateTriggerRequest).build());
    }

    /**
     * <p>
     * Updates an existing function definition in the Data Catalog.
     * </p>
     *
     * @param updateUserDefinedFunctionRequest
     * @return Result of the UpdateUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserDefinedFunctionResponse updateUserDefinedFunction(
            UpdateUserDefinedFunctionRequest updateUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing function definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserDefinedFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param updateUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateUserDefinedFunctionResponse updateUserDefinedFunction(
            Consumer<UpdateUserDefinedFunctionRequest.Builder> updateUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return updateUserDefinedFunction(UpdateUserDefinedFunctionRequest.builder()
                .applyMutation(updateUserDefinedFunctionRequest).build());
    }

    /**
     * <p>
     * Updates an existing workflow.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkflowResponse updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkflowRequest#builder()}
     * </p>
     *
     * @param updateWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorkflowRequest.Builder} to create a request.
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWorkflowResponse updateWorkflow(Consumer<UpdateWorkflowRequest.Builder> updateWorkflowRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        return updateWorkflow(UpdateWorkflowRequest.builder().applyMutation(updateWorkflowRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("glue");
    }
}
