/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunError;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunErrorListCopier;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunSuccessfulSubmission;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunSuccessfulSubmissionListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStopJobRunResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchStopJobRunResponse> {
    private static final SdkField<List<BatchStopJobRunSuccessfulSubmission>> SUCCESSFUL_SUBMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulSubmissions").getter(BatchStopJobRunResponse.getter(BatchStopJobRunResponse::successfulSubmissions)).setter(BatchStopJobRunResponse.setter(Builder::successfulSubmissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulSubmissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchStopJobRunSuccessfulSubmission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchStopJobRunError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchStopJobRunResponse.getter(BatchStopJobRunResponse::errors)).setter(BatchStopJobRunResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchStopJobRunError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SUBMISSIONS_FIELD, ERRORS_FIELD));
    private final List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions;
    private final List<BatchStopJobRunError> errors;

    private BatchStopJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSubmissions = builder.successfulSubmissions;
        this.errors = builder.errors;
    }

    public final boolean hasSuccessfulSubmissions() {
        return this.successfulSubmissions != null && !(this.successfulSubmissions instanceof SdkAutoConstructList);
    }

    public final List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions() {
        return this.successfulSubmissions;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchStopJobRunError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulSubmissions() ? this.successfulSubmissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunResponse)) {
            return false;
        }
        BatchStopJobRunResponse other = (BatchStopJobRunResponse)((Object)obj);
        return this.hasSuccessfulSubmissions() == other.hasSuccessfulSubmissions() && Objects.equals(this.successfulSubmissions(), other.successfulSubmissions()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStopJobRunResponse").add("SuccessfulSubmissions", this.hasSuccessfulSubmissions() ? this.successfulSubmissions() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulSubmissions": {
                return Optional.ofNullable(clazz.cast(this.successfulSubmissions()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopJobRunResponse, T> g) {
        return obj -> g.apply((BatchStopJobRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<BatchStopJobRunSuccessfulSubmission> successfulSubmissions = DefaultSdkAutoConstructList.getInstance();
        private List<BatchStopJobRunError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunResponse model) {
            super(model);
            this.successfulSubmissions(model.successfulSubmissions);
            this.errors(model.errors);
        }

        public final Collection<BatchStopJobRunSuccessfulSubmission.Builder> getSuccessfulSubmissions() {
            if (this.successfulSubmissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulSubmissions != null ? (Collection)this.successfulSubmissions.stream().map(BatchStopJobRunSuccessfulSubmission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission> successfulSubmissions) {
            this.successfulSubmissions = BatchStopJobRunSuccessfulSubmissionListCopier.copy(successfulSubmissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSubmissions(BatchStopJobRunSuccessfulSubmission ... successfulSubmissions) {
            this.successfulSubmissions(Arrays.asList(successfulSubmissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSubmissions(Consumer<BatchStopJobRunSuccessfulSubmission.Builder> ... successfulSubmissions) {
            this.successfulSubmissions(Stream.of(successfulSubmissions).map(c -> (BatchStopJobRunSuccessfulSubmission)((BatchStopJobRunSuccessfulSubmission.Builder)BatchStopJobRunSuccessfulSubmission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission.BuilderImpl> successfulSubmissions) {
            this.successfulSubmissions = BatchStopJobRunSuccessfulSubmissionListCopier.copyFromBuilder(successfulSubmissions);
        }

        public final Collection<BatchStopJobRunError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(BatchStopJobRunError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchStopJobRunError> errors) {
            this.errors = BatchStopJobRunErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchStopJobRunError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchStopJobRunError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchStopJobRunError)((BatchStopJobRunError.Builder)BatchStopJobRunError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchStopJobRunError.BuilderImpl> errors) {
            this.errors = BatchStopJobRunErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchStopJobRunResponse build() {
            return new BatchStopJobRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStopJobRunResponse> {
        public Builder successfulSubmissions(Collection<BatchStopJobRunSuccessfulSubmission> var1);

        public Builder successfulSubmissions(BatchStopJobRunSuccessfulSubmission ... var1);

        public Builder successfulSubmissions(Consumer<BatchStopJobRunSuccessfulSubmission.Builder> ... var1);

        public Builder errors(Collection<BatchStopJobRunError> var1);

        public Builder errors(BatchStopJobRunError ... var1);

        public Builder errors(Consumer<BatchStopJobRunError.Builder> ... var1);
    }
}

