/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XMLClassifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XMLClassifier> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(XMLClassifier.getter(XMLClassifier::name)).setter(XMLClassifier.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(XMLClassifier.getter(XMLClassifier::classification)).setter(XMLClassifier.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(XMLClassifier.getter(XMLClassifier::creationTime)).setter(XMLClassifier.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(XMLClassifier.getter(XMLClassifier::lastUpdated)).setter(XMLClassifier.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(XMLClassifier.getter(XMLClassifier::version)).setter(XMLClassifier.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> ROW_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RowTag").getter(XMLClassifier.getter(XMLClassifier::rowTag)).setter(XMLClassifier.setter(Builder::rowTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowTag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLASSIFICATION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, VERSION_FIELD, ROW_TAG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String classification;
    private final Instant creationTime;
    private final Instant lastUpdated;
    private final Long version;
    private final String rowTag;

    private XMLClassifier(BuilderImpl builder) {
        this.name = builder.name;
        this.classification = builder.classification;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.version = builder.version;
        this.rowTag = builder.rowTag;
    }

    public final String name() {
        return this.name;
    }

    public final String classification() {
        return this.classification;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Long version() {
        return this.version;
    }

    public final String rowTag() {
        return this.rowTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XMLClassifier)) {
            return false;
        }
        XMLClassifier other = (XMLClassifier)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.rowTag(), other.rowTag());
    }

    public final String toString() {
        return ToString.builder((String)"XMLClassifier").add("Name", (Object)this.name()).add("Classification", (Object)this.classification()).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).add("Version", (Object)this.version()).add("RowTag", (Object)this.rowTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "RowTag": {
                return Optional.ofNullable(clazz.cast(this.rowTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XMLClassifier, T> g) {
        return obj -> g.apply((XMLClassifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String classification;
        private Instant creationTime;
        private Instant lastUpdated;
        private Long version;
        private String rowTag;

        private BuilderImpl() {
        }

        private BuilderImpl(XMLClassifier model) {
            this.name(model.name);
            this.classification(model.classification);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
            this.version(model.version);
            this.rowTag(model.rowTag);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getRowTag() {
            return this.rowTag;
        }

        @Override
        public final Builder rowTag(String rowTag) {
            this.rowTag = rowTag;
            return this;
        }

        public final void setRowTag(String rowTag) {
            this.rowTag = rowTag;
        }

        public XMLClassifier build() {
            return new XMLClassifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XMLClassifier> {
        public Builder name(String var1);

        public Builder classification(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);

        public Builder version(Long var1);

        public Builder rowTag(String var1);
    }
}

