/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnError;
import software.amazon.awssdk.services.glue.model.ColumnErrorsCopier;
import software.amazon.awssdk.services.glue.model.ColumnStatistics;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetColumnStatisticsForPartitionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetColumnStatisticsForPartitionResponse> {
    private static final SdkField<List<ColumnStatistics>> COLUMN_STATISTICS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnStatisticsList").getter(GetColumnStatisticsForPartitionResponse.getter(GetColumnStatisticsForPartitionResponse::columnStatisticsList)).setter(GetColumnStatisticsForPartitionResponse.setter(Builder::columnStatisticsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(GetColumnStatisticsForPartitionResponse.getter(GetColumnStatisticsForPartitionResponse::errors)).setter(GetColumnStatisticsForPartitionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_STATISTICS_LIST_FIELD, ERRORS_FIELD));
    private final List<ColumnStatistics> columnStatisticsList;
    private final List<ColumnError> errors;

    private GetColumnStatisticsForPartitionResponse(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsList = builder.columnStatisticsList;
        this.errors = builder.errors;
    }

    public boolean hasColumnStatisticsList() {
        return this.columnStatisticsList != null && !(this.columnStatisticsList instanceof SdkAutoConstructList);
    }

    public List<ColumnStatistics> columnStatisticsList() {
        return this.columnStatisticsList;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<ColumnError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnStatisticsList() ? this.columnStatisticsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsForPartitionResponse)) {
            return false;
        }
        GetColumnStatisticsForPartitionResponse other = (GetColumnStatisticsForPartitionResponse)((Object)obj);
        return this.hasColumnStatisticsList() == other.hasColumnStatisticsList() && Objects.equals(this.columnStatisticsList(), other.columnStatisticsList()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"GetColumnStatisticsForPartitionResponse").add("ColumnStatisticsList", this.hasColumnStatisticsList() ? this.columnStatisticsList() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnStatisticsList": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsList()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsForPartitionResponse, T> g) {
        return obj -> g.apply((GetColumnStatisticsForPartitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<ColumnStatistics> columnStatisticsList = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsForPartitionResponse model) {
            super(model);
            this.columnStatisticsList(model.columnStatisticsList);
            this.errors(model.errors);
        }

        public final Collection<ColumnStatistics.Builder> getColumnStatisticsList() {
            if (this.columnStatisticsList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnStatisticsList != null ? (Collection)this.columnStatisticsList.stream().map(ColumnStatistics::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnStatisticsList(Collection<ColumnStatistics> columnStatisticsList) {
            this.columnStatisticsList = ColumnStatisticsListCopier.copy(columnStatisticsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsList(ColumnStatistics ... columnStatisticsList) {
            this.columnStatisticsList(Arrays.asList(columnStatisticsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsList(Consumer<ColumnStatistics.Builder> ... columnStatisticsList) {
            this.columnStatisticsList(Stream.of(columnStatisticsList).map(c -> (ColumnStatistics)((ColumnStatistics.Builder)ColumnStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnStatisticsList(Collection<ColumnStatistics.BuilderImpl> columnStatisticsList) {
            this.columnStatisticsList = ColumnStatisticsListCopier.copyFromBuilder(columnStatisticsList);
        }

        public final Collection<ColumnError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(ColumnError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<ColumnError> errors) {
            this.errors = ColumnErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ColumnError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ColumnError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ColumnError)((ColumnError.Builder)ColumnError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<ColumnError.BuilderImpl> errors) {
            this.errors = ColumnErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public GetColumnStatisticsForPartitionResponse build() {
            return new GetColumnStatisticsForPartitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetColumnStatisticsForPartitionResponse> {
        public Builder columnStatisticsList(Collection<ColumnStatistics> var1);

        public Builder columnStatisticsList(ColumnStatistics ... var1);

        public Builder columnStatisticsList(Consumer<ColumnStatistics.Builder> ... var1);

        public Builder errors(Collection<ColumnError> var1);

        public Builder errors(ColumnError ... var1);

        public Builder errors(Consumer<ColumnError.Builder> ... var1);
    }
}

