/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportLabelsTaskRunRequest extends GlueRequest implements
        ToCopyableBuilder<StartImportLabelsTaskRunRequest.Builder, StartImportLabelsTaskRunRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformId").getter(getter(StartImportLabelsTaskRunRequest::transformId))
            .setter(setter(Builder::transformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()).build();

    private static final SdkField<String> INPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputS3Path").getter(getter(StartImportLabelsTaskRunRequest::inputS3Path))
            .setter(setter(Builder::inputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputS3Path").build()).build();

    private static final SdkField<Boolean> REPLACE_ALL_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplaceAllLabels").getter(getter(StartImportLabelsTaskRunRequest::replaceAllLabels))
            .setter(setter(Builder::replaceAllLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceAllLabels").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD,
            INPUT_S3_PATH_FIELD, REPLACE_ALL_LABELS_FIELD));

    private final String transformId;

    private final String inputS3Path;

    private final Boolean replaceAllLabels;

    private StartImportLabelsTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.inputS3Path = builder.inputS3Path;
        this.replaceAllLabels = builder.replaceAllLabels;
    }

    /**
     * <p>
     * The unique identifier of the machine learning transform.
     * </p>
     * 
     * @return The unique identifier of the machine learning transform.
     */
    public String transformId() {
        return transformId;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) path from where you import the labels.
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) path from where you import the labels.
     */
    public String inputS3Path() {
        return inputS3Path;
    }

    /**
     * <p>
     * Indicates whether to overwrite your existing labels.
     * </p>
     * 
     * @return Indicates whether to overwrite your existing labels.
     */
    public Boolean replaceAllLabels() {
        return replaceAllLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformId());
        hashCode = 31 * hashCode + Objects.hashCode(inputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(replaceAllLabels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportLabelsTaskRunRequest)) {
            return false;
        }
        StartImportLabelsTaskRunRequest other = (StartImportLabelsTaskRunRequest) obj;
        return Objects.equals(transformId(), other.transformId()) && Objects.equals(inputS3Path(), other.inputS3Path())
                && Objects.equals(replaceAllLabels(), other.replaceAllLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartImportLabelsTaskRunRequest").add("TransformId", transformId())
                .add("InputS3Path", inputS3Path()).add("ReplaceAllLabels", replaceAllLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformId":
            return Optional.ofNullable(clazz.cast(transformId()));
        case "InputS3Path":
            return Optional.ofNullable(clazz.cast(inputS3Path()));
        case "ReplaceAllLabels":
            return Optional.ofNullable(clazz.cast(replaceAllLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportLabelsTaskRunRequest, T> g) {
        return obj -> g.apply((StartImportLabelsTaskRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImportLabelsTaskRunRequest> {
        /**
         * <p>
         * The unique identifier of the machine learning transform.
         * </p>
         * 
         * @param transformId
         *        The unique identifier of the machine learning transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformId(String transformId);

        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) path from where you import the labels.
         * </p>
         * 
         * @param inputS3Path
         *        The Amazon Simple Storage Service (Amazon S3) path from where you import the labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputS3Path(String inputS3Path);

        /**
         * <p>
         * Indicates whether to overwrite your existing labels.
         * </p>
         * 
         * @param replaceAllLabels
         *        Indicates whether to overwrite your existing labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceAllLabels(Boolean replaceAllLabels);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String transformId;

        private String inputS3Path;

        private Boolean replaceAllLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportLabelsTaskRunRequest model) {
            super(model);
            transformId(model.transformId);
            inputS3Path(model.inputS3Path);
            replaceAllLabels(model.replaceAllLabels);
        }

        public final String getTransformId() {
            return transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getInputS3Path() {
            return inputS3Path;
        }

        @Override
        public final Builder inputS3Path(String inputS3Path) {
            this.inputS3Path = inputS3Path;
            return this;
        }

        public final void setInputS3Path(String inputS3Path) {
            this.inputS3Path = inputS3Path;
        }

        public final Boolean getReplaceAllLabels() {
            return replaceAllLabels;
        }

        @Override
        public final Builder replaceAllLabels(Boolean replaceAllLabels) {
            this.replaceAllLabels = replaceAllLabels;
            return this;
        }

        public final void setReplaceAllLabels(Boolean replaceAllLabels) {
            this.replaceAllLabels = replaceAllLabels;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportLabelsTaskRunRequest build() {
            return new StartImportLabelsTaskRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
