/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies skewed values in a table. Skewed values are those that occur with very high frequency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SkewedInfo implements SdkPojo, Serializable, ToCopyableBuilder<SkewedInfo.Builder, SkewedInfo> {
    private static final SdkField<List<String>> SKEWED_COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SkewedColumnNames")
            .getter(getter(SkewedInfo::skewedColumnNames))
            .setter(setter(Builder::skewedColumnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SKEWED_COLUMN_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SkewedColumnValues")
            .getter(getter(SkewedInfo::skewedColumnValues))
            .setter(setter(Builder::skewedColumnValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedColumnValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SKEWED_COLUMN_VALUE_LOCATION_MAPS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SkewedColumnValueLocationMaps")
            .getter(getter(SkewedInfo::skewedColumnValueLocationMaps))
            .setter(setter(Builder::skewedColumnValueLocationMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedColumnValueLocationMaps")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKEWED_COLUMN_NAMES_FIELD,
            SKEWED_COLUMN_VALUES_FIELD, SKEWED_COLUMN_VALUE_LOCATION_MAPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> skewedColumnNames;

    private final List<String> skewedColumnValues;

    private final Map<String, String> skewedColumnValueLocationMaps;

    private SkewedInfo(BuilderImpl builder) {
        this.skewedColumnNames = builder.skewedColumnNames;
        this.skewedColumnValues = builder.skewedColumnValues;
        this.skewedColumnValueLocationMaps = builder.skewedColumnValueLocationMaps;
    }

    /**
     * Returns true if the SkewedColumnNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSkewedColumnNames() {
        return skewedColumnNames != null && !(skewedColumnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of columns that contain skewed values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkewedColumnNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of columns that contain skewed values.
     */
    public List<String> skewedColumnNames() {
        return skewedColumnNames;
    }

    /**
     * Returns true if the SkewedColumnValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSkewedColumnValues() {
        return skewedColumnValues != null && !(skewedColumnValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of values that appear so frequently as to be considered skewed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkewedColumnValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of values that appear so frequently as to be considered skewed.
     */
    public List<String> skewedColumnValues() {
        return skewedColumnValues;
    }

    /**
     * Returns true if the SkewedColumnValueLocationMaps property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasSkewedColumnValueLocationMaps() {
        return skewedColumnValueLocationMaps != null && !(skewedColumnValueLocationMaps instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of skewed values to the columns that contain them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkewedColumnValueLocationMaps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A mapping of skewed values to the columns that contain them.
     */
    public Map<String, String> skewedColumnValueLocationMaps() {
        return skewedColumnValueLocationMaps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSkewedColumnNames() ? skewedColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSkewedColumnValues() ? skewedColumnValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSkewedColumnValueLocationMaps() ? skewedColumnValueLocationMaps() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkewedInfo)) {
            return false;
        }
        SkewedInfo other = (SkewedInfo) obj;
        return hasSkewedColumnNames() == other.hasSkewedColumnNames()
                && Objects.equals(skewedColumnNames(), other.skewedColumnNames())
                && hasSkewedColumnValues() == other.hasSkewedColumnValues()
                && Objects.equals(skewedColumnValues(), other.skewedColumnValues())
                && hasSkewedColumnValueLocationMaps() == other.hasSkewedColumnValueLocationMaps()
                && Objects.equals(skewedColumnValueLocationMaps(), other.skewedColumnValueLocationMaps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("SkewedInfo")
                .add("SkewedColumnNames", hasSkewedColumnNames() ? skewedColumnNames() : null)
                .add("SkewedColumnValues", hasSkewedColumnValues() ? skewedColumnValues() : null)
                .add("SkewedColumnValueLocationMaps", hasSkewedColumnValueLocationMaps() ? skewedColumnValueLocationMaps() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkewedColumnNames":
            return Optional.ofNullable(clazz.cast(skewedColumnNames()));
        case "SkewedColumnValues":
            return Optional.ofNullable(clazz.cast(skewedColumnValues()));
        case "SkewedColumnValueLocationMaps":
            return Optional.ofNullable(clazz.cast(skewedColumnValueLocationMaps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkewedInfo, T> g) {
        return obj -> g.apply((SkewedInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SkewedInfo> {
        /**
         * <p>
         * A list of names of columns that contain skewed values.
         * </p>
         * 
         * @param skewedColumnNames
         *        A list of names of columns that contain skewed values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skewedColumnNames(Collection<String> skewedColumnNames);

        /**
         * <p>
         * A list of names of columns that contain skewed values.
         * </p>
         * 
         * @param skewedColumnNames
         *        A list of names of columns that contain skewed values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skewedColumnNames(String... skewedColumnNames);

        /**
         * <p>
         * A list of values that appear so frequently as to be considered skewed.
         * </p>
         * 
         * @param skewedColumnValues
         *        A list of values that appear so frequently as to be considered skewed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skewedColumnValues(Collection<String> skewedColumnValues);

        /**
         * <p>
         * A list of values that appear so frequently as to be considered skewed.
         * </p>
         * 
         * @param skewedColumnValues
         *        A list of values that appear so frequently as to be considered skewed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skewedColumnValues(String... skewedColumnValues);

        /**
         * <p>
         * A mapping of skewed values to the columns that contain them.
         * </p>
         * 
         * @param skewedColumnValueLocationMaps
         *        A mapping of skewed values to the columns that contain them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps);
    }

    static final class BuilderImpl implements Builder {
        private List<String> skewedColumnNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> skewedColumnValues = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> skewedColumnValueLocationMaps = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SkewedInfo model) {
            skewedColumnNames(model.skewedColumnNames);
            skewedColumnValues(model.skewedColumnValues);
            skewedColumnValueLocationMaps(model.skewedColumnValueLocationMaps);
        }

        public final Collection<String> getSkewedColumnNames() {
            if (skewedColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return skewedColumnNames;
        }

        @Override
        public final Builder skewedColumnNames(Collection<String> skewedColumnNames) {
            this.skewedColumnNames = NameStringListCopier.copy(skewedColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skewedColumnNames(String... skewedColumnNames) {
            skewedColumnNames(Arrays.asList(skewedColumnNames));
            return this;
        }

        public final void setSkewedColumnNames(Collection<String> skewedColumnNames) {
            this.skewedColumnNames = NameStringListCopier.copy(skewedColumnNames);
        }

        public final Collection<String> getSkewedColumnValues() {
            if (skewedColumnValues instanceof SdkAutoConstructList) {
                return null;
            }
            return skewedColumnValues;
        }

        @Override
        public final Builder skewedColumnValues(Collection<String> skewedColumnValues) {
            this.skewedColumnValues = ColumnValueStringListCopier.copy(skewedColumnValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skewedColumnValues(String... skewedColumnValues) {
            skewedColumnValues(Arrays.asList(skewedColumnValues));
            return this;
        }

        public final void setSkewedColumnValues(Collection<String> skewedColumnValues) {
            this.skewedColumnValues = ColumnValueStringListCopier.copy(skewedColumnValues);
        }

        public final Map<String, String> getSkewedColumnValueLocationMaps() {
            if (skewedColumnValueLocationMaps instanceof SdkAutoConstructMap) {
                return null;
            }
            return skewedColumnValueLocationMaps;
        }

        @Override
        public final Builder skewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps) {
            this.skewedColumnValueLocationMaps = LocationMapCopier.copy(skewedColumnValueLocationMaps);
            return this;
        }

        public final void setSkewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps) {
            this.skewedColumnValueLocationMaps = LocationMapCopier.copy(skewedColumnValueLocationMaps);
        }

        @Override
        public SkewedInfo build() {
            return new SkewedInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
