/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegistriesResponse extends GlueResponse implements
        ToCopyableBuilder<ListRegistriesResponse.Builder, ListRegistriesResponse> {
    private static final SdkField<List<RegistryListItem>> REGISTRIES_FIELD = SdkField
            .<List<RegistryListItem>> builder(MarshallingType.LIST)
            .memberName("Registries")
            .getter(getter(ListRegistriesResponse::registries))
            .setter(setter(Builder::registries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistryListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistryListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegistriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RegistryListItem> registries;

    private final String nextToken;

    private ListRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.registries = builder.registries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Registries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRegistries() {
        return registries != null && !(registries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegistries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
     */
    public List<RegistryListItem> registries() {
        return registries;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistries() ? registries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistriesResponse)) {
            return false;
        }
        ListRegistriesResponse other = (ListRegistriesResponse) obj;
        return hasRegistries() == other.hasRegistries() && Objects.equals(registries(), other.registries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRegistriesResponse").add("Registries", hasRegistries() ? registries() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Registries":
            return Optional.ofNullable(clazz.cast(registries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegistriesResponse, T> g) {
        return obj -> g.apply((ListRegistriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRegistriesResponse> {
        /**
         * <p>
         * An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
         * </p>
         * 
         * @param registries
         *        An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(Collection<RegistryListItem> registries);

        /**
         * <p>
         * An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
         * </p>
         * 
         * @param registries
         *        An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(RegistryListItem... registries);

        /**
         * <p>
         * An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegistryListItem>.Builder} avoiding the
         * need to create one manually via {@link List<RegistryListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegistryListItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #registries(List<RegistryListItem>)}.
         * 
         * @param registries
         *        a consumer that will call methods on {@link List<RegistryListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registries(List<RegistryListItem>)
         */
        Builder registries(Consumer<RegistryListItem.Builder>... registries);

        /**
         * <p>
         * A continuation token for paginating the returned list of tokens, returned if the current segment of the list
         * is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of tokens, returned if the current segment of
         *        the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<RegistryListItem> registries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistriesResponse model) {
            super(model);
            registries(model.registries);
            nextToken(model.nextToken);
        }

        public final Collection<RegistryListItem.Builder> getRegistries() {
            if (registries instanceof SdkAutoConstructList) {
                return null;
            }
            return registries != null ? registries.stream().map(RegistryListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder registries(Collection<RegistryListItem> registries) {
            this.registries = RegistryListDefinitionCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(RegistryListItem... registries) {
            registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<RegistryListItem.Builder>... registries) {
            registries(Stream.of(registries).map(c -> RegistryListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRegistries(Collection<RegistryListItem.BuilderImpl> registries) {
            this.registries = RegistryListDefinitionCopier.copyFromBuilder(registries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRegistriesResponse build() {
            return new ListRegistriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
