/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowRunResponse extends GlueResponse implements
        ToCopyableBuilder<GetWorkflowRunResponse.Builder, GetWorkflowRunResponse> {
    private static final SdkField<WorkflowRun> RUN_FIELD = SdkField.<WorkflowRun> builder(MarshallingType.SDK_POJO)
            .memberName("Run").getter(getter(GetWorkflowRunResponse::run)).setter(setter(Builder::run))
            .constructor(WorkflowRun::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Run").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_FIELD));

    private final WorkflowRun run;

    private GetWorkflowRunResponse(BuilderImpl builder) {
        super(builder);
        this.run = builder.run;
    }

    /**
     * <p>
     * The requested workflow run metadata.
     * </p>
     * 
     * @return The requested workflow run metadata.
     */
    public WorkflowRun run() {
        return run;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(run());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunResponse)) {
            return false;
        }
        GetWorkflowRunResponse other = (GetWorkflowRunResponse) obj;
        return Objects.equals(run(), other.run());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWorkflowRunResponse").add("Run", run()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Run":
            return Optional.ofNullable(clazz.cast(run()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowRunResponse> {
        /**
         * <p>
         * The requested workflow run metadata.
         * </p>
         * 
         * @param run
         *        The requested workflow run metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(WorkflowRun run);

        /**
         * <p>
         * The requested workflow run metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link WorkflowRun.Builder} avoiding the need to create
         * one manually via {@link WorkflowRun#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkflowRun.Builder#build()} is called immediately and its result
         * is passed to {@link #run(WorkflowRun)}.
         * 
         * @param run
         *        a consumer that will call methods on {@link WorkflowRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #run(WorkflowRun)
         */
        default Builder run(Consumer<WorkflowRun.Builder> run) {
            return run(WorkflowRun.builder().applyMutation(run).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private WorkflowRun run;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunResponse model) {
            super(model);
            run(model.run);
        }

        public final WorkflowRun.Builder getRun() {
            return run != null ? run.toBuilder() : null;
        }

        @Override
        public final Builder run(WorkflowRun run) {
            this.run = run;
            return this;
        }

        public final void setRun(WorkflowRun.BuilderImpl run) {
            this.run = run != null ? run.build() : null;
        }

        @Override
        public GetWorkflowRunResponse build() {
            return new GetWorkflowRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
