/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowRunPropertiesResponse extends GlueResponse implements
        ToCopyableBuilder<GetWorkflowRunPropertiesResponse.Builder, GetWorkflowRunPropertiesResponse> {
    private static final SdkField<Map<String, String>> RUN_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RunProperties")
            .getter(getter(GetWorkflowRunPropertiesResponse::runProperties))
            .setter(setter(Builder::runProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_PROPERTIES_FIELD));

    private final Map<String, String> runProperties;

    private GetWorkflowRunPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.runProperties = builder.runProperties;
    }

    /**
     * Returns true if the RunProperties property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRunProperties() {
        return runProperties != null && !(runProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The workflow run properties which were set during the specified run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRunProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The workflow run properties which were set during the specified run.
     */
    public Map<String, String> runProperties() {
        return runProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRunProperties() ? runProperties() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunPropertiesResponse)) {
            return false;
        }
        GetWorkflowRunPropertiesResponse other = (GetWorkflowRunPropertiesResponse) obj;
        return hasRunProperties() == other.hasRunProperties() && Objects.equals(runProperties(), other.runProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWorkflowRunPropertiesResponse")
                .add("RunProperties", hasRunProperties() ? runProperties() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunProperties":
            return Optional.ofNullable(clazz.cast(runProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunPropertiesResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowRunPropertiesResponse> {
        /**
         * <p>
         * The workflow run properties which were set during the specified run.
         * </p>
         * 
         * @param runProperties
         *        The workflow run properties which were set during the specified run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runProperties(Map<String, String> runProperties);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Map<String, String> runProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunPropertiesResponse model) {
            super(model);
            runProperties(model.runProperties);
        }

        public final Map<String, String> getRunProperties() {
            if (runProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return runProperties;
        }

        @Override
        public final Builder runProperties(Map<String, String> runProperties) {
            this.runProperties = WorkflowRunPropertiesCopier.copy(runProperties);
            return this;
        }

        public final void setRunProperties(Map<String, String> runProperties) {
            this.runProperties = WorkflowRunPropertiesCopier.copy(runProperties);
        }

        @Override
        public GetWorkflowRunPropertiesResponse build() {
            return new GetWorkflowRunPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
