/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobBookmarkResponse extends GlueResponse implements
        ToCopyableBuilder<GetJobBookmarkResponse.Builder, GetJobBookmarkResponse> {
    private static final SdkField<JobBookmarkEntry> JOB_BOOKMARK_ENTRY_FIELD = SdkField
            .<JobBookmarkEntry> builder(MarshallingType.SDK_POJO).memberName("JobBookmarkEntry")
            .getter(getter(GetJobBookmarkResponse::jobBookmarkEntry)).setter(setter(Builder::jobBookmarkEntry))
            .constructor(JobBookmarkEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkEntry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_BOOKMARK_ENTRY_FIELD));

    private final JobBookmarkEntry jobBookmarkEntry;

    private GetJobBookmarkResponse(BuilderImpl builder) {
        super(builder);
        this.jobBookmarkEntry = builder.jobBookmarkEntry;
    }

    /**
     * <p>
     * A structure that defines a point that a job can resume processing.
     * </p>
     * 
     * @return A structure that defines a point that a job can resume processing.
     */
    public JobBookmarkEntry jobBookmarkEntry() {
        return jobBookmarkEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobBookmarkEntry());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobBookmarkResponse)) {
            return false;
        }
        GetJobBookmarkResponse other = (GetJobBookmarkResponse) obj;
        return Objects.equals(jobBookmarkEntry(), other.jobBookmarkEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetJobBookmarkResponse").add("JobBookmarkEntry", jobBookmarkEntry()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobBookmarkEntry":
            return Optional.ofNullable(clazz.cast(jobBookmarkEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobBookmarkResponse, T> g) {
        return obj -> g.apply((GetJobBookmarkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobBookmarkResponse> {
        /**
         * <p>
         * A structure that defines a point that a job can resume processing.
         * </p>
         * 
         * @param jobBookmarkEntry
         *        A structure that defines a point that a job can resume processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmarkEntry(JobBookmarkEntry jobBookmarkEntry);

        /**
         * <p>
         * A structure that defines a point that a job can resume processing.
         * </p>
         * This is a convenience that creates an instance of the {@link JobBookmarkEntry.Builder} avoiding the need to
         * create one manually via {@link JobBookmarkEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobBookmarkEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #jobBookmarkEntry(JobBookmarkEntry)}.
         * 
         * @param jobBookmarkEntry
         *        a consumer that will call methods on {@link JobBookmarkEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobBookmarkEntry(JobBookmarkEntry)
         */
        default Builder jobBookmarkEntry(Consumer<JobBookmarkEntry.Builder> jobBookmarkEntry) {
            return jobBookmarkEntry(JobBookmarkEntry.builder().applyMutation(jobBookmarkEntry).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private JobBookmarkEntry jobBookmarkEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobBookmarkResponse model) {
            super(model);
            jobBookmarkEntry(model.jobBookmarkEntry);
        }

        public final JobBookmarkEntry.Builder getJobBookmarkEntry() {
            return jobBookmarkEntry != null ? jobBookmarkEntry.toBuilder() : null;
        }

        @Override
        public final Builder jobBookmarkEntry(JobBookmarkEntry jobBookmarkEntry) {
            this.jobBookmarkEntry = jobBookmarkEntry;
            return this;
        }

        public final void setJobBookmarkEntry(JobBookmarkEntry.BuilderImpl jobBookmarkEntry) {
            this.jobBookmarkEntry = jobBookmarkEntry != null ? jobBookmarkEntry.build() : null;
        }

        @Override
        public GetJobBookmarkResponse build() {
            return new GetJobBookmarkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
