/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters to configure the find matches transform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindMatchesParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<FindMatchesParameters.Builder, FindMatchesParameters> {
    private static final SdkField<String> PRIMARY_KEY_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryKeyColumnName").getter(getter(FindMatchesParameters::primaryKeyColumnName))
            .setter(setter(Builder::primaryKeyColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryKeyColumnName").build())
            .build();

    private static final SdkField<Double> PRECISION_RECALL_TRADEOFF_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PrecisionRecallTradeoff").getter(getter(FindMatchesParameters::precisionRecallTradeoff))
            .setter(setter(Builder::precisionRecallTradeoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrecisionRecallTradeoff").build())
            .build();

    private static final SdkField<Double> ACCURACY_COST_TRADEOFF_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AccuracyCostTradeoff").getter(getter(FindMatchesParameters::accuracyCostTradeoff))
            .setter(setter(Builder::accuracyCostTradeoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccuracyCostTradeoff").build())
            .build();

    private static final SdkField<Boolean> ENFORCE_PROVIDED_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnforceProvidedLabels").getter(getter(FindMatchesParameters::enforceProvidedLabels))
            .setter(setter(Builder::enforceProvidedLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceProvidedLabels").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_KEY_COLUMN_NAME_FIELD,
            PRECISION_RECALL_TRADEOFF_FIELD, ACCURACY_COST_TRADEOFF_FIELD, ENFORCE_PROVIDED_LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryKeyColumnName;

    private final Double precisionRecallTradeoff;

    private final Double accuracyCostTradeoff;

    private final Boolean enforceProvidedLabels;

    private FindMatchesParameters(BuilderImpl builder) {
        this.primaryKeyColumnName = builder.primaryKeyColumnName;
        this.precisionRecallTradeoff = builder.precisionRecallTradeoff;
        this.accuracyCostTradeoff = builder.accuracyCostTradeoff;
        this.enforceProvidedLabels = builder.enforceProvidedLabels;
    }

    /**
     * <p>
     * The name of a column that uniquely identifies rows in the source table. Used to help identify matching records.
     * </p>
     * 
     * @return The name of a column that uniquely identifies rows in the source table. Used to help identify matching
     *         records.
     */
    public String primaryKeyColumnName() {
        return primaryKeyColumnName;
    }

    /**
     * <p>
     * The value selected when tuning your transform for a balance between precision and recall. A value of 0.5 means no
     * preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a bias for recall. Because
     * this is a tradeoff, choosing values close to 1.0 means very low recall, and choosing values close to 0.0 results
     * in very low precision.
     * </p>
     * <p>
     * The precision metric indicates how often your model is correct when it predicts a match.
     * </p>
     * <p>
     * The recall metric indicates that for an actual match, how often your model predicts the match.
     * </p>
     * 
     * @return The value selected when tuning your transform for a balance between precision and recall. A value of 0.5
     *         means no preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a bias
     *         for recall. Because this is a tradeoff, choosing values close to 1.0 means very low recall, and choosing
     *         values close to 0.0 results in very low precision.</p>
     *         <p>
     *         The precision metric indicates how often your model is correct when it predicts a match.
     *         </p>
     *         <p>
     *         The recall metric indicates that for an actual match, how often your model predicts the match.
     */
    public Double precisionRecallTradeoff() {
        return precisionRecallTradeoff;
    }

    /**
     * <p>
     * The value that is selected when tuning your transform for a balance between accuracy and cost. A value of 0.5
     * means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely for accuracy, which
     * typically results in a higher cost, sometimes substantially higher. A value of 0.0 means a bias purely for cost,
     * which results in a less accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.
     * </p>
     * <p>
     * Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires
     * more machine resources and cost. But it also results in increased recall.
     * </p>
     * <p>
     * Cost measures how many compute resources, and thus money, are consumed to run the transform.
     * </p>
     * 
     * @return The value that is selected when tuning your transform for a balance between accuracy and cost. A value of
     *         0.5 means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely for
     *         accuracy, which typically results in a higher cost, sometimes substantially higher. A value of 0.0 means
     *         a bias purely for cost, which results in a less accurate <code>FindMatches</code> transform, sometimes
     *         with unacceptable accuracy.</p>
     *         <p>
     *         Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy
     *         requires more machine resources and cost. But it also results in increased recall.
     *         </p>
     *         <p>
     *         Cost measures how many compute resources, and thus money, are consumed to run the transform.
     */
    public Double accuracyCostTradeoff() {
        return accuracyCostTradeoff;
    }

    /**
     * <p>
     * The value to switch on or off to force the output to match the provided labels from users. If the value is
     * <code>True</code>, the <code>find matches</code> transform forces the output to match the provided labels. The
     * results override the normal conflation results. If the value is <code>False</code>, the <code>find matches</code>
     * transform does not ensure all the labels provided are respected, and the results rely on the trained model.
     * </p>
     * <p>
     * Note that setting this value to true may increase the conflation execution time.
     * </p>
     * 
     * @return The value to switch on or off to force the output to match the provided labels from users. If the value
     *         is <code>True</code>, the <code>find matches</code> transform forces the output to match the provided
     *         labels. The results override the normal conflation results. If the value is <code>False</code>, the
     *         <code>find matches</code> transform does not ensure all the labels provided are respected, and the
     *         results rely on the trained model.</p>
     *         <p>
     *         Note that setting this value to true may increase the conflation execution time.
     */
    public Boolean enforceProvidedLabels() {
        return enforceProvidedLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryKeyColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(precisionRecallTradeoff());
        hashCode = 31 * hashCode + Objects.hashCode(accuracyCostTradeoff());
        hashCode = 31 * hashCode + Objects.hashCode(enforceProvidedLabels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindMatchesParameters)) {
            return false;
        }
        FindMatchesParameters other = (FindMatchesParameters) obj;
        return Objects.equals(primaryKeyColumnName(), other.primaryKeyColumnName())
                && Objects.equals(precisionRecallTradeoff(), other.precisionRecallTradeoff())
                && Objects.equals(accuracyCostTradeoff(), other.accuracyCostTradeoff())
                && Objects.equals(enforceProvidedLabels(), other.enforceProvidedLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FindMatchesParameters").add("PrimaryKeyColumnName", primaryKeyColumnName())
                .add("PrecisionRecallTradeoff", precisionRecallTradeoff()).add("AccuracyCostTradeoff", accuracyCostTradeoff())
                .add("EnforceProvidedLabels", enforceProvidedLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryKeyColumnName":
            return Optional.ofNullable(clazz.cast(primaryKeyColumnName()));
        case "PrecisionRecallTradeoff":
            return Optional.ofNullable(clazz.cast(precisionRecallTradeoff()));
        case "AccuracyCostTradeoff":
            return Optional.ofNullable(clazz.cast(accuracyCostTradeoff()));
        case "EnforceProvidedLabels":
            return Optional.ofNullable(clazz.cast(enforceProvidedLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindMatchesParameters, T> g) {
        return obj -> g.apply((FindMatchesParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindMatchesParameters> {
        /**
         * <p>
         * The name of a column that uniquely identifies rows in the source table. Used to help identify matching
         * records.
         * </p>
         * 
         * @param primaryKeyColumnName
         *        The name of a column that uniquely identifies rows in the source table. Used to help identify matching
         *        records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKeyColumnName(String primaryKeyColumnName);

        /**
         * <p>
         * The value selected when tuning your transform for a balance between precision and recall. A value of 0.5
         * means no preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a bias for
         * recall. Because this is a tradeoff, choosing values close to 1.0 means very low recall, and choosing values
         * close to 0.0 results in very low precision.
         * </p>
         * <p>
         * The precision metric indicates how often your model is correct when it predicts a match.
         * </p>
         * <p>
         * The recall metric indicates that for an actual match, how often your model predicts the match.
         * </p>
         * 
         * @param precisionRecallTradeoff
         *        The value selected when tuning your transform for a balance between precision and recall. A value of
         *        0.5 means no preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a
         *        bias for recall. Because this is a tradeoff, choosing values close to 1.0 means very low recall, and
         *        choosing values close to 0.0 results in very low precision.</p>
         *        <p>
         *        The precision metric indicates how often your model is correct when it predicts a match.
         *        </p>
         *        <p>
         *        The recall metric indicates that for an actual match, how often your model predicts the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precisionRecallTradeoff(Double precisionRecallTradeoff);

        /**
         * <p>
         * The value that is selected when tuning your transform for a balance between accuracy and cost. A value of 0.5
         * means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely for accuracy,
         * which typically results in a higher cost, sometimes substantially higher. A value of 0.0 means a bias purely
         * for cost, which results in a less accurate <code>FindMatches</code> transform, sometimes with unacceptable
         * accuracy.
         * </p>
         * <p>
         * Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy
         * requires more machine resources and cost. But it also results in increased recall.
         * </p>
         * <p>
         * Cost measures how many compute resources, and thus money, are consumed to run the transform.
         * </p>
         * 
         * @param accuracyCostTradeoff
         *        The value that is selected when tuning your transform for a balance between accuracy and cost. A value
         *        of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely
         *        for accuracy, which typically results in a higher cost, sometimes substantially higher. A value of 0.0
         *        means a bias purely for cost, which results in a less accurate <code>FindMatches</code> transform,
         *        sometimes with unacceptable accuracy.</p>
         *        <p>
         *        Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy
         *        requires more machine resources and cost. But it also results in increased recall.
         *        </p>
         *        <p>
         *        Cost measures how many compute resources, and thus money, are consumed to run the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accuracyCostTradeoff(Double accuracyCostTradeoff);

        /**
         * <p>
         * The value to switch on or off to force the output to match the provided labels from users. If the value is
         * <code>True</code>, the <code>find matches</code> transform forces the output to match the provided labels.
         * The results override the normal conflation results. If the value is <code>False</code>, the
         * <code>find matches</code> transform does not ensure all the labels provided are respected, and the results
         * rely on the trained model.
         * </p>
         * <p>
         * Note that setting this value to true may increase the conflation execution time.
         * </p>
         * 
         * @param enforceProvidedLabels
         *        The value to switch on or off to force the output to match the provided labels from users. If the
         *        value is <code>True</code>, the <code>find matches</code> transform forces the output to match the
         *        provided labels. The results override the normal conflation results. If the value is
         *        <code>False</code>, the <code>find matches</code> transform does not ensure all the labels provided
         *        are respected, and the results rely on the trained model.</p>
         *        <p>
         *        Note that setting this value to true may increase the conflation execution time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceProvidedLabels(Boolean enforceProvidedLabels);
    }

    static final class BuilderImpl implements Builder {
        private String primaryKeyColumnName;

        private Double precisionRecallTradeoff;

        private Double accuracyCostTradeoff;

        private Boolean enforceProvidedLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(FindMatchesParameters model) {
            primaryKeyColumnName(model.primaryKeyColumnName);
            precisionRecallTradeoff(model.precisionRecallTradeoff);
            accuracyCostTradeoff(model.accuracyCostTradeoff);
            enforceProvidedLabels(model.enforceProvidedLabels);
        }

        public final String getPrimaryKeyColumnName() {
            return primaryKeyColumnName;
        }

        @Override
        public final Builder primaryKeyColumnName(String primaryKeyColumnName) {
            this.primaryKeyColumnName = primaryKeyColumnName;
            return this;
        }

        public final void setPrimaryKeyColumnName(String primaryKeyColumnName) {
            this.primaryKeyColumnName = primaryKeyColumnName;
        }

        public final Double getPrecisionRecallTradeoff() {
            return precisionRecallTradeoff;
        }

        @Override
        public final Builder precisionRecallTradeoff(Double precisionRecallTradeoff) {
            this.precisionRecallTradeoff = precisionRecallTradeoff;
            return this;
        }

        public final void setPrecisionRecallTradeoff(Double precisionRecallTradeoff) {
            this.precisionRecallTradeoff = precisionRecallTradeoff;
        }

        public final Double getAccuracyCostTradeoff() {
            return accuracyCostTradeoff;
        }

        @Override
        public final Builder accuracyCostTradeoff(Double accuracyCostTradeoff) {
            this.accuracyCostTradeoff = accuracyCostTradeoff;
            return this;
        }

        public final void setAccuracyCostTradeoff(Double accuracyCostTradeoff) {
            this.accuracyCostTradeoff = accuracyCostTradeoff;
        }

        public final Boolean getEnforceProvidedLabels() {
            return enforceProvidedLabels;
        }

        @Override
        public final Builder enforceProvidedLabels(Boolean enforceProvidedLabels) {
            this.enforceProvidedLabels = enforceProvidedLabels;
            return this;
        }

        public final void setEnforceProvidedLabels(Boolean enforceProvidedLabels) {
            this.enforceProvidedLabels = enforceProvidedLabels;
        }

        @Override
        public FindMatchesParameters build() {
            return new FindMatchesParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
