/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArg;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArgsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Location> {
    private static final SdkField<List<CodeGenNodeArg>> JDBC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Location.getter(Location::jdbc)).setter(Location.setter(Builder::jdbc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jdbc").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenNodeArg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CodeGenNodeArg>> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Location.getter(Location::s3)).setter(Location.setter(Builder::s3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenNodeArg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CodeGenNodeArg>> DYNAMO_DB_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Location.getter(Location::dynamoDB)).setter(Location.setter(Builder::dynamoDB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDB").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenNodeArg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JDBC_FIELD, S3_FIELD, DYNAMO_DB_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CodeGenNodeArg> jdbc;
    private final List<CodeGenNodeArg> s3;
    private final List<CodeGenNodeArg> dynamoDB;

    private Location(BuilderImpl builder) {
        this.jdbc = builder.jdbc;
        this.s3 = builder.s3;
        this.dynamoDB = builder.dynamoDB;
    }

    public boolean hasJdbc() {
        return this.jdbc != null && !(this.jdbc instanceof SdkAutoConstructList);
    }

    public List<CodeGenNodeArg> jdbc() {
        return this.jdbc;
    }

    public boolean hasS3() {
        return this.s3 != null && !(this.s3 instanceof SdkAutoConstructList);
    }

    public List<CodeGenNodeArg> s3() {
        return this.s3;
    }

    public boolean hasDynamoDB() {
        return this.dynamoDB != null && !(this.dynamoDB instanceof SdkAutoConstructList);
    }

    public List<CodeGenNodeArg> dynamoDB() {
        return this.dynamoDB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jdbc());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDB());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.jdbc(), other.jdbc()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.dynamoDB(), other.dynamoDB());
    }

    public String toString() {
        return ToString.builder((String)"Location").add("Jdbc", this.jdbc()).add("S3", this.s3()).add("DynamoDB", this.dynamoDB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jdbc": {
                return Optional.ofNullable(clazz.cast(this.jdbc()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "DynamoDB": {
                return Optional.ofNullable(clazz.cast(this.dynamoDB()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CodeGenNodeArg> jdbc = DefaultSdkAutoConstructList.getInstance();
        private List<CodeGenNodeArg> s3 = DefaultSdkAutoConstructList.getInstance();
        private List<CodeGenNodeArg> dynamoDB = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.jdbc(model.jdbc);
            this.s3(model.s3);
            this.dynamoDB(model.dynamoDB);
        }

        public final Collection<CodeGenNodeArg.Builder> getJdbc() {
            return this.jdbc != null ? (Collection)this.jdbc.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jdbc(Collection<CodeGenNodeArg> jdbc) {
            this.jdbc = CodeGenNodeArgsCopier.copy(jdbc);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbc(CodeGenNodeArg ... jdbc) {
            this.jdbc(Arrays.asList(jdbc));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbc(Consumer<CodeGenNodeArg.Builder> ... jdbc) {
            this.jdbc(Stream.of(jdbc).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJdbc(Collection<CodeGenNodeArg.BuilderImpl> jdbc) {
            this.jdbc = CodeGenNodeArgsCopier.copyFromBuilder(jdbc);
        }

        public final Collection<CodeGenNodeArg.Builder> getS3() {
            return this.s3 != null ? (Collection)this.s3.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3(Collection<CodeGenNodeArg> s3) {
            this.s3 = CodeGenNodeArgsCopier.copy(s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(CodeGenNodeArg ... s3) {
            this.s3(Arrays.asList(s3));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(Consumer<CodeGenNodeArg.Builder> ... s3) {
            this.s3(Stream.of(s3).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3(Collection<CodeGenNodeArg.BuilderImpl> s3) {
            this.s3 = CodeGenNodeArgsCopier.copyFromBuilder(s3);
        }

        public final Collection<CodeGenNodeArg.Builder> getDynamoDB() {
            return this.dynamoDB != null ? (Collection)this.dynamoDB.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dynamoDB(Collection<CodeGenNodeArg> dynamoDB) {
            this.dynamoDB = CodeGenNodeArgsCopier.copy(dynamoDB);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDB(CodeGenNodeArg ... dynamoDB) {
            this.dynamoDB(Arrays.asList(dynamoDB));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDB(Consumer<CodeGenNodeArg.Builder> ... dynamoDB) {
            this.dynamoDB(Stream.of(dynamoDB).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDynamoDB(Collection<CodeGenNodeArg.BuilderImpl> dynamoDB) {
            this.dynamoDB = CodeGenNodeArgsCopier.copyFromBuilder(dynamoDB);
        }

        public Location build() {
            return new Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Location> {
        public Builder jdbc(Collection<CodeGenNodeArg> var1);

        public Builder jdbc(CodeGenNodeArg ... var1);

        public Builder jdbc(Consumer<CodeGenNodeArg.Builder> ... var1);

        public Builder s3(Collection<CodeGenNodeArg> var1);

        public Builder s3(CodeGenNodeArg ... var1);

        public Builder s3(Consumer<CodeGenNodeArg.Builder> ... var1);

        public Builder dynamoDB(Collection<CodeGenNodeArg> var1);

        public Builder dynamoDB(CodeGenNodeArg ... var1);

        public Builder dynamoDB(Consumer<CodeGenNodeArg.Builder> ... var1);
    }
}

