/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a JSON classifier to be updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJsonClassifierRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateJsonClassifierRequest.Builder, UpdateJsonClassifierRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJsonClassifierRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJsonClassifierRequest::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, JSON_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String jsonPath;

    private UpdateJsonClassifierRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.jsonPath = builder.jsonPath;
    }

    /**
     * <p>
     * The name of the classifier.
     * </p>
     * 
     * @return The name of the classifier.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue supports a subset
     * of JsonPath, as described in <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath
     * Custom Classifiers</a>.
     * </p>
     * 
     * @return A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue supports a
     *         subset of JsonPath, as described in <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing
     *         JsonPath Custom Classifiers</a>.
     */
    public String jsonPath() {
        return jsonPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJsonClassifierRequest)) {
            return false;
        }
        UpdateJsonClassifierRequest other = (UpdateJsonClassifierRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(jsonPath(), other.jsonPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJsonClassifierRequest").add("Name", name()).add("JsonPath", jsonPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "JsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJsonClassifierRequest, T> g) {
        return obj -> g.apply((UpdateJsonClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateJsonClassifierRequest> {
        /**
         * <p>
         * The name of the classifier.
         * </p>
         * 
         * @param name
         *        The name of the classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue supports a
         * subset of JsonPath, as described in <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing
         * JsonPath Custom Classifiers</a>.
         * </p>
         * 
         * @param jsonPath
         *        A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue
         *        supports a subset of JsonPath, as described in <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json"
         *        >Writing JsonPath Custom Classifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String jsonPath;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJsonClassifierRequest model) {
            name(model.name);
            jsonPath(model.jsonPath);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public UpdateJsonClassifierRequest build() {
            return new UpdateJsonClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
