/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a point that a job can resume processing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobBookmarkEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<JobBookmarkEntry.Builder, JobBookmarkEntry> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobBookmarkEntry::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JobBookmarkEntry::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Integer> RUN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JobBookmarkEntry::run)).setter(setter(Builder::run))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Run").build()).build();

    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JobBookmarkEntry::attempt)).setter(setter(Builder::attempt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempt").build()).build();

    private static final SdkField<String> PREVIOUS_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobBookmarkEntry::previousRunId)).setter(setter(Builder::previousRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousRunId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobBookmarkEntry::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> JOB_BOOKMARK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobBookmarkEntry::jobBookmark)).setter(setter(Builder::jobBookmark))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmark").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, VERSION_FIELD,
            RUN_FIELD, ATTEMPT_FIELD, PREVIOUS_RUN_ID_FIELD, RUN_ID_FIELD, JOB_BOOKMARK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final Integer version;

    private final Integer run;

    private final Integer attempt;

    private final String previousRunId;

    private final String runId;

    private final String jobBookmark;

    private JobBookmarkEntry(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.version = builder.version;
        this.run = builder.run;
        this.attempt = builder.attempt;
        this.previousRunId = builder.previousRunId;
        this.runId = builder.runId;
        this.jobBookmark = builder.jobBookmark;
    }

    /**
     * <p>
     * The name of the job in question.
     * </p>
     * 
     * @return The name of the job in question.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The version of the job.
     * </p>
     * 
     * @return The version of the job.
     */
    public Integer version() {
        return version;
    }

    /**
     * <p>
     * The run ID number.
     * </p>
     * 
     * @return The run ID number.
     */
    public Integer run() {
        return run;
    }

    /**
     * <p>
     * The attempt ID number.
     * </p>
     * 
     * @return The attempt ID number.
     */
    public Integer attempt() {
        return attempt;
    }

    /**
     * <p>
     * The unique run identifier associated with the previous job run.
     * </p>
     * 
     * @return The unique run identifier associated with the previous job run.
     */
    public String previousRunId() {
        return previousRunId;
    }

    /**
     * <p>
     * The run ID number.
     * </p>
     * 
     * @return The run ID number.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * The bookmark itself.
     * </p>
     * 
     * @return The bookmark itself.
     */
    public String jobBookmark() {
        return jobBookmark;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(run());
        hashCode = 31 * hashCode + Objects.hashCode(attempt());
        hashCode = 31 * hashCode + Objects.hashCode(previousRunId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(jobBookmark());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobBookmarkEntry)) {
            return false;
        }
        JobBookmarkEntry other = (JobBookmarkEntry) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(version(), other.version())
                && Objects.equals(run(), other.run()) && Objects.equals(attempt(), other.attempt())
                && Objects.equals(previousRunId(), other.previousRunId()) && Objects.equals(runId(), other.runId())
                && Objects.equals(jobBookmark(), other.jobBookmark());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobBookmarkEntry").add("JobName", jobName()).add("Version", version()).add("Run", run())
                .add("Attempt", attempt()).add("PreviousRunId", previousRunId()).add("RunId", runId())
                .add("JobBookmark", jobBookmark()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Run":
            return Optional.ofNullable(clazz.cast(run()));
        case "Attempt":
            return Optional.ofNullable(clazz.cast(attempt()));
        case "PreviousRunId":
            return Optional.ofNullable(clazz.cast(previousRunId()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "JobBookmark":
            return Optional.ofNullable(clazz.cast(jobBookmark()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobBookmarkEntry, T> g) {
        return obj -> g.apply((JobBookmarkEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobBookmarkEntry> {
        /**
         * <p>
         * The name of the job in question.
         * </p>
         * 
         * @param jobName
         *        The name of the job in question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The version of the job.
         * </p>
         * 
         * @param version
         *        The version of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The run ID number.
         * </p>
         * 
         * @param run
         *        The run ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(Integer run);

        /**
         * <p>
         * The attempt ID number.
         * </p>
         * 
         * @param attempt
         *        The attempt ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempt(Integer attempt);

        /**
         * <p>
         * The unique run identifier associated with the previous job run.
         * </p>
         * 
         * @param previousRunId
         *        The unique run identifier associated with the previous job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousRunId(String previousRunId);

        /**
         * <p>
         * The run ID number.
         * </p>
         * 
         * @param runId
         *        The run ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The bookmark itself.
         * </p>
         * 
         * @param jobBookmark
         *        The bookmark itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmark(String jobBookmark);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private Integer version;

        private Integer run;

        private Integer attempt;

        private String previousRunId;

        private String runId;

        private String jobBookmark;

        private BuilderImpl() {
        }

        private BuilderImpl(JobBookmarkEntry model) {
            jobName(model.jobName);
            version(model.version);
            run(model.run);
            attempt(model.attempt);
            previousRunId(model.previousRunId);
            runId(model.runId);
            jobBookmark(model.jobBookmark);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final Integer getRun() {
            return run;
        }

        @Override
        public final Builder run(Integer run) {
            this.run = run;
            return this;
        }

        public final void setRun(Integer run) {
            this.run = run;
        }

        public final Integer getAttempt() {
            return attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public final String getPreviousRunId() {
            return previousRunId;
        }

        @Override
        public final Builder previousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
            return this;
        }

        public final void setPreviousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getJobBookmark() {
            return jobBookmark;
        }

        @Override
        public final Builder jobBookmark(String jobBookmark) {
            this.jobBookmark = jobBookmark;
            return this;
        }

        public final void setJobBookmark(String jobBookmark) {
            this.jobBookmark = jobBookmark;
        }

        @Override
        public JobBookmarkEntry build() {
            return new JobBookmarkEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
