/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an encryption configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfiguration.Builder, EncryptionConfiguration> {
    private static final SdkField<List<S3Encryption>> S3_ENCRYPTION_FIELD = SdkField
            .<List<S3Encryption>> builder(MarshallingType.LIST)
            .getter(getter(EncryptionConfiguration::s3Encryption))
            .setter(setter(Builder::s3Encryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Encryption").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Encryption> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Encryption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CloudWatchEncryption> CLOUD_WATCH_ENCRYPTION_FIELD = SdkField
            .<CloudWatchEncryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(EncryptionConfiguration::cloudWatchEncryption)).setter(setter(Builder::cloudWatchEncryption))
            .constructor(CloudWatchEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEncryption").build())
            .build();

    private static final SdkField<JobBookmarksEncryption> JOB_BOOKMARKS_ENCRYPTION_FIELD = SdkField
            .<JobBookmarksEncryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(EncryptionConfiguration::jobBookmarksEncryption)).setter(setter(Builder::jobBookmarksEncryption))
            .constructor(JobBookmarksEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarksEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ENCRYPTION_FIELD,
            CLOUD_WATCH_ENCRYPTION_FIELD, JOB_BOOKMARKS_ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<S3Encryption> s3Encryption;

    private final CloudWatchEncryption cloudWatchEncryption;

    private final JobBookmarksEncryption jobBookmarksEncryption;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.s3Encryption = builder.s3Encryption;
        this.cloudWatchEncryption = builder.cloudWatchEncryption;
        this.jobBookmarksEncryption = builder.jobBookmarksEncryption;
    }

    /**
     * Returns true if the S3Encryption property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasS3Encryption() {
        return s3Encryption != null && !(s3Encryption instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasS3Encryption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
     */
    public List<S3Encryption> s3Encryption() {
        return s3Encryption;
    }

    /**
     * <p>
     * The encryption configuration for Amazon CloudWatch.
     * </p>
     * 
     * @return The encryption configuration for Amazon CloudWatch.
     */
    public CloudWatchEncryption cloudWatchEncryption() {
        return cloudWatchEncryption;
    }

    /**
     * <p>
     * The encryption configuration for job bookmarks.
     * </p>
     * 
     * @return The encryption configuration for job bookmarks.
     */
    public JobBookmarksEncryption jobBookmarksEncryption() {
        return jobBookmarksEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Encryption());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(jobBookmarksEncryption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        return Objects.equals(s3Encryption(), other.s3Encryption())
                && Objects.equals(cloudWatchEncryption(), other.cloudWatchEncryption())
                && Objects.equals(jobBookmarksEncryption(), other.jobBookmarksEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EncryptionConfiguration").add("S3Encryption", s3Encryption())
                .add("CloudWatchEncryption", cloudWatchEncryption()).add("JobBookmarksEncryption", jobBookmarksEncryption())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Encryption":
            return Optional.ofNullable(clazz.cast(s3Encryption()));
        case "CloudWatchEncryption":
            return Optional.ofNullable(clazz.cast(cloudWatchEncryption()));
        case "JobBookmarksEncryption":
            return Optional.ofNullable(clazz.cast(jobBookmarksEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfiguration> {
        /**
         * <p>
         * The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * </p>
         * 
         * @param s3Encryption
         *        The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Encryption(Collection<S3Encryption> s3Encryption);

        /**
         * <p>
         * The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * </p>
         * 
         * @param s3Encryption
         *        The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Encryption(S3Encryption... s3Encryption);

        /**
         * <p>
         * The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3Encryption>.Builder} avoiding the need to
         * create one manually via {@link List<S3Encryption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3Encryption>.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Encryption(List<S3Encryption>)}.
         * 
         * @param s3Encryption
         *        a consumer that will call methods on {@link List<S3Encryption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Encryption(List<S3Encryption>)
         */
        Builder s3Encryption(Consumer<S3Encryption.Builder>... s3Encryption);

        /**
         * <p>
         * The encryption configuration for Amazon CloudWatch.
         * </p>
         * 
         * @param cloudWatchEncryption
         *        The encryption configuration for Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchEncryption(CloudWatchEncryption cloudWatchEncryption);

        /**
         * <p>
         * The encryption configuration for Amazon CloudWatch.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchEncryption.Builder} avoiding the need
         * to create one manually via {@link CloudWatchEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchEncryption(CloudWatchEncryption)}.
         * 
         * @param cloudWatchEncryption
         *        a consumer that will call methods on {@link CloudWatchEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchEncryption(CloudWatchEncryption)
         */
        default Builder cloudWatchEncryption(Consumer<CloudWatchEncryption.Builder> cloudWatchEncryption) {
            return cloudWatchEncryption(CloudWatchEncryption.builder().applyMutation(cloudWatchEncryption).build());
        }

        /**
         * <p>
         * The encryption configuration for job bookmarks.
         * </p>
         * 
         * @param jobBookmarksEncryption
         *        The encryption configuration for job bookmarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmarksEncryption(JobBookmarksEncryption jobBookmarksEncryption);

        /**
         * <p>
         * The encryption configuration for job bookmarks.
         * </p>
         * This is a convenience that creates an instance of the {@link JobBookmarksEncryption.Builder} avoiding the
         * need to create one manually via {@link JobBookmarksEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobBookmarksEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #jobBookmarksEncryption(JobBookmarksEncryption)}.
         * 
         * @param jobBookmarksEncryption
         *        a consumer that will call methods on {@link JobBookmarksEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobBookmarksEncryption(JobBookmarksEncryption)
         */
        default Builder jobBookmarksEncryption(Consumer<JobBookmarksEncryption.Builder> jobBookmarksEncryption) {
            return jobBookmarksEncryption(JobBookmarksEncryption.builder().applyMutation(jobBookmarksEncryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<S3Encryption> s3Encryption = DefaultSdkAutoConstructList.getInstance();

        private CloudWatchEncryption cloudWatchEncryption;

        private JobBookmarksEncryption jobBookmarksEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            s3Encryption(model.s3Encryption);
            cloudWatchEncryption(model.cloudWatchEncryption);
            jobBookmarksEncryption(model.jobBookmarksEncryption);
        }

        public final Collection<S3Encryption.Builder> getS3Encryption() {
            return s3Encryption != null ? s3Encryption.stream().map(S3Encryption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Encryption(Collection<S3Encryption> s3Encryption) {
            this.s3Encryption = S3EncryptionListCopier.copy(s3Encryption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Encryption(S3Encryption... s3Encryption) {
            s3Encryption(Arrays.asList(s3Encryption));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Encryption(Consumer<S3Encryption.Builder>... s3Encryption) {
            s3Encryption(Stream.of(s3Encryption).map(c -> S3Encryption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setS3Encryption(Collection<S3Encryption.BuilderImpl> s3Encryption) {
            this.s3Encryption = S3EncryptionListCopier.copyFromBuilder(s3Encryption);
        }

        public final CloudWatchEncryption.Builder getCloudWatchEncryption() {
            return cloudWatchEncryption != null ? cloudWatchEncryption.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchEncryption(CloudWatchEncryption cloudWatchEncryption) {
            this.cloudWatchEncryption = cloudWatchEncryption;
            return this;
        }

        public final void setCloudWatchEncryption(CloudWatchEncryption.BuilderImpl cloudWatchEncryption) {
            this.cloudWatchEncryption = cloudWatchEncryption != null ? cloudWatchEncryption.build() : null;
        }

        public final JobBookmarksEncryption.Builder getJobBookmarksEncryption() {
            return jobBookmarksEncryption != null ? jobBookmarksEncryption.toBuilder() : null;
        }

        @Override
        public final Builder jobBookmarksEncryption(JobBookmarksEncryption jobBookmarksEncryption) {
            this.jobBookmarksEncryption = jobBookmarksEncryption;
            return this;
        }

        public final void setJobBookmarksEncryption(JobBookmarksEncryption.BuilderImpl jobBookmarksEncryption) {
            this.jobBookmarksEncryption = jobBookmarksEncryption != null ? jobBookmarksEncryption.build() : null;
        }

        @Override
        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
