/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetJobsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetJobsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunResponse;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.glue.model.ConcurrentRunsExceededException;
import software.amazon.awssdk.services.glue.model.ConditionCheckFailureException;
import software.amazon.awssdk.services.glue.model.CrawlerNotRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerStoppingException;
import software.amazon.awssdk.services.glue.model.CreateClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateClassifierResponse;
import software.amazon.awssdk.services.glue.model.CreateConnectionRequest;
import software.amazon.awssdk.services.glue.model.CreateConnectionResponse;
import software.amazon.awssdk.services.glue.model.CreateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.CreateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.CreateJobRequest;
import software.amazon.awssdk.services.glue.model.CreateJobResponse;
import software.amazon.awssdk.services.glue.model.CreateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.CreateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CreateScriptRequest;
import software.amazon.awssdk.services.glue.model.CreateScriptResponse;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.CreateTriggerRequest;
import software.amazon.awssdk.services.glue.model.CreateTriggerResponse;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DeleteClassifierRequest;
import software.amazon.awssdk.services.glue.model.DeleteClassifierResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerRequest;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerResponse;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.DeleteJobRequest;
import software.amazon.awssdk.services.glue.model.DeleteJobResponse;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformRequest;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTriggerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTriggerResponse;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusResponse;
import software.amazon.awssdk.services.glue.model.GetClassifierRequest;
import software.amazon.awssdk.services.glue.model.GetClassifierResponse;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphRequest;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.GetJobRequest;
import software.amazon.awssdk.services.glue.model.GetJobResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;
import software.amazon.awssdk.services.glue.model.GetMappingRequest;
import software.amazon.awssdk.services.glue.model.GetMappingResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetPlanRequest;
import software.amazon.awssdk.services.glue.model.GetPlanResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GetTagsRequest;
import software.amazon.awssdk.services.glue.model.GetTagsResponse;
import software.amazon.awssdk.services.glue.model.GetTriggerRequest;
import software.amazon.awssdk.services.glue.model.GetTriggerResponse;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;
import software.amazon.awssdk.services.glue.model.GlueEncryptionException;
import software.amazon.awssdk.services.glue.model.GlueException;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.glue.model.IllegalWorkflowStateException;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueRequest;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueResponse;
import software.amazon.awssdk.services.glue.model.InternalServiceException;
import software.amazon.awssdk.services.glue.model.InvalidInputException;
import software.amazon.awssdk.services.glue.model.ListCrawlersRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlersResponse;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.ListJobsRequest;
import software.amazon.awssdk.services.glue.model.ListJobsResponse;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.MlTransformNotReadyException;
import software.amazon.awssdk.services.glue.model.NoScheduleException;
import software.amazon.awssdk.services.glue.model.OperationTimeoutException;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.SchedulerNotRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerTransitioningException;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartJobRunRequest;
import software.amazon.awssdk.services.glue.model.StartJobRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartTriggerRequest;
import software.amazon.awssdk.services.glue.model.StartTriggerResponse;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopTriggerRequest;
import software.amazon.awssdk.services.glue.model.StopTriggerResponse;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.TagResourceRequest;
import software.amazon.awssdk.services.glue.model.TagResourceResponse;
import software.amazon.awssdk.services.glue.model.UntagResourceRequest;
import software.amazon.awssdk.services.glue.model.UntagResourceResponse;
import software.amazon.awssdk.services.glue.model.UpdateClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateClassifierResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.glue.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateTriggerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTriggerResponse;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.ValidationException;
import software.amazon.awssdk.services.glue.model.VersionMismatchException;
import software.amazon.awssdk.services.glue.paginators.GetClassifiersPublisher;
import software.amazon.awssdk.services.glue.paginators.GetConnectionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetCrawlersPublisher;
import software.amazon.awssdk.services.glue.paginators.GetDatabasesPublisher;
import software.amazon.awssdk.services.glue.paginators.GetDevEndpointsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetJobRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetJobsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetMLTransformsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetPartitionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetTableVersionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetTablesPublisher;
import software.amazon.awssdk.services.glue.paginators.GetTriggersPublisher;
import software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListCrawlersPublisher;
import software.amazon.awssdk.services.glue.paginators.ListDevEndpointsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListMLTransformsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListTriggersPublisher;
import software.amazon.awssdk.services.glue.paginators.ListWorkflowsPublisher;
import software.amazon.awssdk.services.glue.paginators.SearchTablesPublisher;
import software.amazon.awssdk.services.glue.transform.BatchCreatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeletePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchStopJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CancelMlTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateScriptRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteColumnStatisticsForPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteColumnStatisticsForTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeletePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCatalogImportStatusRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetClassifiersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsForPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetColumnStatisticsForTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetConnectionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlerMetricsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataCatalogEncryptionSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDatabasesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataflowGraphRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobBookmarkRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMappingRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTaskRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTransformsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPlanRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSecurityConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableVersionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTablesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUserDefinedFunctionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunPropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ImportCatalogToGlueRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListMlTransformsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutDataCatalogEncryptionSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutWorkflowRunPropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ResetJobBookmarkRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ResumeWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.SearchTablesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartExportLabelsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartImportLabelsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartMlEvaluationTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartMlLabelingSetGenerationTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateColumnStatisticsForPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateColumnStatisticsForTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateWorkflowRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultGlueAsyncClient
implements GlueAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlueAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlueAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "glue";
    }

    @Override
    public CompletableFuture<BatchCreatePartitionResponse> batchCreatePartition(BatchCreatePartitionRequest batchCreatePartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchCreatePartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCreatePartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCreatePartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCreatePartition").withMarshaller((Marshaller)new BatchCreatePartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchCreatePartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchCreatePartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchCreatePartition$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchCreatePartition$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteConnectionResponse> batchDeleteConnection(BatchDeleteConnectionRequest batchDeleteConnectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteConnectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteConnection").withMarshaller((Marshaller)new BatchDeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDeleteConnectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchDeleteConnection$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchDeleteConnection$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeletePartitionResponse> batchDeletePartition(BatchDeletePartitionRequest batchDeletePartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeletePartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeletePartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeletePartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeletePartition").withMarshaller((Marshaller)new BatchDeletePartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeletePartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDeletePartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchDeletePartition$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchDeletePartition$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteTableResponse> batchDeleteTable(BatchDeleteTableRequest batchDeleteTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteTable").withMarshaller((Marshaller)new BatchDeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDeleteTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchDeleteTable$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchDeleteTable$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteTableVersionResponse> batchDeleteTableVersion(BatchDeleteTableVersionRequest batchDeleteTableVersionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteTableVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteTableVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteTableVersionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteTableVersion").withMarshaller((Marshaller)new BatchDeleteTableVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteTableVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDeleteTableVersionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchDeleteTableVersion$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchDeleteTableVersion$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetCrawlersResponse> batchGetCrawlers(BatchGetCrawlersRequest batchGetCrawlersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetCrawlersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetCrawlers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetCrawlersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetCrawlers").withMarshaller((Marshaller)new BatchGetCrawlersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetCrawlersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchGetCrawlersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchGetCrawlers$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchGetCrawlers$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetDevEndpointsResponse> batchGetDevEndpoints(BatchGetDevEndpointsRequest batchGetDevEndpointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetDevEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetDevEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetDevEndpointsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetDevEndpoints").withMarshaller((Marshaller)new BatchGetDevEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetDevEndpointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchGetDevEndpointsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchGetDevEndpoints$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchGetDevEndpoints$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetJobsResponse> batchGetJobs(BatchGetJobsRequest batchGetJobsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetJobsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetJobs").withMarshaller((Marshaller)new BatchGetJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchGetJobsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchGetJobs$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchGetJobs$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetPartitionResponse> batchGetPartition(BatchGetPartitionRequest batchGetPartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetPartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetPartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetPartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetPartition").withMarshaller((Marshaller)new BatchGetPartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetPartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchGetPartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchGetPartition$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchGetPartition$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetTriggersResponse> batchGetTriggers(BatchGetTriggersRequest batchGetTriggersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetTriggersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetTriggers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetTriggersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetTriggers").withMarshaller((Marshaller)new BatchGetTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetTriggersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchGetTriggersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchGetTriggers$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchGetTriggers$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetWorkflowsResponse> batchGetWorkflows(BatchGetWorkflowsRequest batchGetWorkflowsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetWorkflowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetWorkflows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetWorkflowsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetWorkflows").withMarshaller((Marshaller)new BatchGetWorkflowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetWorkflowsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchGetWorkflowsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchGetWorkflows$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchGetWorkflows$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchStopJobRunResponse> batchStopJobRun(BatchStopJobRunRequest batchStopJobRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchStopJobRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchStopJobRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchStopJobRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchStopJobRun").withMarshaller((Marshaller)new BatchStopJobRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchStopJobRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchStopJobRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$batchStopJobRun$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$batchStopJobRun$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelMlTaskRunResponse> cancelMLTaskRun(CancelMlTaskRunRequest cancelMlTaskRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, cancelMlTaskRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelMLTaskRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelMlTaskRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelMLTaskRun").withMarshaller((Marshaller)new CancelMlTaskRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelMlTaskRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelMlTaskRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$cancelMLTaskRun$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$cancelMLTaskRun$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClassifierResponse> createClassifier(CreateClassifierRequest createClassifierRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClassifierResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClassifier").withMarshaller((Marshaller)new CreateClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createClassifierRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createClassifier$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createClassifier$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnection").withMarshaller((Marshaller)new CreateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createConnectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createConnection$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createConnection$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCrawlerResponse> createCrawler(CreateCrawlerRequest createCrawlerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCrawlerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCrawler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCrawlerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCrawler").withMarshaller((Marshaller)new CreateCrawlerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCrawlerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCrawlerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createCrawler$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createCrawler$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDatabaseResponse> createDatabase(CreateDatabaseRequest createDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatabase").withMarshaller((Marshaller)new CreateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDatabaseRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createDatabase$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createDatabase$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDevEndpointResponse> createDevEndpoint(CreateDevEndpointRequest createDevEndpointRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDevEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDevEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDevEndpointResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDevEndpoint").withMarshaller((Marshaller)new CreateDevEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDevEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDevEndpointRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createDevEndpoint$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createDevEndpoint$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withMarshaller((Marshaller)new CreateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createJobRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createJob$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createJob$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMlTransformResponse> createMLTransform(CreateMlTransformRequest createMlTransformRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createMlTransformRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMLTransform");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMlTransformResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMLTransform").withMarshaller((Marshaller)new CreateMlTransformRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMlTransformRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createMlTransformRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createMLTransform$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createMLTransform$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePartitionResponse> createPartition(CreatePartitionRequest createPartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createPartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePartition").withMarshaller((Marshaller)new CreatePartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createPartition$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createPartition$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateScriptResponse> createScript(CreateScriptRequest createScriptRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createScriptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScript");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScriptResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScript").withMarshaller((Marshaller)new CreateScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createScriptRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createScriptRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createScript$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createScript$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSecurityConfigurationResponse> createSecurityConfiguration(CreateSecurityConfigurationRequest createSecurityConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createSecurityConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSecurityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSecurityConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSecurityConfiguration").withMarshaller((Marshaller)new CreateSecurityConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSecurityConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSecurityConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createSecurityConfiguration$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createSecurityConfiguration$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createTable$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createTable$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTriggerResponse> createTrigger(CreateTriggerRequest createTriggerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTriggerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrigger");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTriggerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrigger").withMarshaller((Marshaller)new CreateTriggerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTriggerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTriggerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createTrigger$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createTrigger$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserDefinedFunctionResponse> createUserDefinedFunction(CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createUserDefinedFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUserDefinedFunction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserDefinedFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserDefinedFunction").withMarshaller((Marshaller)new CreateUserDefinedFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserDefinedFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createUserDefinedFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createUserDefinedFunction$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createUserDefinedFunction$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, createWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkflowResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkflow").withMarshaller((Marshaller)new CreateWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createWorkflowRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createWorkflowRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$createWorkflow$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$createWorkflow$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteClassifierResponse> deleteClassifier(DeleteClassifierRequest deleteClassifierRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClassifierResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClassifier").withMarshaller((Marshaller)new DeleteClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClassifierRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteClassifier$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteClassifier$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteColumnStatisticsForPartitionResponse> deleteColumnStatisticsForPartition(DeleteColumnStatisticsForPartitionRequest deleteColumnStatisticsForPartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteColumnStatisticsForPartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteColumnStatisticsForPartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteColumnStatisticsForPartition").withMarshaller((Marshaller)new DeleteColumnStatisticsForPartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteColumnStatisticsForPartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteColumnStatisticsForPartition$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteColumnStatisticsForPartition$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteColumnStatisticsForTableResponse> deleteColumnStatisticsForTable(DeleteColumnStatisticsForTableRequest deleteColumnStatisticsForTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteColumnStatisticsForTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteColumnStatisticsForTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteColumnStatisticsForTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteColumnStatisticsForTable").withMarshaller((Marshaller)new DeleteColumnStatisticsForTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteColumnStatisticsForTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteColumnStatisticsForTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteColumnStatisticsForTable$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteColumnStatisticsForTable$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteConnectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteConnection$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteConnection$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCrawlerResponse> deleteCrawler(DeleteCrawlerRequest deleteCrawlerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteCrawlerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCrawler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCrawlerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCrawler").withMarshaller((Marshaller)new DeleteCrawlerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCrawlerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteCrawlerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteCrawler$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteCrawler$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDatabaseResponse> deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatabase").withMarshaller((Marshaller)new DeleteDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDatabaseRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteDatabase$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteDatabase$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDevEndpointResponse> deleteDevEndpoint(DeleteDevEndpointRequest deleteDevEndpointRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDevEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDevEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDevEndpointResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevEndpoint").withMarshaller((Marshaller)new DeleteDevEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDevEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDevEndpointRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteDevEndpoint$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteDevEndpoint$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJobResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJob").withMarshaller((Marshaller)new DeleteJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteJobRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteJob$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteJob$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMlTransformResponse> deleteMLTransform(DeleteMlTransformRequest deleteMlTransformRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteMlTransformRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMLTransform");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMlTransformResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMLTransform").withMarshaller((Marshaller)new DeleteMlTransformRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMlTransformRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMlTransformRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteMLTransform$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteMLTransform$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePartitionResponse> deletePartition(DeletePartitionRequest deletePartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deletePartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePartition").withMarshaller((Marshaller)new DeletePartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deletePartition$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deletePartition$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteResourcePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteResourcePolicy$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteResourcePolicy$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSecurityConfigurationResponse> deleteSecurityConfiguration(DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSecurityConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSecurityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSecurityConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSecurityConfiguration").withMarshaller((Marshaller)new DeleteSecurityConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSecurityConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSecurityConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteSecurityConfiguration$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteSecurityConfiguration$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteTable$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteTable$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTableVersionResponse> deleteTableVersion(DeleteTableVersionRequest deleteTableVersionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTableVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTableVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableVersionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTableVersion").withMarshaller((Marshaller)new DeleteTableVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTableVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTableVersionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteTableVersion$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteTableVersion$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTriggerResponse> deleteTrigger(DeleteTriggerRequest deleteTriggerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTriggerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrigger");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTriggerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrigger").withMarshaller((Marshaller)new DeleteTriggerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTriggerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTriggerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteTrigger$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteTrigger$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserDefinedFunctionResponse> deleteUserDefinedFunction(DeleteUserDefinedFunctionRequest deleteUserDefinedFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteUserDefinedFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUserDefinedFunction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserDefinedFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserDefinedFunction").withMarshaller((Marshaller)new DeleteUserDefinedFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteUserDefinedFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteUserDefinedFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteUserDefinedFunction$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteUserDefinedFunction$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkflowResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkflow").withMarshaller((Marshaller)new DeleteWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWorkflowRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteWorkflowRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$deleteWorkflow$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$deleteWorkflow$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCatalogImportStatusResponse> getCatalogImportStatus(GetCatalogImportStatusRequest getCatalogImportStatusRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCatalogImportStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCatalogImportStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCatalogImportStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCatalogImportStatus").withMarshaller((Marshaller)new GetCatalogImportStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCatalogImportStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCatalogImportStatusRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getCatalogImportStatus$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getCatalogImportStatus$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetClassifierResponse> getClassifier(GetClassifierRequest getClassifierRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClassifierResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClassifier").withMarshaller((Marshaller)new GetClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getClassifierRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getClassifier$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getClassifier$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetClassifiersResponse> getClassifiers(GetClassifiersRequest getClassifiersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getClassifiersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClassifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClassifiersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClassifiers").withMarshaller((Marshaller)new GetClassifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getClassifiersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getClassifiersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getClassifiers$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getClassifiers$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetClassifiersPublisher getClassifiersPaginator(GetClassifiersRequest getClassifiersRequest) {
        return new GetClassifiersPublisher(this, this.applyPaginatorUserAgent(getClassifiersRequest));
    }

    @Override
    public CompletableFuture<GetColumnStatisticsForPartitionResponse> getColumnStatisticsForPartition(GetColumnStatisticsForPartitionRequest getColumnStatisticsForPartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetColumnStatisticsForPartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetColumnStatisticsForPartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetColumnStatisticsForPartition").withMarshaller((Marshaller)new GetColumnStatisticsForPartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getColumnStatisticsForPartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getColumnStatisticsForPartition$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getColumnStatisticsForPartition$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetColumnStatisticsForTableResponse> getColumnStatisticsForTable(GetColumnStatisticsForTableRequest getColumnStatisticsForTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getColumnStatisticsForTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetColumnStatisticsForTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetColumnStatisticsForTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetColumnStatisticsForTable").withMarshaller((Marshaller)new GetColumnStatisticsForTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getColumnStatisticsForTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getColumnStatisticsForTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getColumnStatisticsForTable$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getColumnStatisticsForTable$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnection").withMarshaller((Marshaller)new GetConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getConnectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getConnection$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getConnection$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetConnectionsResponse> getConnections(GetConnectionsRequest getConnectionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnections").withMarshaller((Marshaller)new GetConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getConnectionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getConnectionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getConnections$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getConnections$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetConnectionsPublisher getConnectionsPaginator(GetConnectionsRequest getConnectionsRequest) {
        return new GetConnectionsPublisher(this, this.applyPaginatorUserAgent(getConnectionsRequest));
    }

    @Override
    public CompletableFuture<GetCrawlerResponse> getCrawler(GetCrawlerRequest getCrawlerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCrawlerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCrawler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCrawlerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCrawler").withMarshaller((Marshaller)new GetCrawlerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCrawlerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCrawlerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getCrawler$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getCrawler$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCrawlerMetricsResponse> getCrawlerMetrics(GetCrawlerMetricsRequest getCrawlerMetricsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCrawlerMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCrawlerMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCrawlerMetricsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCrawlerMetrics").withMarshaller((Marshaller)new GetCrawlerMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCrawlerMetricsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCrawlerMetricsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getCrawlerMetrics$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getCrawlerMetrics$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetCrawlerMetricsPublisher getCrawlerMetricsPaginator(GetCrawlerMetricsRequest getCrawlerMetricsRequest) {
        return new GetCrawlerMetricsPublisher(this, this.applyPaginatorUserAgent(getCrawlerMetricsRequest));
    }

    @Override
    public CompletableFuture<GetCrawlersResponse> getCrawlers(GetCrawlersRequest getCrawlersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCrawlersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCrawlers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCrawlersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCrawlers").withMarshaller((Marshaller)new GetCrawlersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCrawlersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCrawlersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getCrawlers$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getCrawlers$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetCrawlersPublisher getCrawlersPaginator(GetCrawlersRequest getCrawlersRequest) {
        return new GetCrawlersPublisher(this, this.applyPaginatorUserAgent(getCrawlersRequest));
    }

    @Override
    public CompletableFuture<GetDataCatalogEncryptionSettingsResponse> getDataCatalogEncryptionSettings(GetDataCatalogEncryptionSettingsRequest getDataCatalogEncryptionSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDataCatalogEncryptionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataCatalogEncryptionSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCatalogEncryptionSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCatalogEncryptionSettings").withMarshaller((Marshaller)new GetDataCatalogEncryptionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataCatalogEncryptionSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDataCatalogEncryptionSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getDataCatalogEncryptionSettings$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getDataCatalogEncryptionSettings$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDatabaseResponse> getDatabase(GetDatabaseRequest getDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatabase").withMarshaller((Marshaller)new GetDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDatabaseRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getDatabase$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getDatabase$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDatabasesResponse> getDatabases(GetDatabasesRequest getDatabasesRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatabasesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatabases").withMarshaller((Marshaller)new GetDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDatabasesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDatabasesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getDatabases$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getDatabases$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetDatabasesPublisher getDatabasesPaginator(GetDatabasesRequest getDatabasesRequest) {
        return new GetDatabasesPublisher(this, this.applyPaginatorUserAgent(getDatabasesRequest));
    }

    @Override
    public CompletableFuture<GetDataflowGraphResponse> getDataflowGraph(GetDataflowGraphRequest getDataflowGraphRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDataflowGraphRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataflowGraph");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataflowGraphResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataflowGraph").withMarshaller((Marshaller)new GetDataflowGraphRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataflowGraphRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDataflowGraphRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getDataflowGraph$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getDataflowGraph$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDevEndpointResponse> getDevEndpoint(GetDevEndpointRequest getDevEndpointRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDevEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevEndpointResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevEndpoint").withMarshaller((Marshaller)new GetDevEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDevEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDevEndpointRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getDevEndpoint$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getDevEndpoint$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDevEndpointsResponse> getDevEndpoints(GetDevEndpointsRequest getDevEndpointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDevEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevEndpointsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevEndpoints").withMarshaller((Marshaller)new GetDevEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDevEndpointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDevEndpointsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getDevEndpoints$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getDevEndpoints$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetDevEndpointsPublisher getDevEndpointsPaginator(GetDevEndpointsRequest getDevEndpointsRequest) {
        return new GetDevEndpointsPublisher(this, this.applyPaginatorUserAgent(getDevEndpointsRequest));
    }

    @Override
    public CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJob").withMarshaller((Marshaller)new GetJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJobRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getJob$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getJob$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobBookmarkResponse> getJobBookmark(GetJobBookmarkRequest getJobBookmarkRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getJobBookmarkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobBookmark");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobBookmarkResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobBookmark").withMarshaller((Marshaller)new GetJobBookmarkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobBookmarkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJobBookmarkRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getJobBookmark$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getJobBookmark$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobRunResponse> getJobRun(GetJobRunRequest getJobRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getJobRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobRun").withMarshaller((Marshaller)new GetJobRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJobRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getJobRun$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getJobRun$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobRunsResponse> getJobRuns(GetJobRunsRequest getJobRunsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getJobRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobRunsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobRuns").withMarshaller((Marshaller)new GetJobRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobRunsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJobRunsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getJobRuns$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getJobRuns$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetJobRunsPublisher getJobRunsPaginator(GetJobRunsRequest getJobRunsRequest) {
        return new GetJobRunsPublisher(this, this.applyPaginatorUserAgent(getJobRunsRequest));
    }

    @Override
    public CompletableFuture<GetJobsResponse> getJobs(GetJobsRequest getJobsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobs").withMarshaller((Marshaller)new GetJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getJobsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getJobs$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getJobs$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetJobsPublisher getJobsPaginator(GetJobsRequest getJobsRequest) {
        return new GetJobsPublisher(this, this.applyPaginatorUserAgent(getJobsRequest));
    }

    @Override
    public CompletableFuture<GetMlTaskRunResponse> getMLTaskRun(GetMlTaskRunRequest getMlTaskRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMlTaskRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLTaskRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlTaskRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLTaskRun").withMarshaller((Marshaller)new GetMlTaskRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMlTaskRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMlTaskRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getMLTaskRun$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getMLTaskRun$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMlTaskRunsResponse> getMLTaskRuns(GetMlTaskRunsRequest getMlTaskRunsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMlTaskRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLTaskRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlTaskRunsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLTaskRuns").withMarshaller((Marshaller)new GetMlTaskRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMlTaskRunsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMlTaskRunsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getMLTaskRuns$199(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getMLTaskRuns$200((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetMLTaskRunsPublisher getMLTaskRunsPaginator(GetMlTaskRunsRequest getMlTaskRunsRequest) {
        return new GetMLTaskRunsPublisher(this, this.applyPaginatorUserAgent(getMlTaskRunsRequest));
    }

    @Override
    public CompletableFuture<GetMlTransformResponse> getMLTransform(GetMlTransformRequest getMlTransformRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMlTransformRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLTransform");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlTransformResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLTransform").withMarshaller((Marshaller)new GetMlTransformRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMlTransformRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMlTransformRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getMLTransform$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getMLTransform$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMlTransformsResponse> getMLTransforms(GetMlTransformsRequest getMlTransformsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMlTransformsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMLTransforms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMlTransformsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMLTransforms").withMarshaller((Marshaller)new GetMlTransformsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMlTransformsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMlTransformsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getMLTransforms$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getMLTransforms$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetMLTransformsPublisher getMLTransformsPaginator(GetMlTransformsRequest getMlTransformsRequest) {
        return new GetMLTransformsPublisher(this, this.applyPaginatorUserAgent(getMlTransformsRequest));
    }

    @Override
    public CompletableFuture<GetMappingResponse> getMapping(GetMappingRequest getMappingRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMappingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMappingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMapping").withMarshaller((Marshaller)new GetMappingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMappingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMappingRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getMapping$208(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getMapping$209((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPartitionResponse> getPartition(GetPartitionRequest getPartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPartition").withMarshaller((Marshaller)new GetPartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getPartition$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getPartition$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPartitionsResponse> getPartitions(GetPartitionsRequest getPartitionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPartitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPartitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPartitionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPartitions").withMarshaller((Marshaller)new GetPartitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPartitionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPartitionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getPartitions$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getPartitions$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetPartitionsPublisher getPartitionsPaginator(GetPartitionsRequest getPartitionsRequest) {
        return new GetPartitionsPublisher(this, this.applyPaginatorUserAgent(getPartitionsRequest));
    }

    @Override
    public CompletableFuture<GetPlanResponse> getPlan(GetPlanRequest getPlanRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPlanResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPlan").withMarshaller((Marshaller)new GetPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPlanRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getPlan$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getPlan$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePoliciesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicies").withMarshaller((Marshaller)new GetResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getResourcePoliciesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getResourcePolicies$220(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getResourcePolicies$221((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getResourcePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getResourcePolicy$223(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getResourcePolicy$224((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSecurityConfigurationResponse> getSecurityConfiguration(GetSecurityConfigurationRequest getSecurityConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getSecurityConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSecurityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSecurityConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSecurityConfiguration").withMarshaller((Marshaller)new GetSecurityConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSecurityConfigurationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSecurityConfigurationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getSecurityConfiguration$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getSecurityConfiguration$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSecurityConfigurationsResponse> getSecurityConfigurations(GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getSecurityConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSecurityConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSecurityConfigurationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSecurityConfigurations").withMarshaller((Marshaller)new GetSecurityConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSecurityConfigurationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSecurityConfigurationsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getSecurityConfigurations$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getSecurityConfigurations$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetSecurityConfigurationsPublisher getSecurityConfigurationsPaginator(GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) {
        return new GetSecurityConfigurationsPublisher(this, this.applyPaginatorUserAgent(getSecurityConfigurationsRequest));
    }

    @Override
    public CompletableFuture<GetTableResponse> getTable(GetTableRequest getTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTable").withMarshaller((Marshaller)new GetTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTable$232(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTable$233((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTableVersionResponse> getTableVersion(GetTableVersionRequest getTableVersionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTableVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableVersionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableVersion").withMarshaller((Marshaller)new GetTableVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTableVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTableVersionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTableVersion$235(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTableVersion$236((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTableVersionsResponse> getTableVersions(GetTableVersionsRequest getTableVersionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTableVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableVersionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableVersions").withMarshaller((Marshaller)new GetTableVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTableVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTableVersionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTableVersions$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTableVersions$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetTableVersionsPublisher getTableVersionsPaginator(GetTableVersionsRequest getTableVersionsRequest) {
        return new GetTableVersionsPublisher(this, this.applyPaginatorUserAgent(getTableVersionsRequest));
    }

    @Override
    public CompletableFuture<GetTablesResponse> getTables(GetTablesRequest getTablesRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTablesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTables").withMarshaller((Marshaller)new GetTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTablesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTablesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTables$241(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTables$242((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetTablesPublisher getTablesPaginator(GetTablesRequest getTablesRequest) {
        return new GetTablesPublisher(this, this.applyPaginatorUserAgent(getTablesRequest));
    }

    @Override
    public CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTags").withMarshaller((Marshaller)new GetTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTags$244(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTags$245((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTriggerResponse> getTrigger(GetTriggerRequest getTriggerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTriggerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrigger");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTriggerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrigger").withMarshaller((Marshaller)new GetTriggerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTriggerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTriggerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTrigger$247(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTrigger$248((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTriggersResponse> getTriggers(GetTriggersRequest getTriggersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTriggersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTriggers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTriggersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTriggers").withMarshaller((Marshaller)new GetTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTriggersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTriggersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getTriggers$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getTriggers$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetTriggersPublisher getTriggersPaginator(GetTriggersRequest getTriggersRequest) {
        return new GetTriggersPublisher(this, this.applyPaginatorUserAgent(getTriggersRequest));
    }

    @Override
    public CompletableFuture<GetUserDefinedFunctionResponse> getUserDefinedFunction(GetUserDefinedFunctionRequest getUserDefinedFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getUserDefinedFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserDefinedFunction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserDefinedFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserDefinedFunction").withMarshaller((Marshaller)new GetUserDefinedFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUserDefinedFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUserDefinedFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getUserDefinedFunction$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getUserDefinedFunction$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUserDefinedFunctionsResponse> getUserDefinedFunctions(GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getUserDefinedFunctionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserDefinedFunctions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserDefinedFunctionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserDefinedFunctions").withMarshaller((Marshaller)new GetUserDefinedFunctionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUserDefinedFunctionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUserDefinedFunctionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getUserDefinedFunctions$256(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getUserDefinedFunctions$257((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetUserDefinedFunctionsPublisher getUserDefinedFunctionsPaginator(GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) {
        return new GetUserDefinedFunctionsPublisher(this, this.applyPaginatorUserAgent(getUserDefinedFunctionsRequest));
    }

    @Override
    public CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflow").withMarshaller((Marshaller)new GetWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkflowRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWorkflowRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getWorkflow$259(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getWorkflow$260((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkflowRunResponse> getWorkflowRun(GetWorkflowRunRequest getWorkflowRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getWorkflowRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflowRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflowRun").withMarshaller((Marshaller)new GetWorkflowRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkflowRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWorkflowRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getWorkflowRun$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getWorkflowRun$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkflowRunPropertiesResponse> getWorkflowRunProperties(GetWorkflowRunPropertiesRequest getWorkflowRunPropertiesRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getWorkflowRunPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflowRunProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowRunPropertiesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflowRunProperties").withMarshaller((Marshaller)new GetWorkflowRunPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkflowRunPropertiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWorkflowRunPropertiesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getWorkflowRunProperties$265(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getWorkflowRunProperties$266((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkflowRunsResponse> getWorkflowRuns(GetWorkflowRunsRequest getWorkflowRunsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, getWorkflowRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflowRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowRunsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflowRuns").withMarshaller((Marshaller)new GetWorkflowRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getWorkflowRunsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getWorkflowRunsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$getWorkflowRuns$268(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$getWorkflowRuns$269((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetWorkflowRunsPublisher getWorkflowRunsPaginator(GetWorkflowRunsRequest getWorkflowRunsRequest) {
        return new GetWorkflowRunsPublisher(this, this.applyPaginatorUserAgent(getWorkflowRunsRequest));
    }

    @Override
    public CompletableFuture<ImportCatalogToGlueResponse> importCatalogToGlue(ImportCatalogToGlueRequest importCatalogToGlueRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, importCatalogToGlueRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCatalogToGlue");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCatalogToGlueResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCatalogToGlue").withMarshaller((Marshaller)new ImportCatalogToGlueRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importCatalogToGlueRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importCatalogToGlueRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$importCatalogToGlue$271(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$importCatalogToGlue$272((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCrawlersResponse> listCrawlers(ListCrawlersRequest listCrawlersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, listCrawlersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCrawlers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCrawlersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCrawlers").withMarshaller((Marshaller)new ListCrawlersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCrawlersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listCrawlersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$listCrawlers$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$listCrawlers$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListCrawlersPublisher listCrawlersPaginator(ListCrawlersRequest listCrawlersRequest) {
        return new ListCrawlersPublisher(this, this.applyPaginatorUserAgent(listCrawlersRequest));
    }

    @Override
    public CompletableFuture<ListDevEndpointsResponse> listDevEndpoints(ListDevEndpointsRequest listDevEndpointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDevEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevEndpointsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevEndpoints").withMarshaller((Marshaller)new ListDevEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDevEndpointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDevEndpointsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$listDevEndpoints$277(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$listDevEndpoints$278((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListDevEndpointsPublisher listDevEndpointsPaginator(ListDevEndpointsRequest listDevEndpointsRequest) {
        return new ListDevEndpointsPublisher(this, this.applyPaginatorUserAgent(listDevEndpointsRequest));
    }

    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listJobsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$listJobs$280(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$listJobs$281((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    @Override
    public CompletableFuture<ListMlTransformsResponse> listMLTransforms(ListMlTransformsRequest listMlTransformsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, listMlTransformsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMLTransforms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMlTransformsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMLTransforms").withMarshaller((Marshaller)new ListMlTransformsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMlTransformsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMlTransformsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$listMLTransforms$283(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$listMLTransforms$284((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMLTransformsPublisher listMLTransformsPaginator(ListMlTransformsRequest listMlTransformsRequest) {
        return new ListMLTransformsPublisher(this, this.applyPaginatorUserAgent(listMlTransformsRequest));
    }

    @Override
    public CompletableFuture<ListTriggersResponse> listTriggers(ListTriggersRequest listTriggersRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTriggersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTriggers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTriggersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTriggers").withMarshaller((Marshaller)new ListTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTriggersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTriggersRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$listTriggers$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$listTriggers$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTriggersPublisher listTriggersPaginator(ListTriggersRequest listTriggersRequest) {
        return new ListTriggersPublisher(this, this.applyPaginatorUserAgent(listTriggersRequest));
    }

    @Override
    public CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, listWorkflowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkflows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflows").withMarshaller((Marshaller)new ListWorkflowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWorkflowsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listWorkflowsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$listWorkflows$289(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$listWorkflows$290((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListWorkflowsPublisher listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) {
        return new ListWorkflowsPublisher(this, this.applyPaginatorUserAgent(listWorkflowsRequest));
    }

    @Override
    public CompletableFuture<PutDataCatalogEncryptionSettingsResponse> putDataCatalogEncryptionSettings(PutDataCatalogEncryptionSettingsRequest putDataCatalogEncryptionSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, putDataCatalogEncryptionSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDataCatalogEncryptionSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDataCatalogEncryptionSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDataCatalogEncryptionSettings").withMarshaller((Marshaller)new PutDataCatalogEncryptionSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDataCatalogEncryptionSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putDataCatalogEncryptionSettingsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$putDataCatalogEncryptionSettings$292(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$putDataCatalogEncryptionSettings$293((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putResourcePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$putResourcePolicy$295(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$putResourcePolicy$296((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutWorkflowRunPropertiesResponse> putWorkflowRunProperties(PutWorkflowRunPropertiesRequest putWorkflowRunPropertiesRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, putWorkflowRunPropertiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWorkflowRunProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWorkflowRunPropertiesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWorkflowRunProperties").withMarshaller((Marshaller)new PutWorkflowRunPropertiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putWorkflowRunPropertiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putWorkflowRunPropertiesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$putWorkflowRunProperties$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$putWorkflowRunProperties$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetJobBookmarkResponse> resetJobBookmark(ResetJobBookmarkRequest resetJobBookmarkRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetJobBookmarkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetJobBookmark");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetJobBookmarkResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetJobBookmark").withMarshaller((Marshaller)new ResetJobBookmarkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetJobBookmarkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetJobBookmarkRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$resetJobBookmark$301(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$resetJobBookmark$302((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResumeWorkflowRunResponse> resumeWorkflowRun(ResumeWorkflowRunRequest resumeWorkflowRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, resumeWorkflowRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeWorkflowRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResumeWorkflowRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeWorkflowRun").withMarshaller((Marshaller)new ResumeWorkflowRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resumeWorkflowRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resumeWorkflowRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$resumeWorkflowRun$304(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$resumeWorkflowRun$305((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchTablesResponse> searchTables(SearchTablesRequest searchTablesRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, searchTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchTablesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchTables").withMarshaller((Marshaller)new SearchTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchTablesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = searchTablesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$searchTables$307(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$searchTables$308((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public SearchTablesPublisher searchTablesPaginator(SearchTablesRequest searchTablesRequest) {
        return new SearchTablesPublisher(this, this.applyPaginatorUserAgent(searchTablesRequest));
    }

    @Override
    public CompletableFuture<StartCrawlerResponse> startCrawler(StartCrawlerRequest startCrawlerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startCrawlerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCrawler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCrawlerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCrawler").withMarshaller((Marshaller)new StartCrawlerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startCrawlerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startCrawlerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startCrawler$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startCrawler$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartCrawlerScheduleResponse> startCrawlerSchedule(StartCrawlerScheduleRequest startCrawlerScheduleRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startCrawlerScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCrawlerSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCrawlerScheduleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCrawlerSchedule").withMarshaller((Marshaller)new StartCrawlerScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startCrawlerScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startCrawlerScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startCrawlerSchedule$313(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startCrawlerSchedule$314((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartExportLabelsTaskRunResponse> startExportLabelsTaskRun(StartExportLabelsTaskRunRequest startExportLabelsTaskRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startExportLabelsTaskRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExportLabelsTaskRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExportLabelsTaskRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExportLabelsTaskRun").withMarshaller((Marshaller)new StartExportLabelsTaskRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startExportLabelsTaskRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startExportLabelsTaskRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startExportLabelsTaskRun$316(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startExportLabelsTaskRun$317((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartImportLabelsTaskRunResponse> startImportLabelsTaskRun(StartImportLabelsTaskRunRequest startImportLabelsTaskRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startImportLabelsTaskRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartImportLabelsTaskRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartImportLabelsTaskRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartImportLabelsTaskRun").withMarshaller((Marshaller)new StartImportLabelsTaskRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startImportLabelsTaskRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startImportLabelsTaskRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startImportLabelsTaskRun$319(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startImportLabelsTaskRun$320((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartJobRunResponse> startJobRun(StartJobRunRequest startJobRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startJobRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartJobRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartJobRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartJobRun").withMarshaller((Marshaller)new StartJobRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startJobRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startJobRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startJobRun$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startJobRun$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartMlEvaluationTaskRunResponse> startMLEvaluationTaskRun(StartMlEvaluationTaskRunRequest startMlEvaluationTaskRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startMlEvaluationTaskRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMLEvaluationTaskRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMlEvaluationTaskRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMLEvaluationTaskRun").withMarshaller((Marshaller)new StartMlEvaluationTaskRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startMlEvaluationTaskRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startMlEvaluationTaskRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startMLEvaluationTaskRun$325(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startMLEvaluationTaskRun$326((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartMlLabelingSetGenerationTaskRunResponse> startMLLabelingSetGenerationTaskRun(StartMlLabelingSetGenerationTaskRunRequest startMlLabelingSetGenerationTaskRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startMlLabelingSetGenerationTaskRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMLLabelingSetGenerationTaskRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMlLabelingSetGenerationTaskRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMLLabelingSetGenerationTaskRun").withMarshaller((Marshaller)new StartMlLabelingSetGenerationTaskRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startMlLabelingSetGenerationTaskRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startMlLabelingSetGenerationTaskRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startMLLabelingSetGenerationTaskRun$328(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startMLLabelingSetGenerationTaskRun$329((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartTriggerResponse> startTrigger(StartTriggerRequest startTriggerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startTriggerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTrigger");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTriggerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTrigger").withMarshaller((Marshaller)new StartTriggerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startTriggerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startTriggerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startTrigger$331(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startTrigger$332((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartWorkflowRunResponse> startWorkflowRun(StartWorkflowRunRequest startWorkflowRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, startWorkflowRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartWorkflowRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkflowRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartWorkflowRun").withMarshaller((Marshaller)new StartWorkflowRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startWorkflowRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startWorkflowRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$startWorkflowRun$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$startWorkflowRun$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopCrawlerResponse> stopCrawler(StopCrawlerRequest stopCrawlerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopCrawlerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopCrawler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCrawlerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCrawler").withMarshaller((Marshaller)new StopCrawlerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopCrawlerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopCrawlerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$stopCrawler$337(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$stopCrawler$338((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopCrawlerScheduleResponse> stopCrawlerSchedule(StopCrawlerScheduleRequest stopCrawlerScheduleRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopCrawlerScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopCrawlerSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCrawlerScheduleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCrawlerSchedule").withMarshaller((Marshaller)new StopCrawlerScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopCrawlerScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopCrawlerScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$stopCrawlerSchedule$340(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$stopCrawlerSchedule$341((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopTriggerResponse> stopTrigger(StopTriggerRequest stopTriggerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopTriggerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrigger");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTriggerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrigger").withMarshaller((Marshaller)new StopTriggerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopTriggerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopTriggerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$stopTrigger$343(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$stopTrigger$344((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopWorkflowRunResponse> stopWorkflowRun(StopWorkflowRunRequest stopWorkflowRunRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopWorkflowRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopWorkflowRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopWorkflowRunResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopWorkflowRun").withMarshaller((Marshaller)new StopWorkflowRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopWorkflowRunRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopWorkflowRunRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$stopWorkflowRun$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$stopWorkflowRun$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$tagResource$349(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$tagResource$350((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$untagResource$352(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$untagResource$353((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateClassifierResponse> updateClassifier(UpdateClassifierRequest updateClassifierRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClassifierResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateClassifier").withMarshaller((Marshaller)new UpdateClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateClassifierRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateClassifier$355(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateClassifier$356((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateColumnStatisticsForPartitionResponse> updateColumnStatisticsForPartition(UpdateColumnStatisticsForPartitionRequest updateColumnStatisticsForPartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateColumnStatisticsForPartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateColumnStatisticsForPartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateColumnStatisticsForPartition").withMarshaller((Marshaller)new UpdateColumnStatisticsForPartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateColumnStatisticsForPartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateColumnStatisticsForPartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateColumnStatisticsForPartition$358(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateColumnStatisticsForPartition$359((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateColumnStatisticsForTableResponse> updateColumnStatisticsForTable(UpdateColumnStatisticsForTableRequest updateColumnStatisticsForTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateColumnStatisticsForTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateColumnStatisticsForTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateColumnStatisticsForTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateColumnStatisticsForTable").withMarshaller((Marshaller)new UpdateColumnStatisticsForTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateColumnStatisticsForTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateColumnStatisticsForTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateColumnStatisticsForTable$361(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateColumnStatisticsForTable$362((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest updateConnectionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnection").withMarshaller((Marshaller)new UpdateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateConnectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateConnectionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateConnection$364(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateConnection$365((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCrawlerResponse> updateCrawler(UpdateCrawlerRequest updateCrawlerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateCrawlerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCrawler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCrawlerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCrawler").withMarshaller((Marshaller)new UpdateCrawlerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCrawlerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateCrawlerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateCrawler$367(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateCrawler$368((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCrawlerScheduleResponse> updateCrawlerSchedule(UpdateCrawlerScheduleRequest updateCrawlerScheduleRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateCrawlerScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCrawlerSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCrawlerScheduleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCrawlerSchedule").withMarshaller((Marshaller)new UpdateCrawlerScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCrawlerScheduleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateCrawlerScheduleRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateCrawlerSchedule$370(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateCrawlerSchedule$371((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDatabaseResponse> updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatabase").withMarshaller((Marshaller)new UpdateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDatabaseRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateDatabase$373(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateDatabase$374((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDevEndpointResponse> updateDevEndpoint(UpdateDevEndpointRequest updateDevEndpointRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDevEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDevEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDevEndpointResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDevEndpoint").withMarshaller((Marshaller)new UpdateDevEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDevEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDevEndpointRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateDevEndpoint$376(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateDevEndpoint$377((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJob").withMarshaller((Marshaller)new UpdateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateJobRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateJob$379(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateJob$380((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMlTransformResponse> updateMLTransform(UpdateMlTransformRequest updateMlTransformRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateMlTransformRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMLTransform");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMlTransformResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMLTransform").withMarshaller((Marshaller)new UpdateMlTransformRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateMlTransformRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateMlTransformRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateMLTransform$382(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateMLTransform$383((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePartitionResponse> updatePartition(UpdatePartitionRequest updatePartitionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePartitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePartition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePartitionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePartition").withMarshaller((Marshaller)new UpdatePartitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePartitionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePartitionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updatePartition$385(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updatePartition$386((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTableRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTableRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateTable$388(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateTable$389((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTriggerResponse> updateTrigger(UpdateTriggerRequest updateTriggerRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTriggerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrigger");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTriggerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrigger").withMarshaller((Marshaller)new UpdateTriggerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTriggerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTriggerRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateTrigger$391(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateTrigger$392((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserDefinedFunctionResponse> updateUserDefinedFunction(UpdateUserDefinedFunctionRequest updateUserDefinedFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateUserDefinedFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUserDefinedFunction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserDefinedFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserDefinedFunction").withMarshaller((Marshaller)new UpdateUserDefinedFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateUserDefinedFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateUserDefinedFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateUserDefinedFunction$394(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateUserDefinedFunction$395((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateWorkflowResponse> updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) {
        List<MetricPublisher> metricPublishers = DefaultGlueAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Glue");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkflowResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkflow").withMarshaller((Marshaller)new UpdateWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateWorkflowRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateWorkflowRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultGlueAsyncClient.lambda$updateWorkflow$397(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultGlueAsyncClient.lambda$updateWorkflow$398((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GlueException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SchedulerRunningException").exceptionBuilderSupplier(SchedulerRunningException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SchedulerTransitioningException").exceptionBuilderSupplier(SchedulerTransitioningException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CrawlerRunningException").exceptionBuilderSupplier(CrawlerRunningException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CrawlerStoppingException").exceptionBuilderSupplier(CrawlerStoppingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CrawlerNotRunningException").exceptionBuilderSupplier(CrawlerNotRunningException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VersionMismatchException").exceptionBuilderSupplier(VersionMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoScheduleException").exceptionBuilderSupplier(NoScheduleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MLTransformNotReadyException").exceptionBuilderSupplier(MlTransformNotReadyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException").exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException").exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SchedulerNotRunningException").exceptionBuilderSupplier(SchedulerNotRunningException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConditionCheckFailureException").exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends GlueRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.63").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GlueRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private static /* synthetic */ void lambda$updateWorkflow$398(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkflow$397(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateWorkflowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateUserDefinedFunction$395(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUserDefinedFunction$394(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateUserDefinedFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTrigger$392(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTrigger$391(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTriggerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTable$389(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$388(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePartition$386(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePartition$385(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateMLTransform$383(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMLTransform$382(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateMlTransformResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateJob$380(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJob$379(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDevEndpoint$377(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDevEndpoint$376(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDevEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDatabase$374(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatabase$373(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCrawlerSchedule$371(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCrawlerSchedule$370(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCrawlerScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCrawler$368(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCrawler$367(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCrawlerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateConnection$365(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnection$364(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateColumnStatisticsForTable$362(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateColumnStatisticsForTable$361(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateColumnStatisticsForTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateColumnStatisticsForPartition$359(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateColumnStatisticsForPartition$358(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateColumnStatisticsForPartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateClassifier$356(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateClassifier$355(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$353(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$352(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$350(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$349(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopWorkflowRun$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopWorkflowRun$346(List metricPublishers, MetricCollector apiCallMetricCollector, StopWorkflowRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopTrigger$344(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrigger$343(List metricPublishers, MetricCollector apiCallMetricCollector, StopTriggerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopCrawlerSchedule$341(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopCrawlerSchedule$340(List metricPublishers, MetricCollector apiCallMetricCollector, StopCrawlerScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopCrawler$338(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopCrawler$337(List metricPublishers, MetricCollector apiCallMetricCollector, StopCrawlerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startWorkflowRun$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startWorkflowRun$334(List metricPublishers, MetricCollector apiCallMetricCollector, StartWorkflowRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startTrigger$332(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTrigger$331(List metricPublishers, MetricCollector apiCallMetricCollector, StartTriggerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startMLLabelingSetGenerationTaskRun$329(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMLLabelingSetGenerationTaskRun$328(List metricPublishers, MetricCollector apiCallMetricCollector, StartMlLabelingSetGenerationTaskRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startMLEvaluationTaskRun$326(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMLEvaluationTaskRun$325(List metricPublishers, MetricCollector apiCallMetricCollector, StartMlEvaluationTaskRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startJobRun$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startJobRun$322(List metricPublishers, MetricCollector apiCallMetricCollector, StartJobRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startImportLabelsTaskRun$320(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startImportLabelsTaskRun$319(List metricPublishers, MetricCollector apiCallMetricCollector, StartImportLabelsTaskRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startExportLabelsTaskRun$317(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExportLabelsTaskRun$316(List metricPublishers, MetricCollector apiCallMetricCollector, StartExportLabelsTaskRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startCrawlerSchedule$314(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCrawlerSchedule$313(List metricPublishers, MetricCollector apiCallMetricCollector, StartCrawlerScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startCrawler$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCrawler$310(List metricPublishers, MetricCollector apiCallMetricCollector, StartCrawlerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchTables$308(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchTables$307(List metricPublishers, MetricCollector apiCallMetricCollector, SearchTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resumeWorkflowRun$305(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeWorkflowRun$304(List metricPublishers, MetricCollector apiCallMetricCollector, ResumeWorkflowRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetJobBookmark$302(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetJobBookmark$301(List metricPublishers, MetricCollector apiCallMetricCollector, ResetJobBookmarkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putWorkflowRunProperties$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWorkflowRunProperties$298(List metricPublishers, MetricCollector apiCallMetricCollector, PutWorkflowRunPropertiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$296(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$295(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putDataCatalogEncryptionSettings$293(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDataCatalogEncryptionSettings$292(List metricPublishers, MetricCollector apiCallMetricCollector, PutDataCatalogEncryptionSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWorkflows$290(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkflows$289(List metricPublishers, MetricCollector apiCallMetricCollector, ListWorkflowsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTriggers$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTriggers$286(List metricPublishers, MetricCollector apiCallMetricCollector, ListTriggersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMLTransforms$284(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMLTransforms$283(List metricPublishers, MetricCollector apiCallMetricCollector, ListMlTransformsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listJobs$281(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$280(List metricPublishers, MetricCollector apiCallMetricCollector, ListJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDevEndpoints$278(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevEndpoints$277(List metricPublishers, MetricCollector apiCallMetricCollector, ListDevEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCrawlers$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCrawlers$274(List metricPublishers, MetricCollector apiCallMetricCollector, ListCrawlersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importCatalogToGlue$272(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCatalogToGlue$271(List metricPublishers, MetricCollector apiCallMetricCollector, ImportCatalogToGlueResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflowRuns$269(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflowRuns$268(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflowRunProperties$266(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflowRunProperties$265(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowRunPropertiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflowRun$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflowRun$262(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflow$260(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflow$259(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUserDefinedFunctions$257(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserDefinedFunctions$256(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserDefinedFunctionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUserDefinedFunction$254(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserDefinedFunction$253(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserDefinedFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTriggers$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTriggers$250(List metricPublishers, MetricCollector apiCallMetricCollector, GetTriggersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTrigger$248(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrigger$247(List metricPublishers, MetricCollector apiCallMetricCollector, GetTriggerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTags$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTags$244(List metricPublishers, MetricCollector apiCallMetricCollector, GetTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTables$242(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTables$241(List metricPublishers, MetricCollector apiCallMetricCollector, GetTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTableVersions$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableVersions$238(List metricPublishers, MetricCollector apiCallMetricCollector, GetTableVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTableVersion$236(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableVersion$235(List metricPublishers, MetricCollector apiCallMetricCollector, GetTableVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTable$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTable$232(List metricPublishers, MetricCollector apiCallMetricCollector, GetTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSecurityConfigurations$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSecurityConfigurations$229(List metricPublishers, MetricCollector apiCallMetricCollector, GetSecurityConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSecurityConfiguration$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSecurityConfiguration$226(List metricPublishers, MetricCollector apiCallMetricCollector, GetSecurityConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicy$224(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$223(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicies$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicies$220(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPlan$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPlan$217(List metricPublishers, MetricCollector apiCallMetricCollector, GetPlanResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPartitions$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPartitions$214(List metricPublishers, MetricCollector apiCallMetricCollector, GetPartitionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPartition$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPartition$211(List metricPublishers, MetricCollector apiCallMetricCollector, GetPartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMapping$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMapping$208(List metricPublishers, MetricCollector apiCallMetricCollector, GetMappingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMLTransforms$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLTransforms$205(List metricPublishers, MetricCollector apiCallMetricCollector, GetMlTransformsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMLTransform$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLTransform$202(List metricPublishers, MetricCollector apiCallMetricCollector, GetMlTransformResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMLTaskRuns$200(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLTaskRuns$199(List metricPublishers, MetricCollector apiCallMetricCollector, GetMlTaskRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMLTaskRun$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMLTaskRun$196(List metricPublishers, MetricCollector apiCallMetricCollector, GetMlTaskRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobs$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobs$193(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobRuns$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobRuns$190(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobRun$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobRun$187(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobBookmark$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobBookmark$184(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobBookmarkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJob$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJob$181(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDevEndpoints$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevEndpoints$178(List metricPublishers, MetricCollector apiCallMetricCollector, GetDevEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDevEndpoint$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevEndpoint$175(List metricPublishers, MetricCollector apiCallMetricCollector, GetDevEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataflowGraph$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataflowGraph$172(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataflowGraphResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDatabases$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatabases$169(List metricPublishers, MetricCollector apiCallMetricCollector, GetDatabasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDatabase$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDatabase$166(List metricPublishers, MetricCollector apiCallMetricCollector, GetDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataCatalogEncryptionSettings$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataCatalogEncryptionSettings$163(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataCatalogEncryptionSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCrawlers$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCrawlers$160(List metricPublishers, MetricCollector apiCallMetricCollector, GetCrawlersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCrawlerMetrics$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCrawlerMetrics$157(List metricPublishers, MetricCollector apiCallMetricCollector, GetCrawlerMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCrawler$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCrawler$154(List metricPublishers, MetricCollector apiCallMetricCollector, GetCrawlerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getConnections$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnections$151(List metricPublishers, MetricCollector apiCallMetricCollector, GetConnectionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getConnection$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnection$148(List metricPublishers, MetricCollector apiCallMetricCollector, GetConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getColumnStatisticsForTable$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getColumnStatisticsForTable$145(List metricPublishers, MetricCollector apiCallMetricCollector, GetColumnStatisticsForTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getColumnStatisticsForPartition$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getColumnStatisticsForPartition$142(List metricPublishers, MetricCollector apiCallMetricCollector, GetColumnStatisticsForPartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getClassifiers$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClassifiers$139(List metricPublishers, MetricCollector apiCallMetricCollector, GetClassifiersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getClassifier$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClassifier$136(List metricPublishers, MetricCollector apiCallMetricCollector, GetClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCatalogImportStatus$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCatalogImportStatus$133(List metricPublishers, MetricCollector apiCallMetricCollector, GetCatalogImportStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWorkflow$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkflow$130(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWorkflowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteUserDefinedFunction$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUserDefinedFunction$127(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteUserDefinedFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTrigger$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrigger$124(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTriggerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTableVersion$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTableVersion$121(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTableVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTable$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$118(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSecurityConfiguration$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSecurityConfiguration$115(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSecurityConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$112(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePartition$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePartition$109(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMLTransform$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMLTransform$106(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMlTransformResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteJob$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJob$103(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDevEndpoint$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDevEndpoint$100(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDevEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDatabase$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatabase$97(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCrawler$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCrawler$94(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCrawlerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteConnection$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnection$91(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteColumnStatisticsForTable$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteColumnStatisticsForTable$88(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteColumnStatisticsForTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteColumnStatisticsForPartition$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteColumnStatisticsForPartition$85(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteColumnStatisticsForPartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteClassifier$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClassifier$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createWorkflow$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkflow$79(List metricPublishers, MetricCollector apiCallMetricCollector, CreateWorkflowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUserDefinedFunction$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUserDefinedFunction$76(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUserDefinedFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTrigger$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrigger$73(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTriggerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTable$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$70(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSecurityConfiguration$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSecurityConfiguration$67(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSecurityConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createScript$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScript$64(List metricPublishers, MetricCollector apiCallMetricCollector, CreateScriptResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPartition$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPartition$61(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMLTransform$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMLTransform$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMlTransformResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createJob$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$55(List metricPublishers, MetricCollector apiCallMetricCollector, CreateJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDevEndpoint$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDevEndpoint$52(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDevEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDatabase$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatabase$49(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCrawler$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCrawler$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCrawlerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createConnection$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnection$43(List metricPublishers, MetricCollector apiCallMetricCollector, CreateConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createClassifier$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createClassifier$40(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClassifierResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelMLTaskRun$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelMLTaskRun$37(List metricPublishers, MetricCollector apiCallMetricCollector, CancelMlTaskRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchStopJobRun$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchStopJobRun$34(List metricPublishers, MetricCollector apiCallMetricCollector, BatchStopJobRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetWorkflows$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetWorkflows$31(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetWorkflowsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetTriggers$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetTriggers$28(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetTriggersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetPartition$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetPartition$25(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetPartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetJobs$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetJobs$22(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetDevEndpoints$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetDevEndpoints$19(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetDevEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetCrawlers$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetCrawlers$16(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetCrawlersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteTableVersion$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteTableVersion$13(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteTableVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteTable$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteTable$10(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeletePartition$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeletePartition$7(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeletePartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteConnection$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteConnection$4(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteConnectionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchCreatePartition$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCreatePartition$1(List metricPublishers, MetricCollector apiCallMetricCollector, BatchCreatePartitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

