/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.LastCrawlStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastCrawlInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastCrawlInfo> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LastCrawlInfo.getter(LastCrawlInfo::statusAsString)).setter(LastCrawlInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LastCrawlInfo.getter(LastCrawlInfo::errorMessage)).setter(LastCrawlInfo.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LastCrawlInfo.getter(LastCrawlInfo::logGroup)).setter(LastCrawlInfo.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()}).build();
    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LastCrawlInfo.getter(LastCrawlInfo::logStream)).setter(LastCrawlInfo.setter(Builder::logStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()}).build();
    private static final SdkField<String> MESSAGE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LastCrawlInfo.getter(LastCrawlInfo::messagePrefix)).setter(LastCrawlInfo.setter(Builder::messagePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagePrefix").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LastCrawlInfo.getter(LastCrawlInfo::startTime)).setter(LastCrawlInfo.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ERROR_MESSAGE_FIELD, LOG_GROUP_FIELD, LOG_STREAM_FIELD, MESSAGE_PREFIX_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String errorMessage;
    private final String logGroup;
    private final String logStream;
    private final String messagePrefix;
    private final Instant startTime;

    private LastCrawlInfo(BuilderImpl builder) {
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
        this.messagePrefix = builder.messagePrefix;
        this.startTime = builder.startTime;
    }

    public LastCrawlStatus status() {
        return LastCrawlStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String logGroup() {
        return this.logGroup;
    }

    public String logStream() {
        return this.logStream;
    }

    public String messagePrefix() {
        return this.messagePrefix;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.messagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastCrawlInfo)) {
            return false;
        }
        LastCrawlInfo other = (LastCrawlInfo)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.logGroup(), other.logGroup()) && Objects.equals(this.logStream(), other.logStream()) && Objects.equals(this.messagePrefix(), other.messagePrefix()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"LastCrawlInfo").add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("LogGroup", (Object)this.logGroup()).add("LogStream", (Object)this.logStream()).add("MessagePrefix", (Object)this.messagePrefix()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
            case "LogStream": {
                return Optional.ofNullable(clazz.cast(this.logStream()));
            }
            case "MessagePrefix": {
                return Optional.ofNullable(clazz.cast(this.messagePrefix()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LastCrawlInfo, T> g) {
        return obj -> g.apply((LastCrawlInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String errorMessage;
        private String logGroup;
        private String logStream;
        private String messagePrefix;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastCrawlInfo model) {
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.logGroup(model.logGroup);
            this.logStream(model.logStream);
            this.messagePrefix(model.messagePrefix);
            this.startTime(model.startTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LastCrawlStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public final String getLogStream() {
            return this.logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        public final String getMessagePrefix() {
            return this.messagePrefix;
        }

        @Override
        public final Builder messagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public final void setMessagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public LastCrawlInfo build() {
            return new LastCrawlInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastCrawlInfo> {
        public Builder status(String var1);

        public Builder status(LastCrawlStatus var1);

        public Builder errorMessage(String var1);

        public Builder logGroup(String var1);

        public Builder logStream(String var1);

        public Builder messagePrefix(String var1);

        public Builder startTime(Instant var1);
    }
}

