/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the equivalent of a Hive user-defined function (<code>UDF</code>) definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserDefinedFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<UserDefinedFunction.Builder, UserDefinedFunction> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserDefinedFunction::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserDefinedFunction::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> CLASS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserDefinedFunction::className)).setter(setter(Builder::className))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassName").build()).build();

    private static final SdkField<String> OWNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserDefinedFunction::ownerName)).setter(setter(Builder::ownerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerName").build()).build();

    private static final SdkField<String> OWNER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UserDefinedFunction::ownerTypeAsString)).setter(setter(Builder::ownerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerType").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UserDefinedFunction::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<List<ResourceUri>> RESOURCE_URIS_FIELD = SdkField
            .<List<ResourceUri>> builder(MarshallingType.LIST)
            .getter(getter(UserDefinedFunction::resourceUris))
            .setter(setter(Builder::resourceUris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUris").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceUri> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceUri::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            DATABASE_NAME_FIELD, CLASS_NAME_FIELD, OWNER_NAME_FIELD, OWNER_TYPE_FIELD, CREATE_TIME_FIELD, RESOURCE_URIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionName;

    private final String databaseName;

    private final String className;

    private final String ownerName;

    private final String ownerType;

    private final Instant createTime;

    private final List<ResourceUri> resourceUris;

    private UserDefinedFunction(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.databaseName = builder.databaseName;
        this.className = builder.className;
        this.ownerName = builder.ownerName;
        this.ownerType = builder.ownerType;
        this.createTime = builder.createTime;
        this.resourceUris = builder.resourceUris;
    }

    /**
     * <p>
     * The name of the function.
     * </p>
     * 
     * @return The name of the function.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The name of the database where the function resides.
     * </p>
     * 
     * @return The name of the database where the function resides.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The Java class that contains the function code.
     * </p>
     * 
     * @return The Java class that contains the function code.
     */
    public String className() {
        return className;
    }

    /**
     * <p>
     * The owner of the function.
     * </p>
     * 
     * @return The owner of the function.
     */
    public String ownerName() {
        return ownerName;
    }

    /**
     * <p>
     * The owner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ownerType} will
     * return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerTypeAsString}.
     * </p>
     * 
     * @return The owner type.
     * @see PrincipalType
     */
    public PrincipalType ownerType() {
        return PrincipalType.fromValue(ownerType);
    }

    /**
     * <p>
     * The owner type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ownerType} will
     * return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerTypeAsString}.
     * </p>
     * 
     * @return The owner type.
     * @see PrincipalType
     */
    public String ownerTypeAsString() {
        return ownerType;
    }

    /**
     * <p>
     * The time at which the function was created.
     * </p>
     * 
     * @return The time at which the function was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * Returns true if the ResourceUris property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceUris() {
        return resourceUris != null && !(resourceUris instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource URIs for the function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceUris()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The resource URIs for the function.
     */
    public List<ResourceUri> resourceUris() {
        return resourceUris;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(className());
        hashCode = 31 * hashCode + Objects.hashCode(ownerName());
        hashCode = 31 * hashCode + Objects.hashCode(ownerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceUris());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDefinedFunction)) {
            return false;
        }
        UserDefinedFunction other = (UserDefinedFunction) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(className(), other.className()) && Objects.equals(ownerName(), other.ownerName())
                && Objects.equals(ownerTypeAsString(), other.ownerTypeAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(resourceUris(), other.resourceUris());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UserDefinedFunction").add("FunctionName", functionName()).add("DatabaseName", databaseName())
                .add("ClassName", className()).add("OwnerName", ownerName()).add("OwnerType", ownerTypeAsString())
                .add("CreateTime", createTime()).add("ResourceUris", resourceUris()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "ClassName":
            return Optional.ofNullable(clazz.cast(className()));
        case "OwnerName":
            return Optional.ofNullable(clazz.cast(ownerName()));
        case "OwnerType":
            return Optional.ofNullable(clazz.cast(ownerTypeAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "ResourceUris":
            return Optional.ofNullable(clazz.cast(resourceUris()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDefinedFunction, T> g) {
        return obj -> g.apply((UserDefinedFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserDefinedFunction> {
        /**
         * <p>
         * The name of the function.
         * </p>
         * 
         * @param functionName
         *        The name of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The name of the database where the function resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the database where the function resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The Java class that contains the function code.
         * </p>
         * 
         * @param className
         *        The Java class that contains the function code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder className(String className);

        /**
         * <p>
         * The owner of the function.
         * </p>
         * 
         * @param ownerName
         *        The owner of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerName(String ownerName);

        /**
         * <p>
         * The owner type.
         * </p>
         * 
         * @param ownerType
         *        The owner type.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder ownerType(String ownerType);

        /**
         * <p>
         * The owner type.
         * </p>
         * 
         * @param ownerType
         *        The owner type.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder ownerType(PrincipalType ownerType);

        /**
         * <p>
         * The time at which the function was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the function was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The resource URIs for the function.
         * </p>
         * 
         * @param resourceUris
         *        The resource URIs for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceUris(Collection<ResourceUri> resourceUris);

        /**
         * <p>
         * The resource URIs for the function.
         * </p>
         * 
         * @param resourceUris
         *        The resource URIs for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceUris(ResourceUri... resourceUris);

        /**
         * <p>
         * The resource URIs for the function.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceUri>.Builder} avoiding the need to
         * create one manually via {@link List<ResourceUri>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceUri>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceUris(List<ResourceUri>)}.
         * 
         * @param resourceUris
         *        a consumer that will call methods on {@link List<ResourceUri>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceUris(List<ResourceUri>)
         */
        Builder resourceUris(Consumer<ResourceUri.Builder>... resourceUris);
    }

    static final class BuilderImpl implements Builder {
        private String functionName;

        private String databaseName;

        private String className;

        private String ownerName;

        private String ownerType;

        private Instant createTime;

        private List<ResourceUri> resourceUris = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserDefinedFunction model) {
            functionName(model.functionName);
            databaseName(model.databaseName);
            className(model.className);
            ownerName(model.ownerName);
            ownerType(model.ownerType);
            createTime(model.createTime);
            resourceUris(model.resourceUris);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getClassName() {
            return className;
        }

        @Override
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        public final String getOwnerName() {
            return ownerName;
        }

        @Override
        public final Builder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public final void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        public final String getOwnerType() {
            return ownerType;
        }

        @Override
        public final Builder ownerType(String ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        @Override
        public final Builder ownerType(PrincipalType ownerType) {
            this.ownerType(ownerType == null ? null : ownerType.toString());
            return this;
        }

        public final void setOwnerType(String ownerType) {
            this.ownerType = ownerType;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Collection<ResourceUri.Builder> getResourceUris() {
            return resourceUris != null ? resourceUris.stream().map(ResourceUri::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceUris(Collection<ResourceUri> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copy(resourceUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUris(ResourceUri... resourceUris) {
            resourceUris(Arrays.asList(resourceUris));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUris(Consumer<ResourceUri.Builder>... resourceUris) {
            resourceUris(Stream.of(resourceUris).map(c -> ResourceUri.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceUris(Collection<ResourceUri.BuilderImpl> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copyFromBuilder(resourceUris);
        }

        @Override
        public UserDefinedFunction build() {
            return new UserDefinedFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
