/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetJobsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetJobsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunResponse;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.glue.model.ConcurrentRunsExceededException;
import software.amazon.awssdk.services.glue.model.ConditionCheckFailureException;
import software.amazon.awssdk.services.glue.model.CrawlerNotRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerRunningException;
import software.amazon.awssdk.services.glue.model.CrawlerStoppingException;
import software.amazon.awssdk.services.glue.model.CreateClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateClassifierResponse;
import software.amazon.awssdk.services.glue.model.CreateConnectionRequest;
import software.amazon.awssdk.services.glue.model.CreateConnectionResponse;
import software.amazon.awssdk.services.glue.model.CreateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.CreateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.CreateJobRequest;
import software.amazon.awssdk.services.glue.model.CreateJobResponse;
import software.amazon.awssdk.services.glue.model.CreateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.CreateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CreateScriptRequest;
import software.amazon.awssdk.services.glue.model.CreateScriptResponse;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.CreateTriggerRequest;
import software.amazon.awssdk.services.glue.model.CreateTriggerResponse;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DeleteClassifierRequest;
import software.amazon.awssdk.services.glue.model.DeleteClassifierResponse;
import software.amazon.awssdk.services.glue.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerRequest;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerResponse;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.DeleteJobRequest;
import software.amazon.awssdk.services.glue.model.DeleteJobResponse;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformRequest;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTriggerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTriggerResponse;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusResponse;
import software.amazon.awssdk.services.glue.model.GetClassifierRequest;
import software.amazon.awssdk.services.glue.model.GetClassifierResponse;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphRequest;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.GetJobRequest;
import software.amazon.awssdk.services.glue.model.GetJobResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;
import software.amazon.awssdk.services.glue.model.GetMappingRequest;
import software.amazon.awssdk.services.glue.model.GetMappingResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetPlanRequest;
import software.amazon.awssdk.services.glue.model.GetPlanResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GetTagsRequest;
import software.amazon.awssdk.services.glue.model.GetTagsResponse;
import software.amazon.awssdk.services.glue.model.GetTriggerRequest;
import software.amazon.awssdk.services.glue.model.GetTriggerResponse;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;
import software.amazon.awssdk.services.glue.model.GlueEncryptionException;
import software.amazon.awssdk.services.glue.model.GlueException;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.glue.model.IllegalWorkflowStateException;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueRequest;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueResponse;
import software.amazon.awssdk.services.glue.model.InternalServiceException;
import software.amazon.awssdk.services.glue.model.InvalidInputException;
import software.amazon.awssdk.services.glue.model.ListCrawlersRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlersResponse;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.ListJobsRequest;
import software.amazon.awssdk.services.glue.model.ListJobsResponse;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.MlTransformNotReadyException;
import software.amazon.awssdk.services.glue.model.NoScheduleException;
import software.amazon.awssdk.services.glue.model.OperationTimeoutException;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.glue.model.SchedulerNotRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerRunningException;
import software.amazon.awssdk.services.glue.model.SchedulerTransitioningException;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartJobRunRequest;
import software.amazon.awssdk.services.glue.model.StartJobRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartTriggerRequest;
import software.amazon.awssdk.services.glue.model.StartTriggerResponse;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopTriggerRequest;
import software.amazon.awssdk.services.glue.model.StopTriggerResponse;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.TagResourceRequest;
import software.amazon.awssdk.services.glue.model.TagResourceResponse;
import software.amazon.awssdk.services.glue.model.UntagResourceRequest;
import software.amazon.awssdk.services.glue.model.UntagResourceResponse;
import software.amazon.awssdk.services.glue.model.UpdateClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateClassifierResponse;
import software.amazon.awssdk.services.glue.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.glue.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateTriggerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTriggerResponse;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.ValidationException;
import software.amazon.awssdk.services.glue.model.VersionMismatchException;
import software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable;
import software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable;
import software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable;
import software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable;
import software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable;
import software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable;
import software.amazon.awssdk.services.glue.paginators.GetJobsIterable;
import software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable;
import software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable;
import software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable;
import software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetTablesIterable;
import software.amazon.awssdk.services.glue.paginators.GetTriggersIterable;
import software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable;
import software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable;
import software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable;
import software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable;
import software.amazon.awssdk.services.glue.paginators.ListJobsIterable;
import software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable;
import software.amazon.awssdk.services.glue.paginators.ListTriggersIterable;
import software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable;
import software.amazon.awssdk.services.glue.paginators.SearchTablesIterable;
import software.amazon.awssdk.services.glue.transform.BatchCreatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeletePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchDeleteTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchGetWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.BatchStopJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CancelMlTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateScriptRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeletePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCatalogImportStatusRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetClassifiersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetConnectionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlerMetricsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataCatalogEncryptionSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDatabasesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDataflowGraphRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobBookmarkRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMappingRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTaskRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetMlTransformsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPartitionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetPlanRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSecurityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetSecurityConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableVersionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTableVersionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTablesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetUserDefinedFunctionsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunPropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.GetWorkflowRunsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ImportCatalogToGlueRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListCrawlersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListDevEndpointsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListMlTransformsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListTriggersRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutDataCatalogEncryptionSettingsRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.PutWorkflowRunPropertiesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.ResetJobBookmarkRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.SearchTablesRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartExportLabelsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartImportLabelsTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartJobRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartMlEvaluationTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartMlLabelingSetGenerationTaskRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StartWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.StopWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateClassifierRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCrawlerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateCrawlerScheduleRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateDevEndpointRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateMlTransformRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdatePartitionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateTriggerRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateUserDefinedFunctionRequestMarshaller;
import software.amazon.awssdk.services.glue.transform.UpdateWorkflowRequestMarshaller;

/**
 * Internal implementation of {@link GlueClient}.
 *
 * @see GlueClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGlueClient implements GlueClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlueClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchCreatePartitionRequest
     * @return Result of the BatchCreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchCreatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchCreatePartitionResponse batchCreatePartition(BatchCreatePartitionRequest batchCreatePartitionRequest)
            throws InvalidInputException, AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException,
            EntityNotFoundException, OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreatePartitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreatePartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchCreatePartitionRequest, BatchCreatePartitionResponse>()
                .withOperationName("BatchCreatePartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchCreatePartitionRequest)
                .withMarshaller(new BatchCreatePartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param batchDeleteConnectionRequest
     * @return Result of the BatchDeleteConnection operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteConnectionResponse batchDeleteConnection(BatchDeleteConnectionRequest batchDeleteConnectionRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchDeleteConnectionRequest, BatchDeleteConnectionResponse>()
                .withOperationName("BatchDeleteConnection").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchDeleteConnectionRequest)
                .withMarshaller(new BatchDeleteConnectionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes one or more partitions in a batch operation.
     * </p>
     *
     * @param batchDeletePartitionRequest
     * @return Result of the BatchDeletePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeletePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeletePartitionResponse batchDeletePartition(BatchDeletePartitionRequest batchDeletePartitionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeletePartitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeletePartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchDeletePartitionRequest, BatchDeletePartitionResponse>()
                .withOperationName("BatchDeletePartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchDeletePartitionRequest)
                .withMarshaller(new BatchDeletePartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes multiple tables at once.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the
     * discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param batchDeleteTableRequest
     * @return Result of the BatchDeleteTable operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteTableResponse batchDeleteTable(BatchDeleteTableRequest batchDeleteTableRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchDeleteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchDeleteTableRequest, BatchDeleteTableResponse>()
                .withOperationName("BatchDeleteTable").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchDeleteTableRequest)
                .withMarshaller(new BatchDeleteTableRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified batch of versions of a table.
     * </p>
     *
     * @param batchDeleteTableVersionRequest
     * @return Result of the BatchDeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchDeleteTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchDeleteTableVersionResponse batchDeleteTableVersion(BatchDeleteTableVersionRequest batchDeleteTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteTableVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteTableVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchDeleteTableVersionRequest, BatchDeleteTableVersionResponse>()
                .withOperationName("BatchDeleteTableVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchDeleteTableVersionRequest)
                .withMarshaller(new BatchDeleteTableVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of crawler names. After calling the
     * <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetCrawlersRequest
     * @return Result of the BatchGetCrawlers operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetCrawlersResponse batchGetCrawlers(BatchGetCrawlersRequest batchGetCrawlersRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetCrawlersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetCrawlersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetCrawlersRequest, BatchGetCrawlersResponse>()
                .withOperationName("BatchGetCrawlers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetCrawlersRequest)
                .withMarshaller(new BatchGetCrawlersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of development endpoint names. After calling the
     * <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetDevEndpointsRequest
     * @return Result of the BatchGetDevEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetDevEndpointsResponse batchGetDevEndpoints(BatchGetDevEndpointsRequest batchGetDevEndpointsRequest)
            throws AccessDeniedException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetDevEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetDevEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetDevEndpointsRequest, BatchGetDevEndpointsResponse>()
                .withOperationName("BatchGetDevEndpoints").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetDevEndpointsRequest)
                .withMarshaller(new BatchGetDevEndpointsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code>
     * operation, you can call this operation to access the data to which you have been granted permissions. This
     * operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetJobsRequest
     * @return Result of the BatchGetJobs operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetJobsResponse batchGetJobs(BatchGetJobsRequest batchGetJobsRequest) throws InternalServiceException,
            OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetJobsRequest, BatchGetJobsResponse>()
                .withOperationName("BatchGetJobs").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetJobsRequest)
                .withMarshaller(new BatchGetJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves partitions in a batch request.
     * </p>
     *
     * @param batchGetPartitionRequest
     * @return Result of the BatchGetPartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetPartitionResponse batchGetPartition(BatchGetPartitionRequest batchGetPartitionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetPartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetPartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetPartitionRequest, BatchGetPartitionResponse>()
                .withOperationName("BatchGetPartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetPartitionRequest)
                .withMarshaller(new BatchGetPartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of trigger names. After calling the
     * <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetTriggersRequest
     * @return Result of the BatchGetTriggers operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetTriggersResponse batchGetTriggers(BatchGetTriggersRequest batchGetTriggersRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetTriggersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetTriggersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetTriggersRequest, BatchGetTriggersResponse>()
                .withOperationName("BatchGetTriggers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetTriggersRequest)
                .withMarshaller(new BatchGetTriggersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of workflow names. After calling the
     * <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetWorkflowsRequest
     * @return Result of the BatchGetWorkflows operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchGetWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetWorkflowsResponse batchGetWorkflows(BatchGetWorkflowsRequest batchGetWorkflowsRequest)
            throws InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetWorkflowsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetWorkflowsRequest, BatchGetWorkflowsResponse>()
                .withOperationName("BatchGetWorkflows").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetWorkflowsRequest)
                .withMarshaller(new BatchGetWorkflowsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stops one or more job runs for a specified job definition.
     * </p>
     *
     * @param batchStopJobRunRequest
     * @return Result of the BatchStopJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.BatchStopJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchStopJobRunResponse batchStopJobRun(BatchStopJobRunRequest batchStopJobRunRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchStopJobRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchStopJobRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchStopJobRunRequest, BatchStopJobRunResponse>()
                .withOperationName("BatchStopJobRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchStopJobRunRequest)
                .withMarshaller(new BatchStopJobRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that AWS Glue runs on your behalf
     * as part of various machine learning workflows. You can cancel a machine learning task run at any time by calling
     * <code>CancelMLTaskRun</code> with a task run's parent transform's <code>TransformID</code> and the task run's
     * <code>TaskRunId</code>.
     * </p>
     *
     * @param cancelMlTaskRunRequest
     * @return Result of the CancelMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CancelMLTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelMlTaskRunResponse cancelMLTaskRun(CancelMlTaskRunRequest cancelMlTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMlTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelMlTaskRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CancelMlTaskRunRequest, CancelMlTaskRunResponse>()
                .withOperationName("CancelMLTaskRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(cancelMlTaskRunRequest)
                .withMarshaller(new CancelMlTaskRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
     * <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which
     * field of the request is present.
     * </p>
     *
     * @param createClassifierRequest
     * @return Result of the CreateClassifier operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateClassifierResponse createClassifier(CreateClassifierRequest createClassifierRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateClassifierResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateClassifierResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateClassifierRequest, CreateClassifierResponse>()
                .withOperationName("CreateClassifier").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createClassifierRequest)
                .withMarshaller(new CreateClassifierRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a connection definition in the Data Catalog.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateConnectionRequest, CreateConnectionResponse>()
                .withOperationName("CreateConnection").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createConnectionRequest)
                .withMarshaller(new CreateConnectionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl
     * target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the
     * <code>DynamoDBTargets</code> field.
     * </p>
     *
     * @param createCrawlerRequest
     * @return Result of the CreateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCrawlerResponse createCrawler(CreateCrawlerRequest createCrawlerRequest) throws InvalidInputException,
            AlreadyExistsException, OperationTimeoutException, ResourceNumberLimitExceededException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCrawlerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateCrawlerRequest, CreateCrawlerResponse>()
                .withOperationName("CreateCrawler").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createCrawlerRequest)
                .withMarshaller(new CreateCrawlerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new database in a Data Catalog.
     * </p>
     *
     * @param createDatabaseRequest
     * @return Result of the CreateDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateDatabaseRequest, CreateDatabaseResponse>()
                .withOperationName("CreateDatabase").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDatabaseRequest)
                .withMarshaller(new CreateDatabaseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new development endpoint.
     * </p>
     *
     * @param createDevEndpointRequest
     * @return Result of the CreateDevEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDevEndpointResponse createDevEndpoint(CreateDevEndpointRequest createDevEndpointRequest)
            throws AccessDeniedException, AlreadyExistsException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, InvalidInputException, ValidationException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDevEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDevEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateDevEndpointRequest, CreateDevEndpointResponse>()
                .withOperationName("CreateDevEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDevEndpointRequest)
                .withMarshaller(new CreateDevEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new job definition.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidInputException,
            IdempotentParameterMismatchException, AlreadyExistsException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>()
                .withOperationName("CreateJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createJobRequest)
                .withMarshaller(new CreateJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an AWS Glue machine learning transform. This operation creates the transform and all the necessary
     * parameters to train it.
     * </p>
     * <p>
     * Call this operation as the first step in the process of using a machine learning transform (such as the
     * <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>,
     * in addition to the parameters that you want to use for your algorithm.
     * </p>
     * <p>
     * You must also specify certain parameters for the tasks that AWS Glue runs on your behalf as part of learning from
     * your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and
     * optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.
     * </p>
     *
     * @param createMlTransformRequest
     * @return Result of the CreateMLTransform operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateMlTransformResponse createMLTransform(CreateMlTransformRequest createMlTransformRequest)
            throws AlreadyExistsException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, ResourceNumberLimitExceededException, IdempotentParameterMismatchException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMlTransformResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMlTransformResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateMlTransformRequest, CreateMlTransformResponse>()
                .withOperationName("CreateMLTransform").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createMlTransformRequest)
                .withMarshaller(new CreateMlTransformRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new partition.
     * </p>
     *
     * @param createPartitionRequest
     * @return Result of the CreatePartition operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePartitionResponse createPartition(CreatePartitionRequest createPartitionRequest) throws InvalidInputException,
            AlreadyExistsException, ResourceNumberLimitExceededException, InternalServiceException, EntityNotFoundException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreatePartitionRequest, CreatePartitionResponse>()
                .withOperationName("CreatePartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPartitionRequest)
                .withMarshaller(new CreatePartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Transforms a directed acyclic graph (DAG) into code.
     * </p>
     *
     * @param createScriptRequest
     * @return Result of the CreateScript operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateScript
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateScriptResponse createScript(CreateScriptRequest createScriptRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateScriptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateScriptResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateScriptRequest, CreateScriptResponse>()
                .withOperationName("CreateScript").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createScriptRequest)
                .withMarshaller(new CreateScriptRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new security configuration. A security configuration is a set of security properties that can be used
     * by AWS Glue. You can use a security configuration to encrypt data at rest. For information about using security
     * configurations in AWS Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written
     * by Crawlers, Jobs, and Development Endpoints</a>.
     * </p>
     *
     * @param createSecurityConfigurationRequest
     * @return Result of the CreateSecurityConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSecurityConfigurationResponse createSecurityConfiguration(
            CreateSecurityConfigurationRequest createSecurityConfigurationRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSecurityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSecurityConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateSecurityConfigurationRequest, CreateSecurityConfigurationResponse>()
                        .withOperationName("CreateSecurityConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createSecurityConfigurationRequest)
                        .withMarshaller(new CreateSecurityConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new table definition in the Data Catalog.
     * </p>
     *
     * @param createTableRequest
     * @return Result of the CreateTable operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws AlreadyExistsException,
            InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException,
            OperationTimeoutException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateTableRequest, CreateTableResponse>()
                .withOperationName("CreateTable").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createTableRequest)
                .withMarshaller(new CreateTableRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new trigger.
     * </p>
     *
     * @param createTriggerRequest
     * @return Result of the CreateTrigger operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws IdempotentParameterMismatchException
     *         The same unique identifier was associated with two different records.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTriggerResponse createTrigger(CreateTriggerRequest createTriggerRequest) throws AlreadyExistsException,
            EntityNotFoundException, InvalidInputException, IdempotentParameterMismatchException, InternalServiceException,
            OperationTimeoutException, ResourceNumberLimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTriggerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateTriggerRequest, CreateTriggerResponse>()
                .withOperationName("CreateTrigger").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createTriggerRequest)
                .withMarshaller(new CreateTriggerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new function definition in the Data Catalog.
     * </p>
     *
     * @param createUserDefinedFunctionRequest
     * @return Result of the CreateUserDefinedFunction operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUserDefinedFunctionResponse createUserDefinedFunction(
            CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, EntityNotFoundException, OperationTimeoutException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserDefinedFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserDefinedFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateUserDefinedFunctionRequest, CreateUserDefinedFunctionResponse>()
                        .withOperationName("CreateUserDefinedFunction").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createUserDefinedFunctionRequest)
                        .withMarshaller(new CreateUserDefinedFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.CreateWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws AlreadyExistsException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateWorkflowRequest, CreateWorkflowResponse>()
                .withOperationName("CreateWorkflow").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createWorkflowRequest)
                .withMarshaller(new CreateWorkflowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a classifier from the Data Catalog.
     * </p>
     *
     * @param deleteClassifierRequest
     * @return Result of the DeleteClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteClassifierResponse deleteClassifier(DeleteClassifierRequest deleteClassifierRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClassifierResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteClassifierResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteClassifierRequest, DeleteClassifierResponse>()
                .withOperationName("DeleteClassifier").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteClassifierRequest)
                .withMarshaller(new DeleteClassifierRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a connection from the Data Catalog.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws EntityNotFoundException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteConnectionRequest, DeleteConnectionResponse>()
                .withOperationName("DeleteConnection").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteConnectionRequest)
                .withMarshaller(new DeleteConnectionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a specified crawler from the AWS Glue Data Catalog, unless the crawler state is <code>RUNNING</code>.
     * </p>
     *
     * @param deleteCrawlerRequest
     * @return Result of the DeleteCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCrawlerResponse deleteCrawler(DeleteCrawlerRequest deleteCrawlerRequest) throws EntityNotFoundException,
            CrawlerRunningException, SchedulerTransitioningException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCrawlerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteCrawlerRequest, DeleteCrawlerResponse>()
                .withOperationName("DeleteCrawler").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteCrawlerRequest)
                .withMarshaller(new DeleteCrawlerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a specified database from a Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the tables (and all table versions and partitions
     * that might belong to the tables) and the user-defined functions in the deleted database. AWS Glue deletes these
     * "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteDatabase</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and <code>DeleteTable</code> or
     * <code>BatchDeleteTable</code>, to delete any resources that belong to the database.
     * </p>
     * </note>
     *
     * @param deleteDatabaseRequest
     * @return Result of the DeleteDatabase operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDatabaseResponse deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteDatabaseRequest, DeleteDatabaseResponse>()
                .withOperationName("DeleteDatabase").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDatabaseRequest)
                .withMarshaller(new DeleteDatabaseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified development endpoint.
     * </p>
     *
     * @param deleteDevEndpointRequest
     * @return Result of the DeleteDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDevEndpointResponse deleteDevEndpoint(DeleteDevEndpointRequest deleteDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDevEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDevEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteDevEndpointRequest, DeleteDevEndpointResponse>()
                .withOperationName("DeleteDevEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDevEndpointRequest)
                .withMarshaller(new DeleteDevEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified job definition. If the job definition is not found, no exception is thrown.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws InvalidInputException, InternalServiceException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteJobRequest, DeleteJobResponse>()
                .withOperationName("DeleteJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteJobRequest)
                .withMarshaller(new DeleteJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an AWS Glue machine learning transform. Machine learning transforms are a special type of transform that
     * use machine learning to learn the details of the transformation to be performed by learning from examples
     * provided by humans. These transformations are then saved by AWS Glue. If you no longer need a transform, you can
     * delete it by calling <code>DeleteMLTransforms</code>. However, any AWS Glue jobs that still reference the deleted
     * transform will no longer succeed.
     * </p>
     *
     * @param deleteMlTransformRequest
     * @return Result of the DeleteMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteMlTransformResponse deleteMLTransform(DeleteMlTransformRequest deleteMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMlTransformResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMlTransformResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteMlTransformRequest, DeleteMlTransformResponse>()
                .withOperationName("DeleteMLTransform").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteMlTransformRequest)
                .withMarshaller(new DeleteMlTransformRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified partition.
     * </p>
     *
     * @param deletePartitionRequest
     * @return Result of the DeletePartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeletePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePartitionResponse deletePartition(DeletePartitionRequest deletePartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeletePartitionRequest, DeletePartitionResponse>()
                .withOperationName("DeletePartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deletePartitionRequest)
                .withMarshaller(new DeletePartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ConditionCheckFailureException
     *         A specified condition was not satisfied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ConditionCheckFailureException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                .withOperationName("DeleteResourcePolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourcePolicyRequest)
                .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified security configuration.
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     * @return Result of the DeleteSecurityConfiguration operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSecurityConfigurationResponse deleteSecurityConfiguration(
            DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSecurityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSecurityConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteSecurityConfigurationRequest, DeleteSecurityConfigurationResponse>()
                        .withOperationName("DeleteSecurityConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteSecurityConfigurationRequest)
                        .withMarshaller(new DeleteSecurityConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a table definition from the Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the
     * discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param deleteTableRequest
     * @return Result of the DeleteTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteTableRequest, DeleteTableResponse>()
                .withOperationName("DeleteTable").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTableRequest)
                .withMarshaller(new DeleteTableRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified version of a table.
     * </p>
     *
     * @param deleteTableVersionRequest
     * @return Result of the DeleteTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTableVersionResponse deleteTableVersion(DeleteTableVersionRequest deleteTableVersionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTableVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTableVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteTableVersionRequest, DeleteTableVersionResponse>()
                .withOperationName("DeleteTableVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTableVersionRequest)
                .withMarshaller(new DeleteTableVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified trigger. If the trigger is not found, no exception is thrown.
     * </p>
     *
     * @param deleteTriggerRequest
     * @return Result of the DeleteTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTriggerResponse deleteTrigger(DeleteTriggerRequest deleteTriggerRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTriggerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteTriggerRequest, DeleteTriggerResponse>()
                .withOperationName("DeleteTrigger").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTriggerRequest)
                .withMarshaller(new DeleteTriggerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an existing function definition from the Data Catalog.
     * </p>
     *
     * @param deleteUserDefinedFunctionRequest
     * @return Result of the DeleteUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserDefinedFunctionResponse deleteUserDefinedFunction(
            DeleteUserDefinedFunctionRequest deleteUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserDefinedFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserDefinedFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteUserDefinedFunctionRequest, DeleteUserDefinedFunctionResponse>()
                        .withOperationName("DeleteUserDefinedFunction").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserDefinedFunctionRequest)
                        .withMarshaller(new DeleteUserDefinedFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.DeleteWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteWorkflowRequest, DeleteWorkflowResponse>()
                .withOperationName("DeleteWorkflow").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteWorkflowRequest)
                .withMarshaller(new DeleteWorkflowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the status of a migration operation.
     * </p>
     *
     * @param getCatalogImportStatusRequest
     * @return Result of the GetCatalogImportStatus operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCatalogImportStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCatalogImportStatusResponse getCatalogImportStatus(GetCatalogImportStatusRequest getCatalogImportStatusRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCatalogImportStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCatalogImportStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCatalogImportStatusRequest, GetCatalogImportStatusResponse>()
                .withOperationName("GetCatalogImportStatus").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCatalogImportStatusRequest)
                .withMarshaller(new GetCatalogImportStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieve a classifier by name.
     * </p>
     *
     * @param getClassifierRequest
     * @return Result of the GetClassifier operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetClassifierResponse getClassifier(GetClassifierRequest getClassifierRequest) throws EntityNotFoundException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetClassifierResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetClassifierResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetClassifierRequest, GetClassifierResponse>()
                .withOperationName("GetClassifier").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getClassifierRequest)
                .withMarshaller(new GetClassifierRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     *
     * @param getClassifiersRequest
     * @return Result of the GetClassifiers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetClassifiersResponse getClassifiers(GetClassifiersRequest getClassifiersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetClassifiersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetClassifiersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetClassifiersRequest, GetClassifiersResponse>()
                .withOperationName("GetClassifiers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getClassifiersRequest)
                .withMarshaller(new GetClassifiersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetClassifiersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersIterable responses = client.getClassifiersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)} operation.</b>
     * </p>
     *
     * @param getClassifiersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetClassifiersIterable getClassifiersPaginator(GetClassifiersRequest getClassifiersRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return new GetClassifiersIterable(this, applyPaginatorUserAgent(getClassifiersRequest));
    }

    /**
     * <p>
     * Retrieves a connection definition from the Data Catalog.
     * </p>
     *
     * @param getConnectionRequest
     * @return Result of the GetConnection operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest getConnectionRequest) throws EntityNotFoundException,
            OperationTimeoutException, InvalidInputException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetConnectionRequest, GetConnectionResponse>()
                .withOperationName("GetConnection").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getConnectionRequest)
                .withMarshaller(new GetConnectionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param getConnectionsRequest
     * @return Result of the GetConnections operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetConnectionsResponse getConnections(GetConnectionsRequest getConnectionsRequest) throws EntityNotFoundException,
            OperationTimeoutException, InvalidInputException, GlueEncryptionException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetConnectionsRequest, GetConnectionsResponse>()
                .withOperationName("GetConnections").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getConnectionsRequest)
                .withMarshaller(new GetConnectionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsIterable responses = client.getConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param getConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetConnectionsIterable getConnectionsPaginator(GetConnectionsRequest getConnectionsRequest)
            throws EntityNotFoundException, OperationTimeoutException, InvalidInputException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetConnectionsIterable(this, applyPaginatorUserAgent(getConnectionsRequest));
    }

    /**
     * <p>
     * Retrieves metadata for a specified crawler.
     * </p>
     *
     * @param getCrawlerRequest
     * @return Result of the GetCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCrawlerResponse getCrawler(GetCrawlerRequest getCrawlerRequest) throws EntityNotFoundException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCrawlerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCrawlerRequest, GetCrawlerResponse>()
                .withOperationName("GetCrawler").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCrawlerRequest)
                .withMarshaller(new GetCrawlerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     *
     * @param getCrawlerMetricsRequest
     * @return Result of the GetCrawlerMetrics operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlerMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCrawlerMetricsResponse getCrawlerMetrics(GetCrawlerMetricsRequest getCrawlerMetricsRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCrawlerMetricsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCrawlerMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCrawlerMetricsRequest, GetCrawlerMetricsResponse>()
                .withOperationName("GetCrawlerMetrics").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCrawlerMetricsRequest)
                .withMarshaller(new GetCrawlerMetricsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client.getCrawlerMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client
     *             .getCrawlerMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsIterable responses = client.getCrawlerMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation.</b>
     * </p>
     *
     * @param getCrawlerMetricsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlerMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCrawlerMetricsIterable getCrawlerMetricsPaginator(GetCrawlerMetricsRequest getCrawlerMetricsRequest)
            throws OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return new GetCrawlerMetricsIterable(this, applyPaginatorUserAgent(getCrawlerMetricsRequest));
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     *
     * @param getCrawlersRequest
     * @return Result of the GetCrawlers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCrawlersResponse getCrawlers(GetCrawlersRequest getCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCrawlersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCrawlersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCrawlersRequest, GetCrawlersResponse>()
                .withOperationName("GetCrawlers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCrawlersRequest)
                .withMarshaller(new GetCrawlersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetCrawlersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersIterable responses = client.getCrawlersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)} operation.</b>
     * </p>
     *
     * @param getCrawlersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCrawlersIterable getCrawlersPaginator(GetCrawlersRequest getCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetCrawlersIterable(this, applyPaginatorUserAgent(getCrawlersRequest));
    }

    /**
     * <p>
     * Retrieves the security configuration for a specified catalog.
     * </p>
     *
     * @param getDataCatalogEncryptionSettingsRequest
     * @return Result of the GetDataCatalogEncryptionSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDataCatalogEncryptionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDataCatalogEncryptionSettingsResponse getDataCatalogEncryptionSettings(
            GetDataCatalogEncryptionSettingsRequest getDataCatalogEncryptionSettingsRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataCatalogEncryptionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDataCatalogEncryptionSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetDataCatalogEncryptionSettingsRequest, GetDataCatalogEncryptionSettingsResponse>()
                        .withOperationName("GetDataCatalogEncryptionSettings").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getDataCatalogEncryptionSettingsRequest)
                        .withMarshaller(new GetDataCatalogEncryptionSettingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the definition of a specified database.
     * </p>
     *
     * @param getDatabaseRequest
     * @return Result of the GetDatabase operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDatabaseRequest, GetDatabaseResponse>()
                .withOperationName("GetDatabase").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDatabaseRequest)
                .withMarshaller(new GetDatabaseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     *
     * @param getDatabasesRequest
     * @return Result of the GetDatabases operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDatabasesResponse getDatabases(GetDatabasesRequest getDatabasesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDatabasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDatabasesRequest, GetDatabasesResponse>()
                .withOperationName("GetDatabases").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDatabasesRequest)
                .withMarshaller(new GetDatabasesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesIterable responses = client.getDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param getDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDatabasesIterable getDatabasesPaginator(GetDatabasesRequest getDatabasesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        return new GetDatabasesIterable(this, applyPaginatorUserAgent(getDatabasesRequest));
    }

    /**
     * <p>
     * Transforms a Python script into a directed acyclic graph (DAG).
     * </p>
     *
     * @param getDataflowGraphRequest
     * @return Result of the GetDataflowGraph operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDataflowGraph
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDataflowGraphResponse getDataflowGraph(GetDataflowGraphRequest getDataflowGraphRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataflowGraphResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDataflowGraphResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDataflowGraphRequest, GetDataflowGraphResponse>()
                .withOperationName("GetDataflowGraph").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDataflowGraphRequest)
                .withMarshaller(new GetDataflowGraphRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about a specified development endpoint.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address, and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note>
     *
     * @param getDevEndpointRequest
     * @return Result of the GetDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDevEndpointResponse getDevEndpoint(GetDevEndpointRequest getDevEndpointRequest) throws EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDevEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDevEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDevEndpointRequest, GetDevEndpointResponse>()
                .withOperationName("GetDevEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDevEndpointRequest)
                .withMarshaller(new GetDevEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this AWS account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note>
     *
     * @param getDevEndpointsRequest
     * @return Result of the GetDevEndpoints operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDevEndpointsResponse getDevEndpoints(GetDevEndpointsRequest getDevEndpointsRequest) throws EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, InvalidInputException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDevEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDevEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDevEndpointsRequest, GetDevEndpointsResponse>()
                .withOperationName("GetDevEndpoints").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDevEndpointsRequest)
                .withMarshaller(new GetDevEndpointsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this AWS account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP
     * address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS
     * Glue returns only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsIterable responses = client.getDevEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param getDevEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDevEndpointsIterable getDevEndpointsPaginator(GetDevEndpointsRequest getDevEndpointsRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetDevEndpointsIterable(this, applyPaginatorUserAgent(getDevEndpointsRequest));
    }

    /**
     * <p>
     * Retrieves an existing job definition.
     * </p>
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobResponse getJob(GetJobRequest getJobRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetJobRequest, GetJobResponse>().withOperationName("GetJob")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getJobRequest)
                .withMarshaller(new GetJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information on a job bookmark entry.
     * </p>
     *
     * @param getJobBookmarkRequest
     * @return Result of the GetJobBookmark operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobBookmark
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobBookmarkResponse getJobBookmark(GetJobBookmarkRequest getJobBookmarkRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ValidationException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobBookmarkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobBookmarkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetJobBookmarkRequest, GetJobBookmarkResponse>()
                .withOperationName("GetJobBookmark").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getJobBookmarkRequest)
                .withMarshaller(new GetJobBookmarkRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the metadata for a given job run.
     * </p>
     *
     * @param getJobRunRequest
     * @return Result of the GetJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobRunResponse getJobRun(GetJobRunRequest getJobRunRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetJobRunRequest, GetJobRunResponse>()
                .withOperationName("GetJobRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getJobRunRequest)
                .withMarshaller(new GetJobRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     *
     * @param getJobRunsRequest
     * @return Result of the GetJobRuns operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobRunsResponse getJobRuns(GetJobRunsRequest getJobRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetJobRunsRequest, GetJobRunsResponse>()
                .withOperationName("GetJobRuns").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getJobRunsRequest)
                .withMarshaller(new GetJobRunsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetJobRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsIterable responses = client.getJobRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.</b>
     * </p>
     *
     * @param getJobRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobRunsIterable getJobRunsPaginator(GetJobRunsRequest getJobRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return new GetJobRunsIterable(this, applyPaginatorUserAgent(getJobRunsRequest));
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     *
     * @param getJobsRequest
     * @return Result of the GetJobs operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobsResponse getJobs(GetJobsRequest getJobsRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetJobsRequest, GetJobsResponse>().withOperationName("GetJobs")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getJobsRequest)
                .withMarshaller(new GetJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsIterable responses = client.getJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation.</b>
     * </p>
     *
     * @param getJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetJobsIterable getJobsPaginator(GetJobsRequest getJobsRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return new GetJobsIterable(this, applyPaginatorUserAgent(getJobsRequest));
    }

    /**
     * <p>
     * Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous
     * tasks that AWS Glue runs on your behalf as part of various machine learning workflows. You can check the stats of
     * any task run by calling <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform's
     * <code>TransformID</code>.
     * </p>
     *
     * @param getMlTaskRunRequest
     * @return Result of the GetMLTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMlTaskRunResponse getMLTaskRun(GetMlTaskRunRequest getMlTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMlTaskRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMlTaskRunRequest, GetMlTaskRunResponse>()
                .withOperationName("GetMLTaskRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMlTaskRunRequest)
                .withMarshaller(new GetMlTaskRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS
     * Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list
     * of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     *
     * @param getMlTaskRunsRequest
     * @return Result of the GetMLTaskRuns operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMlTaskRunsResponse getMLTaskRuns(GetMlTaskRunsRequest getMlTaskRunsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlTaskRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMlTaskRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMlTaskRunsRequest, GetMlTaskRunsResponse>()
                .withOperationName("GetMLTaskRuns").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMlTaskRunsRequest)
                .withMarshaller(new GetMlTaskRunsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS
     * Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list
     * of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsIterable responses = client.getMLTaskRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)} operation.</b>
     * </p>
     *
     * @param getMlTaskRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTaskRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMLTaskRunsIterable getMLTaskRunsPaginator(GetMlTaskRunsRequest getMlTaskRunsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetMLTaskRunsIterable(this, applyPaginatorUserAgent(getMlTaskRunsRequest));
    }

    /**
     * <p>
     * Gets an AWS Glue machine learning transform artifact and all its corresponding metadata. Machine learning
     * transforms are a special type of transform that use machine learning to learn the details of the transformation
     * to be performed by learning from examples provided by humans. These transformations are then saved by AWS Glue.
     * You can retrieve their metadata by calling <code>GetMLTransform</code>.
     * </p>
     *
     * @param getMlTransformRequest
     * @return Result of the GetMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMlTransformResponse getMLTransform(GetMlTransformRequest getMlTransformRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlTransformResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMlTransformResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMlTransformRequest, GetMlTransformResponse>()
                .withOperationName("GetMLTransform").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMlTransformRequest)
                .withMarshaller(new GetMlTransformRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you
     * can retrieve their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     *
     * @param getMlTransformsRequest
     * @return Result of the GetMLTransforms operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMlTransformsResponse getMLTransforms(GetMlTransformsRequest getMlTransformsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMlTransformsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMlTransformsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMlTransformsRequest, GetMlTransformsResponse>()
                .withOperationName("GetMLTransforms").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMlTransformsRequest)
                .withMarshaller(new GetMlTransformsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you
     * can retrieve their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetMlTransformsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsIterable responses = client.getMLTransformsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)} operation.</b>
     * </p>
     *
     * @param getMlTransformsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMLTransformsIterable getMLTransformsPaginator(GetMlTransformsRequest getMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetMLTransformsIterable(this, applyPaginatorUserAgent(getMlTransformsRequest));
    }

    /**
     * <p>
     * Creates mappings.
     * </p>
     *
     * @param getMappingRequest
     * @return Result of the GetMapping operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMappingResponse getMapping(GetMappingRequest getMappingRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMappingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMappingRequest, GetMappingResponse>()
                .withOperationName("GetMapping").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMappingRequest)
                .withMarshaller(new GetMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about a specified partition.
     * </p>
     *
     * @param getPartitionRequest
     * @return Result of the GetPartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPartitionResponse getPartition(GetPartitionRequest getPartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetPartitionRequest, GetPartitionResponse>()
                .withOperationName("GetPartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPartitionRequest)
                .withMarshaller(new GetPartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     *
     * @param getPartitionsRequest
     * @return Result of the GetPartitions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPartitionsResponse getPartitions(GetPartitionsRequest getPartitionsRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPartitionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPartitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetPartitionsRequest, GetPartitionsResponse>()
                .withOperationName("GetPartitions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPartitionsRequest)
                .withMarshaller(new GetPartitionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetPartitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsIterable responses = client.getPartitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)} operation.</b>
     * </p>
     *
     * @param getPartitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPartitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPartitionsIterable getPartitionsPaginator(GetPartitionsRequest getPartitionsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return new GetPartitionsIterable(this, applyPaginatorUserAgent(getPartitionsRequest));
    }

    /**
     * <p>
     * Gets code to perform a specified mapping.
     * </p>
     *
     * @param getPlanRequest
     * @return Result of the GetPlan operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPlanResponse getPlan(GetPlanRequest getPlanRequest) throws InvalidInputException, InternalServiceException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetPlanRequest, GetPlanResponse>().withOperationName("GetPlan")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getPlanRequest)
                .withMarshaller(new GetPlanRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a specified resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                .withOperationName("GetResourcePolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getResourcePolicyRequest)
                .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a specified security configuration.
     * </p>
     *
     * @param getSecurityConfigurationRequest
     * @return Result of the GetSecurityConfiguration operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSecurityConfigurationResponse getSecurityConfiguration(
            GetSecurityConfigurationRequest getSecurityConfigurationRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSecurityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSecurityConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetSecurityConfigurationRequest, GetSecurityConfigurationResponse>()
                        .withOperationName("GetSecurityConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getSecurityConfigurationRequest)
                        .withMarshaller(new GetSecurityConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     * @return Result of the GetSecurityConfigurations operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSecurityConfigurationsResponse getSecurityConfigurations(
            GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSecurityConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSecurityConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetSecurityConfigurationsRequest, GetSecurityConfigurationsResponse>()
                        .withOperationName("GetSecurityConfigurations").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getSecurityConfigurationsRequest)
                        .withMarshaller(new GetSecurityConfigurationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client.getSecurityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client
     *             .getSecurityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsIterable responses = client.getSecurityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSecurityConfigurationsIterable getSecurityConfigurationsPaginator(
            GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return new GetSecurityConfigurationsIterable(this, applyPaginatorUserAgent(getSecurityConfigurationsRequest));
    }

    /**
     * <p>
     * Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.
     * </p>
     *
     * @param getTableRequest
     * @return Result of the GetTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTableResponse getTable(GetTableRequest getTableRequest) throws EntityNotFoundException, InvalidInputException,
            InternalServiceException, OperationTimeoutException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTableRequest, GetTableResponse>().withOperationName("GetTable")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getTableRequest)
                .withMarshaller(new GetTableRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a specified version of a table.
     * </p>
     *
     * @param getTableVersionRequest
     * @return Result of the GetTableVersion operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTableVersionResponse getTableVersion(GetTableVersionRequest getTableVersionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTableVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTableVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTableVersionRequest, GetTableVersionResponse>()
                .withOperationName("GetTableVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTableVersionRequest)
                .withMarshaller(new GetTableVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     *
     * @param getTableVersionsRequest
     * @return Result of the GetTableVersions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTableVersionsResponse getTableVersions(GetTableVersionsRequest getTableVersionsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTableVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTableVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTableVersionsRequest, GetTableVersionsResponse>()
                .withOperationName("GetTableVersions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTableVersionsRequest)
                .withMarshaller(new GetTableVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client.getTableVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client
     *             .getTableVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTableVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsIterable responses = client.getTableVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation.</b>
     * </p>
     *
     * @param getTableVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTableVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTableVersionsIterable getTableVersionsPaginator(GetTableVersionsRequest getTableVersionsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        return new GetTableVersionsIterable(this, applyPaginatorUserAgent(getTableVersionsRequest));
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     *
     * @param getTablesRequest
     * @return Result of the GetTables operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTablesResponse getTables(GetTablesRequest getTablesRequest) throws EntityNotFoundException, InvalidInputException,
            OperationTimeoutException, InternalServiceException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTablesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTablesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTablesRequest, GetTablesResponse>()
                .withOperationName("GetTables").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTablesRequest)
                .withMarshaller(new GetTablesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesIterable responses = client.getTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.</b>
     * </p>
     *
     * @param getTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTablesIterable getTablesPaginator(GetTablesRequest getTablesRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetTablesIterable(this, applyPaginatorUserAgent(getTablesRequest));
    }

    /**
     * <p>
     * Retrieves a list of tags associated with a resource.
     * </p>
     *
     * @param getTagsRequest
     * @return Result of the GetTags operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws InvalidInputException, InternalServiceException,
            OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTagsRequest, GetTagsResponse>().withOperationName("GetTags")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getTagsRequest)
                .withMarshaller(new GetTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the definition of a trigger.
     * </p>
     *
     * @param getTriggerRequest
     * @return Result of the GetTrigger operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTriggerResponse getTrigger(GetTriggerRequest getTriggerRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTriggerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTriggerRequest, GetTriggerResponse>()
                .withOperationName("GetTrigger").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTriggerRequest)
                .withMarshaller(new GetTriggerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     *
     * @param getTriggersRequest
     * @return Result of the GetTriggers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTriggersResponse getTriggers(GetTriggersRequest getTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTriggersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTriggersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetTriggersRequest, GetTriggersResponse>()
                .withOperationName("GetTriggers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTriggersRequest)
                .withMarshaller(new GetTriggersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersIterable responses = client.getTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)} operation.</b>
     * </p>
     *
     * @param getTriggersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTriggersIterable getTriggersPaginator(GetTriggersRequest getTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return new GetTriggersIterable(this, applyPaginatorUserAgent(getTriggersRequest));
    }

    /**
     * <p>
     * Retrieves a specified function definition from the Data Catalog.
     * </p>
     *
     * @param getUserDefinedFunctionRequest
     * @return Result of the GetUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetUserDefinedFunctionResponse getUserDefinedFunction(GetUserDefinedFunctionRequest getUserDefinedFunctionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserDefinedFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetUserDefinedFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetUserDefinedFunctionRequest, GetUserDefinedFunctionResponse>()
                .withOperationName("GetUserDefinedFunction").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getUserDefinedFunctionRequest)
                .withMarshaller(new GetUserDefinedFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     * @return Result of the GetUserDefinedFunctions operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetUserDefinedFunctionsResponse getUserDefinedFunctions(GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserDefinedFunctionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetUserDefinedFunctionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetUserDefinedFunctionsRequest, GetUserDefinedFunctionsResponse>()
                .withOperationName("GetUserDefinedFunctions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getUserDefinedFunctionsRequest)
                .withMarshaller(new GetUserDefinedFunctionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client.getUserDefinedFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client
     *             .getUserDefinedFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsIterable responses = client.getUserDefinedFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetUserDefinedFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetUserDefinedFunctionsIterable getUserDefinedFunctionsPaginator(
            GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) throws EntityNotFoundException, InvalidInputException,
            OperationTimeoutException, InternalServiceException, GlueEncryptionException, AwsServiceException,
            SdkClientException, GlueException {
        return new GetUserDefinedFunctionsIterable(this, applyPaginatorUserAgent(getUserDefinedFunctionsRequest));
    }

    /**
     * <p>
     * Retrieves resource metadata for a workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetWorkflowRequest, GetWorkflowResponse>()
                .withOperationName("GetWorkflow").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getWorkflowRequest)
                .withMarshaller(new GetWorkflowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the metadata for a given workflow run.
     * </p>
     *
     * @param getWorkflowRunRequest
     * @return Result of the GetWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowRunResponse getWorkflowRun(GetWorkflowRunRequest getWorkflowRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkflowRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetWorkflowRunRequest, GetWorkflowRunResponse>()
                .withOperationName("GetWorkflowRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getWorkflowRunRequest)
                .withMarshaller(new GetWorkflowRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the workflow run properties which were set during the run.
     * </p>
     *
     * @param getWorkflowRunPropertiesRequest
     * @return Result of the GetWorkflowRunProperties operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRunProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetWorkflowRunPropertiesResponse getWorkflowRunProperties(
            GetWorkflowRunPropertiesRequest getWorkflowRunPropertiesRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowRunPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWorkflowRunPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetWorkflowRunPropertiesRequest, GetWorkflowRunPropertiesResponse>()
                        .withOperationName("GetWorkflowRunProperties").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getWorkflowRunPropertiesRequest)
                        .withMarshaller(new GetWorkflowRunPropertiesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     *
     * @param getWorkflowRunsRequest
     * @return Result of the GetWorkflowRuns operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowRunsResponse getWorkflowRuns(GetWorkflowRunsRequest getWorkflowRunsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkflowRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetWorkflowRunsRequest, GetWorkflowRunsResponse>()
                .withOperationName("GetWorkflowRuns").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getWorkflowRunsRequest)
                .withMarshaller(new GetWorkflowRunsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsIterable responses = client.getWorkflowRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)} operation.</b>
     * </p>
     *
     * @param getWorkflowRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.GetWorkflowRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowRunsIterable getWorkflowRunsPaginator(GetWorkflowRunsRequest getWorkflowRunsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return new GetWorkflowRunsIterable(this, applyPaginatorUserAgent(getWorkflowRunsRequest));
    }

    /**
     * <p>
     * Imports an existing Amazon Athena Data Catalog to AWS Glue
     * </p>
     *
     * @param importCatalogToGlueRequest
     * @return Result of the ImportCatalogToGlue operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ImportCatalogToGlue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ImportCatalogToGlueResponse importCatalogToGlue(ImportCatalogToGlueRequest importCatalogToGlueRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportCatalogToGlueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportCatalogToGlueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ImportCatalogToGlueRequest, ImportCatalogToGlueResponse>()
                .withOperationName("ImportCatalogToGlue").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(importCatalogToGlueRequest)
                .withMarshaller(new ImportCatalogToGlueRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listCrawlersRequest
     * @return Result of the ListCrawlers operation returned by the service.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCrawlersResponse listCrawlers(ListCrawlersRequest listCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCrawlersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCrawlersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListCrawlersRequest, ListCrawlersResponse>()
                .withOperationName("ListCrawlers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listCrawlersRequest)
                .withMarshaller(new ListCrawlersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCrawlers(software.amazon.awssdk.services.glue.model.ListCrawlersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListCrawlersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListCrawlersIterable responses = client.listCrawlersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrawlers(software.amazon.awssdk.services.glue.model.ListCrawlersRequest)} operation.</b>
     * </p>
     *
     * @param listCrawlersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListCrawlers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCrawlersIterable listCrawlersPaginator(ListCrawlersRequest listCrawlersRequest) throws OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return new ListCrawlersIterable(this, applyPaginatorUserAgent(listCrawlersRequest));
    }

    /**
     * <p>
     * Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the
     * specified tag. This operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listDevEndpointsRequest
     * @return Result of the ListDevEndpoints operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDevEndpointsResponse listDevEndpoints(ListDevEndpointsRequest listDevEndpointsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDevEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDevEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListDevEndpointsRequest, ListDevEndpointsResponse>()
                .withOperationName("ListDevEndpoints").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDevEndpointsRequest)
                .withMarshaller(new ListDevEndpointsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the
     * specified tag. This operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevEndpoints(software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client.listDevEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client
     *             .listDevEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListDevEndpointsIterable responses = client.listDevEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevEndpoints(software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param listDevEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListDevEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDevEndpointsIterable listDevEndpointsPaginator(ListDevEndpointsRequest listDevEndpointsRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        return new ListDevEndpointsIterable(this, applyPaginatorUserAgent(listDevEndpointsRequest));
    }

    /**
     * <p>
     * Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>().withOperationName("ListJobs")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listJobsRequest)
                .withMarshaller(new ListJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.glue.model.ListJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.glue.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        return new ListJobsIterable(this, applyPaginatorUserAgent(listJobsRequest));
    }

    /**
     * <p>
     * Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or
     * the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can
     * use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
     * filtering, only resources with the tags are retrieved.
     * </p>
     *
     * @param listMlTransformsRequest
     * @return Result of the ListMLTransforms operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMlTransformsResponse listMLTransforms(ListMlTransformsRequest listMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMlTransformsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMlTransformsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListMlTransformsRequest, ListMlTransformsResponse>()
                .withOperationName("ListMLTransforms").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listMlTransformsRequest)
                .withMarshaller(new ListMlTransformsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or
     * the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can
     * use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
     * filtering, only resources with the tags are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMLTransforms(software.amazon.awssdk.services.glue.model.ListMlTransformsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client.listMLTransformsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client
     *             .listMLTransformsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListMlTransformsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListMLTransformsIterable responses = client.listMLTransformsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMLTransforms(software.amazon.awssdk.services.glue.model.ListMlTransformsRequest)} operation.</b>
     * </p>
     *
     * @param listMlTransformsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListMLTransforms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMLTransformsIterable listMLTransformsPaginator(ListMlTransformsRequest listMlTransformsRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        return new ListMLTransformsIterable(this, applyPaginatorUserAgent(listMlTransformsRequest));
    }

    /**
     * <p>
     * Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     *
     * @param listTriggersRequest
     * @return Result of the ListTriggers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTriggersResponse listTriggers(ListTriggersRequest listTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTriggersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTriggersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTriggersRequest, ListTriggersResponse>()
                .withOperationName("ListTriggers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTriggersRequest)
                .withMarshaller(new ListTriggersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This
     * operation allows you to see which resources are available in your account, and their names.
     * </p>
     * <p>
     * This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that
     * tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag
     * are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTriggers(software.amazon.awssdk.services.glue.model.ListTriggersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListTriggersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListTriggersIterable responses = client.listTriggersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTriggers(software.amazon.awssdk.services.glue.model.ListTriggersRequest)} operation.</b>
     * </p>
     *
     * @param listTriggersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTriggersIterable listTriggersPaginator(ListTriggersRequest listTriggersRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            GlueException {
        return new ListTriggersIterable(this, applyPaginatorUserAgent(listTriggersRequest));
    }

    /**
     * <p>
     * Lists names of workflows created in the account.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkflowsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListWorkflowsRequest, ListWorkflowsResponse>()
                .withOperationName("ListWorkflows").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listWorkflowsRequest)
                .withMarshaller(new ListWorkflowsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists names of workflows created in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.glue.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.glue.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ListWorkflows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkflowsIterable listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return new ListWorkflowsIterable(this, applyPaginatorUserAgent(listWorkflowsRequest));
    }

    /**
     * <p>
     * Sets the security configuration for a specified catalog. After the configuration has been set, the specified
     * encryption is applied to every catalog write thereafter.
     * </p>
     *
     * @param putDataCatalogEncryptionSettingsRequest
     * @return Result of the PutDataCatalogEncryptionSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutDataCatalogEncryptionSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutDataCatalogEncryptionSettingsResponse putDataCatalogEncryptionSettings(
            PutDataCatalogEncryptionSettingsRequest putDataCatalogEncryptionSettingsRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDataCatalogEncryptionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDataCatalogEncryptionSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PutDataCatalogEncryptionSettingsRequest, PutDataCatalogEncryptionSettingsResponse>()
                        .withOperationName("PutDataCatalogEncryptionSettings").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(putDataCatalogEncryptionSettingsRequest)
                        .withMarshaller(new PutDataCatalogEncryptionSettingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets the Data Catalog resource policy for access control.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ConditionCheckFailureException
     *         A specified condition was not satisfied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutResourcePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ConditionCheckFailureException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                .withOperationName("PutResourcePolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putResourcePolicyRequest)
                .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Puts the specified workflow run properties for the given workflow run. If a property already exists for the
     * specified run, then it overrides the value otherwise adds the property to existing properties.
     * </p>
     *
     * @param putWorkflowRunPropertiesRequest
     * @return Result of the PutWorkflowRunProperties operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.PutWorkflowRunProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PutWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutWorkflowRunPropertiesResponse putWorkflowRunProperties(
            PutWorkflowRunPropertiesRequest putWorkflowRunPropertiesRequest) throws AlreadyExistsException,
            EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutWorkflowRunPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutWorkflowRunPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PutWorkflowRunPropertiesRequest, PutWorkflowRunPropertiesResponse>()
                        .withOperationName("PutWorkflowRunProperties").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(putWorkflowRunPropertiesRequest)
                        .withMarshaller(new PutWorkflowRunPropertiesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Resets a bookmark entry.
     * </p>
     *
     * @param resetJobBookmarkRequest
     * @return Result of the ResetJobBookmark operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.ResetJobBookmark
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResetJobBookmarkResponse resetJobBookmark(ResetJobBookmarkRequest resetJobBookmarkRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetJobBookmarkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResetJobBookmarkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ResetJobBookmarkRequest, ResetJobBookmarkResponse>()
                .withOperationName("ResetJobBookmark").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resetJobBookmarkRequest)
                .withMarshaller(new ResetJobBookmarkRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches a set of tables based on properties in the table metadata as well as on the parent database. You can
     * search against text or filter conditions.
     * </p>
     * <p>
     * You can only get tables that you have access to based on the security policies defined in Lake Formation. You
     * need at least a read-only access to the table for it to be returned. If you do not have access to all the columns
     * in the table, these columns will not be searched against when returning the list of tables back to you. If you
     * have access to the columns but not the data in the columns, those columns and the associated metadata for those
     * columns will be included in the search.
     * </p>
     *
     * @param searchTablesRequest
     * @return Result of the SearchTables operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.SearchTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchTablesResponse searchTables(SearchTablesRequest searchTablesRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchTablesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchTablesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchTablesRequest, SearchTablesResponse>()
                .withOperationName("SearchTables").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchTablesRequest)
                .withMarshaller(new SearchTablesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches a set of tables based on properties in the table metadata as well as on the parent database. You can
     * search against text or filter conditions.
     * </p>
     * <p>
     * You can only get tables that you have access to based on the security policies defined in Lake Formation. You
     * need at least a read-only access to the table for it to be returned. If you do not have access to all the columns
     * in the table, these columns will not be searched against when returning the list of tables back to you. If you
     * have access to the columns but not the data in the columns, those columns and the associated metadata for those
     * columns will be included in the search.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #searchTables(software.amazon.awssdk.services.glue.model.SearchTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     *     for (software.amazon.awssdk.services.glue.model.SearchTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.SearchTablesIterable responses = client.searchTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTables(software.amazon.awssdk.services.glue.model.SearchTablesRequest)} operation.</b>
     * </p>
     *
     * @param searchTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.SearchTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SearchTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchTablesIterable searchTablesPaginator(SearchTablesRequest searchTablesRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        return new SearchTablesIterable(this, applyPaginatorUserAgent(searchTablesRequest));
    }

    /**
     * <p>
     * Starts a crawl using the specified crawler, regardless of what is scheduled. If the crawler is already running,
     * returns a <a href=
     * "https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException"
     * >CrawlerRunningException</a>.
     * </p>
     *
     * @param startCrawlerRequest
     * @return Result of the StartCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartCrawlerResponse startCrawler(StartCrawlerRequest startCrawlerRequest) throws EntityNotFoundException,
            CrawlerRunningException, OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartCrawlerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartCrawlerRequest, StartCrawlerResponse>()
                .withOperationName("StartCrawler").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startCrawlerRequest)
                .withMarshaller(new StartCrawlerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Changes the schedule state of the specified crawler to <code>SCHEDULED</code>, unless the crawler is already
     * running or the schedule state is already <code>SCHEDULED</code>.
     * </p>
     *
     * @param startCrawlerScheduleRequest
     * @return Result of the StartCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SchedulerRunningException
     *         The specified scheduler is already running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws NoScheduleException
     *         There is no applicable schedule.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartCrawlerScheduleResponse startCrawlerSchedule(StartCrawlerScheduleRequest startCrawlerScheduleRequest)
            throws EntityNotFoundException, SchedulerRunningException, SchedulerTransitioningException, NoScheduleException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCrawlerScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartCrawlerScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartCrawlerScheduleRequest, StartCrawlerScheduleResponse>()
                .withOperationName("StartCrawlerSchedule").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startCrawlerScheduleRequest)
                .withMarshaller(new StartCrawlerScheduleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Begins an asynchronous task to export all labeled data for a particular transform. This task is the only
     * label-related API call that is not part of the typical active learning workflow. You typically use
     * <code>StartExportLabelsTaskRun</code> when you want to work with all of your existing labels at the same time,
     * such as when you want to remove or change labels that were previously submitted as truth. This API operation
     * accepts the <code>TransformId</code> whose labels you want to export and an Amazon Simple Storage Service (Amazon
     * S3) path to export the labels to. The operation returns a <code>TaskRunId</code>. You can check on the status of
     * your task run by calling the <code>GetMLTaskRun</code> API.
     * </p>
     *
     * @param startExportLabelsTaskRunRequest
     * @return Result of the StartExportLabelsTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartExportLabelsTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartExportLabelsTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartExportLabelsTaskRunResponse startExportLabelsTaskRun(
            StartExportLabelsTaskRunRequest startExportLabelsTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartExportLabelsTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartExportLabelsTaskRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<StartExportLabelsTaskRunRequest, StartExportLabelsTaskRunResponse>()
                        .withOperationName("StartExportLabelsTaskRun").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(startExportLabelsTaskRunRequest)
                        .withMarshaller(new StartExportLabelsTaskRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Enables you to provide additional labels (examples of truth) to be used to teach the machine learning transform
     * and improve its quality. This API operation is generally used as part of the active learning workflow that starts
     * with the <code>StartMLLabelingSetGenerationTaskRun</code> call and that ultimately results in improving the
     * quality of your machine learning transform.
     * </p>
     * <p>
     * After the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue machine learning will have
     * generated a series of questions for humans to answer. (Answering these questions is often called 'labeling' in
     * the machine learning workflows). In the case of the <code>FindMatches</code> transform, these questions are of
     * the form, “What is the correct way to group these rows together into groups composed entirely of matching
     * records?” After the labeling process is finished, users upload their answers/labels with a call to
     * <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of
     * the machine learning transform use the new and improved labels and perform a higher-quality transformation.
     * </p>
     * <p>
     * By default, <code>StartMLLabelingSetGenerationTaskRun</code> continually learns from and combines all labels that
     * you upload unless you set <code>Replace</code> to true. If you set <code>Replace</code> to true,
     * <code>StartImportLabelsTaskRun</code> deletes and forgets all previously uploaded labels and learns only from the
     * exact set that you upload. Replacing labels can be helpful if you realize that you previously uploaded incorrect
     * labels, and you believe that they are having a negative effect on your transform quality.
     * </p>
     * <p>
     * You can check on the status of your task run by calling the <code>GetMLTaskRun</code> operation.
     * </p>
     *
     * @param startImportLabelsTaskRunRequest
     * @return Result of the StartImportLabelsTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartImportLabelsTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartImportLabelsTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartImportLabelsTaskRunResponse startImportLabelsTaskRun(
            StartImportLabelsTaskRunRequest startImportLabelsTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, ResourceNumberLimitExceededException, InternalServiceException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImportLabelsTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartImportLabelsTaskRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<StartImportLabelsTaskRunRequest, StartImportLabelsTaskRunResponse>()
                        .withOperationName("StartImportLabelsTaskRun").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(startImportLabelsTaskRunRequest)
                        .withMarshaller(new StartImportLabelsTaskRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts a job run using a job definition.
     * </p>
     *
     * @param startJobRunRequest
     * @return Result of the StartJobRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartJobRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartJobRunResponse startJobRun(StartJobRunRequest startJobRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartJobRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartJobRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartJobRunRequest, StartJobRunResponse>()
                .withOperationName("StartJobRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startJobRunRequest)
                .withMarshaller(new StartJobRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts a task to estimate the quality of the transform.
     * </p>
     * <p>
     * When you provide label sets as examples of truth, AWS Glue machine learning uses some of those examples to learn
     * from them. The rest of the labels are used as a test to estimate quality.
     * </p>
     * <p>
     * Returns a unique identifier for the run. You can call <code>GetMLTaskRun</code> to get more information about the
     * stats of the <code>EvaluationTaskRun</code>.
     * </p>
     *
     * @param startMlEvaluationTaskRunRequest
     * @return Result of the StartMLEvaluationTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws MlTransformNotReadyException
     *         The machine learning transform is not ready to run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartMLEvaluationTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLEvaluationTaskRun" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartMlEvaluationTaskRunResponse startMLEvaluationTaskRun(
            StartMlEvaluationTaskRunRequest startMlEvaluationTaskRunRequest) throws EntityNotFoundException,
            InvalidInputException, OperationTimeoutException, InternalServiceException, ConcurrentRunsExceededException,
            MlTransformNotReadyException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMlEvaluationTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMlEvaluationTaskRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<StartMlEvaluationTaskRunRequest, StartMlEvaluationTaskRunResponse>()
                        .withOperationName("StartMLEvaluationTaskRun").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(startMlEvaluationTaskRunRequest)
                        .withMarshaller(new StartMlEvaluationTaskRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts the active learning workflow for your machine learning transform to improve the transform's quality by
     * generating label sets and adding labels.
     * </p>
     * <p>
     * When the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue will have generated a "labeling set"
     * or a set of questions for humans to answer.
     * </p>
     * <p>
     * In the case of the <code>FindMatches</code> transform, these questions are of the form, “What is the correct way
     * to group these rows together into groups composed entirely of matching records?”
     * </p>
     * <p>
     * After the labeling process is finished, you can upload your labels with a call to
     * <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of
     * the machine learning transform will use the new and improved labels and perform a higher-quality transformation.
     * </p>
     *
     * @param startMlLabelingSetGenerationTaskRunRequest
     * @return Result of the StartMLLabelingSetGenerationTaskRun operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartMLLabelingSetGenerationTaskRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartMLLabelingSetGenerationTaskRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMlLabelingSetGenerationTaskRunResponse startMLLabelingSetGenerationTaskRun(
            StartMlLabelingSetGenerationTaskRunRequest startMlLabelingSetGenerationTaskRunRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMlLabelingSetGenerationTaskRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMlLabelingSetGenerationTaskRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<StartMlLabelingSetGenerationTaskRunRequest, StartMlLabelingSetGenerationTaskRunResponse>()
                        .withOperationName("StartMLLabelingSetGenerationTaskRun").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(startMlLabelingSetGenerationTaskRunRequest)
                        .withMarshaller(new StartMlLabelingSetGenerationTaskRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts an existing trigger. See <a href="https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html">Triggering
     * Jobs</a> for information about how different types of trigger are started.
     * </p>
     *
     * @param startTriggerRequest
     * @return Result of the StartTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartTriggerResponse startTrigger(StartTriggerRequest startTriggerRequest) throws InvalidInputException,
            InternalServiceException, EntityNotFoundException, OperationTimeoutException, ResourceNumberLimitExceededException,
            ConcurrentRunsExceededException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartTriggerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartTriggerRequest, StartTriggerResponse>()
                .withOperationName("StartTrigger").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startTriggerRequest)
                .withMarshaller(new StartTriggerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Starts a new run of the specified workflow.
     * </p>
     *
     * @param startWorkflowRunRequest
     * @return Result of the StartWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws ConcurrentRunsExceededException
     *         Too many jobs are being run concurrently.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StartWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartWorkflowRunResponse startWorkflowRun(StartWorkflowRunRequest startWorkflowRunRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            ResourceNumberLimitExceededException, ConcurrentRunsExceededException, AwsServiceException, SdkClientException,
            GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartWorkflowRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartWorkflowRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartWorkflowRunRequest, StartWorkflowRunResponse>()
                .withOperationName("StartWorkflowRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startWorkflowRunRequest)
                .withMarshaller(new StartWorkflowRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * If the specified crawler is running, stops the crawl.
     * </p>
     *
     * @param stopCrawlerRequest
     * @return Result of the StopCrawler operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerNotRunningException
     *         The specified crawler is not running.
     * @throws CrawlerStoppingException
     *         The specified crawler is stopping.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopCrawlerResponse stopCrawler(StopCrawlerRequest stopCrawlerRequest) throws EntityNotFoundException,
            CrawlerNotRunningException, CrawlerStoppingException, OperationTimeoutException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopCrawlerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StopCrawlerRequest, StopCrawlerResponse>()
                .withOperationName("StopCrawler").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopCrawlerRequest)
                .withMarshaller(new StopCrawlerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets the schedule state of the specified crawler to <code>NOT_SCHEDULED</code>, but does not stop the crawler if
     * it is already running.
     * </p>
     *
     * @param stopCrawlerScheduleRequest
     * @return Result of the StopCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SchedulerNotRunningException
     *         The specified scheduler is not running.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopCrawlerScheduleResponse stopCrawlerSchedule(StopCrawlerScheduleRequest stopCrawlerScheduleRequest)
            throws EntityNotFoundException, SchedulerNotRunningException, SchedulerTransitioningException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopCrawlerScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopCrawlerScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StopCrawlerScheduleRequest, StopCrawlerScheduleResponse>()
                .withOperationName("StopCrawlerSchedule").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopCrawlerScheduleRequest)
                .withMarshaller(new StopCrawlerScheduleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stops a specified trigger.
     * </p>
     *
     * @param stopTriggerRequest
     * @return Result of the StopTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopTriggerResponse stopTrigger(StopTriggerRequest stopTriggerRequest) throws InvalidInputException,
            InternalServiceException, EntityNotFoundException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopTriggerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StopTriggerRequest, StopTriggerResponse>()
                .withOperationName("StopTrigger").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopTriggerRequest)
                .withMarshaller(new StopTriggerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stops the execution of the specified workflow run.
     * </p>
     *
     * @param stopWorkflowRunRequest
     * @return Result of the StopWorkflowRun operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws IllegalWorkflowStateException
     *         The workflow is in an invalid state to perform a requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.StopWorkflowRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopWorkflowRunResponse stopWorkflowRun(StopWorkflowRunRequest stopWorkflowRunRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, IllegalWorkflowStateException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopWorkflowRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopWorkflowRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StopWorkflowRunRequest, StopWorkflowRunResponse>()
                .withOperationName("StopWorkflowRun").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopWorkflowRunRequest)
                .withMarshaller(new StopWorkflowRunRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds tags to a resource. A tag is a label you can assign to an AWS resource. In AWS Glue, you can tag only
     * certain resources. For information about what resources you can tag, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Modifies an existing classifier (a <code>GrokClassifier</code>, an <code>XMLClassifier</code>, a
     * <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which field is present).
     * </p>
     *
     * @param updateClassifierRequest
     * @return Result of the UpdateClassifier operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateClassifierResponse updateClassifier(UpdateClassifierRequest updateClassifierRequest)
            throws InvalidInputException, VersionMismatchException, EntityNotFoundException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateClassifierResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateClassifierResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateClassifierRequest, UpdateClassifierResponse>()
                .withOperationName("UpdateClassifier").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateClassifierRequest)
                .withMarshaller(new UpdateClassifierRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a connection definition in the Data Catalog.
     * </p>
     *
     * @param updateConnectionRequest
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateConnectionRequest, UpdateConnectionResponse>()
                .withOperationName("UpdateConnection").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateConnectionRequest)
                .withMarshaller(new UpdateConnectionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a crawler. If a crawler is running, you must stop it using <code>StopCrawler</code> before updating it.
     * </p>
     *
     * @param updateCrawlerRequest
     * @return Result of the UpdateCrawler operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws CrawlerRunningException
     *         The operation cannot be performed because the crawler is already running.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateCrawler
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateCrawlerResponse updateCrawler(UpdateCrawlerRequest updateCrawlerRequest) throws InvalidInputException,
            VersionMismatchException, EntityNotFoundException, CrawlerRunningException, OperationTimeoutException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCrawlerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCrawlerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateCrawlerRequest, UpdateCrawlerResponse>()
                .withOperationName("UpdateCrawler").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateCrawlerRequest)
                .withMarshaller(new UpdateCrawlerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the schedule of a crawler using a <code>cron</code> expression.
     * </p>
     *
     * @param updateCrawlerScheduleRequest
     * @return Result of the UpdateCrawlerSchedule operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws VersionMismatchException
     *         There was a version conflict.
     * @throws SchedulerTransitioningException
     *         The specified scheduler is transitioning.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateCrawlerSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateCrawlerScheduleResponse updateCrawlerSchedule(UpdateCrawlerScheduleRequest updateCrawlerScheduleRequest)
            throws EntityNotFoundException, InvalidInputException, VersionMismatchException, SchedulerTransitioningException,
            OperationTimeoutException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCrawlerScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCrawlerScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateCrawlerScheduleRequest, UpdateCrawlerScheduleResponse>()
                .withOperationName("UpdateCrawlerSchedule").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateCrawlerScheduleRequest)
                .withMarshaller(new UpdateCrawlerScheduleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing database definition in a Data Catalog.
     * </p>
     *
     * @param updateDatabaseRequest
     * @return Result of the UpdateDatabase operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDatabaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateDatabaseRequest, UpdateDatabaseResponse>()
                .withOperationName("UpdateDatabase").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDatabaseRequest)
                .withMarshaller(new UpdateDatabaseRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a specified development endpoint.
     * </p>
     *
     * @param updateDevEndpointRequest
     * @return Result of the UpdateDevEndpoint operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ValidationException
     *         A value could not be validated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateDevEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDevEndpointResponse updateDevEndpoint(UpdateDevEndpointRequest updateDevEndpointRequest)
            throws EntityNotFoundException, InternalServiceException, OperationTimeoutException, InvalidInputException,
            ValidationException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDevEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDevEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateDevEndpointRequest, UpdateDevEndpointResponse>()
                .withOperationName("UpdateDevEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDevEndpointRequest)
                .withMarshaller(new UpdateDevEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing job definition.
     * </p>
     *
     * @param updateJobRequest
     * @return Result of the UpdateJob operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidInputException, EntityNotFoundException,
            InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateJobRequest, UpdateJobResponse>()
                .withOperationName("UpdateJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateJobRequest)
                .withMarshaller(new UpdateJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve
     * better results.
     * </p>
     * <p>
     * After calling this operation, you can call the <code>StartMLEvaluationTaskRun</code> operation to assess how well
     * your new parameters achieved your goals (such as improving the quality of your machine learning transform, or
     * making it more cost-effective).
     * </p>
     *
     * @param updateMlTransformRequest
     * @return Result of the UpdateMLTransform operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateMLTransform
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateMlTransformResponse updateMLTransform(UpdateMlTransformRequest updateMlTransformRequest)
            throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMlTransformResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMlTransformResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateMlTransformRequest, UpdateMlTransformResponse>()
                .withOperationName("UpdateMLTransform").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateMlTransformRequest)
                .withMarshaller(new UpdateMlTransformRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a partition.
     * </p>
     *
     * @param updatePartitionRequest
     * @return Result of the UpdatePartition operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdatePartition
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdatePartitionResponse updatePartition(UpdatePartitionRequest updatePartitionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePartitionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePartitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdatePartitionRequest, UpdatePartitionResponse>()
                .withOperationName("UpdatePartition").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updatePartitionRequest)
                .withMarshaller(new UpdatePartitionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a metadata table in the Data Catalog.
     * </p>
     *
     * @param updateTableRequest
     * @return Result of the UpdateTable operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            ResourceNumberLimitExceededException, GlueEncryptionException, AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateTableRequest, UpdateTableResponse>()
                .withOperationName("UpdateTable").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateTableRequest)
                .withMarshaller(new UpdateTableRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a trigger definition.
     * </p>
     *
     * @param updateTriggerRequest
     * @return Result of the UpdateTrigger operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateTrigger
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateTriggerResponse updateTrigger(UpdateTriggerRequest updateTriggerRequest) throws InvalidInputException,
            InternalServiceException, EntityNotFoundException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTriggerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTriggerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateTriggerRequest, UpdateTriggerResponse>()
                .withOperationName("UpdateTrigger").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateTriggerRequest)
                .withMarshaller(new UpdateTriggerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing function definition in the Data Catalog.
     * </p>
     *
     * @param updateUserDefinedFunctionRequest
     * @return Result of the UpdateUserDefinedFunction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateUserDefinedFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateUserDefinedFunctionResponse updateUserDefinedFunction(
            UpdateUserDefinedFunctionRequest updateUserDefinedFunctionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserDefinedFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateUserDefinedFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateUserDefinedFunctionRequest, UpdateUserDefinedFunctionResponse>()
                        .withOperationName("UpdateUserDefinedFunction").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateUserDefinedFunctionRequest)
                        .withMarshaller(new UpdateUserDefinedFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing workflow.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlueException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlueClient.UpdateWorkflow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWorkflowResponse updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, GlueException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkflowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateWorkflowRequest, UpdateWorkflowResponse>()
                .withOperationName("UpdateWorkflow").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateWorkflowRequest)
                .withMarshaller(new UpdateWorkflowRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GlueException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SchedulerRunningException")
                                .exceptionBuilderSupplier(SchedulerRunningException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SchedulerTransitioningException")
                                .exceptionBuilderSupplier(SchedulerTransitioningException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CrawlerRunningException")
                                .exceptionBuilderSupplier(CrawlerRunningException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceException")
                                .exceptionBuilderSupplier(InternalServiceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CrawlerStoppingException")
                                .exceptionBuilderSupplier(CrawlerStoppingException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInputException")
                                .exceptionBuilderSupplier(InvalidInputException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CrawlerNotRunningException")
                                .exceptionBuilderSupplier(CrawlerNotRunningException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityNotFoundException")
                                .exceptionBuilderSupplier(EntityNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlueEncryptionException")
                                .exceptionBuilderSupplier(GlueEncryptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationTimeoutException")
                                .exceptionBuilderSupplier(OperationTimeoutException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VersionMismatchException")
                                .exceptionBuilderSupplier(VersionMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoScheduleException")
                                .exceptionBuilderSupplier(NoScheduleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MLTransformNotReadyException")
                                .exceptionBuilderSupplier(MlTransformNotReadyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalWorkflowStateException")
                                .exceptionBuilderSupplier(IllegalWorkflowStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentRunsExceededException")
                                .exceptionBuilderSupplier(ConcurrentRunsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException")
                                .exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SchedulerNotRunningException")
                                .exceptionBuilderSupplier(SchedulerNotRunningException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConditionCheckFailureException")
                                .exceptionBuilderSupplier(ConditionCheckFailureException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends GlueRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
