/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;

public class GetPartitionsPublisher
implements SdkPublisher<GetPartitionsResponse> {
    private final GlueAsyncClient client;
    private final GetPartitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPartitionsPublisher(GlueAsyncClient client, GetPartitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPartitionsPublisher(GlueAsyncClient client, GetPartitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPartitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPartitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetPartitionsResponseFetcher
    implements AsyncPageFetcher<GetPartitionsResponse> {
        private GetPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPartitionsResponse> nextPage(GetPartitionsResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionsPublisher.this.client.getPartitions(GetPartitionsPublisher.this.firstRequest);
            }
            return GetPartitionsPublisher.this.client.getPartitions((GetPartitionsRequest)((Object)GetPartitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

