/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetJobRunRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobRunRequest.getter(GetJobRunRequest::jobName)).setter(GetJobRunRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetJobRunRequest.getter(GetJobRunRequest::runId)).setter(GetJobRunRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<Boolean> PREDECESSORS_INCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetJobRunRequest.getter(GetJobRunRequest::predecessorsIncluded)).setter(GetJobRunRequest.setter(Builder::predecessorsIncluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredecessorsIncluded").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, RUN_ID_FIELD, PREDECESSORS_INCLUDED_FIELD));
    private final String jobName;
    private final String runId;
    private final Boolean predecessorsIncluded;

    private GetJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.runId = builder.runId;
        this.predecessorsIncluded = builder.predecessorsIncluded;
    }

    public String jobName() {
        return this.jobName;
    }

    public String runId() {
        return this.runId;
    }

    public Boolean predecessorsIncluded() {
        return this.predecessorsIncluded;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.predecessorsIncluded());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunRequest)) {
            return false;
        }
        GetJobRunRequest other = (GetJobRunRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.predecessorsIncluded(), other.predecessorsIncluded());
    }

    public String toString() {
        return ToString.builder((String)"GetJobRunRequest").add("JobName", (Object)this.jobName()).add("RunId", (Object)this.runId()).add("PredecessorsIncluded", (Object)this.predecessorsIncluded()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "PredecessorsIncluded": {
                return Optional.ofNullable(clazz.cast(this.predecessorsIncluded()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobRunRequest, T> g) {
        return obj -> g.apply((GetJobRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String runId;
        private Boolean predecessorsIncluded;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.runId(model.runId);
            this.predecessorsIncluded(model.predecessorsIncluded);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final Boolean getPredecessorsIncluded() {
            return this.predecessorsIncluded;
        }

        @Override
        public final Builder predecessorsIncluded(Boolean predecessorsIncluded) {
            this.predecessorsIncluded = predecessorsIncluded;
            return this;
        }

        public final void setPredecessorsIncluded(Boolean predecessorsIncluded) {
            this.predecessorsIncluded = predecessorsIncluded;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJobRunRequest build() {
            return new GetJobRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobRunRequest> {
        public Builder jobName(String var1);

        public Builder runId(String var1);

        public Builder predecessorsIncluded(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

