/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.GlueTable;
import software.amazon.awssdk.services.glue.model.GlueTablesCopier;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.services.glue.model.TransformParameters;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMlTransformRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateMlTransformRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::name)).setter(CreateMlTransformRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::description)).setter(CreateMlTransformRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<GlueTable>> INPUT_RECORD_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::inputRecordTables)).setter(CreateMlTransformRequest.setter(Builder::inputRecordTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRecordTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TransformParameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::parameters)).setter(CreateMlTransformRequest.setter(Builder::parameters)).constructor(TransformParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::role)).setter(CreateMlTransformRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::glueVersion)).setter(CreateMlTransformRequest.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::maxCapacity)).setter(CreateMlTransformRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::workerTypeAsString)).setter(CreateMlTransformRequest.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::numberOfWorkers)).setter(CreateMlTransformRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::timeout)).setter(CreateMlTransformRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::maxRetries)).setter(CreateMlTransformRequest.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateMlTransformRequest.getter(CreateMlTransformRequest::tags)).setter(CreateMlTransformRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INPUT_RECORD_TABLES_FIELD, PARAMETERS_FIELD, ROLE_FIELD, GLUE_VERSION_FIELD, MAX_CAPACITY_FIELD, WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, MAX_RETRIES_FIELD, TAGS_FIELD));
    private final String name;
    private final String description;
    private final List<GlueTable> inputRecordTables;
    private final TransformParameters parameters;
    private final String role;
    private final String glueVersion;
    private final Double maxCapacity;
    private final String workerType;
    private final Integer numberOfWorkers;
    private final Integer timeout;
    private final Integer maxRetries;
    private final Map<String, String> tags;

    private CreateMlTransformRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.inputRecordTables = builder.inputRecordTables;
        this.parameters = builder.parameters;
        this.role = builder.role;
        this.glueVersion = builder.glueVersion;
        this.maxCapacity = builder.maxCapacity;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
        this.tags = builder.tags;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasInputRecordTables() {
        return this.inputRecordTables != null && !(this.inputRecordTables instanceof SdkAutoConstructList);
    }

    public List<GlueTable> inputRecordTables() {
        return this.inputRecordTables;
    }

    public TransformParameters parameters() {
        return this.parameters;
    }

    public String role() {
        return this.role;
    }

    public String glueVersion() {
        return this.glueVersion;
    }

    public Double maxCapacity() {
        return this.maxCapacity;
    }

    public WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public String workerTypeAsString() {
        return this.workerType;
    }

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputRecordTables());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlTransformRequest)) {
            return false;
        }
        CreateMlTransformRequest other = (CreateMlTransformRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inputRecordTables(), other.inputRecordTables()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateMlTransformRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("InputRecordTables", this.inputRecordTables()).add("Parameters", (Object)this.parameters()).add("Role", (Object)this.role()).add("GlueVersion", (Object)this.glueVersion()).add("MaxCapacity", (Object)this.maxCapacity()).add("WorkerType", (Object)this.workerTypeAsString()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("Timeout", (Object)this.timeout()).add("MaxRetries", (Object)this.maxRetries()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InputRecordTables": {
                return Optional.ofNullable(clazz.cast(this.inputRecordTables()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMlTransformRequest, T> g) {
        return obj -> g.apply((CreateMlTransformRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<GlueTable> inputRecordTables = DefaultSdkAutoConstructList.getInstance();
        private TransformParameters parameters;
        private String role;
        private String glueVersion;
        private Double maxCapacity;
        private String workerType;
        private Integer numberOfWorkers;
        private Integer timeout;
        private Integer maxRetries;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlTransformRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.inputRecordTables(model.inputRecordTables);
            this.parameters(model.parameters);
            this.role(model.role);
            this.glueVersion(model.glueVersion);
            this.maxCapacity(model.maxCapacity);
            this.workerType(model.workerType);
            this.numberOfWorkers(model.numberOfWorkers);
            this.timeout(model.timeout);
            this.maxRetries(model.maxRetries);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GlueTable.Builder> getInputRecordTables() {
            return this.inputRecordTables != null ? (Collection)this.inputRecordTables.stream().map(GlueTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputRecordTables(Collection<GlueTable> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copy(inputRecordTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(GlueTable ... inputRecordTables) {
            this.inputRecordTables(Arrays.asList(inputRecordTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(Consumer<GlueTable.Builder> ... inputRecordTables) {
            this.inputRecordTables(Stream.of(inputRecordTables).map(c -> (GlueTable)((GlueTable.Builder)GlueTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputRecordTables(Collection<GlueTable.BuilderImpl> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copyFromBuilder(inputRecordTables);
        }

        public final TransformParameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(TransformParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(TransformParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getWorkerTypeAsString() {
            return this.workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlTransformRequest build() {
            return new CreateMlTransformRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMlTransformRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder inputRecordTables(Collection<GlueTable> var1);

        public Builder inputRecordTables(GlueTable ... var1);

        public Builder inputRecordTables(Consumer<GlueTable.Builder> ... var1);

        public Builder parameters(TransformParameters var1);

        default public Builder parameters(Consumer<TransformParameters.Builder> parameters) {
            return this.parameters((TransformParameters)((TransformParameters.Builder)TransformParameters.builder().applyMutation(parameters)).build());
        }

        public Builder role(String var1);

        public Builder glueVersion(String var1);

        public Builder maxCapacity(Double var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder timeout(Integer var1);

        public Builder maxRetries(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

