/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Condition;
import software.amazon.awssdk.services.glue.model.ConditionListCopier;
import software.amazon.awssdk.services.glue.model.Logical;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Predicate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Predicate> {
    private static final SdkField<String> LOGICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Predicate.getter(Predicate::logicalAsString)).setter(Predicate.setter(Builder::logical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logical").build()}).build();
    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Predicate.getter(Predicate::conditions)).setter(Predicate.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_FIELD, CONDITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logical;
    private final List<Condition> conditions;

    private Predicate(BuilderImpl builder) {
        this.logical = builder.logical;
        this.conditions = builder.conditions;
    }

    public Logical logical() {
        return Logical.fromValue(this.logical);
    }

    public String logicalAsString() {
        return this.logical;
    }

    public boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        return Objects.equals(this.logicalAsString(), other.logicalAsString()) && Objects.equals(this.conditions(), other.conditions());
    }

    public String toString() {
        return ToString.builder((String)"Predicate").add("Logical", (Object)this.logicalAsString()).add("Conditions", this.conditions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Logical": {
                return Optional.ofNullable(clazz.cast(this.logicalAsString()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Predicate, T> g) {
        return obj -> g.apply((Predicate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logical;
        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            this.logical(model.logical);
            this.conditions(model.conditions);
        }

        public final String getLogicalAsString() {
            return this.logical;
        }

        @Override
        public final Builder logical(String logical) {
            this.logical = logical;
            return this;
        }

        @Override
        public final Builder logical(Logical logical) {
            this.logical(logical == null ? null : logical.toString());
            return this;
        }

        public final void setLogical(String logical) {
            this.logical = logical;
        }

        public final Collection<Condition.Builder> getConditions() {
            return this.conditions != null ? (Collection)this.conditions.stream().map(Condition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (Condition)((Condition.Builder)Condition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionListCopier.copyFromBuilder(conditions);
        }

        public Predicate build() {
            return new Predicate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Predicate> {
        public Builder logical(String var1);

        public Builder logical(Logical var1);

        public Builder conditions(Collection<Condition> var1);

        public Builder conditions(Condition ... var1);

        public Builder conditions(Consumer<Condition.Builder> ... var1);
    }
}

