/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTriggerResponse extends GlueResponse implements
        ToCopyableBuilder<UpdateTriggerResponse.Builder, UpdateTriggerResponse> {
    private static final SdkField<Trigger> TRIGGER_FIELD = SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateTriggerResponse::trigger)).setter(setter(Builder::trigger)).constructor(Trigger::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trigger").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_FIELD));

    private final Trigger trigger;

    private UpdateTriggerResponse(BuilderImpl builder) {
        super(builder);
        this.trigger = builder.trigger;
    }

    /**
     * <p>
     * The resulting trigger definition.
     * </p>
     * 
     * @return The resulting trigger definition.
     */
    public Trigger trigger() {
        return trigger;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trigger());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTriggerResponse)) {
            return false;
        }
        UpdateTriggerResponse other = (UpdateTriggerResponse) obj;
        return Objects.equals(trigger(), other.trigger());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTriggerResponse").add("Trigger", trigger()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Trigger":
            return Optional.ofNullable(clazz.cast(trigger()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTriggerResponse, T> g) {
        return obj -> g.apply((UpdateTriggerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTriggerResponse> {
        /**
         * <p>
         * The resulting trigger definition.
         * </p>
         * 
         * @param trigger
         *        The resulting trigger definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trigger(Trigger trigger);

        /**
         * <p>
         * The resulting trigger definition.
         * </p>
         * This is a convenience that creates an instance of the {@link Trigger.Builder} avoiding the need to create one
         * manually via {@link Trigger#builder()}.
         *
         * When the {@link Consumer} completes, {@link Trigger.Builder#build()} is called immediately and its result is
         * passed to {@link #trigger(Trigger)}.
         * 
         * @param trigger
         *        a consumer that will call methods on {@link Trigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trigger(Trigger)
         */
        default Builder trigger(Consumer<Trigger.Builder> trigger) {
            return trigger(Trigger.builder().applyMutation(trigger).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Trigger trigger;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTriggerResponse model) {
            super(model);
            trigger(model.trigger);
        }

        public final Trigger.Builder getTrigger() {
            return trigger != null ? trigger.toBuilder() : null;
        }

        @Override
        public final Builder trigger(Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public final void setTrigger(Trigger.BuilderImpl trigger) {
            this.trigger = trigger != null ? trigger.build() : null;
        }

        @Override
        public UpdateTriggerResponse build() {
            return new UpdateTriggerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
