/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportLabelsTaskRunResponse extends GlueResponse implements
        ToCopyableBuilder<StartImportLabelsTaskRunResponse.Builder, StartImportLabelsTaskRunResponse> {
    private static final SdkField<String> TASK_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartImportLabelsTaskRunResponse::taskRunId)).setter(setter(Builder::taskRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskRunId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_RUN_ID_FIELD));

    private final String taskRunId;

    private StartImportLabelsTaskRunResponse(BuilderImpl builder) {
        super(builder);
        this.taskRunId = builder.taskRunId;
    }

    /**
     * <p>
     * The unique identifier for the task run.
     * </p>
     * 
     * @return The unique identifier for the task run.
     */
    public String taskRunId() {
        return taskRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskRunId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportLabelsTaskRunResponse)) {
            return false;
        }
        StartImportLabelsTaskRunResponse other = (StartImportLabelsTaskRunResponse) obj;
        return Objects.equals(taskRunId(), other.taskRunId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartImportLabelsTaskRunResponse").add("TaskRunId", taskRunId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskRunId":
            return Optional.ofNullable(clazz.cast(taskRunId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportLabelsTaskRunResponse, T> g) {
        return obj -> g.apply((StartImportLabelsTaskRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartImportLabelsTaskRunResponse> {
        /**
         * <p>
         * The unique identifier for the task run.
         * </p>
         * 
         * @param taskRunId
         *        The unique identifier for the task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunId(String taskRunId);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String taskRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportLabelsTaskRunResponse model) {
            super(model);
            taskRunId(model.taskRunId);
        }

        public final String getTaskRunId() {
            return taskRunId;
        }

        @Override
        public final Builder taskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        public final void setTaskRunId(String taskRunId) {
            this.taskRunId = taskRunId;
        }

        @Override
        public StartImportLabelsTaskRunResponse build() {
            return new StartImportLabelsTaskRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
