/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies code executed when a job is run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobCommand implements SdkPojo, Serializable, ToCopyableBuilder<JobCommand.Builder, JobCommand> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobCommand::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SCRIPT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobCommand::scriptLocation)).setter(setter(Builder::scriptLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptLocation").build()).build();

    private static final SdkField<String> PYTHON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobCommand::pythonVersion)).setter(setter(Builder::pythonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SCRIPT_LOCATION_FIELD, PYTHON_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String scriptLocation;

    private final String pythonVersion;

    private JobCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptLocation = builder.scriptLocation;
        this.pythonVersion = builder.pythonVersion;
    }

    /**
     * <p>
     * The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python shell
     * job, it must be <code>pythonshell</code>.
     * </p>
     * 
     * @return The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python
     *         shell job, it must be <code>pythonshell</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job.
     * </p>
     * 
     * @return Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job.
     */
    public String scriptLocation() {
        return scriptLocation;
    }

    /**
     * <p>
     * The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
     * </p>
     * 
     * @return The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
     */
    public String pythonVersion() {
        return pythonVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scriptLocation());
        hashCode = 31 * hashCode + Objects.hashCode(pythonVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobCommand)) {
            return false;
        }
        JobCommand other = (JobCommand) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scriptLocation(), other.scriptLocation())
                && Objects.equals(pythonVersion(), other.pythonVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobCommand").add("Name", name()).add("ScriptLocation", scriptLocation())
                .add("PythonVersion", pythonVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ScriptLocation":
            return Optional.ofNullable(clazz.cast(scriptLocation()));
        case "PythonVersion":
            return Optional.ofNullable(clazz.cast(pythonVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobCommand, T> g) {
        return obj -> g.apply((JobCommand) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobCommand> {
        /**
         * <p>
         * The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python
         * shell job, it must be <code>pythonshell</code>.
         * </p>
         * 
         * @param name
         *        The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a
         *        Python shell job, it must be <code>pythonshell</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job.
         * </p>
         * 
         * @param scriptLocation
         *        Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptLocation(String scriptLocation);

        /**
         * <p>
         * The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
         * </p>
         * 
         * @param pythonVersion
         *        The Python version being used to execute a Python shell job. Allowed values are 2 or 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonVersion(String pythonVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String scriptLocation;

        private String pythonVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobCommand model) {
            name(model.name);
            scriptLocation(model.scriptLocation);
            pythonVersion(model.pythonVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getScriptLocation() {
            return scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        public final String getPythonVersion() {
            return pythonVersion;
        }

        @Override
        public final Builder pythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        public final void setPythonVersion(String pythonVersion) {
            this.pythonVersion = pythonVersion;
        }

        @Override
        public JobCommand build() {
            return new JobCommand(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
