/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure used to create or update a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseInput implements SdkPojo, Serializable, ToCopyableBuilder<DatabaseInput.Builder, DatabaseInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatabaseInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatabaseInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatabaseInput::locationUri)).setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DatabaseInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .getter(getter(DatabaseInput::createTableDefaultPermissions))
            .setter(setter(Builder::createTableDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            LOCATION_URI_FIELD, PARAMETERS_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String locationUri;

    private final Map<String, String> parameters;

    private final List<PrincipalPermissions> createTableDefaultPermissions;

    private DatabaseInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.locationUri = builder.locationUri;
        this.parameters = builder.parameters;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
    }

    /**
     * <p>
     * The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
     * </p>
     * 
     * @return The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the database.
     * </p>
     * 
     * @return A description of the database.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The location of the database (for example, an HDFS path).
     * </p>
     * 
     * @return The location of the database (for example, an HDFS path).
     */
    public String locationUri() {
        return locationUri;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define parameters and properties of the database.
     * </p>
     * <p>
     * These key-value pairs define parameters and properties of the database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return These key-value pairs define parameters and properties of the database.</p>
     *         <p>
     *         These key-value pairs define parameters and properties of the database.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * Returns true if the CreateTableDefaultPermissions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCreateTableDefaultPermissions() {
        return createTableDefaultPermissions != null && !(createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Creates a set of default permissions on the table for principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreateTableDefaultPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Creates a set of default permissions on the table for principals.
     */
    public List<PrincipalPermissions> createTableDefaultPermissions() {
        return createTableDefaultPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(createTableDefaultPermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseInput)) {
            return false;
        }
        DatabaseInput other = (DatabaseInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(locationUri(), other.locationUri()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(createTableDefaultPermissions(), other.createTableDefaultPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatabaseInput").add("Name", name()).add("Description", description())
                .add("LocationUri", locationUri()).add("Parameters", parameters())
                .add("CreateTableDefaultPermissions", createTableDefaultPermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "CreateTableDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createTableDefaultPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseInput, T> g) {
        return obj -> g.apply((DatabaseInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseInput> {
        /**
         * <p>
         * The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
         * </p>
         * 
         * @param name
         *        The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the database.
         * </p>
         * 
         * @param description
         *        A description of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The location of the database (for example, an HDFS path).
         * </p>
         * 
         * @param locationUri
         *        The location of the database (for example, an HDFS path).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * These key-value pairs define parameters and properties of the database.
         * </p>
         * <p>
         * These key-value pairs define parameters and properties of the database.
         * </p>
         * 
         * @param parameters
         *        These key-value pairs define parameters and properties of the database.</p>
         *        <p>
         *        These key-value pairs define parameters and properties of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * Creates a set of default permissions on the table for principals.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        Creates a set of default permissions on the table for principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions);

        /**
         * <p>
         * Creates a set of default permissions on the table for principals.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        Creates a set of default permissions on the table for principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions);

        /**
         * <p>
         * Creates a set of default permissions on the table for principals.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrincipalPermissions>.Builder} avoiding the
         * need to create one manually via {@link List<PrincipalPermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalPermissions>.Builder#build()} is called immediately
         * and its result is passed to {@link #createTableDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createTableDefaultPermissions
         *        a consumer that will call methods on {@link List<PrincipalPermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTableDefaultPermissions(List<PrincipalPermissions>)
         */
        Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String locationUri;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseInput model) {
            name(model.name);
            description(model.description);
            locationUri(model.locationUri);
            parameters(model.parameters);
            createTableDefaultPermissions(model.createTableDefaultPermissions);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final Collection<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            return createTableDefaultPermissions != null ? createTableDefaultPermissions.stream()
                    .map(PrincipalPermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions) {
            createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions) {
            createTableDefaultPermissions(Stream.of(createTableDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateTableDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public DatabaseInput build() {
            return new DatabaseInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
