/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDevEndpointResponse extends GlueResponse implements
        ToCopyableBuilder<CreateDevEndpointResponse.Builder, CreateDevEndpointResponse> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDevEndpointResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> YARN_ENDPOINT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::yarnEndpointAddress)).setter(setter(Builder::yarnEndpointAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YarnEndpointAddress").build())
            .build();

    private static final SdkField<Integer> ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateDevEndpointResponse::zeppelinRemoteSparkInterpreterPort))
            .setter(setter(Builder::zeppelinRemoteSparkInterpreterPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZeppelinRemoteSparkInterpreterPort")
                    .build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateDevEndpointResponse::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::workerTypeAsString)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateDevEndpointResponse::numberOfWorkers)).setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::extraPythonLibsS3Path)).setter(setter(Builder::extraPythonLibsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build())
            .build();

    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::extraJarsS3Path)).setter(setter(Builder::extraJarsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDevEndpointResponse::securityConfiguration)).setter(setter(Builder::securityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateDevEndpointResponse::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateDevEndpointResponse::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            STATUS_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, ROLE_ARN_FIELD, YARN_ENDPOINT_ADDRESS_FIELD,
            ZEPPELIN_REMOTE_SPARK_INTERPRETER_PORT_FIELD, NUMBER_OF_NODES_FIELD, WORKER_TYPE_FIELD, GLUE_VERSION_FIELD,
            NUMBER_OF_WORKERS_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, EXTRA_PYTHON_LIBS_S3_PATH_FIELD,
            EXTRA_JARS_S3_PATH_FIELD, FAILURE_REASON_FIELD, SECURITY_CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD,
            ARGUMENTS_FIELD));

    private final String endpointName;

    private final String status;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String roleArn;

    private final String yarnEndpointAddress;

    private final Integer zeppelinRemoteSparkInterpreterPort;

    private final Integer numberOfNodes;

    private final String workerType;

    private final String glueVersion;

    private final Integer numberOfWorkers;

    private final String availabilityZone;

    private final String vpcId;

    private final String extraPythonLibsS3Path;

    private final String extraJarsS3Path;

    private final String failureReason;

    private final String securityConfiguration;

    private final Instant createdTimestamp;

    private final Map<String, String> arguments;

    private CreateDevEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.status = builder.status;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.roleArn = builder.roleArn;
        this.yarnEndpointAddress = builder.yarnEndpointAddress;
        this.zeppelinRemoteSparkInterpreterPort = builder.zeppelinRemoteSparkInterpreterPort;
        this.numberOfNodes = builder.numberOfNodes;
        this.workerType = builder.workerType;
        this.glueVersion = builder.glueVersion;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.failureReason = builder.failureReason;
        this.securityConfiguration = builder.securityConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.arguments = builder.arguments;
    }

    /**
     * <p>
     * The name assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name assigned to the new <code>DevEndpoint</code>.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The current status of the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The current status of the new <code>DevEndpoint</code>.
     */
    public String status() {
        return status;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups assigned to the new <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security groups assigned to the new <code>DevEndpoint</code>.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The subnet ID assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The subnet ID assigned to the new <code>DevEndpoint</code>.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The address of the YARN endpoint used by this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The address of the YARN endpoint used by this <code>DevEndpoint</code>.
     */
    public String yarnEndpointAddress() {
        return yarnEndpointAddress;
    }

    /**
     * <p>
     * The Apache Zeppelin port for the remote Apache Spark interpreter.
     * </p>
     * 
     * @return The Apache Zeppelin port for the remote Apache Spark interpreter.
     */
    public Integer zeppelinRemoteSparkInterpreterPort() {
        return zeppelinRemoteSparkInterpreterPort;
    }

    /**
     * <p>
     * The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
     * </p>
     * 
     * @return The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
     */
    public Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or
     * G.2X.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
     *         G.1X, or G.2X.
     * @see WorkerType
     */
    public WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or
     * G.2X.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
     *         G.1X, or G.2X.
     * @see WorkerType
     */
    public String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version
     * indicates the version supported for running your ETL scripts on development endpoints.
     * </p>
     * 
     * @return Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python
     *         version indicates the version supported for running your ETL scripts on development endpoints.
     */
    public String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated to the development
     *         endpoint.
     */
    public Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The AWS Availability Zone where this <code>DevEndpoint</code> is located.
     * </p>
     * 
     * @return The AWS Availability Zone where this <code>DevEndpoint</code> is located.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The paths to one or more Python libraries in an S3 bucket that will be loaded in your <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The paths to one or more Python libraries in an S3 bucket that will be loaded in your
     *         <code>DevEndpoint</code>.
     */
    public String extraPythonLibsS3Path() {
        return extraPythonLibsS3Path;
    }

    /**
     * <p>
     * Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
     * <code>DevEndpoint</code>.
     * </p>
     * 
     * @return Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
     *         <code>DevEndpoint</code>.
     */
    public String extraJarsS3Path() {
        return extraJarsS3Path;
    }

    /**
     * <p>
     * The reason for a current failure in this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The reason for a current failure in this <code>DevEndpoint</code>.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The name of the <code>SecurityConfiguration</code> structure being used with this <code>DevEndpoint</code>.
     * </p>
     * 
     * @return The name of the <code>SecurityConfiguration</code> structure being used with this
     *         <code>DevEndpoint</code>.
     */
    public String securityConfiguration() {
        return securityConfiguration;
    }

    /**
     * <p>
     * The point in time at which this <code>DevEndpoint</code> was created.
     * </p>
     * 
     * @return The point in time at which this <code>DevEndpoint</code> was created.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * Returns true if the Arguments property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The map of arguments used to configure this <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Valid arguments are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"--enable-glue-datacatalog": ""</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"GLUE_PYTHON_VERSION": "3"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"GLUE_PYTHON_VERSION": "2"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
     * provided, the version defaults to Python 2.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArguments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The map of arguments used to configure this <code>DevEndpoint</code>.</p>
     *         <p>
     *         Valid arguments are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"--enable-glue-datacatalog": ""</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"GLUE_PYTHON_VERSION": "3"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"GLUE_PYTHON_VERSION": "2"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     *         parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments
     *         are provided, the version defaults to Python 2.
     */
    public Map<String, String> arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(yarnEndpointAddress());
        hashCode = 31 * hashCode + Objects.hashCode(zeppelinRemoteSparkInterpreterPort());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(arguments());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointResponse)) {
            return false;
        }
        CreateDevEndpointResponse other = (CreateDevEndpointResponse) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(status(), other.status())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(yarnEndpointAddress(), other.yarnEndpointAddress())
                && Objects.equals(zeppelinRemoteSparkInterpreterPort(), other.zeppelinRemoteSparkInterpreterPort())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(glueVersion(), other.glueVersion())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(extraPythonLibsS3Path(), other.extraPythonLibsS3Path())
                && Objects.equals(extraJarsS3Path(), other.extraJarsS3Path())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(securityConfiguration(), other.securityConfiguration())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDevEndpointResponse").add("EndpointName", endpointName()).add("Status", status())
                .add("SecurityGroupIds", securityGroupIds()).add("SubnetId", subnetId()).add("RoleArn", roleArn())
                .add("YarnEndpointAddress", yarnEndpointAddress())
                .add("ZeppelinRemoteSparkInterpreterPort", zeppelinRemoteSparkInterpreterPort())
                .add("NumberOfNodes", numberOfNodes()).add("WorkerType", workerTypeAsString()).add("GlueVersion", glueVersion())
                .add("NumberOfWorkers", numberOfWorkers()).add("AvailabilityZone", availabilityZone()).add("VpcId", vpcId())
                .add("ExtraPythonLibsS3Path", extraPythonLibsS3Path()).add("ExtraJarsS3Path", extraJarsS3Path())
                .add("FailureReason", failureReason()).add("SecurityConfiguration", securityConfiguration())
                .add("CreatedTimestamp", createdTimestamp()).add("Arguments", arguments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "YarnEndpointAddress":
            return Optional.ofNullable(clazz.cast(yarnEndpointAddress()));
        case "ZeppelinRemoteSparkInterpreterPort":
            return Optional.ofNullable(clazz.cast(zeppelinRemoteSparkInterpreterPort()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ExtraPythonLibsS3Path":
            return Optional.ofNullable(clazz.cast(extraPythonLibsS3Path()));
        case "ExtraJarsS3Path":
            return Optional.ofNullable(clazz.cast(extraJarsS3Path()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "SecurityConfiguration":
            return Optional.ofNullable(clazz.cast(securityConfiguration()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevEndpointResponse, T> g) {
        return obj -> g.apply((CreateDevEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDevEndpointResponse> {
        /**
         * <p>
         * The name assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param endpointName
         *        The name assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The current status of the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param status
         *        The current status of the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The security groups assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnet ID assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The address of the YARN endpoint used by this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param yarnEndpointAddress
         *        The address of the YARN endpoint used by this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yarnEndpointAddress(String yarnEndpointAddress);

        /**
         * <p>
         * The Apache Zeppelin port for the remote Apache Spark interpreter.
         * </p>
         * 
         * @param zeppelinRemoteSparkInterpreterPort
         *        The Apache Zeppelin port for the remote Apache Spark interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort);

        /**
         * <p>
         * The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. May be a value of
         *        Standard, G.1X, or G.2X.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated to the development endpoint. May be a value of Standard,
         * G.1X, or G.2X.
         * </p>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated to the development endpoint. May be a value of
         *        Standard, G.1X, or G.2X.
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version
         * indicates the version supported for running your ETL scripts on development endpoints.
         * </p>
         * 
         * @param glueVersion
         *        Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python
         *        version indicates the version supported for running your ETL scripts on development endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated to the development
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The AWS Availability Zone where this <code>DevEndpoint</code> is located.
         * </p>
         * 
         * @param availabilityZone
         *        The AWS Availability Zone where this <code>DevEndpoint</code> is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The paths to one or more Python libraries in an S3 bucket that will be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param extraPythonLibsS3Path
         *        The paths to one or more Python libraries in an S3 bucket that will be loaded in your
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraPythonLibsS3Path(String extraPythonLibsS3Path);

        /**
         * <p>
         * Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param extraJarsS3Path
         *        Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraJarsS3Path(String extraJarsS3Path);

        /**
         * <p>
         * The reason for a current failure in this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason for a current failure in this <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The name of the <code>SecurityConfiguration</code> structure being used with this <code>DevEndpoint</code>.
         * </p>
         * 
         * @param securityConfiguration
         *        The name of the <code>SecurityConfiguration</code> structure being used with this
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfiguration(String securityConfiguration);

        /**
         * <p>
         * The point in time at which this <code>DevEndpoint</code> was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The point in time at which this <code>DevEndpoint</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The map of arguments used to configure this <code>DevEndpoint</code>.
         * </p>
         * <p>
         * Valid arguments are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"--enable-glue-datacatalog": ""</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"GLUE_PYTHON_VERSION": "3"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"GLUE_PYTHON_VERSION": "2"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
         * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
         * provided, the version defaults to Python 2.
         * </p>
         * 
         * @param arguments
         *        The map of arguments used to configure this <code>DevEndpoint</code>.</p>
         *        <p>
         *        Valid arguments are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"--enable-glue-datacatalog": ""</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"GLUE_PYTHON_VERSION": "3"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"GLUE_PYTHON_VERSION": "2"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify a version of Python support for development endpoints by using the
         *        <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or
         *        <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String endpointName;

        private String status;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String roleArn;

        private String yarnEndpointAddress;

        private Integer zeppelinRemoteSparkInterpreterPort;

        private Integer numberOfNodes;

        private String workerType;

        private String glueVersion;

        private Integer numberOfWorkers;

        private String availabilityZone;

        private String vpcId;

        private String extraPythonLibsS3Path;

        private String extraJarsS3Path;

        private String failureReason;

        private String securityConfiguration;

        private Instant createdTimestamp;

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointResponse model) {
            super(model);
            endpointName(model.endpointName);
            status(model.status);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            roleArn(model.roleArn);
            yarnEndpointAddress(model.yarnEndpointAddress);
            zeppelinRemoteSparkInterpreterPort(model.zeppelinRemoteSparkInterpreterPort);
            numberOfNodes(model.numberOfNodes);
            workerType(model.workerType);
            glueVersion(model.glueVersion);
            numberOfWorkers(model.numberOfWorkers);
            availabilityZone(model.availabilityZone);
            vpcId(model.vpcId);
            extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            extraJarsS3Path(model.extraJarsS3Path);
            failureReason(model.failureReason);
            securityConfiguration(model.securityConfiguration);
            createdTimestamp(model.createdTimestamp);
            arguments(model.arguments);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getYarnEndpointAddress() {
            return yarnEndpointAddress;
        }

        @Override
        public final Builder yarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
            return this;
        }

        public final void setYarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
        }

        public final Integer getZeppelinRemoteSparkInterpreterPort() {
            return zeppelinRemoteSparkInterpreterPort;
        }

        @Override
        public final Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
            return this;
        }

        public final void setZeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getWorkerTypeAsString() {
            return workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getExtraPythonLibsS3Path() {
            return extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        public final String getExtraJarsS3Path() {
            return extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getSecurityConfiguration() {
            return securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Map<String, String> getArguments() {
            return arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = MapValueCopier.copy(arguments);
        }

        @Override
        public CreateDevEndpointResponse build() {
            return new CreateDevEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
