/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the connections used by a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionsList implements SdkPojo, Serializable, ToCopyableBuilder<ConnectionsList.Builder, ConnectionsList> {
    private static final SdkField<List<String>> CONNECTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ConnectionsList::connections))
            .setter(setter(Builder::connections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> connections;

    private ConnectionsList(BuilderImpl builder) {
        this.connections = builder.connections;
    }

    /**
     * Returns true if the Connections property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConnections() {
        return connections != null && !(connections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of connections used by the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnections()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of connections used by the job.
     */
    public List<String> connections() {
        return connections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connections());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionsList)) {
            return false;
        }
        ConnectionsList other = (ConnectionsList) obj;
        return Objects.equals(connections(), other.connections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectionsList").add("Connections", connections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connections":
            return Optional.ofNullable(clazz.cast(connections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionsList, T> g) {
        return obj -> g.apply((ConnectionsList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionsList> {
        /**
         * <p>
         * A list of connections used by the job.
         * </p>
         * 
         * @param connections
         *        A list of connections used by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Collection<String> connections);

        /**
         * <p>
         * A list of connections used by the job.
         * </p>
         * 
         * @param connections
         *        A list of connections used by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(String... connections);
    }

    static final class BuilderImpl implements Builder {
        private List<String> connections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionsList model) {
            connections(model.connections);
        }

        public final Collection<String> getConnections() {
            return connections;
        }

        @Override
        public final Builder connections(Collection<String> connections) {
            this.connections = OrchestrationStringListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(String... connections) {
            connections(Arrays.asList(connections));
            return this;
        }

        public final void setConnections(Collection<String> connections) {
            this.connections = OrchestrationStringListCopier.copy(connections);
        }

        @Override
        public ConnectionsList build() {
            return new ConnectionsList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
