/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ConnectionPropertyKey {
    HOST("HOST"),

    PORT("PORT"),

    USERNAME("USERNAME"),

    PASSWORD("PASSWORD"),

    ENCRYPTED_PASSWORD("ENCRYPTED_PASSWORD"),

    JDBC_DRIVER_JAR_URI("JDBC_DRIVER_JAR_URI"),

    JDBC_DRIVER_CLASS_NAME("JDBC_DRIVER_CLASS_NAME"),

    JDBC_ENGINE("JDBC_ENGINE"),

    JDBC_ENGINE_VERSION("JDBC_ENGINE_VERSION"),

    CONFIG_FILES("CONFIG_FILES"),

    INSTANCE_ID("INSTANCE_ID"),

    JDBC_CONNECTION_URL("JDBC_CONNECTION_URL"),

    JDBC_ENFORCE_SSL("JDBC_ENFORCE_SSL"),

    CUSTOM_JDBC_CERT("CUSTOM_JDBC_CERT"),

    SKIP_CUSTOM_JDBC_CERT_VALIDATION("SKIP_CUSTOM_JDBC_CERT_VALIDATION"),

    CUSTOM_JDBC_CERT_STRING("CUSTOM_JDBC_CERT_STRING"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConnectionPropertyKey(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ConnectionPropertyKey corresponding to the value
     */
    public static ConnectionPropertyKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConnectionPropertyKey.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ConnectionPropertyKey}s
     */
    public static Set<ConnectionPropertyKey> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
