/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Records an error that occurred when attempting to stop a specified job run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStopJobRunError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchStopJobRunError.Builder, BatchStopJobRunError> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchStopJobRunError::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchStopJobRunError::jobRunId)).setter(setter(Builder::jobRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()).build();

    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(BatchStopJobRunError::errorDetail)).setter(setter(Builder::errorDetail))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_RUN_ID_FIELD, ERROR_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String jobRunId;

    private final ErrorDetail errorDetail;

    private BatchStopJobRunError(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.errorDetail = builder.errorDetail;
    }

    /**
     * <p>
     * The name of the job definition that is used in the job run in question.
     * </p>
     * 
     * @return The name of the job definition that is used in the job run in question.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The <code>JobRunId</code> of the job run in question.
     * </p>
     * 
     * @return The <code>JobRunId</code> of the job run in question.
     */
    public String jobRunId() {
        return jobRunId;
    }

    /**
     * <p>
     * Specifies details about the error that was encountered.
     * </p>
     * 
     * @return Specifies details about the error that was encountered.
     */
    public ErrorDetail errorDetail() {
        return errorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunError)) {
            return false;
        }
        BatchStopJobRunError other = (BatchStopJobRunError) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobRunId(), other.jobRunId())
                && Objects.equals(errorDetail(), other.errorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchStopJobRunError").add("JobName", jobName()).add("JobRunId", jobRunId())
                .add("ErrorDetail", errorDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobRunId":
            return Optional.ofNullable(clazz.cast(jobRunId()));
        case "ErrorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopJobRunError, T> g) {
        return obj -> g.apply((BatchStopJobRunError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchStopJobRunError> {
        /**
         * <p>
         * The name of the job definition that is used in the job run in question.
         * </p>
         * 
         * @param jobName
         *        The name of the job definition that is used in the job run in question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The <code>JobRunId</code> of the job run in question.
         * </p>
         * 
         * @param jobRunId
         *        The <code>JobRunId</code> of the job run in question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunId(String jobRunId);

        /**
         * <p>
         * Specifies details about the error that was encountered.
         * </p>
         * 
         * @param errorDetail
         *        Specifies details about the error that was encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(ErrorDetail errorDetail);

        /**
         * <p>
         * Specifies details about the error that was encountered.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to create
         * one manually via {@link ErrorDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #errorDetail(ErrorDetail)}.
         * 
         * @param errorDetail
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetail(ErrorDetail)
         */
        default Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return errorDetail(ErrorDetail.builder().applyMutation(errorDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobRunId;

        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunError model) {
            jobName(model.jobName);
            jobRunId(model.jobRunId);
            errorDetail(model.errorDetail);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobRunId() {
            return jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return errorDetail != null ? errorDetail.toBuilder() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        @Override
        public BatchStopJobRunError build() {
            return new BatchStopJobRunError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
