/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTriggersResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetTriggersResponse.Builder, BatchGetTriggersResponse> {
    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField
            .<List<Trigger>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetTriggersResponse::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TRIGGERS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetTriggersResponse::triggersNotFound))
            .setter(setter(Builder::triggersNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggersNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGERS_FIELD,
            TRIGGERS_NOT_FOUND_FIELD));

    private final List<Trigger> triggers;

    private final List<String> triggersNotFound;

    private BatchGetTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.triggers = builder.triggers;
        this.triggersNotFound = builder.triggersNotFound;
    }

    /**
     * Returns true if the Triggers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of trigger definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of trigger definitions.
     */
    public List<Trigger> triggers() {
        return triggers;
    }

    /**
     * Returns true if the TriggersNotFound property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTriggersNotFound() {
        return triggersNotFound != null && !(triggersNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of triggers not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggersNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of triggers not found.
     */
    public List<String> triggersNotFound() {
        return triggersNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(triggers());
        hashCode = 31 * hashCode + Objects.hashCode(triggersNotFound());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTriggersResponse)) {
            return false;
        }
        BatchGetTriggersResponse other = (BatchGetTriggersResponse) obj;
        return Objects.equals(triggers(), other.triggers()) && Objects.equals(triggersNotFound(), other.triggersNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetTriggersResponse").add("Triggers", triggers())
                .add("TriggersNotFound", triggersNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "TriggersNotFound":
            return Optional.ofNullable(clazz.cast(triggersNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTriggersResponse, T> g) {
        return obj -> g.apply((BatchGetTriggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetTriggersResponse> {
        /**
         * <p>
         * A list of trigger definitions.
         * </p>
         * 
         * @param triggers
         *        A list of trigger definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<Trigger> triggers);

        /**
         * <p>
         * A list of trigger definitions.
         * </p>
         * 
         * @param triggers
         *        A list of trigger definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Trigger... triggers);

        /**
         * <p>
         * A list of trigger definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Trigger>.Builder} avoiding the need to
         * create one manually via {@link List<Trigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trigger>.Builder#build()} is called immediately and its
         * result is passed to {@link #triggers(List<Trigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<Trigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<Trigger>)
         */
        Builder triggers(Consumer<Trigger.Builder>... triggers);

        /**
         * <p>
         * A list of names of triggers not found.
         * </p>
         * 
         * @param triggersNotFound
         *        A list of names of triggers not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggersNotFound(Collection<String> triggersNotFound);

        /**
         * <p>
         * A list of names of triggers not found.
         * </p>
         * 
         * @param triggersNotFound
         *        A list of names of triggers not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggersNotFound(String... triggersNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<String> triggersNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTriggersResponse model) {
            super(model);
            triggers(model.triggers);
            triggersNotFound(model.triggersNotFound);
        }

        public final Collection<Trigger.Builder> getTriggers() {
            return triggers != null ? triggers.stream().map(Trigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> Trigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        public final Collection<String> getTriggersNotFound() {
            return triggersNotFound;
        }

        @Override
        public final Builder triggersNotFound(Collection<String> triggersNotFound) {
            this.triggersNotFound = TriggerNameListCopier.copy(triggersNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggersNotFound(String... triggersNotFound) {
            triggersNotFound(Arrays.asList(triggersNotFound));
            return this;
        }

        public final void setTriggersNotFound(Collection<String> triggersNotFound) {
            this.triggersNotFound = TriggerNameListCopier.copy(triggersNotFound);
        }

        @Override
        public BatchGetTriggersResponse build() {
            return new BatchGetTriggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
