/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTriggersRequest extends GlueRequest implements
        ToCopyableBuilder<BatchGetTriggersRequest.Builder, BatchGetTriggersRequest> {
    private static final SdkField<List<String>> TRIGGER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetTriggersRequest::triggerNames))
            .setter(setter(Builder::triggerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_NAMES_FIELD));

    private final List<String> triggerNames;

    private BatchGetTriggersRequest(BuilderImpl builder) {
        super(builder);
        this.triggerNames = builder.triggerNames;
    }

    /**
     * Returns true if the TriggerNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggerNames() {
        return triggerNames != null && !(triggerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggerNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.
     */
    public List<String> triggerNames() {
        return triggerNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(triggerNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTriggersRequest)) {
            return false;
        }
        BatchGetTriggersRequest other = (BatchGetTriggersRequest) obj;
        return Objects.equals(triggerNames(), other.triggerNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetTriggersRequest").add("TriggerNames", triggerNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TriggerNames":
            return Optional.ofNullable(clazz.cast(triggerNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTriggersRequest, T> g) {
        return obj -> g.apply((BatchGetTriggersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetTriggersRequest> {
        /**
         * <p>
         * A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.
         * </p>
         * 
         * @param triggerNames
         *        A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerNames(Collection<String> triggerNames);

        /**
         * <p>
         * A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.
         * </p>
         * 
         * @param triggerNames
         *        A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerNames(String... triggerNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private List<String> triggerNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTriggersRequest model) {
            super(model);
            triggerNames(model.triggerNames);
        }

        public final Collection<String> getTriggerNames() {
            return triggerNames;
        }

        @Override
        public final Builder triggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerNames(String... triggerNames) {
            triggerNames(Arrays.asList(triggerNames));
            return this;
        }

        public final void setTriggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetTriggersRequest build() {
            return new BatchGetTriggersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
