/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCrawlersResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetCrawlersResponse.Builder, BatchGetCrawlersResponse> {
    private static final SdkField<List<Crawler>> CRAWLERS_FIELD = SdkField
            .<List<Crawler>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetCrawlersResponse::crawlers))
            .setter(setter(Builder::crawlers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Crawlers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Crawler> builder(MarshallingType.SDK_POJO)
                                            .constructor(Crawler::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CRAWLERS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetCrawlersResponse::crawlersNotFound))
            .setter(setter(Builder::crawlersNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlersNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLERS_FIELD,
            CRAWLERS_NOT_FOUND_FIELD));

    private final List<Crawler> crawlers;

    private final List<String> crawlersNotFound;

    private BatchGetCrawlersResponse(BuilderImpl builder) {
        super(builder);
        this.crawlers = builder.crawlers;
        this.crawlersNotFound = builder.crawlersNotFound;
    }

    /**
     * Returns true if the Crawlers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCrawlers() {
        return crawlers != null && !(crawlers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of crawler definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCrawlers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of crawler definitions.
     */
    public List<Crawler> crawlers() {
        return crawlers;
    }

    /**
     * Returns true if the CrawlersNotFound property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCrawlersNotFound() {
        return crawlersNotFound != null && !(crawlersNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of crawlers that were not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCrawlersNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of crawlers that were not found.
     */
    public List<String> crawlersNotFound() {
        return crawlersNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crawlers());
        hashCode = 31 * hashCode + Objects.hashCode(crawlersNotFound());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCrawlersResponse)) {
            return false;
        }
        BatchGetCrawlersResponse other = (BatchGetCrawlersResponse) obj;
        return Objects.equals(crawlers(), other.crawlers()) && Objects.equals(crawlersNotFound(), other.crawlersNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetCrawlersResponse").add("Crawlers", crawlers())
                .add("CrawlersNotFound", crawlersNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Crawlers":
            return Optional.ofNullable(clazz.cast(crawlers()));
        case "CrawlersNotFound":
            return Optional.ofNullable(clazz.cast(crawlersNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCrawlersResponse, T> g) {
        return obj -> g.apply((BatchGetCrawlersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCrawlersResponse> {
        /**
         * <p>
         * A list of crawler definitions.
         * </p>
         * 
         * @param crawlers
         *        A list of crawler definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlers(Collection<Crawler> crawlers);

        /**
         * <p>
         * A list of crawler definitions.
         * </p>
         * 
         * @param crawlers
         *        A list of crawler definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlers(Crawler... crawlers);

        /**
         * <p>
         * A list of crawler definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Crawler>.Builder} avoiding the need to
         * create one manually via {@link List<Crawler>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Crawler>.Builder#build()} is called immediately and its
         * result is passed to {@link #crawlers(List<Crawler>)}.
         * 
         * @param crawlers
         *        a consumer that will call methods on {@link List<Crawler>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawlers(List<Crawler>)
         */
        Builder crawlers(Consumer<Crawler.Builder>... crawlers);

        /**
         * <p>
         * A list of names of crawlers that were not found.
         * </p>
         * 
         * @param crawlersNotFound
         *        A list of names of crawlers that were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlersNotFound(Collection<String> crawlersNotFound);

        /**
         * <p>
         * A list of names of crawlers that were not found.
         * </p>
         * 
         * @param crawlersNotFound
         *        A list of names of crawlers that were not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlersNotFound(String... crawlersNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Crawler> crawlers = DefaultSdkAutoConstructList.getInstance();

        private List<String> crawlersNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCrawlersResponse model) {
            super(model);
            crawlers(model.crawlers);
            crawlersNotFound(model.crawlersNotFound);
        }

        public final Collection<Crawler.Builder> getCrawlers() {
            return crawlers != null ? crawlers.stream().map(Crawler::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crawlers(Collection<Crawler> crawlers) {
            this.crawlers = CrawlerListCopier.copy(crawlers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlers(Crawler... crawlers) {
            crawlers(Arrays.asList(crawlers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlers(Consumer<Crawler.Builder>... crawlers) {
            crawlers(Stream.of(crawlers).map(c -> Crawler.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCrawlers(Collection<Crawler.BuilderImpl> crawlers) {
            this.crawlers = CrawlerListCopier.copyFromBuilder(crawlers);
        }

        public final Collection<String> getCrawlersNotFound() {
            return crawlersNotFound;
        }

        @Override
        public final Builder crawlersNotFound(Collection<String> crawlersNotFound) {
            this.crawlersNotFound = CrawlerNameListCopier.copy(crawlersNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlersNotFound(String... crawlersNotFound) {
            crawlersNotFound(Arrays.asList(crawlersNotFound));
            return this;
        }

        public final void setCrawlersNotFound(Collection<String> crawlersNotFound) {
            this.crawlersNotFound = CrawlerNameListCopier.copy(crawlersNotFound);
        }

        @Override
        public BatchGetCrawlersResponse build() {
            return new BatchGetCrawlersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
