/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteTableRequest extends GlueRequest implements
        ToCopyableBuilder<BatchDeleteTableRequest.Builder, BatchDeleteTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDeleteTableRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDeleteTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<List<String>> TABLES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchDeleteTableRequest::tablesToDelete))
            .setter(setter(Builder::tablesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLES_TO_DELETE_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final List<String> tablesToDelete;

    private BatchDeleteTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tablesToDelete = builder.tablesToDelete;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by
     *         default.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the catalog database in which the tables to delete reside. For Hive compatibility, this name is
     * entirely lowercase.
     * </p>
     * 
     * @return The name of the catalog database in which the tables to delete reside. For Hive compatibility, this name
     *         is entirely lowercase.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * Returns true if the TablesToDelete property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTablesToDelete() {
        return tablesToDelete != null && !(tablesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the table to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTablesToDelete()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the table to delete.
     */
    public List<String> tablesToDelete() {
        return tablesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tablesToDelete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTableRequest)) {
            return false;
        }
        BatchDeleteTableRequest other = (BatchDeleteTableRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tablesToDelete(), other.tablesToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDeleteTableRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TablesToDelete", tablesToDelete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TablesToDelete":
            return Optional.ofNullable(clazz.cast(tablesToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTableRequest, T> g) {
        return obj -> g.apply((BatchDeleteTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteTableRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by
         * default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the catalog database in which the tables to delete reside. For Hive compatibility, this name is
         * entirely lowercase.
         * </p>
         * 
         * @param databaseName
         *        The name of the catalog database in which the tables to delete reside. For Hive compatibility, this
         *        name is entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A list of the table to delete.
         * </p>
         * 
         * @param tablesToDelete
         *        A list of the table to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesToDelete(Collection<String> tablesToDelete);

        /**
         * <p>
         * A list of the table to delete.
         * </p>
         * 
         * @param tablesToDelete
         *        A list of the table to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesToDelete(String... tablesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private List<String> tablesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTableRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tablesToDelete(model.tablesToDelete);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final Collection<String> getTablesToDelete() {
            return tablesToDelete;
        }

        @Override
        public final Builder tablesToDelete(Collection<String> tablesToDelete) {
            this.tablesToDelete = BatchDeleteTableNameListCopier.copy(tablesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToDelete(String... tablesToDelete) {
            tablesToDelete(Arrays.asList(tablesToDelete));
            return this;
        }

        public final void setTablesToDelete(Collection<String> tablesToDelete) {
            this.tablesToDelete = BatchDeleteTableNameListCopier.copy(tablesToDelete);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteTableRequest build() {
            return new BatchDeleteTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
