/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.JdbcTarget;

public class JdbcTargetUnmarshaller
implements Unmarshaller<JdbcTarget, JsonUnmarshallerContext> {
    private static final JdbcTargetUnmarshaller INSTANCE = new JdbcTargetUnmarshaller();

    public JdbcTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        JdbcTarget.Builder jdbcTargetBuilder = JdbcTarget.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ConnectionName", targetDepth)) {
                    context.nextToken();
                    jdbcTargetBuilder.connectionName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Path", targetDepth)) {
                    context.nextToken();
                    jdbcTargetBuilder.path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Exclusions", targetDepth)) {
                    context.nextToken();
                    jdbcTargetBuilder.exclusions(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JdbcTarget)jdbcTargetBuilder.build();
    }

    public static JdbcTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

